#!/usr/bin/env python2
#-*- coding: utf-8 -*-
#
#

__author__  = "Black Viking"
__version__ = (0, 0, 6)
__date__    = "07.06.2017"
__mail__    = "blackvkng@yandex.com"

import os
import sys
import time
import argparse

from src import crawler
from src import sqliscan
from src import reverseip

from thirdparty.colorama import init, Fore, Style

class viSQL:
    def __init__(self):
        self.colors = {
            "red":     Style.BRIGHT + Fore.RED,
            "cyan":    Style.BRIGHT + Fore.CYAN,
            "blue":    Style.BRIGHT + Fore.BLUE,
            "green":   Style.BRIGHT + Fore.GREEN,
            "white":   Style.BRIGHT + Fore.WHITE,
            "yellow":  Style.BRIGHT + Fore.YELLOW,
            "magenta": Style.BRIGHT + Fore.MAGENTA
        }

        self.crawler = crawler.Crawler()
        self.textTypes = {"info": (" [INFO] ", 'yellow'), "err": ("[ERROR] ", 'red'), None: ('', '')}

    def vprint(self, text, color, type):
        print self.colors['magenta'] + "["  + time.strftime("%H:%M:%S") + "] " + self.colors[self.textTypes[type][1]] + self.textTypes[type][0] + self.colors[color] + text

    def banner(self):
        print self.colors['blue'] + """
                     ,,
                     db   .M\"\""bgd   .g8""8q. `7MMF'
                         ,MI    "Y .dP'    `YM. MM
        `7M'   `MF'`7MM  `MMb.     dM'      `MM MM
          VA   ,V    MM    `YMMNq. MM        MM MM
           VA ,V     MM  .     `MM MM.      ,MP MM      ,
            VVV      MM  Mb     dM `Mb.    ,dP' MM     ,M
             W     .JMML.P"Ybmmd"    `"bmmd"' .JMMmmmmMMM
                                         MMb
                                          `bood'
        \t\t\tVersion: %s
        \t\t\thttp://github.com/blackvkng\n"""%('.'.join([str(x) for x in __version__]))

    def versionControl(self, version):
        latestVersion = tuple([int(x) for x in __import__('urllib2').urlopen('https://raw.githubusercontent.com/blackvkng/viSQL/master/version').read().strip().split('.')])

        for vers in [('Your Version  ', version), ("Latest Version", latestVersion)]:
            print self.colors['blue'] + "[+] " + self.colors['green'] + vers[0] + ': ', vers[1]

        if version == latestVersion:
            print self.colors['blue'] + "\n[+] " + self.colors['green'] + 'viSQL up to date!'

        elif latestVersion > version:
            print self.colors['blue'] + "\n[!] " + self.colors['yellow'] + 'New version available, please update!'

        else:
            print self.colors['red']  + "\n[?] " + self.colors['yellow'] + "WTF?"

    def singleScan(self, target):
        try:
            links = self.crawler.crawl(target)
        except Exception as err:
            self.vprint(err.__str__(), 'red', 'err')
            return

        self.vprint('Found %s URL to SQLi scan' % len(links), 'cyan', 'info')

        if len(links) == 0:
            return

        self.vprint('SQLi scan started', 'green', 'info')

        for link in links:
            try:
                self.vprint('Link: ' + link, 'yellow', 'info')

                if sqliscan.scan(link) == True:
                    self.vprint('SQLi vuln --> ' + link, 'cyan', 'info')
            except Exception as err:
                self.vprint(err.__str__(), 'red', 'err')

    def main(self, target, single=False):
        self.banner()
        self.vprint("Program started", "green", "info")

        if single != False:
            self.singleScan(target)
            return

        self.vprint('Reverse IP lookup started', 'green', 'info')

        try:
            sitesOnServer = reverseip.find(target)
            self.vprint('Found %s web site on server' % len(sitesOnServer), 'cyan', 'info')
        except Exception as err:
            self.vprint(err.__str__(), 'red', 'err')
            return

        for site in sitesOnServer:
            print "-" * 40
            self.vprint('Scanning: ' + site, 'green', 'info')
            self.singleScan('http://' + site)

        print '-'  * 40
        self.vprint("Program shutting down", "green", "info")

if __name__ == '__main__':
    init(autoreset=True)
    visql = viSQL()

    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--target', dest='target', help="Scan target's server for sqli", type=str)
    parser.add_argument('-s', '--single', dest='single', help='Scan just one site', action='store_true', default=False)
    parser.add_argument('-c', '--control-version', help='Check for new updates', action='store_true', default=False)

    args = parser.parse_args()

    if args.control_version == True:
        visql.versionControl(__version__)
        sys.exit()

    if args.single == True and args.target:
        visql.main('http://' + args.target.replace('http://', '').replace('https://', ''), True)
        sys.exit()

    if args.target != None:
        visql.main(args.target)
        sys.exit()

    parser.print_help()
