/*
 * Copyright 2017 CodiLime
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
// This file is autogenerated do not modify it by hand

#pragma once
#include <memory>

#include "fwd_models.h"
#include "data/bindata.h"
#include "data/nodeid.h"
#include "network/msgpackobject.h"
namespace veles {
namespace data {
enum class Endian {
LITTLE,
BIG
};

class RepackerModel {
 public:
  class Builder {
  veles::data::Endian endian;
  uint64_t from_width;
  uint64_t to_width;
  uint64_t high_pad;
  uint64_t low_pad;

 public:
  Builder() : endian(veles::data::Endian::LITTLE), from_width(UINT64_C(0)), to_width(UINT64_C(0)), high_pad(UINT64_C(0)), low_pad(UINT64_C(0)) {}
  
    Builder& set_endian(veles::data::Endian endian);

    Builder& set_from_width(uint64_t from_width);

    Builder& set_to_width(uint64_t to_width);

    Builder& set_high_pad(uint64_t high_pad);

    Builder& set_low_pad(uint64_t low_pad);

    std::shared_ptr<veles::data::Repacker> build();
  };
  veles::data::Endian endian;
  uint64_t from_width;
  uint64_t to_width;
  uint64_t high_pad;
  uint64_t low_pad;
  RepackerModel(veles::data::Endian endian, uint64_t from_width, uint64_t to_width, uint64_t high_pad, uint64_t low_pad) : endian(endian), from_width(from_width), to_width(to_width), high_pad(high_pad), low_pad(low_pad) {}

  static std::shared_ptr<veles::data::Repacker> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace data
}  // namespace veles
namespace veles {
namespace proto {
enum class TriggerState {
PENDING,
DONE,
EXCEPTION
};

class Node {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> data;
  std::shared_ptr<std::unordered_map<std::string,uint64_t>> bindata;
  std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> triggers;

 public:
  Builder() : id(nullptr), parent(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)), tags(nullptr), attr(nullptr), data(nullptr), bindata(nullptr), triggers(nullptr) {}
  
    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    Builder& set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr);

    Builder& set_data(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> data);

    Builder& set_bindata(std::shared_ptr<std::unordered_map<std::string,uint64_t>> bindata);

    Builder& set_triggers(std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> triggers);

    std::shared_ptr<veles::proto::Node> build();
  };
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> data;
  std::shared_ptr<std::unordered_map<std::string,uint64_t>> bindata;
  std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> triggers;
  Node(std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<veles::data::NodeID> parent, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> data, std::shared_ptr<std::unordered_map<std::string,uint64_t>> bindata, std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> triggers) : id(id), parent(parent), pos_start(pos_start), pos_end(pos_end), tags(tags), attr(attr), data(data), bindata(bindata), triggers(triggers) {}

  static std::shared_ptr<veles::proto::Node> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class PosFilter {
 public:
  class Builder {
  std::pair<bool, int64_t> start_from;
  std::pair<bool, int64_t> start_to;
  std::pair<bool, int64_t> end_from;
  std::pair<bool, int64_t> end_to;

 public:
  Builder() : start_from(false, INT64_C(0)), start_to(false, INT64_C(0)), end_from(false, INT64_C(0)), end_to(false, INT64_C(0)) {}
  
    Builder& set_start_from(const std::pair<bool, int64_t>& start_from);

    Builder& set_start_to(const std::pair<bool, int64_t>& start_to);

    Builder& set_end_from(const std::pair<bool, int64_t>& end_from);

    Builder& set_end_to(const std::pair<bool, int64_t>& end_to);

    std::shared_ptr<veles::proto::PosFilter> build();
  };
  std::pair<bool, int64_t> start_from;
  std::pair<bool, int64_t> start_to;
  std::pair<bool, int64_t> end_from;
  std::pair<bool, int64_t> end_to;
  PosFilter(const std::pair<bool, int64_t>& start_from, const std::pair<bool, int64_t>& start_to, const std::pair<bool, int64_t>& end_from, const std::pair<bool, int64_t>& end_to) : start_from(start_from), start_to(start_to), end_from(end_from), end_to(end_to) {}

  static std::shared_ptr<veles::proto::PosFilter> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {

class Check {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
    objectTypes()["gone"] = &createInstance<CheckGone>;
    objectTypes()["parent"] = &createInstance<CheckParent>;
    objectTypes()["pos"] = &createInstance<CheckPos>;
    objectTypes()["tags"] = &createInstance<CheckTags>;
    objectTypes()["tag"] = &createInstance<CheckTag>;
    objectTypes()["attr"] = &createInstance<CheckAttr>;
    objectTypes()["data"] = &createInstance<CheckData>;
    objectTypes()["bindata_size"] = &createInstance<CheckBinDataSize>;
    objectTypes()["bindata"] = &createInstance<CheckBinData>;
    objectTypes()["trigger"] = &createInstance<CheckTrigger>;
    objectTypes()["list"] = &createInstance<CheckList>;
  }
  template<typename T> static std::shared_ptr<Check>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<Check>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<Check>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  Check(std::string object_type) : object_type(object_type) {}
  virtual ~Check() {}

  static std::shared_ptr<Check> polymorphicLoad(const msgpack::object& obj);
};


class CheckGone : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;

 public:
  Builder() : node(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    std::shared_ptr<veles::proto::CheckGone> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  CheckGone(std::shared_ptr<veles::data::NodeID> node) : Check("gone"), node(node) {}

  static std::shared_ptr<veles::proto::CheckGone> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckParent : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;

 public:
  Builder() : node(nullptr), parent(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    std::shared_ptr<veles::proto::CheckParent> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;
  CheckParent(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<veles::data::NodeID> parent) : Check("parent"), node(node), parent(parent) {}

  static std::shared_ptr<veles::proto::CheckParent> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckPos : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;

 public:
  Builder() : node(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    std::shared_ptr<veles::proto::CheckPos> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  CheckPos(std::shared_ptr<veles::data::NodeID> node, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end) : Check("pos"), node(node), pos_start(pos_start), pos_end(pos_end) {}

  static std::shared_ptr<veles::proto::CheckPos> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckTags : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;

 public:
  Builder() : node(nullptr), tags(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    std::shared_ptr<veles::proto::CheckTags> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  CheckTags(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) : Check("tags"), node(node), tags(tags) {}

  static std::shared_ptr<veles::proto::CheckTags> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckTag : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;
  bool present;

 public:
  Builder() : node(nullptr), tag(nullptr), present(false) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_tag(std::shared_ptr<std::string> tag);

    Builder& set_present(bool present);

    std::shared_ptr<veles::proto::CheckTag> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;
  bool present;
  CheckTag(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> tag, bool present) : Check("tag"), node(node), tag(tag), present(present) {}

  static std::shared_ptr<veles::proto::CheckTag> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckAttr : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : node(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::CheckAttr> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  CheckAttr(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : Check("attr"), node(node), key(key), data(data) {}

  static std::shared_ptr<veles::proto::CheckAttr> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckData : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : node(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::CheckData> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  CheckData(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : Check("data"), node(node), key(key), data(data) {}

  static std::shared_ptr<veles::proto::CheckData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckBinDataSize : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t size;

 public:
  Builder() : node(nullptr), key(nullptr), size(UINT64_C(0)) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_size(uint64_t size);

    std::shared_ptr<veles::proto::CheckBinDataSize> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t size;
  CheckBinDataSize(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, uint64_t size) : Check("bindata_size"), node(node), key(key), size(size) {}

  static std::shared_ptr<veles::proto::CheckBinDataSize> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckBinData : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::pair<bool, uint64_t> end;
  std::shared_ptr<std::vector<uint8_t>> data;

 public:
  Builder() : node(nullptr), key(nullptr), start(UINT64_C(0)), end(false, UINT64_C(0)), data(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_start(uint64_t start);

    Builder& set_end(const std::pair<bool, uint64_t>& end);

    Builder& set_data(std::shared_ptr<std::vector<uint8_t>> data);

    std::shared_ptr<veles::proto::CheckBinData> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::pair<bool, uint64_t> end;
  std::shared_ptr<std::vector<uint8_t>> data;
  CheckBinData(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, uint64_t start, const std::pair<bool, uint64_t>& end, std::shared_ptr<std::vector<uint8_t>> data) : Check("bindata"), node(node), key(key), start(start), end(end), data(data) {}

  static std::shared_ptr<veles::proto::CheckBinData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckTrigger : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, veles::proto::TriggerState> state;

 public:
  Builder() : node(nullptr), key(nullptr), state(false, veles::proto::TriggerState::PENDING) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_state(const std::pair<bool, veles::proto::TriggerState>& state);

    std::shared_ptr<veles::proto::CheckTrigger> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, veles::proto::TriggerState> state;
  CheckTrigger(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, const std::pair<bool, veles::proto::TriggerState>& state) : Check("trigger"), node(node), key(key), state(state) {}

  static std::shared_ptr<veles::proto::CheckTrigger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class CheckList : public Check {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> parent;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<veles::proto::PosFilter> pos_filter;
  std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> nodes;

 public:
  Builder() : parent(nullptr), tags(nullptr), pos_filter(nullptr), nodes(nullptr) {}
  
    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    Builder& set_pos_filter(std::shared_ptr<veles::proto::PosFilter> pos_filter);

    Builder& set_nodes(std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> nodes);

    std::shared_ptr<veles::proto::CheckList> build();
  };
  std::shared_ptr<veles::data::NodeID> parent;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<veles::proto::PosFilter> pos_filter;
  std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> nodes;
  CheckList(std::shared_ptr<veles::data::NodeID> parent, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags, std::shared_ptr<veles::proto::PosFilter> pos_filter, std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> nodes) : Check("list"), parent(parent), tags(tags), pos_filter(pos_filter), nodes(nodes) {}

  static std::shared_ptr<veles::proto::CheckList> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {
enum class FieldSignMode {
UNSIGNED,
SIGNED
};
enum class FieldFloatMode {
IEEE754_SINGLE,
IEEE754_DOUBLE
};
enum class FieldStringMode {
RAW,
ZERO_PADDED,
ZERO_TERMINATED
};
enum class FieldStringEncoding {
RAW,
UTF8,
UTF16
};

class FieldType {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<FieldType>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<FieldType>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<FieldType>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  FieldType(std::string object_type) : object_type(object_type) {}
  virtual ~FieldType() {}

  static std::shared_ptr<FieldType> polymorphicLoad(const msgpack::object& obj);
};


class FieldTypeFixed {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<FieldTypeFixed>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<FieldTypeFixed>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<FieldTypeFixed>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  FieldTypeFixed(std::string object_type) : object_type(object_type) {}
  virtual ~FieldTypeFixed() {}

  static std::shared_ptr<FieldTypeFixed> polymorphicLoad(const msgpack::object& obj);
};


class FieldTypeFloat {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<FieldTypeFloat>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<FieldTypeFloat>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<FieldTypeFloat>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  FieldTypeFloat(std::string object_type) : object_type(object_type) {}
  virtual ~FieldTypeFloat() {}

  static std::shared_ptr<FieldTypeFloat> polymorphicLoad(const msgpack::object& obj);
};


class FieldTypeString {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<FieldTypeString>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<FieldTypeString>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<FieldTypeString>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  FieldTypeString(std::string object_type) : object_type(object_type) {}
  virtual ~FieldTypeString() {}

  static std::shared_ptr<FieldTypeString> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItem {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItem>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItem>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItem>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItem(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItem() {}

  static std::shared_ptr<ChunkDataItem> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItemSubchunk {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItemSubchunk>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItemSubchunk>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItemSubchunk>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItemSubchunk(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItemSubchunk() {}

  static std::shared_ptr<ChunkDataItemSubchunk> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItemSubblob {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItemSubblob>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItemSubblob>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItemSubblob>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItemSubblob(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItemSubblob() {}

  static std::shared_ptr<ChunkDataItemSubblob> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItemField {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItemField>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItemField>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItemField>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItemField(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItemField() {}

  static std::shared_ptr<ChunkDataItemField> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItemComputed {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItemComputed>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItemComputed>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItemComputed>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItemComputed(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItemComputed() {}

  static std::shared_ptr<ChunkDataItemComputed> polymorphicLoad(const msgpack::object& obj);
};


class ChunkDataItemPad {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
  }
  template<typename T> static std::shared_ptr<ChunkDataItemPad>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<ChunkDataItemPad>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<ChunkDataItemPad>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  ChunkDataItemPad(std::string object_type) : object_type(object_type) {}
  virtual ~ChunkDataItemPad() {}

  static std::shared_ptr<ChunkDataItemPad> polymorphicLoad(const msgpack::object& obj);
};

}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {

class Connection {
 public:
  class Builder {
  uint64_t client_id;
  std::shared_ptr<std::string> client_name;
  std::shared_ptr<std::string> client_version;
  std::shared_ptr<std::string> client_description;
  std::shared_ptr<std::string> client_type;

 public:
  Builder() : client_id(UINT64_C(0)), client_name(nullptr), client_version(nullptr), client_description(nullptr), client_type(nullptr) {}
  
    Builder& set_client_id(uint64_t client_id);

    Builder& set_client_name(std::shared_ptr<std::string> client_name);

    Builder& set_client_version(std::shared_ptr<std::string> client_version);

    Builder& set_client_description(std::shared_ptr<std::string> client_description);

    Builder& set_client_type(std::shared_ptr<std::string> client_type);

    std::shared_ptr<veles::proto::Connection> build();
  };
  uint64_t client_id;
  std::shared_ptr<std::string> client_name;
  std::shared_ptr<std::string> client_version;
  std::shared_ptr<std::string> client_description;
  std::shared_ptr<std::string> client_type;
  Connection(uint64_t client_id, std::shared_ptr<std::string> client_name, std::shared_ptr<std::string> client_version, std::shared_ptr<std::string> client_description, std::shared_ptr<std::string> client_type) : client_id(client_id), client_name(client_name), client_version(client_version), client_description(client_description), client_type(client_type) {}

  static std::shared_ptr<veles::proto::Connection> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {

class Operation {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
    objectTypes()["create"] = &createInstance<OperationCreate>;
    objectTypes()["delete"] = &createInstance<OperationDelete>;
    objectTypes()["set_parent"] = &createInstance<OperationSetParent>;
    objectTypes()["set_pos"] = &createInstance<OperationSetPos>;
    objectTypes()["add_tag"] = &createInstance<OperationAddTag>;
    objectTypes()["del_tag"] = &createInstance<OperationDelTag>;
    objectTypes()["set_attr"] = &createInstance<OperationSetAttr>;
    objectTypes()["set_data"] = &createInstance<OperationSetData>;
    objectTypes()["set_bindata"] = &createInstance<OperationSetBinData>;
    objectTypes()["add_trigger"] = &createInstance<OperationAddTrigger>;
    objectTypes()["del_trigger"] = &createInstance<OperationDelTrigger>;
  }
  template<typename T> static std::shared_ptr<Operation>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<Operation>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<Operation>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  Operation(std::string object_type) : object_type(object_type) {}
  virtual ~Operation() {}

  static std::shared_ptr<Operation> polymorphicLoad(const msgpack::object& obj);
};


class OperationCreate : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers;

 public:
  Builder() : node(nullptr), parent(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)), tags(nullptr), attr(nullptr), data(nullptr), bindata(nullptr), triggers(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    Builder& set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr);

    Builder& set_data(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data);

    Builder& set_bindata(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata);

    Builder& set_triggers(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers);

    std::shared_ptr<veles::proto::OperationCreate> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers;
  OperationCreate(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<veles::data::NodeID> parent, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers) : Operation("create"), node(node), parent(parent), pos_start(pos_start), pos_end(pos_end), tags(tags), attr(attr), data(data), bindata(bindata), triggers(triggers) {}

  static std::shared_ptr<veles::proto::OperationCreate> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationDelete : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;

 public:
  Builder() : node(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    std::shared_ptr<veles::proto::OperationDelete> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  OperationDelete(std::shared_ptr<veles::data::NodeID> node) : Operation("delete"), node(node) {}

  static std::shared_ptr<veles::proto::OperationDelete> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationSetParent : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;

 public:
  Builder() : node(nullptr), parent(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    std::shared_ptr<veles::proto::OperationSetParent> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<veles::data::NodeID> parent;
  OperationSetParent(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<veles::data::NodeID> parent) : Operation("set_parent"), node(node), parent(parent) {}

  static std::shared_ptr<veles::proto::OperationSetParent> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationSetPos : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;

 public:
  Builder() : node(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    std::shared_ptr<veles::proto::OperationSetPos> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  OperationSetPos(std::shared_ptr<veles::data::NodeID> node, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end) : Operation("set_pos"), node(node), pos_start(pos_start), pos_end(pos_end) {}

  static std::shared_ptr<veles::proto::OperationSetPos> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationAddTag : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;

 public:
  Builder() : node(nullptr), tag(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_tag(std::shared_ptr<std::string> tag);

    std::shared_ptr<veles::proto::OperationAddTag> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;
  OperationAddTag(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> tag) : Operation("add_tag"), node(node), tag(tag) {}

  static std::shared_ptr<veles::proto::OperationAddTag> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationDelTag : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;

 public:
  Builder() : node(nullptr), tag(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_tag(std::shared_ptr<std::string> tag);

    std::shared_ptr<veles::proto::OperationDelTag> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> tag;
  OperationDelTag(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> tag) : Operation("del_tag"), node(node), tag(tag) {}

  static std::shared_ptr<veles::proto::OperationDelTag> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationSetAttr : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : node(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::OperationSetAttr> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  OperationSetAttr(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : Operation("set_attr"), node(node), key(key), data(data) {}

  static std::shared_ptr<veles::proto::OperationSetAttr> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationSetData : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : node(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::OperationSetData> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  OperationSetData(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : Operation("set_data"), node(node), key(key), data(data) {}

  static std::shared_ptr<veles::proto::OperationSetData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationSetBinData : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::shared_ptr<std::vector<uint8_t>> data;
  bool truncate;

 public:
  Builder() : node(nullptr), key(nullptr), start(UINT64_C(0)), data(nullptr), truncate(false) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_start(uint64_t start);

    Builder& set_data(std::shared_ptr<std::vector<uint8_t>> data);

    Builder& set_truncate(bool truncate);

    std::shared_ptr<veles::proto::OperationSetBinData> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::shared_ptr<std::vector<uint8_t>> data;
  bool truncate;
  OperationSetBinData(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> key, uint64_t start, std::shared_ptr<std::vector<uint8_t>> data, bool truncate) : Operation("set_bindata"), node(node), key(key), start(start), data(data), truncate(truncate) {}

  static std::shared_ptr<veles::proto::OperationSetBinData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationAddTrigger : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> trigger;

 public:
  Builder() : node(nullptr), trigger(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_trigger(std::shared_ptr<std::string> trigger);

    std::shared_ptr<veles::proto::OperationAddTrigger> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> trigger;
  OperationAddTrigger(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> trigger) : Operation("add_trigger"), node(node), trigger(trigger) {}

  static std::shared_ptr<veles::proto::OperationAddTrigger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class OperationDelTrigger : public Operation {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> trigger;

 public:
  Builder() : node(nullptr), trigger(nullptr) {}
  
    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_trigger(std::shared_ptr<std::string> trigger);

    std::shared_ptr<veles::proto::OperationDelTrigger> build();
  };
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> trigger;
  OperationDelTrigger(std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> trigger) : Operation("del_trigger"), node(node), trigger(trigger) {}

  static std::shared_ptr<veles::proto::OperationDelTrigger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {
const int64_t PROTO_VERSION = 1;

class MsgpackMsg {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
    objectTypes()["connect"] = &createInstance<MsgConnect>;
    objectTypes()["connected"] = &createInstance<MsgConnected>;
    objectTypes()["connection_error"] = &createInstance<MsgConnectionError>;
    objectTypes()["proto_error"] = &createInstance<MsgProtoError>;
    objectTypes()["get"] = &createInstance<MsgGet>;
    objectTypes()["get_reply"] = &createInstance<MsgGetReply>;
    objectTypes()["get_data"] = &createInstance<MsgGetData>;
    objectTypes()["get_data_reply"] = &createInstance<MsgGetDataReply>;
    objectTypes()["get_bindata"] = &createInstance<MsgGetBinData>;
    objectTypes()["get_bindata_reply"] = &createInstance<MsgGetBinDataReply>;
    objectTypes()["get_list"] = &createInstance<MsgGetList>;
    objectTypes()["get_list_reply"] = &createInstance<MsgGetListReply>;
    objectTypes()["get_query"] = &createInstance<MsgGetQuery>;
    objectTypes()["get_query_reply"] = &createInstance<MsgGetQueryReply>;
    objectTypes()["list_connections"] = &createInstance<MsgListConnections>;
    objectTypes()["connections_reply"] = &createInstance<MsgConnectionsReply>;
    objectTypes()["query_error"] = &createInstance<MsgQueryError>;
    objectTypes()["cancel_subscription"] = &createInstance<MsgCancelSubscription>;
    objectTypes()["subscription_cancelled"] = &createInstance<MsgSubscriptionCancelled>;
    objectTypes()["create"] = &createInstance<MsgCreate>;
    objectTypes()["delete"] = &createInstance<MsgDelete>;
    objectTypes()["set_parent"] = &createInstance<MsgSetParent>;
    objectTypes()["set_pos"] = &createInstance<MsgSetPos>;
    objectTypes()["add_tag"] = &createInstance<MsgAddTag>;
    objectTypes()["del_tag"] = &createInstance<MsgDelTag>;
    objectTypes()["set_attr"] = &createInstance<MsgSetAttr>;
    objectTypes()["set_data"] = &createInstance<MsgSetData>;
    objectTypes()["set_bindata"] = &createInstance<MsgSetBinData>;
    objectTypes()["transaction"] = &createInstance<MsgTransaction>;
    objectTypes()["request_ack"] = &createInstance<MsgRequestAck>;
    objectTypes()["request_error"] = &createInstance<MsgRequestError>;
    objectTypes()["method_run"] = &createInstance<MsgMethodRun>;
    objectTypes()["method_result"] = &createInstance<MsgMethodResult>;
    objectTypes()["method_error"] = &createInstance<MsgMethodError>;
    objectTypes()["broadcast_run"] = &createInstance<MsgBroadcastRun>;
    objectTypes()["broadcast_result"] = &createInstance<MsgBroadcastResult>;
    objectTypes()["plugin_method_register"] = &createInstance<MsgPluginMethodRegister>;
    objectTypes()["plugin_method_run"] = &createInstance<MsgPluginMethodRun>;
    objectTypes()["plugin_method_result"] = &createInstance<MsgPluginMethodResult>;
    objectTypes()["plugin_method_error"] = &createInstance<MsgPluginMethodError>;
    objectTypes()["plugin_query_register"] = &createInstance<MsgPluginQueryRegister>;
    objectTypes()["plugin_query_get"] = &createInstance<MsgPluginQueryGet>;
    objectTypes()["plugin_query_result"] = &createInstance<MsgPluginQueryResult>;
    objectTypes()["plugin_query_error"] = &createInstance<MsgPluginQueryError>;
    objectTypes()["plugin_broadcast_register"] = &createInstance<MsgPluginBroadcastRegister>;
    objectTypes()["plugin_broadcast_run"] = &createInstance<MsgPluginBroadcastRun>;
    objectTypes()["plugin_broadcast_result"] = &createInstance<MsgPluginBroadcastResult>;
    objectTypes()["plugin_trigger_register"] = &createInstance<MsgPluginTriggerRegister>;
    objectTypes()["plugin_trigger_run"] = &createInstance<MsgPluginTriggerRun>;
    objectTypes()["plugin_trigger_done"] = &createInstance<MsgPluginTriggerDone>;
    objectTypes()["plugin_trigger_error"] = &createInstance<MsgPluginTriggerError>;
    objectTypes()["plugin_handler_unregister"] = &createInstance<MsgPluginHandlerUnregister>;
    objectTypes()["plugin_handler_unregistered"] = &createInstance<MsgPluginHandlerUnregistered>;
  }
  template<typename T> static std::shared_ptr<MsgpackMsg>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<MsgpackMsg>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<MsgpackMsg>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  MsgpackMsg(std::string object_type) : object_type(object_type) {}
  virtual ~MsgpackMsg() {}

  static std::shared_ptr<MsgpackMsg> polymorphicLoad(const msgpack::object& obj);
};


class MsgConnect : public MsgpackMsg {
 public:
  class Builder {
  int64_t proto_version;
  std::pair<bool, std::shared_ptr<std::string>> client_name;
  std::pair<bool, std::shared_ptr<std::string>> client_version;
  std::pair<bool, std::shared_ptr<std::string>> client_description;
  std::pair<bool, std::shared_ptr<std::string>> client_type;
  bool quit_on_close;

 public:
  Builder() : proto_version(INT64_C(0)), client_name(false, nullptr), client_version(false, nullptr), client_description(false, nullptr), client_type(false, nullptr), quit_on_close(false) {}
  
    Builder& set_proto_version(int64_t proto_version);

    Builder& set_client_name(const std::pair<bool, std::shared_ptr<std::string>>& client_name);

    Builder& set_client_version(const std::pair<bool, std::shared_ptr<std::string>>& client_version);

    Builder& set_client_description(const std::pair<bool, std::shared_ptr<std::string>>& client_description);

    Builder& set_client_type(const std::pair<bool, std::shared_ptr<std::string>>& client_type);

    Builder& set_quit_on_close(bool quit_on_close);

    std::shared_ptr<veles::proto::MsgConnect> build();
  };
  int64_t proto_version;
  std::pair<bool, std::shared_ptr<std::string>> client_name;
  std::pair<bool, std::shared_ptr<std::string>> client_version;
  std::pair<bool, std::shared_ptr<std::string>> client_description;
  std::pair<bool, std::shared_ptr<std::string>> client_type;
  bool quit_on_close;
  MsgConnect(int64_t proto_version, const std::pair<bool, std::shared_ptr<std::string>>& client_name, const std::pair<bool, std::shared_ptr<std::string>>& client_version, const std::pair<bool, std::shared_ptr<std::string>>& client_description, const std::pair<bool, std::shared_ptr<std::string>>& client_type, bool quit_on_close) : MsgpackMsg("connect"), proto_version(proto_version), client_name(client_name), client_version(client_version), client_description(client_description), client_type(client_type), quit_on_close(quit_on_close) {}

  static std::shared_ptr<veles::proto::MsgConnect> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgConnected : public MsgpackMsg {
 public:
  class Builder {
  int64_t proto_version;
  std::shared_ptr<std::string> server_name;
  std::shared_ptr<std::string> server_version;

 public:
  Builder() : proto_version(INT64_C(0)), server_name(nullptr), server_version(nullptr) {}
  
    Builder& set_proto_version(int64_t proto_version);

    Builder& set_server_name(std::shared_ptr<std::string> server_name);

    Builder& set_server_version(std::shared_ptr<std::string> server_version);

    std::shared_ptr<veles::proto::MsgConnected> build();
  };
  int64_t proto_version;
  std::shared_ptr<std::string> server_name;
  std::shared_ptr<std::string> server_version;
  MsgConnected(int64_t proto_version, std::shared_ptr<std::string> server_name, std::shared_ptr<std::string> server_version) : MsgpackMsg("connected"), proto_version(proto_version), server_name(server_name), server_version(server_version) {}

  static std::shared_ptr<veles::proto::MsgConnected> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgConnectionError : public MsgpackMsg {
 public:
  class Builder {
  std::shared_ptr<veles::proto::VelesException> err;

 public:
  Builder() : err(nullptr) {}
  
    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    std::shared_ptr<veles::proto::MsgConnectionError> build();
  };
  std::shared_ptr<veles::proto::VelesException> err;
  MsgConnectionError(std::shared_ptr<veles::proto::VelesException> err) : MsgpackMsg("connection_error"), err(err) {}

  static std::shared_ptr<veles::proto::MsgConnectionError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgProtoError : public MsgpackMsg {
 public:
  class Builder {
  std::shared_ptr<veles::proto::VelesException> err;

 public:
  Builder() : err(nullptr) {}
  
    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    std::shared_ptr<veles::proto::MsgProtoError> build();
  };
  std::shared_ptr<veles::proto::VelesException> err;
  MsgProtoError(std::shared_ptr<veles::proto::VelesException> err) : MsgpackMsg("proto_error"), err(err) {}

  static std::shared_ptr<veles::proto::MsgProtoError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGet : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), id(nullptr), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgGet> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  bool sub;
  MsgGet(uint64_t qid, std::shared_ptr<veles::data::NodeID> id, bool sub) : MsgpackMsg("get"), qid(qid), id(id), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgGet> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::proto::Node> obj;

 public:
  Builder() : qid(UINT64_C(0)), obj(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_obj(std::shared_ptr<veles::proto::Node> obj);

    std::shared_ptr<veles::proto::MsgGetReply> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::proto::Node> obj;
  MsgGetReply(uint64_t qid, std::shared_ptr<veles::proto::Node> obj) : MsgpackMsg("get_reply"), qid(qid), obj(obj) {}

  static std::shared_ptr<veles::proto::MsgGetReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetData : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), id(nullptr), key(nullptr), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgGetData> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  bool sub;
  MsgGetData(uint64_t qid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> key, bool sub) : MsgpackMsg("get_data"), qid(qid), id(id), key(key), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgGetData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetDataReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : qid(UINT64_C(0)), data(false, nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::MsgGetDataReply> build();
  };
  uint64_t qid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  MsgGetDataReply(uint64_t qid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : MsgpackMsg("get_data_reply"), qid(qid), data(data) {}

  static std::shared_ptr<veles::proto::MsgGetDataReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetBinData : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::pair<bool, uint64_t> end;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), id(nullptr), key(nullptr), start(UINT64_C(0)), end(false, UINT64_C(0)), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_start(uint64_t start);

    Builder& set_end(const std::pair<bool, uint64_t>& end);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgGetBinData> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::pair<bool, uint64_t> end;
  bool sub;
  MsgGetBinData(uint64_t qid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> key, uint64_t start, const std::pair<bool, uint64_t>& end, bool sub) : MsgpackMsg("get_bindata"), qid(qid), id(id), key(key), start(start), end(end), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgGetBinData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetBinDataReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<std::vector<uint8_t>> data;

 public:
  Builder() : qid(UINT64_C(0)), data(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_data(std::shared_ptr<std::vector<uint8_t>> data);

    std::shared_ptr<veles::proto::MsgGetBinDataReply> build();
  };
  uint64_t qid;
  std::shared_ptr<std::vector<uint8_t>> data;
  MsgGetBinDataReply(uint64_t qid, std::shared_ptr<std::vector<uint8_t>> data) : MsgpackMsg("get_bindata_reply"), qid(qid), data(data) {}

  static std::shared_ptr<veles::proto::MsgGetBinDataReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetList : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> parent;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<veles::proto::PosFilter> pos_filter;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), parent(nullptr), tags(nullptr), pos_filter(nullptr), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    Builder& set_pos_filter(std::shared_ptr<veles::proto::PosFilter> pos_filter);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgGetList> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> parent;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<veles::proto::PosFilter> pos_filter;
  bool sub;
  MsgGetList(uint64_t qid, std::shared_ptr<veles::data::NodeID> parent, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags, std::shared_ptr<veles::proto::PosFilter> pos_filter, bool sub) : MsgpackMsg("get_list"), qid(qid), parent(parent), tags(tags), pos_filter(pos_filter), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgGetList> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetListReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> objs;
  std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> gone;

 public:
  Builder() : qid(UINT64_C(0)), objs(nullptr), gone(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_objs(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> objs);

    Builder& set_gone(std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> gone);

    std::shared_ptr<veles::proto::MsgGetListReply> build();
  };
  uint64_t qid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> objs;
  std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> gone;
  MsgGetListReply(uint64_t qid, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> objs, std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> gone) : MsgpackMsg("get_list_reply"), qid(qid), objs(objs), gone(gone) {}

  static std::shared_ptr<veles::proto::MsgGetListReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetQuery : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> query;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  bool trace;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), node(nullptr), query(nullptr), params(false, nullptr), trace(false), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_query(std::shared_ptr<std::string> query);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    Builder& set_trace(bool trace);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgGetQuery> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> query;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  bool trace;
  bool sub;
  MsgGetQuery(uint64_t qid, std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> query, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params, bool trace, bool sub) : MsgpackMsg("get_query"), qid(qid), node(node), query(query), params(params), trace(trace), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgGetQuery> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgGetQueryReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : qid(UINT64_C(0)), result(false, nullptr), checks(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgGetQueryReply> build();
  };
  uint64_t qid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgGetQueryReply(uint64_t qid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("get_query_reply"), qid(qid), result(result), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgGetQueryReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgListConnections : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  bool sub;

 public:
  Builder() : qid(UINT64_C(0)), sub(false) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_sub(bool sub);

    std::shared_ptr<veles::proto::MsgListConnections> build();
  };
  uint64_t qid;
  bool sub;
  MsgListConnections(uint64_t qid, bool sub) : MsgpackMsg("list_connections"), qid(qid), sub(sub) {}

  static std::shared_ptr<veles::proto::MsgListConnections> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgConnectionsReply : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> connections;

 public:
  Builder() : qid(UINT64_C(0)), connections(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_connections(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> connections);

    std::shared_ptr<veles::proto::MsgConnectionsReply> build();
  };
  uint64_t qid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> connections;
  MsgConnectionsReply(uint64_t qid, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> connections) : MsgpackMsg("connections_reply"), qid(qid), connections(connections) {}

  static std::shared_ptr<veles::proto::MsgConnectionsReply> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgQueryError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : qid(UINT64_C(0)), err(nullptr), checks(nullptr) {}
  
    Builder& set_qid(uint64_t qid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgQueryError> build();
  };
  uint64_t qid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgQueryError(uint64_t qid, std::shared_ptr<veles::proto::VelesException> err, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("query_error"), qid(qid), err(err), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgQueryError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgCancelSubscription : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;

 public:
  Builder() : qid(UINT64_C(0)) {}
  
    Builder& set_qid(uint64_t qid);

    std::shared_ptr<veles::proto::MsgCancelSubscription> build();
  };
  uint64_t qid;
  MsgCancelSubscription(uint64_t qid) : MsgpackMsg("cancel_subscription"), qid(qid) {}

  static std::shared_ptr<veles::proto::MsgCancelSubscription> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSubscriptionCancelled : public MsgpackMsg {
 public:
  class Builder {
  uint64_t qid;

 public:
  Builder() : qid(UINT64_C(0)) {}
  
    Builder& set_qid(uint64_t qid);

    std::shared_ptr<veles::proto::MsgSubscriptionCancelled> build();
  };
  uint64_t qid;
  MsgSubscriptionCancelled(uint64_t qid) : MsgpackMsg("subscription_cancelled"), qid(qid) {}

  static std::shared_ptr<veles::proto::MsgSubscriptionCancelled> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgCreate : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), parent(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)), tags(nullptr), attr(nullptr), data(nullptr), bindata(nullptr), triggers(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    Builder& set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr);

    Builder& set_data(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data);

    Builder& set_bindata(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata);

    Builder& set_triggers(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers);

    std::shared_ptr<veles::proto::MsgCreate> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data;
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers;
  MsgCreate(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<veles::data::NodeID> parent, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data, std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers) : MsgpackMsg("create"), rid(rid), id(id), parent(parent), pos_start(pos_start), pos_end(pos_end), tags(tags), attr(attr), data(data), bindata(bindata), triggers(triggers) {}

  static std::shared_ptr<veles::proto::MsgCreate> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgDelete : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    std::shared_ptr<veles::proto::MsgDelete> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  MsgDelete(uint64_t rid, std::shared_ptr<veles::data::NodeID> id) : MsgpackMsg("delete"), rid(rid), id(id) {}

  static std::shared_ptr<veles::proto::MsgDelete> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSetParent : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), parent(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_parent(std::shared_ptr<veles::data::NodeID> parent);

    std::shared_ptr<veles::proto::MsgSetParent> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<veles::data::NodeID> parent;
  MsgSetParent(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<veles::data::NodeID> parent) : MsgpackMsg("set_parent"), rid(rid), id(id), parent(parent) {}

  static std::shared_ptr<veles::proto::MsgSetParent> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSetPos : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), pos_start(false, INT64_C(0)), pos_end(false, INT64_C(0)) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_pos_start(const std::pair<bool, int64_t>& pos_start);

    Builder& set_pos_end(const std::pair<bool, int64_t>& pos_end);

    std::shared_ptr<veles::proto::MsgSetPos> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::pair<bool, int64_t> pos_start;
  std::pair<bool, int64_t> pos_end;
  MsgSetPos(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, const std::pair<bool, int64_t>& pos_start, const std::pair<bool, int64_t>& pos_end) : MsgpackMsg("set_pos"), rid(rid), id(id), pos_start(pos_start), pos_end(pos_end) {}

  static std::shared_ptr<veles::proto::MsgSetPos> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgAddTag : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> tag;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), tag(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_tag(std::shared_ptr<std::string> tag);

    std::shared_ptr<veles::proto::MsgAddTag> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> tag;
  MsgAddTag(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> tag) : MsgpackMsg("add_tag"), rid(rid), id(id), tag(tag) {}

  static std::shared_ptr<veles::proto::MsgAddTag> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgDelTag : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> tag;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), tag(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_tag(std::shared_ptr<std::string> tag);

    std::shared_ptr<veles::proto::MsgDelTag> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> tag;
  MsgDelTag(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> tag) : MsgpackMsg("del_tag"), rid(rid), id(id), tag(tag) {}

  static std::shared_ptr<veles::proto::MsgDelTag> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSetAttr : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::MsgSetAttr> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  MsgSetAttr(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : MsgpackMsg("set_attr"), rid(rid), id(id), key(key), data(data) {}

  static std::shared_ptr<veles::proto::MsgSetAttr> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSetData : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), key(nullptr), data(false, nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data);

    std::shared_ptr<veles::proto::MsgSetData> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> data;
  MsgSetData(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> key, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) : MsgpackMsg("set_data"), rid(rid), id(id), key(key), data(data) {}

  static std::shared_ptr<veles::proto::MsgSetData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgSetBinData : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::shared_ptr<std::vector<uint8_t>> data;
  bool truncate;

 public:
  Builder() : rid(UINT64_C(0)), id(nullptr), key(nullptr), start(UINT64_C(0)), data(nullptr), truncate(false) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_id(std::shared_ptr<veles::data::NodeID> id);

    Builder& set_key(std::shared_ptr<std::string> key);

    Builder& set_start(uint64_t start);

    Builder& set_data(std::shared_ptr<std::vector<uint8_t>> data);

    Builder& set_truncate(bool truncate);

    std::shared_ptr<veles::proto::MsgSetBinData> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::data::NodeID> id;
  std::shared_ptr<std::string> key;
  uint64_t start;
  std::shared_ptr<std::vector<uint8_t>> data;
  bool truncate;
  MsgSetBinData(uint64_t rid, std::shared_ptr<veles::data::NodeID> id, std::shared_ptr<std::string> key, uint64_t start, std::shared_ptr<std::vector<uint8_t>> data, bool truncate) : MsgpackMsg("set_bindata"), rid(rid), id(id), key(key), start(start), data(data), truncate(truncate) {}

  static std::shared_ptr<veles::proto::MsgSetBinData> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgTransaction : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> operations;

 public:
  Builder() : rid(UINT64_C(0)), checks(nullptr), operations(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    Builder& set_operations(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> operations);

    std::shared_ptr<veles::proto::MsgTransaction> build();
  };
  uint64_t rid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> operations;
  MsgTransaction(uint64_t rid, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> operations) : MsgpackMsg("transaction"), rid(rid), checks(checks), operations(operations) {}

  static std::shared_ptr<veles::proto::MsgTransaction> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgRequestAck : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;

 public:
  Builder() : rid(UINT64_C(0)) {}
  
    Builder& set_rid(uint64_t rid);

    std::shared_ptr<veles::proto::MsgRequestAck> build();
  };
  uint64_t rid;
  MsgRequestAck(uint64_t rid) : MsgpackMsg("request_ack"), rid(rid) {}

  static std::shared_ptr<veles::proto::MsgRequestAck> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgRequestError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t rid;
  std::shared_ptr<veles::proto::VelesException> err;

 public:
  Builder() : rid(UINT64_C(0)), err(nullptr) {}
  
    Builder& set_rid(uint64_t rid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    std::shared_ptr<veles::proto::MsgRequestError> build();
  };
  uint64_t rid;
  std::shared_ptr<veles::proto::VelesException> err;
  MsgRequestError(uint64_t rid, std::shared_ptr<veles::proto::VelesException> err) : MsgpackMsg("request_error"), rid(rid), err(err) {}

  static std::shared_ptr<veles::proto::MsgRequestError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgMethodRun : public MsgpackMsg {
 public:
  class Builder {
  uint64_t mid;
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> method;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;

 public:
  Builder() : mid(UINT64_C(0)), node(nullptr), method(nullptr), params(false, nullptr) {}
  
    Builder& set_mid(uint64_t mid);

    Builder& set_node(std::shared_ptr<veles::data::NodeID> node);

    Builder& set_method(std::shared_ptr<std::string> method);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    std::shared_ptr<veles::proto::MsgMethodRun> build();
  };
  uint64_t mid;
  std::shared_ptr<veles::data::NodeID> node;
  std::shared_ptr<std::string> method;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  MsgMethodRun(uint64_t mid, std::shared_ptr<veles::data::NodeID> node, std::shared_ptr<std::string> method, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) : MsgpackMsg("method_run"), mid(mid), node(node), method(method), params(params) {}

  static std::shared_ptr<veles::proto::MsgMethodRun> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgMethodResult : public MsgpackMsg {
 public:
  class Builder {
  uint64_t mid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;

 public:
  Builder() : mid(UINT64_C(0)), result(false, nullptr) {}
  
    Builder& set_mid(uint64_t mid);

    Builder& set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result);

    std::shared_ptr<veles::proto::MsgMethodResult> build();
  };
  uint64_t mid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  MsgMethodResult(uint64_t mid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) : MsgpackMsg("method_result"), mid(mid), result(result) {}

  static std::shared_ptr<veles::proto::MsgMethodResult> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgMethodError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t mid;
  std::shared_ptr<veles::proto::VelesException> err;

 public:
  Builder() : mid(UINT64_C(0)), err(nullptr) {}
  
    Builder& set_mid(uint64_t mid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    std::shared_ptr<veles::proto::MsgMethodError> build();
  };
  uint64_t mid;
  std::shared_ptr<veles::proto::VelesException> err;
  MsgMethodError(uint64_t mid, std::shared_ptr<veles::proto::VelesException> err) : MsgpackMsg("method_error"), mid(mid), err(err) {}

  static std::shared_ptr<veles::proto::MsgMethodError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgBroadcastRun : public MsgpackMsg {
 public:
  class Builder {
  uint64_t bid;
  std::shared_ptr<std::string> broadcast;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;

 public:
  Builder() : bid(UINT64_C(0)), broadcast(nullptr), params(false, nullptr) {}
  
    Builder& set_bid(uint64_t bid);

    Builder& set_broadcast(std::shared_ptr<std::string> broadcast);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    std::shared_ptr<veles::proto::MsgBroadcastRun> build();
  };
  uint64_t bid;
  std::shared_ptr<std::string> broadcast;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  MsgBroadcastRun(uint64_t bid, std::shared_ptr<std::string> broadcast, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) : MsgpackMsg("broadcast_run"), bid(bid), broadcast(broadcast), params(params) {}

  static std::shared_ptr<veles::proto::MsgBroadcastRun> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgBroadcastResult : public MsgpackMsg {
 public:
  class Builder {
  uint64_t bid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results;

 public:
  Builder() : bid(UINT64_C(0)), results(nullptr) {}
  
    Builder& set_bid(uint64_t bid);

    Builder& set_results(std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results);

    std::shared_ptr<veles::proto::MsgBroadcastResult> build();
  };
  uint64_t bid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results;
  MsgBroadcastResult(uint64_t bid, std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results) : MsgpackMsg("broadcast_result"), bid(bid), results(results) {}

  static std::shared_ptr<veles::proto::MsgBroadcastResult> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginMethodRegister : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;

 public:
  Builder() : phid(UINT64_C(0)), name(nullptr), tags(nullptr) {}
  
    Builder& set_phid(uint64_t phid);

    Builder& set_name(std::shared_ptr<std::string> name);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    std::shared_ptr<veles::proto::MsgPluginMethodRegister> build();
  };
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  MsgPluginMethodRegister(uint64_t phid, std::shared_ptr<std::string> name, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) : MsgpackMsg("plugin_method_register"), phid(phid), name(name), tags(tags) {}

  static std::shared_ptr<veles::proto::MsgPluginMethodRegister> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginMethodRun : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pmid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;

 public:
  Builder() : pmid(UINT64_C(0)), phid(UINT64_C(0)), node(nullptr), params(false, nullptr) {}
  
    Builder& set_pmid(uint64_t pmid);

    Builder& set_phid(uint64_t phid);

    Builder& set_node(std::shared_ptr<veles::proto::Node> node);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    std::shared_ptr<veles::proto::MsgPluginMethodRun> build();
  };
  uint64_t pmid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  MsgPluginMethodRun(uint64_t pmid, uint64_t phid, std::shared_ptr<veles::proto::Node> node, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) : MsgpackMsg("plugin_method_run"), pmid(pmid), phid(phid), node(node), params(params) {}

  static std::shared_ptr<veles::proto::MsgPluginMethodRun> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginMethodResult : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pmid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;

 public:
  Builder() : pmid(UINT64_C(0)), result(false, nullptr) {}
  
    Builder& set_pmid(uint64_t pmid);

    Builder& set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result);

    std::shared_ptr<veles::proto::MsgPluginMethodResult> build();
  };
  uint64_t pmid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  MsgPluginMethodResult(uint64_t pmid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) : MsgpackMsg("plugin_method_result"), pmid(pmid), result(result) {}

  static std::shared_ptr<veles::proto::MsgPluginMethodResult> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginMethodError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pmid;
  std::shared_ptr<veles::proto::VelesException> err;

 public:
  Builder() : pmid(UINT64_C(0)), err(nullptr) {}
  
    Builder& set_pmid(uint64_t pmid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    std::shared_ptr<veles::proto::MsgPluginMethodError> build();
  };
  uint64_t pmid;
  std::shared_ptr<veles::proto::VelesException> err;
  MsgPluginMethodError(uint64_t pmid, std::shared_ptr<veles::proto::VelesException> err) : MsgpackMsg("plugin_method_error"), pmid(pmid), err(err) {}

  static std::shared_ptr<veles::proto::MsgPluginMethodError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginQueryRegister : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;

 public:
  Builder() : phid(UINT64_C(0)), name(nullptr), tags(nullptr) {}
  
    Builder& set_phid(uint64_t phid);

    Builder& set_name(std::shared_ptr<std::string> name);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    std::shared_ptr<veles::proto::MsgPluginQueryRegister> build();
  };
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  MsgPluginQueryRegister(uint64_t phid, std::shared_ptr<std::string> name, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) : MsgpackMsg("plugin_query_register"), phid(phid), name(name), tags(tags) {}

  static std::shared_ptr<veles::proto::MsgPluginQueryRegister> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginQueryGet : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pqid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;

 public:
  Builder() : pqid(UINT64_C(0)), phid(UINT64_C(0)), node(nullptr), params(false, nullptr) {}
  
    Builder& set_pqid(uint64_t pqid);

    Builder& set_phid(uint64_t phid);

    Builder& set_node(std::shared_ptr<veles::proto::Node> node);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    std::shared_ptr<veles::proto::MsgPluginQueryGet> build();
  };
  uint64_t pqid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  MsgPluginQueryGet(uint64_t pqid, uint64_t phid, std::shared_ptr<veles::proto::Node> node, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) : MsgpackMsg("plugin_query_get"), pqid(pqid), phid(phid), node(node), params(params) {}

  static std::shared_ptr<veles::proto::MsgPluginQueryGet> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginQueryResult : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pqid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : pqid(UINT64_C(0)), result(false, nullptr), checks(nullptr) {}
  
    Builder& set_pqid(uint64_t pqid);

    Builder& set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgPluginQueryResult> build();
  };
  uint64_t pqid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> result;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgPluginQueryResult(uint64_t pqid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("plugin_query_result"), pqid(pqid), result(result), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgPluginQueryResult> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginQueryError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pqid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : pqid(UINT64_C(0)), err(nullptr), checks(nullptr) {}
  
    Builder& set_pqid(uint64_t pqid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgPluginQueryError> build();
  };
  uint64_t pqid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgPluginQueryError(uint64_t pqid, std::shared_ptr<veles::proto::VelesException> err, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("plugin_query_error"), pqid(pqid), err(err), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgPluginQueryError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginBroadcastRegister : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;
  std::shared_ptr<std::string> name;

 public:
  Builder() : phid(UINT64_C(0)), name(nullptr) {}
  
    Builder& set_phid(uint64_t phid);

    Builder& set_name(std::shared_ptr<std::string> name);

    std::shared_ptr<veles::proto::MsgPluginBroadcastRegister> build();
  };
  uint64_t phid;
  std::shared_ptr<std::string> name;
  MsgPluginBroadcastRegister(uint64_t phid, std::shared_ptr<std::string> name) : MsgpackMsg("plugin_broadcast_register"), phid(phid), name(name) {}

  static std::shared_ptr<veles::proto::MsgPluginBroadcastRegister> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginBroadcastRun : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pbid;
  uint64_t phid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;

 public:
  Builder() : pbid(UINT64_C(0)), phid(UINT64_C(0)), params(false, nullptr) {}
  
    Builder& set_pbid(uint64_t pbid);

    Builder& set_phid(uint64_t phid);

    Builder& set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params);

    std::shared_ptr<veles::proto::MsgPluginBroadcastRun> build();
  };
  uint64_t pbid;
  uint64_t phid;
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> params;
  MsgPluginBroadcastRun(uint64_t pbid, uint64_t phid, const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) : MsgpackMsg("plugin_broadcast_run"), pbid(pbid), phid(phid), params(params) {}

  static std::shared_ptr<veles::proto::MsgPluginBroadcastRun> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginBroadcastResult : public MsgpackMsg {
 public:
  class Builder {
  uint64_t pbid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results;

 public:
  Builder() : pbid(UINT64_C(0)), results(nullptr) {}
  
    Builder& set_pbid(uint64_t pbid);

    Builder& set_results(std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results);

    std::shared_ptr<veles::proto::MsgPluginBroadcastResult> build();
  };
  uint64_t pbid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results;
  MsgPluginBroadcastResult(uint64_t pbid, std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results) : MsgpackMsg("plugin_broadcast_result"), pbid(pbid), results(results) {}

  static std::shared_ptr<veles::proto::MsgPluginBroadcastResult> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginTriggerRegister : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;

 public:
  Builder() : phid(UINT64_C(0)), name(nullptr), tags(nullptr) {}
  
    Builder& set_phid(uint64_t phid);

    Builder& set_name(std::shared_ptr<std::string> name);

    Builder& set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags);

    std::shared_ptr<veles::proto::MsgPluginTriggerRegister> build();
  };
  uint64_t phid;
  std::shared_ptr<std::string> name;
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags;
  MsgPluginTriggerRegister(uint64_t phid, std::shared_ptr<std::string> name, std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) : MsgpackMsg("plugin_trigger_register"), phid(phid), name(name), tags(tags) {}

  static std::shared_ptr<veles::proto::MsgPluginTriggerRegister> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginTriggerRun : public MsgpackMsg {
 public:
  class Builder {
  uint64_t ptid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;

 public:
  Builder() : ptid(UINT64_C(0)), phid(UINT64_C(0)), node(nullptr) {}
  
    Builder& set_ptid(uint64_t ptid);

    Builder& set_phid(uint64_t phid);

    Builder& set_node(std::shared_ptr<veles::proto::Node> node);

    std::shared_ptr<veles::proto::MsgPluginTriggerRun> build();
  };
  uint64_t ptid;
  uint64_t phid;
  std::shared_ptr<veles::proto::Node> node;
  MsgPluginTriggerRun(uint64_t ptid, uint64_t phid, std::shared_ptr<veles::proto::Node> node) : MsgpackMsg("plugin_trigger_run"), ptid(ptid), phid(phid), node(node) {}

  static std::shared_ptr<veles::proto::MsgPluginTriggerRun> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginTriggerDone : public MsgpackMsg {
 public:
  class Builder {
  uint64_t ptid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : ptid(UINT64_C(0)), checks(nullptr) {}
  
    Builder& set_ptid(uint64_t ptid);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgPluginTriggerDone> build();
  };
  uint64_t ptid;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgPluginTriggerDone(uint64_t ptid, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("plugin_trigger_done"), ptid(ptid), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgPluginTriggerDone> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginTriggerError : public MsgpackMsg {
 public:
  class Builder {
  uint64_t ptid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;

 public:
  Builder() : ptid(UINT64_C(0)), err(nullptr), checks(nullptr) {}
  
    Builder& set_ptid(uint64_t ptid);

    Builder& set_err(std::shared_ptr<veles::proto::VelesException> err);

    Builder& set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks);

    std::shared_ptr<veles::proto::MsgPluginTriggerError> build();
  };
  uint64_t ptid;
  std::shared_ptr<veles::proto::VelesException> err;
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks;
  MsgPluginTriggerError(uint64_t ptid, std::shared_ptr<veles::proto::VelesException> err, std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) : MsgpackMsg("plugin_trigger_error"), ptid(ptid), err(err), checks(checks) {}

  static std::shared_ptr<veles::proto::MsgPluginTriggerError> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginHandlerUnregister : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;

 public:
  Builder() : phid(UINT64_C(0)) {}
  
    Builder& set_phid(uint64_t phid);

    std::shared_ptr<veles::proto::MsgPluginHandlerUnregister> build();
  };
  uint64_t phid;
  MsgPluginHandlerUnregister(uint64_t phid) : MsgpackMsg("plugin_handler_unregister"), phid(phid) {}

  static std::shared_ptr<veles::proto::MsgPluginHandlerUnregister> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MsgPluginHandlerUnregistered : public MsgpackMsg {
 public:
  class Builder {
  uint64_t phid;

 public:
  Builder() : phid(UINT64_C(0)) {}
  
    Builder& set_phid(uint64_t phid);

    std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered> build();
  };
  uint64_t phid;
  MsgPluginHandlerUnregistered(uint64_t phid) : MsgpackMsg("plugin_handler_unregistered"), phid(phid) {}

  static std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace proto
}  // namespace veles
namespace veles {
namespace proto {
const int64_t EXT_NODE_ID = 0;
const int64_t EXT_BINDATA = 1;
const int64_t EXT_BIGINT = 2;
}  // namespace proto
}  // namespace veles
namespace veles {
namespace tests {
namespace schema {
enum class TestEnum {
OPT1,
OPT2
};

class Any {
 public:
  class Builder {
  std::shared_ptr<veles::messages::MsgpackObject> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<veles::messages::MsgpackObject> a);

    std::shared_ptr<veles::tests::schema::Any> build();
  };
  std::shared_ptr<veles::messages::MsgpackObject> a;
  Any(std::shared_ptr<veles::messages::MsgpackObject> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Any> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class AnyOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& a);

    std::shared_ptr<veles::tests::schema::AnyOptional> build();
  };
  std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>> a;
  AnyOptional(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::AnyOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Integer {
 public:
  class Builder {
  int64_t a;

 public:
  Builder() : a(INT64_C(-42)) {}
  
    Builder& set_a(int64_t a);

    std::shared_ptr<veles::tests::schema::Integer> build();
  };
  int64_t a;
  Integer(int64_t a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Integer> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class IntegerOptional {
 public:
  class Builder {
  std::pair<bool, int64_t> a;

 public:
  Builder() : a(false, INT64_C(0)) {}
  
    Builder& set_a(const std::pair<bool, int64_t>& a);

    std::shared_ptr<veles::tests::schema::IntegerOptional> build();
  };
  std::pair<bool, int64_t> a;
  IntegerOptional(const std::pair<bool, int64_t>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::IntegerOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class UnsignedInteger {
 public:
  class Builder {
  uint64_t a;

 public:
  Builder() : a(UINT64_C(42)) {}
  
    Builder& set_a(uint64_t a);

    std::shared_ptr<veles::tests::schema::UnsignedInteger> build();
  };
  uint64_t a;
  UnsignedInteger(uint64_t a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::UnsignedInteger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class UnsignedIntegerOptional {
 public:
  class Builder {
  std::pair<bool, uint64_t> a;

 public:
  Builder() : a(false, UINT64_C(0)) {}
  
    Builder& set_a(const std::pair<bool, uint64_t>& a);

    std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional> build();
  };
  std::pair<bool, uint64_t> a;
  UnsignedIntegerOptional(const std::pair<bool, uint64_t>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SmallInteger {
 public:
  class Builder {
  int64_t a;

 public:
  Builder() : a(INT64_C(-42)) {}
  
    Builder& set_a(int64_t a);

    std::shared_ptr<veles::tests::schema::SmallInteger> build();
  };
  int64_t a;
  SmallInteger(int64_t a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::SmallInteger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SmallIntegerOptional {
 public:
  class Builder {
  std::pair<bool, int64_t> a;

 public:
  Builder() : a(false, INT64_C(0)) {}
  
    Builder& set_a(const std::pair<bool, int64_t>& a);

    std::shared_ptr<veles::tests::schema::SmallIntegerOptional> build();
  };
  std::pair<bool, int64_t> a;
  SmallIntegerOptional(const std::pair<bool, int64_t>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::SmallIntegerOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SmallUnsignedInteger {
 public:
  class Builder {
  uint64_t a;

 public:
  Builder() : a(UINT64_C(42)) {}
  
    Builder& set_a(uint64_t a);

    std::shared_ptr<veles::tests::schema::SmallUnsignedInteger> build();
  };
  uint64_t a;
  SmallUnsignedInteger(uint64_t a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::SmallUnsignedInteger> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SmallUnsignedIntegerOptional {
 public:
  class Builder {
  std::pair<bool, uint64_t> a;

 public:
  Builder() : a(false, UINT64_C(0)) {}
  
    Builder& set_a(const std::pair<bool, uint64_t>& a);

    std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional> build();
  };
  std::pair<bool, uint64_t> a;
  SmallUnsignedIntegerOptional(const std::pair<bool, uint64_t>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Boolean {
 public:
  class Builder {
  bool a;

 public:
  Builder() : a(true) {}
  
    Builder& set_a(bool a);

    std::shared_ptr<veles::tests::schema::Boolean> build();
  };
  bool a;
  Boolean(bool a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Boolean> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class BooleanOptional {
 public:
  class Builder {
  std::pair<bool, bool> a;

 public:
  Builder() : a(false, false) {}
  
    Builder& set_a(const std::pair<bool, bool>& a);

    std::shared_ptr<veles::tests::schema::BooleanOptional> build();
  };
  std::pair<bool, bool> a;
  BooleanOptional(const std::pair<bool, bool>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::BooleanOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Float {
 public:
  class Builder {
  double a;

 public:
  Builder() : a(5.0) {}
  
    Builder& set_a(double a);

    std::shared_ptr<veles::tests::schema::Float> build();
  };
  double a;
  Float(double a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Float> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class FloatOptional {
 public:
  class Builder {
  std::pair<bool, double> a;

 public:
  Builder() : a(false, 0.0) {}
  
    Builder& set_a(const std::pair<bool, double>& a);

    std::shared_ptr<veles::tests::schema::FloatOptional> build();
  };
  std::pair<bool, double> a;
  FloatOptional(const std::pair<bool, double>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::FloatOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class String {
 public:
  class Builder {
  std::shared_ptr<std::string> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::string> a);

    std::shared_ptr<veles::tests::schema::String> build();
  };
  std::shared_ptr<std::string> a;
  String(std::shared_ptr<std::string> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::String> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class StringOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<std::string>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<std::string>>& a);

    std::shared_ptr<veles::tests::schema::StringOptional> build();
  };
  std::pair<bool, std::shared_ptr<std::string>> a;
  StringOptional(const std::pair<bool, std::shared_ptr<std::string>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::StringOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Binary {
 public:
  class Builder {
  std::shared_ptr<std::vector<uint8_t>> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::vector<uint8_t>> a);

    std::shared_ptr<veles::tests::schema::Binary> build();
  };
  std::shared_ptr<std::vector<uint8_t>> a;
  Binary(std::shared_ptr<std::vector<uint8_t>> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Binary> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class BinaryOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<std::vector<uint8_t>>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<std::vector<uint8_t>>>& a);

    std::shared_ptr<veles::tests::schema::BinaryOptional> build();
  };
  std::pair<bool, std::shared_ptr<std::vector<uint8_t>>> a;
  BinaryOptional(const std::pair<bool, std::shared_ptr<std::vector<uint8_t>>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::BinaryOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class NodeIDModel {
 public:
  class Builder {
  std::shared_ptr<veles::data::NodeID> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<veles::data::NodeID> a);

    std::shared_ptr<veles::tests::schema::NodeIDModel> build();
  };
  std::shared_ptr<veles::data::NodeID> a;
  NodeIDModel(std::shared_ptr<veles::data::NodeID> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::NodeIDModel> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class NodeIDModelOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<veles::data::NodeID>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<veles::data::NodeID>>& a);

    std::shared_ptr<veles::tests::schema::NodeIDModelOptional> build();
  };
  std::pair<bool, std::shared_ptr<veles::data::NodeID>> a;
  NodeIDModelOptional(const std::pair<bool, std::shared_ptr<veles::data::NodeID>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::NodeIDModelOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class BinDataModel {
 public:
  class Builder {
  std::shared_ptr<veles::data::BinData> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<veles::data::BinData> a);

    std::shared_ptr<veles::tests::schema::BinDataModel> build();
  };
  std::shared_ptr<veles::data::BinData> a;
  BinDataModel(std::shared_ptr<veles::data::BinData> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::BinDataModel> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class BinDataModelOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<veles::data::BinData>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<veles::data::BinData>>& a);

    std::shared_ptr<veles::tests::schema::BinDataModelOptional> build();
  };
  std::pair<bool, std::shared_ptr<veles::data::BinData>> a;
  BinDataModelOptional(const std::pair<bool, std::shared_ptr<veles::data::BinData>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::BinDataModelOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class List {
 public:
  class Builder {
  std::shared_ptr<std::vector<int64_t>> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::vector<int64_t>> a);

    std::shared_ptr<veles::tests::schema::List> build();
  };
  std::shared_ptr<std::vector<int64_t>> a;
  List(std::shared_ptr<std::vector<int64_t>> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::List> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class ListOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<std::vector<int64_t>>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<std::vector<int64_t>>>& a);

    std::shared_ptr<veles::tests::schema::ListOptional> build();
  };
  std::pair<bool, std::shared_ptr<std::vector<int64_t>>> a;
  ListOptional(const std::pair<bool, std::shared_ptr<std::vector<int64_t>>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::ListOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Set {
 public:
  class Builder {
  std::shared_ptr<std::unordered_set<int64_t>> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::unordered_set<int64_t>> a);

    std::shared_ptr<veles::tests::schema::Set> build();
  };
  std::shared_ptr<std::unordered_set<int64_t>> a;
  Set(std::shared_ptr<std::unordered_set<int64_t>> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Set> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SetOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>>& a);

    std::shared_ptr<veles::tests::schema::SetOptional> build();
  };
  std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>> a;
  SetOptional(const std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::SetOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Map {
 public:
  class Builder {
  std::shared_ptr<std::unordered_map<std::string,int64_t>> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::unordered_map<std::string,int64_t>> a);

    std::shared_ptr<veles::tests::schema::Map> build();
  };
  std::shared_ptr<std::unordered_map<std::string,int64_t>> a;
  Map(std::shared_ptr<std::unordered_map<std::string,int64_t>> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Map> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class MapOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>>& a);

    std::shared_ptr<veles::tests::schema::MapOptional> build();
  };
  std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>> a;
  MapOptional(const std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::MapOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Object {
 public:
  class Builder {
  std::shared_ptr<veles::tests::schema::String> a;

 public:
  Builder() : a(nullptr) {}
  
    Builder& set_a(std::shared_ptr<veles::tests::schema::String> a);

    std::shared_ptr<veles::tests::schema::Object> build();
  };
  std::shared_ptr<veles::tests::schema::String> a;
  Object(std::shared_ptr<veles::tests::schema::String> a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Object> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class ObjectOptional {
 public:
  class Builder {
  std::pair<bool, std::shared_ptr<veles::tests::schema::String>> a;

 public:
  Builder() : a(false, nullptr) {}
  
    Builder& set_a(const std::pair<bool, std::shared_ptr<veles::tests::schema::String>>& a);

    std::shared_ptr<veles::tests::schema::ObjectOptional> build();
  };
  std::pair<bool, std::shared_ptr<veles::tests::schema::String>> a;
  ObjectOptional(const std::pair<bool, std::shared_ptr<veles::tests::schema::String>>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::ObjectOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class Enum {
 public:
  class Builder {
  veles::tests::schema::TestEnum a;

 public:
  Builder() : a(veles::tests::schema::TestEnum::OPT1) {}
  
    Builder& set_a(veles::tests::schema::TestEnum a);

    std::shared_ptr<veles::tests::schema::Enum> build();
  };
  veles::tests::schema::TestEnum a;
  Enum(veles::tests::schema::TestEnum a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::Enum> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class EnumOptional {
 public:
  class Builder {
  std::pair<bool, veles::tests::schema::TestEnum> a;

 public:
  Builder() : a(false, veles::tests::schema::TestEnum::OPT1) {}
  
    Builder& set_a(const std::pair<bool, veles::tests::schema::TestEnum>& a);

    std::shared_ptr<veles::tests::schema::EnumOptional> build();
  };
  std::pair<bool, veles::tests::schema::TestEnum> a;
  EnumOptional(const std::pair<bool, veles::tests::schema::TestEnum>& a) : a(a) {}

  static std::shared_ptr<veles::tests::schema::EnumOptional> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class BaseModel {
 public:
  virtual std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject() = 0;
  static void initObjectTypes() {
    objectTypes()["sub1"] = &createInstance<SubType1>;
    objectTypes()["sub2"] = &createInstance<SubType2>;
  }
  template<typename T> static std::shared_ptr<BaseModel>   createInstance(const std::shared_ptr<messages::MsgpackObject>& obj) {
    std::shared_ptr<T> out;
    fromMsgpackObject(obj, &out);
    return out;
  }
  static std::map<std::string, std::shared_ptr<BaseModel>(*)(const std::shared_ptr<messages::MsgpackObject>&)>& objectTypes() {
    static std::map<std::string, std::shared_ptr<BaseModel>(*)(const std::shared_ptr<messages::MsgpackObject>&)> object_types;
    return object_types;
  }
  std::string object_type;
  BaseModel(std::string object_type) : object_type(object_type) {}
  virtual ~BaseModel() {}

  static std::shared_ptr<BaseModel> polymorphicLoad(const msgpack::object& obj);
};


class SubType1 : public BaseModel {
 public:
  class Builder {
  std::shared_ptr<std::string> a;
  std::shared_ptr<std::string> b;

 public:
  Builder() : a(nullptr), b(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::string> a);

    Builder& set_b(std::shared_ptr<std::string> b);

    std::shared_ptr<veles::tests::schema::SubType1> build();
  };
  std::shared_ptr<std::string> a;
  std::shared_ptr<std::string> b;
  SubType1(std::shared_ptr<std::string> a, std::shared_ptr<std::string> b) : BaseModel("sub1"), a(a), b(b) {}

  static std::shared_ptr<veles::tests::schema::SubType1> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};

class SubType2 : public BaseModel {
 public:
  class Builder {
  std::shared_ptr<std::string> a;
  std::shared_ptr<std::vector<uint8_t>> b;

 public:
  Builder() : a(nullptr), b(nullptr) {}
  
    Builder& set_a(std::shared_ptr<std::string> a);

    Builder& set_b(std::shared_ptr<std::vector<uint8_t>> b);

    std::shared_ptr<veles::tests::schema::SubType2> build();
  };
  std::shared_ptr<std::string> a;
  std::shared_ptr<std::vector<uint8_t>> b;
  SubType2(std::shared_ptr<std::string> a, std::shared_ptr<std::vector<uint8_t>> b) : BaseModel("sub2"), a(a), b(b) {}

  static std::shared_ptr<veles::tests::schema::SubType2> loadMessagePack(const msgpack::object& obj);

  std::shared_ptr<messages::MsgpackObject> serializeToMsgpackObject();
};
}  // namespace schema
}  // namespace tests
}  // namespace veles
