/*
 * Copyright 2017 CodiLime
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
// This file is autogenerated do not modify it by hand
#include "models.h"
#include "data/repack.h"
namespace veles {
namespace data {

                RepackerModel::Builder& RepackerModel::Builder::set_endian(veles::data::Endian endian) {
                  this->endian = endian;
                  return *this;
                }
            
                RepackerModel::Builder& RepackerModel::Builder::set_from_width(uint64_t from_width) {
                  this->from_width = from_width;
                  return *this;
                }
            
                RepackerModel::Builder& RepackerModel::Builder::set_to_width(uint64_t to_width) {
                  this->to_width = to_width;
                  return *this;
                }
            
                RepackerModel::Builder& RepackerModel::Builder::set_high_pad(uint64_t high_pad) {
                  this->high_pad = high_pad;
                  return *this;
                }
            
                RepackerModel::Builder& RepackerModel::Builder::set_low_pad(uint64_t low_pad) {
                  this->low_pad = low_pad;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> RepackerModel::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["endian"] = messages::toMsgpackObject(this->endian);
msg["from_width"] = messages::toMsgpackObject(this->from_width);
msg["to_width"] = messages::toMsgpackObject(this->to_width);
msg["high_pad"] = messages::toMsgpackObject(this->high_pad);
msg["low_pad"] = messages::toMsgpackObject(this->low_pad);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::data::Repacker> RepackerModel::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::data::Repacker> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::data::Repacker> RepackerModel::Builder::build() {
  return std::make_shared<veles::data::Repacker>(endian, from_width, to_width, high_pad, low_pad);
}}  // namespace data
}  // namespace veles
namespace veles {
namespace messages {
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::data::Endian* out) {
  if (*obj->getString() == "LITTLE") {
    *out = veles::data::Endian::LITTLE;
    return;
  }
  if (*obj->getString() == "BIG") {
    *out = veles::data::Endian::BIG;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::data::Endian val) {
  switch (val) {
    case veles::data::Endian::LITTLE:
      return std::make_shared<MsgpackObject>("LITTLE");
    case veles::data::Endian::BIG:
      return std::make_shared<MsgpackObject>("BIG");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::data::Repacker>* out) {
            veles::data::Repacker::Builder b;
            auto it_endian = obj->getMap()->find("endian");
if (it_endian != obj->getMap()->end() && it_endian->second->type() != ObjectType::NIL) {
  veles::data::Endian obj_endian;
  fromMsgpackObject(it_endian->second, &obj_endian);
  b.set_endian(obj_endian);
} else {
  throw proto::SchemaError("Nonoptional field endian not found when unpacking");
}
auto it_from_width = obj->getMap()->find("from_width");
if (it_from_width != obj->getMap()->end() && it_from_width->second->type() != ObjectType::NIL) {
  uint64_t obj_from_width;
  fromMsgpackObject(it_from_width->second, &obj_from_width);
  b.set_from_width(obj_from_width);
} else {
  throw proto::SchemaError("Nonoptional field from_width not found when unpacking");
}
auto it_to_width = obj->getMap()->find("to_width");
if (it_to_width != obj->getMap()->end() && it_to_width->second->type() != ObjectType::NIL) {
  uint64_t obj_to_width;
  fromMsgpackObject(it_to_width->second, &obj_to_width);
  b.set_to_width(obj_to_width);
} else {
  throw proto::SchemaError("Nonoptional field to_width not found when unpacking");
}
auto it_high_pad = obj->getMap()->find("high_pad");
if (it_high_pad != obj->getMap()->end() && it_high_pad->second->type() != ObjectType::NIL) {
  uint64_t obj_high_pad;
  fromMsgpackObject(it_high_pad->second, &obj_high_pad);
  b.set_high_pad(obj_high_pad);
} else {
  throw proto::SchemaError("Nonoptional field high_pad not found when unpacking");
}
auto it_low_pad = obj->getMap()->find("low_pad");
if (it_low_pad != obj->getMap()->end() && it_low_pad->second->type() != ObjectType::NIL) {
  uint64_t obj_low_pad;
  fromMsgpackObject(it_low_pad->second, &obj_low_pad);
  b.set_low_pad(obj_low_pad);
} else {
  throw proto::SchemaError("Nonoptional field low_pad not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::data::Repacker>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

                Node::Builder& Node::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr) {
                  this->attr = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>>(attr);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_data(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> data) {
                  this->data = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(data);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_bindata(std::shared_ptr<std::unordered_map<std::string,uint64_t>> bindata) {
                  this->bindata = std::shared_ptr<std::unordered_map<std::string,uint64_t>>(bindata);
                  return *this;
                }
            
                Node::Builder& Node::Builder::set_triggers(std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> triggers) {
                  this->triggers = std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>>(triggers);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Node::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);
if (this->attr == nullptr) {
  throw proto::SchemaError("Nonoptional field attr not set when packing");
}
msg["attr"] = messages::toMsgpackObject(this->attr);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);
if (this->bindata == nullptr) {
  throw proto::SchemaError("Nonoptional field bindata not set when packing");
}
msg["bindata"] = messages::toMsgpackObject(this->bindata);
if (this->triggers == nullptr) {
  throw proto::SchemaError("Nonoptional field triggers not set when packing");
}
msg["triggers"] = messages::toMsgpackObject(this->triggers);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::Node> Node::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::Node> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::Node> Node::Builder::build() {
  return std::make_shared<veles::proto::Node>(id, parent, pos_start, pos_end, tags, attr, data, bindata, triggers);
}
                PosFilter::Builder& PosFilter::Builder::set_start_from(const std::pair<bool, int64_t>& start_from) {
                  this->start_from = start_from;
                  return *this;
                }
            
                PosFilter::Builder& PosFilter::Builder::set_start_to(const std::pair<bool, int64_t>& start_to) {
                  this->start_to = start_to;
                  return *this;
                }
            
                PosFilter::Builder& PosFilter::Builder::set_end_from(const std::pair<bool, int64_t>& end_from) {
                  this->end_from = end_from;
                  return *this;
                }
            
                PosFilter::Builder& PosFilter::Builder::set_end_to(const std::pair<bool, int64_t>& end_to) {
                  this->end_to = end_to;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> PosFilter::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->start_from.first) {
                  msg["start_from"] = messages::toMsgpackObject(this->start_from.second);
                } else {
                  msg["start_from"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->start_to.first) {
                  msg["start_to"] = messages::toMsgpackObject(this->start_to.second);
                } else {
                  msg["start_to"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->end_from.first) {
                  msg["end_from"] = messages::toMsgpackObject(this->end_from.second);
                } else {
                  msg["end_from"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->end_to.first) {
                  msg["end_to"] = messages::toMsgpackObject(this->end_to.second);
                } else {
                  msg["end_to"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::PosFilter> PosFilter::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::PosFilter> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::PosFilter> PosFilter::Builder::build() {
  return std::make_shared<veles::proto::PosFilter>(start_from, start_to, end_from, end_to);
}}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::proto::TriggerState* out) {
  if (*obj->getString() == "pending") {
    *out = veles::proto::TriggerState::PENDING;
    return;
  }
  if (*obj->getString() == "done") {
    *out = veles::proto::TriggerState::DONE;
    return;
  }
  if (*obj->getString() == "exception") {
    *out = veles::proto::TriggerState::EXCEPTION;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::proto::TriggerState val) {
  switch (val) {
    case veles::proto::TriggerState::PENDING:
      return std::make_shared<MsgpackObject>("pending");
    case veles::proto::TriggerState::DONE:
      return std::make_shared<MsgpackObject>("done");
    case veles::proto::TriggerState::EXCEPTION:
      return std::make_shared<MsgpackObject>("exception");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::Node>* out) {
            veles::proto::Node::Builder b;
            auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
auto it_attr = obj->getMap()->find("attr");
if (it_attr != obj->getMap()->end() && it_attr->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> obj_attr;
  fromMsgpackObject(it_attr->second, &obj_attr);
  b.set_attr(obj_attr);
} else {
  throw proto::SchemaError("Nonoptional field attr not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
auto it_bindata = obj->getMap()->find("bindata");
if (it_bindata != obj->getMap()->end() && it_bindata->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,uint64_t>> obj_bindata;
  fromMsgpackObject(it_bindata->second, &obj_bindata);
  b.set_bindata(obj_bindata);
} else {
  throw proto::SchemaError("Nonoptional field bindata not found when unpacking");
}
auto it_triggers = obj->getMap()->find("triggers");
if (it_triggers != obj->getMap()->end() && it_triggers->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,veles::proto::TriggerState>> obj_triggers;
  fromMsgpackObject(it_triggers->second, &obj_triggers);
  b.set_triggers(obj_triggers);
} else {
  throw proto::SchemaError("Nonoptional field triggers not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::Node>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::PosFilter>* out) {
            veles::proto::PosFilter::Builder b;
            auto it_start_from = obj->getMap()->find("start_from");
if (it_start_from != obj->getMap()->end() && it_start_from->second->type() != ObjectType::NIL) {
int64_t obj_start_from;
  fromMsgpackObject(it_start_from->second, &obj_start_from);
  b.set_start_from(std::pair<bool, int64_t>(true, obj_start_from));
}

auto it_start_to = obj->getMap()->find("start_to");
if (it_start_to != obj->getMap()->end() && it_start_to->second->type() != ObjectType::NIL) {
int64_t obj_start_to;
  fromMsgpackObject(it_start_to->second, &obj_start_to);
  b.set_start_to(std::pair<bool, int64_t>(true, obj_start_to));
}

auto it_end_from = obj->getMap()->find("end_from");
if (it_end_from != obj->getMap()->end() && it_end_from->second->type() != ObjectType::NIL) {
int64_t obj_end_from;
  fromMsgpackObject(it_end_from->second, &obj_end_from);
  b.set_end_from(std::pair<bool, int64_t>(true, obj_end_from));
}

auto it_end_to = obj->getMap()->find("end_to");
if (it_end_to != obj->getMap()->end() && it_end_to->second->type() != ObjectType::NIL) {
int64_t obj_end_to;
  fromMsgpackObject(it_end_to->second, &obj_end_to);
  b.set_end_to(std::pair<bool, int64_t>(true, obj_end_to));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::PosFilter>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

std::shared_ptr<Check> Check::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<Check> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

                CheckGone::Builder& CheckGone::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckGone::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckGone> CheckGone::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckGone> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckGone> CheckGone::Builder::build() {
  return std::make_shared<veles::proto::CheckGone>(node);
}
                CheckParent::Builder& CheckParent::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckParent::Builder& CheckParent::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckParent::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckParent> CheckParent::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckParent> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckParent> CheckParent::Builder::build() {
  return std::make_shared<veles::proto::CheckParent>(node, parent);
}
                CheckPos::Builder& CheckPos::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckPos::Builder& CheckPos::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                CheckPos::Builder& CheckPos::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckPos::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckPos> CheckPos::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckPos> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckPos> CheckPos::Builder::build() {
  return std::make_shared<veles::proto::CheckPos>(node, pos_start, pos_end);
}
                CheckTags::Builder& CheckTags::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckTags::Builder& CheckTags::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckTags::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckTags> CheckTags::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckTags> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckTags> CheckTags::Builder::build() {
  return std::make_shared<veles::proto::CheckTags>(node, tags);
}
                CheckTag::Builder& CheckTag::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckTag::Builder& CheckTag::Builder::set_tag(std::shared_ptr<std::string> tag) {
                  this->tag = std::shared_ptr<std::string>(tag);
                  return *this;
                }
            
                CheckTag::Builder& CheckTag::Builder::set_present(bool present) {
                  this->present = present;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckTag::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->tag == nullptr) {
  throw proto::SchemaError("Nonoptional field tag not set when packing");
}
msg["tag"] = messages::toMsgpackObject(this->tag);
msg["present"] = messages::toMsgpackObject(this->present);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckTag> CheckTag::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckTag> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckTag> CheckTag::Builder::build() {
  return std::make_shared<veles::proto::CheckTag>(node, tag, present);
}
                CheckAttr::Builder& CheckAttr::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckAttr::Builder& CheckAttr::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                CheckAttr::Builder& CheckAttr::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckAttr::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckAttr> CheckAttr::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckAttr> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckAttr> CheckAttr::Builder::build() {
  return std::make_shared<veles::proto::CheckAttr>(node, key, data);
}
                CheckData::Builder& CheckData::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckData::Builder& CheckData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                CheckData::Builder& CheckData::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckData> CheckData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckData> CheckData::Builder::build() {
  return std::make_shared<veles::proto::CheckData>(node, key, data);
}
                CheckBinDataSize::Builder& CheckBinDataSize::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckBinDataSize::Builder& CheckBinDataSize::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                CheckBinDataSize::Builder& CheckBinDataSize::Builder::set_size(uint64_t size) {
                  this->size = size;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckBinDataSize::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["size"] = messages::toMsgpackObject(this->size);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckBinDataSize> CheckBinDataSize::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckBinDataSize> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckBinDataSize> CheckBinDataSize::Builder::build() {
  return std::make_shared<veles::proto::CheckBinDataSize>(node, key, size);
}
                CheckBinData::Builder& CheckBinData::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckBinData::Builder& CheckBinData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                CheckBinData::Builder& CheckBinData::Builder::set_start(uint64_t start) {
                  this->start = start;
                  return *this;
                }
            
                CheckBinData::Builder& CheckBinData::Builder::set_end(const std::pair<bool, uint64_t>& end) {
                  this->end = end;
                  return *this;
                }
            
                CheckBinData::Builder& CheckBinData::Builder::set_data(std::shared_ptr<std::vector<uint8_t>> data) {
                  this->data = std::shared_ptr<std::vector<uint8_t>>(data);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckBinData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["start"] = messages::toMsgpackObject(this->start);
if (this->end.first) {
                  msg["end"] = messages::toMsgpackObject(this->end.second);
                } else {
                  msg["end"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckBinData> CheckBinData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckBinData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckBinData> CheckBinData::Builder::build() {
  return std::make_shared<veles::proto::CheckBinData>(node, key, start, end, data);
}
                CheckTrigger::Builder& CheckTrigger::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                CheckTrigger::Builder& CheckTrigger::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                CheckTrigger::Builder& CheckTrigger::Builder::set_state(const std::pair<bool, veles::proto::TriggerState>& state) {
                  this->state = state;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckTrigger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->state.first) {
                  msg["state"] = messages::toMsgpackObject(this->state.second);
                } else {
                  msg["state"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckTrigger> CheckTrigger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckTrigger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckTrigger> CheckTrigger::Builder::build() {
  return std::make_shared<veles::proto::CheckTrigger>(node, key, state);
}
                CheckList::Builder& CheckList::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
                CheckList::Builder& CheckList::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
                CheckList::Builder& CheckList::Builder::set_pos_filter(std::shared_ptr<veles::proto::PosFilter> pos_filter) {
                  this->pos_filter = std::shared_ptr<veles::proto::PosFilter>(pos_filter);
                  return *this;
                }
            
                CheckList::Builder& CheckList::Builder::set_nodes(std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> nodes) {
                  this->nodes = std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>>(nodes);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> CheckList::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);
if (this->pos_filter == nullptr) {
  throw proto::SchemaError("Nonoptional field pos_filter not set when packing");
}
msg["pos_filter"] = messages::toMsgpackObject(this->pos_filter);
if (this->nodes == nullptr) {
  throw proto::SchemaError("Nonoptional field nodes not set when packing");
}
msg["nodes"] = messages::toMsgpackObject(this->nodes);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::CheckList> CheckList::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::CheckList> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::CheckList> CheckList::Builder::build() {
  return std::make_shared<veles::proto::CheckList>(parent, tags, pos_filter, nodes);
}}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::Check>* out) {
  auto& types = veles::proto::Check::objectTypes();
  if (types.size() == 0) {
    veles::proto::Check::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::Check>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckGone>* out) {
            veles::proto::CheckGone::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckGone>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckParent>* out) {
            veles::proto::CheckParent::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckParent>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckPos>* out) {
            veles::proto::CheckPos::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckPos>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckTags>* out) {
            veles::proto::CheckTags::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckTags>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckTag>* out) {
            veles::proto::CheckTag::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_tag = obj->getMap()->find("tag");
if (it_tag != obj->getMap()->end() && it_tag->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_tag;
  fromMsgpackObject(it_tag->second, &obj_tag);
  b.set_tag(obj_tag);
} else {
  throw proto::SchemaError("Nonoptional field tag not found when unpacking");
}
auto it_present = obj->getMap()->find("present");
if (it_present != obj->getMap()->end() && it_present->second->type() != ObjectType::NIL) {
  bool obj_present;
  fromMsgpackObject(it_present->second, &obj_present);
  b.set_present(obj_present);
} else {
  throw proto::SchemaError("Nonoptional field present not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckTag>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckAttr>* out) {
            veles::proto::CheckAttr::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckAttr>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckData>* out) {
            veles::proto::CheckData::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckBinDataSize>* out) {
            veles::proto::CheckBinDataSize::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_size = obj->getMap()->find("size");
if (it_size != obj->getMap()->end() && it_size->second->type() != ObjectType::NIL) {
  uint64_t obj_size;
  fromMsgpackObject(it_size->second, &obj_size);
  b.set_size(obj_size);
} else {
  throw proto::SchemaError("Nonoptional field size not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckBinDataSize>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckBinData>* out) {
            veles::proto::CheckBinData::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_start = obj->getMap()->find("start");
if (it_start != obj->getMap()->end() && it_start->second->type() != ObjectType::NIL) {
  uint64_t obj_start;
  fromMsgpackObject(it_start->second, &obj_start);
  b.set_start(obj_start);
} else {
  throw proto::SchemaError("Nonoptional field start not found when unpacking");
}
auto it_end = obj->getMap()->find("end");
if (it_end != obj->getMap()->end() && it_end->second->type() != ObjectType::NIL) {
uint64_t obj_end;
  fromMsgpackObject(it_end->second, &obj_end);
  b.set_end(std::pair<bool, uint64_t>(true, obj_end));
}

auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckBinData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckTrigger>* out) {
            veles::proto::CheckTrigger::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_state = obj->getMap()->find("state");
if (it_state != obj->getMap()->end() && it_state->second->type() != ObjectType::NIL) {
veles::proto::TriggerState obj_state;
  fromMsgpackObject(it_state->second, &obj_state);
  b.set_state(std::pair<bool, veles::proto::TriggerState>(true, obj_state));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckTrigger>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::CheckList>* out) {
            veles::proto::CheckList::Builder b;
            auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
auto it_pos_filter = obj->getMap()->find("pos_filter");
if (it_pos_filter != obj->getMap()->end() && it_pos_filter->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::PosFilter> obj_pos_filter;
  fromMsgpackObject(it_pos_filter->second, &obj_pos_filter);
  b.set_pos_filter(obj_pos_filter);
} else {
  throw proto::SchemaError("Nonoptional field pos_filter not found when unpacking");
}
auto it_nodes = obj->getMap()->find("nodes");
if (it_nodes != obj->getMap()->end() && it_nodes->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<veles::data::NodeID>>> obj_nodes;
  fromMsgpackObject(it_nodes->second, &obj_nodes);
  b.set_nodes(obj_nodes);
} else {
  throw proto::SchemaError("Nonoptional field nodes not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::CheckList>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

std::shared_ptr<FieldType> FieldType::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<FieldType> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<FieldTypeFixed> FieldTypeFixed::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<FieldTypeFixed> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<FieldTypeFloat> FieldTypeFloat::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<FieldTypeFloat> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<FieldTypeString> FieldTypeString::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<FieldTypeString> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItem> ChunkDataItem::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItem> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItemSubchunk> ChunkDataItemSubchunk::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItemSubchunk> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItemSubblob> ChunkDataItemSubblob::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItemSubblob> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItemField> ChunkDataItemField::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItemField> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItemComputed> ChunkDataItemComputed::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItemComputed> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

std::shared_ptr<ChunkDataItemPad> ChunkDataItemPad::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<ChunkDataItemPad> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }
}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::proto::FieldSignMode* out) {
  if (*obj->getString() == "unsigned") {
    *out = veles::proto::FieldSignMode::UNSIGNED;
    return;
  }
  if (*obj->getString() == "signed") {
    *out = veles::proto::FieldSignMode::SIGNED;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::proto::FieldSignMode val) {
  switch (val) {
    case veles::proto::FieldSignMode::UNSIGNED:
      return std::make_shared<MsgpackObject>("unsigned");
    case veles::proto::FieldSignMode::SIGNED:
      return std::make_shared<MsgpackObject>("signed");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::proto::FieldFloatMode* out) {
  if (*obj->getString() == "ieee754_single") {
    *out = veles::proto::FieldFloatMode::IEEE754_SINGLE;
    return;
  }
  if (*obj->getString() == "ieee754_double") {
    *out = veles::proto::FieldFloatMode::IEEE754_DOUBLE;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::proto::FieldFloatMode val) {
  switch (val) {
    case veles::proto::FieldFloatMode::IEEE754_SINGLE:
      return std::make_shared<MsgpackObject>("ieee754_single");
    case veles::proto::FieldFloatMode::IEEE754_DOUBLE:
      return std::make_shared<MsgpackObject>("ieee754_double");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::proto::FieldStringMode* out) {
  if (*obj->getString() == "raw") {
    *out = veles::proto::FieldStringMode::RAW;
    return;
  }
  if (*obj->getString() == "zero_padded") {
    *out = veles::proto::FieldStringMode::ZERO_PADDED;
    return;
  }
  if (*obj->getString() == "zero_terminated") {
    *out = veles::proto::FieldStringMode::ZERO_TERMINATED;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::proto::FieldStringMode val) {
  switch (val) {
    case veles::proto::FieldStringMode::RAW:
      return std::make_shared<MsgpackObject>("raw");
    case veles::proto::FieldStringMode::ZERO_PADDED:
      return std::make_shared<MsgpackObject>("zero_padded");
    case veles::proto::FieldStringMode::ZERO_TERMINATED:
      return std::make_shared<MsgpackObject>("zero_terminated");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::proto::FieldStringEncoding* out) {
  if (*obj->getString() == "raw") {
    *out = veles::proto::FieldStringEncoding::RAW;
    return;
  }
  if (*obj->getString() == "utf8") {
    *out = veles::proto::FieldStringEncoding::UTF8;
    return;
  }
  if (*obj->getString() == "utf16") {
    *out = veles::proto::FieldStringEncoding::UTF16;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::proto::FieldStringEncoding val) {
  switch (val) {
    case veles::proto::FieldStringEncoding::RAW:
      return std::make_shared<MsgpackObject>("raw");
    case veles::proto::FieldStringEncoding::UTF8:
      return std::make_shared<MsgpackObject>("utf8");
    case veles::proto::FieldStringEncoding::UTF16:
      return std::make_shared<MsgpackObject>("utf16");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::FieldType>* out) {
  auto& types = veles::proto::FieldType::objectTypes();
  if (types.size() == 0) {
    veles::proto::FieldType::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::FieldType>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::FieldTypeFixed>* out) {
  auto& types = veles::proto::FieldTypeFixed::objectTypes();
  if (types.size() == 0) {
    veles::proto::FieldTypeFixed::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::FieldTypeFixed>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::FieldTypeFloat>* out) {
  auto& types = veles::proto::FieldTypeFloat::objectTypes();
  if (types.size() == 0) {
    veles::proto::FieldTypeFloat::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::FieldTypeFloat>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::FieldTypeString>* out) {
  auto& types = veles::proto::FieldTypeString::objectTypes();
  if (types.size() == 0) {
    veles::proto::FieldTypeString::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::FieldTypeString>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItem>* out) {
  auto& types = veles::proto::ChunkDataItem::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItem::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItem>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItemSubchunk>* out) {
  auto& types = veles::proto::ChunkDataItemSubchunk::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItemSubchunk::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItemSubchunk>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItemSubblob>* out) {
  auto& types = veles::proto::ChunkDataItemSubblob::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItemSubblob::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItemSubblob>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItemField>* out) {
  auto& types = veles::proto::ChunkDataItemField::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItemField::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItemField>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItemComputed>* out) {
  auto& types = veles::proto::ChunkDataItemComputed::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItemComputed::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItemComputed>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::ChunkDataItemPad>* out) {
  auto& types = veles::proto::ChunkDataItemPad::objectTypes();
  if (types.size() == 0) {
    veles::proto::ChunkDataItemPad::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::ChunkDataItemPad>& val) {
  return val->serializeToMsgpackObject();
}
}  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

                Connection::Builder& Connection::Builder::set_client_id(uint64_t client_id) {
                  this->client_id = client_id;
                  return *this;
                }
            
                Connection::Builder& Connection::Builder::set_client_name(std::shared_ptr<std::string> client_name) {
                  this->client_name = std::shared_ptr<std::string>(client_name);
                  return *this;
                }
            
                Connection::Builder& Connection::Builder::set_client_version(std::shared_ptr<std::string> client_version) {
                  this->client_version = std::shared_ptr<std::string>(client_version);
                  return *this;
                }
            
                Connection::Builder& Connection::Builder::set_client_description(std::shared_ptr<std::string> client_description) {
                  this->client_description = std::shared_ptr<std::string>(client_description);
                  return *this;
                }
            
                Connection::Builder& Connection::Builder::set_client_type(std::shared_ptr<std::string> client_type) {
                  this->client_type = std::shared_ptr<std::string>(client_type);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Connection::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["client_id"] = messages::toMsgpackObject(this->client_id);
if (this->client_name == nullptr) {
  throw proto::SchemaError("Nonoptional field client_name not set when packing");
}
msg["client_name"] = messages::toMsgpackObject(this->client_name);
if (this->client_version == nullptr) {
  throw proto::SchemaError("Nonoptional field client_version not set when packing");
}
msg["client_version"] = messages::toMsgpackObject(this->client_version);
if (this->client_description == nullptr) {
  throw proto::SchemaError("Nonoptional field client_description not set when packing");
}
msg["client_description"] = messages::toMsgpackObject(this->client_description);
if (this->client_type == nullptr) {
  throw proto::SchemaError("Nonoptional field client_type not set when packing");
}
msg["client_type"] = messages::toMsgpackObject(this->client_type);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::Connection> Connection::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::Connection> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::Connection> Connection::Builder::build() {
  return std::make_shared<veles::proto::Connection>(client_id, client_name, client_version, client_description, client_type);
}}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::Connection>* out) {
            veles::proto::Connection::Builder b;
            auto it_client_id = obj->getMap()->find("client_id");
if (it_client_id != obj->getMap()->end() && it_client_id->second->type() != ObjectType::NIL) {
  uint64_t obj_client_id;
  fromMsgpackObject(it_client_id->second, &obj_client_id);
  b.set_client_id(obj_client_id);
} else {
  throw proto::SchemaError("Nonoptional field client_id not found when unpacking");
}
auto it_client_name = obj->getMap()->find("client_name");
if (it_client_name != obj->getMap()->end() && it_client_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_client_name;
  fromMsgpackObject(it_client_name->second, &obj_client_name);
  b.set_client_name(obj_client_name);
} else {
  throw proto::SchemaError("Nonoptional field client_name not found when unpacking");
}
auto it_client_version = obj->getMap()->find("client_version");
if (it_client_version != obj->getMap()->end() && it_client_version->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_client_version;
  fromMsgpackObject(it_client_version->second, &obj_client_version);
  b.set_client_version(obj_client_version);
} else {
  throw proto::SchemaError("Nonoptional field client_version not found when unpacking");
}
auto it_client_description = obj->getMap()->find("client_description");
if (it_client_description != obj->getMap()->end() && it_client_description->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_client_description;
  fromMsgpackObject(it_client_description->second, &obj_client_description);
  b.set_client_description(obj_client_description);
} else {
  throw proto::SchemaError("Nonoptional field client_description not found when unpacking");
}
auto it_client_type = obj->getMap()->find("client_type");
if (it_client_type != obj->getMap()->end() && it_client_type->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_client_type;
  fromMsgpackObject(it_client_type->second, &obj_client_type);
  b.set_client_type(obj_client_type);
} else {
  throw proto::SchemaError("Nonoptional field client_type not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::Connection>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

std::shared_ptr<Operation> Operation::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<Operation> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

                OperationCreate::Builder& OperationCreate::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr) {
                  this->attr = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>>(attr);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_data(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data) {
                  this->data = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>>(data);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_bindata(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata) {
                  this->bindata = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>>(bindata);
                  return *this;
                }
            
                OperationCreate::Builder& OperationCreate::Builder::set_triggers(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers) {
                  this->triggers = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(triggers);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationCreate::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);
if (this->attr == nullptr) {
  throw proto::SchemaError("Nonoptional field attr not set when packing");
}
msg["attr"] = messages::toMsgpackObject(this->attr);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);
if (this->bindata == nullptr) {
  throw proto::SchemaError("Nonoptional field bindata not set when packing");
}
msg["bindata"] = messages::toMsgpackObject(this->bindata);
if (this->triggers == nullptr) {
  throw proto::SchemaError("Nonoptional field triggers not set when packing");
}
msg["triggers"] = messages::toMsgpackObject(this->triggers);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationCreate> OperationCreate::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationCreate> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationCreate> OperationCreate::Builder::build() {
  return std::make_shared<veles::proto::OperationCreate>(node, parent, pos_start, pos_end, tags, attr, data, bindata, triggers);
}
                OperationDelete::Builder& OperationDelete::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationDelete::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationDelete> OperationDelete::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationDelete> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationDelete> OperationDelete::Builder::build() {
  return std::make_shared<veles::proto::OperationDelete>(node);
}
                OperationSetParent::Builder& OperationSetParent::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationSetParent::Builder& OperationSetParent::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationSetParent::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationSetParent> OperationSetParent::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationSetParent> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationSetParent> OperationSetParent::Builder::build() {
  return std::make_shared<veles::proto::OperationSetParent>(node, parent);
}
                OperationSetPos::Builder& OperationSetPos::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationSetPos::Builder& OperationSetPos::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                OperationSetPos::Builder& OperationSetPos::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationSetPos::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationSetPos> OperationSetPos::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationSetPos> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationSetPos> OperationSetPos::Builder::build() {
  return std::make_shared<veles::proto::OperationSetPos>(node, pos_start, pos_end);
}
                OperationAddTag::Builder& OperationAddTag::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationAddTag::Builder& OperationAddTag::Builder::set_tag(std::shared_ptr<std::string> tag) {
                  this->tag = std::shared_ptr<std::string>(tag);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationAddTag::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->tag == nullptr) {
  throw proto::SchemaError("Nonoptional field tag not set when packing");
}
msg["tag"] = messages::toMsgpackObject(this->tag);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationAddTag> OperationAddTag::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationAddTag> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationAddTag> OperationAddTag::Builder::build() {
  return std::make_shared<veles::proto::OperationAddTag>(node, tag);
}
                OperationDelTag::Builder& OperationDelTag::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationDelTag::Builder& OperationDelTag::Builder::set_tag(std::shared_ptr<std::string> tag) {
                  this->tag = std::shared_ptr<std::string>(tag);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationDelTag::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->tag == nullptr) {
  throw proto::SchemaError("Nonoptional field tag not set when packing");
}
msg["tag"] = messages::toMsgpackObject(this->tag);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationDelTag> OperationDelTag::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationDelTag> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationDelTag> OperationDelTag::Builder::build() {
  return std::make_shared<veles::proto::OperationDelTag>(node, tag);
}
                OperationSetAttr::Builder& OperationSetAttr::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationSetAttr::Builder& OperationSetAttr::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                OperationSetAttr::Builder& OperationSetAttr::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationSetAttr::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationSetAttr> OperationSetAttr::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationSetAttr> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationSetAttr> OperationSetAttr::Builder::build() {
  return std::make_shared<veles::proto::OperationSetAttr>(node, key, data);
}
                OperationSetData::Builder& OperationSetData::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationSetData::Builder& OperationSetData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                OperationSetData::Builder& OperationSetData::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationSetData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationSetData> OperationSetData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationSetData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationSetData> OperationSetData::Builder::build() {
  return std::make_shared<veles::proto::OperationSetData>(node, key, data);
}
                OperationSetBinData::Builder& OperationSetBinData::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationSetBinData::Builder& OperationSetBinData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                OperationSetBinData::Builder& OperationSetBinData::Builder::set_start(uint64_t start) {
                  this->start = start;
                  return *this;
                }
            
                OperationSetBinData::Builder& OperationSetBinData::Builder::set_data(std::shared_ptr<std::vector<uint8_t>> data) {
                  this->data = std::shared_ptr<std::vector<uint8_t>>(data);
                  return *this;
                }
            
                OperationSetBinData::Builder& OperationSetBinData::Builder::set_truncate(bool truncate) {
                  this->truncate = truncate;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationSetBinData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["start"] = messages::toMsgpackObject(this->start);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);
msg["truncate"] = messages::toMsgpackObject(this->truncate);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationSetBinData> OperationSetBinData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationSetBinData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationSetBinData> OperationSetBinData::Builder::build() {
  return std::make_shared<veles::proto::OperationSetBinData>(node, key, start, data, truncate);
}
                OperationAddTrigger::Builder& OperationAddTrigger::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationAddTrigger::Builder& OperationAddTrigger::Builder::set_trigger(std::shared_ptr<std::string> trigger) {
                  this->trigger = std::shared_ptr<std::string>(trigger);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationAddTrigger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->trigger == nullptr) {
  throw proto::SchemaError("Nonoptional field trigger not set when packing");
}
msg["trigger"] = messages::toMsgpackObject(this->trigger);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationAddTrigger> OperationAddTrigger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationAddTrigger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationAddTrigger> OperationAddTrigger::Builder::build() {
  return std::make_shared<veles::proto::OperationAddTrigger>(node, trigger);
}
                OperationDelTrigger::Builder& OperationDelTrigger::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                OperationDelTrigger::Builder& OperationDelTrigger::Builder::set_trigger(std::shared_ptr<std::string> trigger) {
                  this->trigger = std::shared_ptr<std::string>(trigger);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> OperationDelTrigger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->trigger == nullptr) {
  throw proto::SchemaError("Nonoptional field trigger not set when packing");
}
msg["trigger"] = messages::toMsgpackObject(this->trigger);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::OperationDelTrigger> OperationDelTrigger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::OperationDelTrigger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::OperationDelTrigger> OperationDelTrigger::Builder::build() {
  return std::make_shared<veles::proto::OperationDelTrigger>(node, trigger);
}}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::Operation>* out) {
  auto& types = veles::proto::Operation::objectTypes();
  if (types.size() == 0) {
    veles::proto::Operation::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::Operation>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationCreate>* out) {
            veles::proto::OperationCreate::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
auto it_attr = obj->getMap()->find("attr");
if (it_attr != obj->getMap()->end() && it_attr->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> obj_attr;
  fromMsgpackObject(it_attr->second, &obj_attr);
  b.set_attr(obj_attr);
} else {
  throw proto::SchemaError("Nonoptional field attr not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
auto it_bindata = obj->getMap()->find("bindata");
if (it_bindata != obj->getMap()->end() && it_bindata->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> obj_bindata;
  fromMsgpackObject(it_bindata->second, &obj_bindata);
  b.set_bindata(obj_bindata);
} else {
  throw proto::SchemaError("Nonoptional field bindata not found when unpacking");
}
auto it_triggers = obj->getMap()->find("triggers");
if (it_triggers != obj->getMap()->end() && it_triggers->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_triggers;
  fromMsgpackObject(it_triggers->second, &obj_triggers);
  b.set_triggers(obj_triggers);
} else {
  throw proto::SchemaError("Nonoptional field triggers not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationCreate>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationDelete>* out) {
            veles::proto::OperationDelete::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationDelete>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationSetParent>* out) {
            veles::proto::OperationSetParent::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationSetParent>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationSetPos>* out) {
            veles::proto::OperationSetPos::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationSetPos>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationAddTag>* out) {
            veles::proto::OperationAddTag::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_tag = obj->getMap()->find("tag");
if (it_tag != obj->getMap()->end() && it_tag->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_tag;
  fromMsgpackObject(it_tag->second, &obj_tag);
  b.set_tag(obj_tag);
} else {
  throw proto::SchemaError("Nonoptional field tag not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationAddTag>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationDelTag>* out) {
            veles::proto::OperationDelTag::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_tag = obj->getMap()->find("tag");
if (it_tag != obj->getMap()->end() && it_tag->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_tag;
  fromMsgpackObject(it_tag->second, &obj_tag);
  b.set_tag(obj_tag);
} else {
  throw proto::SchemaError("Nonoptional field tag not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationDelTag>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationSetAttr>* out) {
            veles::proto::OperationSetAttr::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationSetAttr>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationSetData>* out) {
            veles::proto::OperationSetData::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationSetData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationSetBinData>* out) {
            veles::proto::OperationSetBinData::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_start = obj->getMap()->find("start");
if (it_start != obj->getMap()->end() && it_start->second->type() != ObjectType::NIL) {
  uint64_t obj_start;
  fromMsgpackObject(it_start->second, &obj_start);
  b.set_start(obj_start);
} else {
  throw proto::SchemaError("Nonoptional field start not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
auto it_truncate = obj->getMap()->find("truncate");
if (it_truncate != obj->getMap()->end() && it_truncate->second->type() != ObjectType::NIL) {
  bool obj_truncate;
  fromMsgpackObject(it_truncate->second, &obj_truncate);
  b.set_truncate(obj_truncate);
} else {
  throw proto::SchemaError("Nonoptional field truncate not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationSetBinData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationAddTrigger>* out) {
            veles::proto::OperationAddTrigger::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_trigger = obj->getMap()->find("trigger");
if (it_trigger != obj->getMap()->end() && it_trigger->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_trigger;
  fromMsgpackObject(it_trigger->second, &obj_trigger);
  b.set_trigger(obj_trigger);
} else {
  throw proto::SchemaError("Nonoptional field trigger not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationAddTrigger>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::OperationDelTrigger>* out) {
            veles::proto::OperationDelTrigger::Builder b;
            auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_trigger = obj->getMap()->find("trigger");
if (it_trigger != obj->getMap()->end() && it_trigger->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_trigger;
  fromMsgpackObject(it_trigger->second, &obj_trigger);
  b.set_trigger(obj_trigger);
} else {
  throw proto::SchemaError("Nonoptional field trigger not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::OperationDelTrigger>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {

std::shared_ptr<MsgpackMsg> MsgpackMsg::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<MsgpackMsg> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

                MsgConnect::Builder& MsgConnect::Builder::set_proto_version(int64_t proto_version) {
                  this->proto_version = proto_version;
                  return *this;
                }
            
                MsgConnect::Builder& MsgConnect::Builder::set_client_name(const std::pair<bool, std::shared_ptr<std::string>>& client_name) {
                  this->client_name = client_name;
                  return *this;
                }
            
                MsgConnect::Builder& MsgConnect::Builder::set_client_version(const std::pair<bool, std::shared_ptr<std::string>>& client_version) {
                  this->client_version = client_version;
                  return *this;
                }
            
                MsgConnect::Builder& MsgConnect::Builder::set_client_description(const std::pair<bool, std::shared_ptr<std::string>>& client_description) {
                  this->client_description = client_description;
                  return *this;
                }
            
                MsgConnect::Builder& MsgConnect::Builder::set_client_type(const std::pair<bool, std::shared_ptr<std::string>>& client_type) {
                  this->client_type = client_type;
                  return *this;
                }
            
                MsgConnect::Builder& MsgConnect::Builder::set_quit_on_close(bool quit_on_close) {
                  this->quit_on_close = quit_on_close;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgConnect::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["proto_version"] = messages::toMsgpackObject(this->proto_version);
if (this->client_name.first) {
                  msg["client_name"] = messages::toMsgpackObject(this->client_name.second);
                } else {
                  msg["client_name"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->client_version.first) {
                  msg["client_version"] = messages::toMsgpackObject(this->client_version.second);
                } else {
                  msg["client_version"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->client_description.first) {
                  msg["client_description"] = messages::toMsgpackObject(this->client_description.second);
                } else {
                  msg["client_description"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->client_type.first) {
                  msg["client_type"] = messages::toMsgpackObject(this->client_type.second);
                } else {
                  msg["client_type"] = std::make_shared<messages::MsgpackObject>();
                }
                msg["quit_on_close"] = messages::toMsgpackObject(this->quit_on_close);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgConnect> MsgConnect::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgConnect> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgConnect> MsgConnect::Builder::build() {
  return std::make_shared<veles::proto::MsgConnect>(proto_version, client_name, client_version, client_description, client_type, quit_on_close);
}
                MsgConnected::Builder& MsgConnected::Builder::set_proto_version(int64_t proto_version) {
                  this->proto_version = proto_version;
                  return *this;
                }
            
                MsgConnected::Builder& MsgConnected::Builder::set_server_name(std::shared_ptr<std::string> server_name) {
                  this->server_name = std::shared_ptr<std::string>(server_name);
                  return *this;
                }
            
                MsgConnected::Builder& MsgConnected::Builder::set_server_version(std::shared_ptr<std::string> server_version) {
                  this->server_version = std::shared_ptr<std::string>(server_version);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgConnected::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["proto_version"] = messages::toMsgpackObject(this->proto_version);
if (this->server_name == nullptr) {
  throw proto::SchemaError("Nonoptional field server_name not set when packing");
}
msg["server_name"] = messages::toMsgpackObject(this->server_name);
if (this->server_version == nullptr) {
  throw proto::SchemaError("Nonoptional field server_version not set when packing");
}
msg["server_version"] = messages::toMsgpackObject(this->server_version);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgConnected> MsgConnected::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgConnected> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgConnected> MsgConnected::Builder::build() {
  return std::make_shared<veles::proto::MsgConnected>(proto_version, server_name, server_version);
}
                MsgConnectionError::Builder& MsgConnectionError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgConnectionError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgConnectionError> MsgConnectionError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgConnectionError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgConnectionError> MsgConnectionError::Builder::build() {
  return std::make_shared<veles::proto::MsgConnectionError>(err);
}
                MsgProtoError::Builder& MsgProtoError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgProtoError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgProtoError> MsgProtoError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgProtoError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgProtoError> MsgProtoError::Builder::build() {
  return std::make_shared<veles::proto::MsgProtoError>(err);
}
                MsgGet::Builder& MsgGet::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGet::Builder& MsgGet::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgGet::Builder& MsgGet::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGet::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGet> MsgGet::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGet> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGet> MsgGet::Builder::build() {
  return std::make_shared<veles::proto::MsgGet>(qid, id, sub);
}
                MsgGetReply::Builder& MsgGetReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetReply::Builder& MsgGetReply::Builder::set_obj(std::shared_ptr<veles::proto::Node> obj) {
                  this->obj = std::shared_ptr<veles::proto::Node>(obj);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->obj == nullptr) {
  throw proto::SchemaError("Nonoptional field obj not set when packing");
}
msg["obj"] = messages::toMsgpackObject(this->obj);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetReply> MsgGetReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetReply> MsgGetReply::Builder::build() {
  return std::make_shared<veles::proto::MsgGetReply>(qid, obj);
}
                MsgGetData::Builder& MsgGetData::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetData::Builder& MsgGetData::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgGetData::Builder& MsgGetData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                MsgGetData::Builder& MsgGetData::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetData> MsgGetData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetData> MsgGetData::Builder::build() {
  return std::make_shared<veles::proto::MsgGetData>(qid, id, key, sub);
}
                MsgGetDataReply::Builder& MsgGetDataReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetDataReply::Builder& MsgGetDataReply::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetDataReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetDataReply> MsgGetDataReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetDataReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetDataReply> MsgGetDataReply::Builder::build() {
  return std::make_shared<veles::proto::MsgGetDataReply>(qid, data);
}
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_start(uint64_t start) {
                  this->start = start;
                  return *this;
                }
            
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_end(const std::pair<bool, uint64_t>& end) {
                  this->end = end;
                  return *this;
                }
            
                MsgGetBinData::Builder& MsgGetBinData::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetBinData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["start"] = messages::toMsgpackObject(this->start);
if (this->end.first) {
                  msg["end"] = messages::toMsgpackObject(this->end.second);
                } else {
                  msg["end"] = std::make_shared<messages::MsgpackObject>();
                }
                msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetBinData> MsgGetBinData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetBinData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetBinData> MsgGetBinData::Builder::build() {
  return std::make_shared<veles::proto::MsgGetBinData>(qid, id, key, start, end, sub);
}
                MsgGetBinDataReply::Builder& MsgGetBinDataReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetBinDataReply::Builder& MsgGetBinDataReply::Builder::set_data(std::shared_ptr<std::vector<uint8_t>> data) {
                  this->data = std::shared_ptr<std::vector<uint8_t>>(data);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetBinDataReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetBinDataReply> MsgGetBinDataReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetBinDataReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetBinDataReply> MsgGetBinDataReply::Builder::build() {
  return std::make_shared<veles::proto::MsgGetBinDataReply>(qid, data);
}
                MsgGetList::Builder& MsgGetList::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetList::Builder& MsgGetList::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
                MsgGetList::Builder& MsgGetList::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
                MsgGetList::Builder& MsgGetList::Builder::set_pos_filter(std::shared_ptr<veles::proto::PosFilter> pos_filter) {
                  this->pos_filter = std::shared_ptr<veles::proto::PosFilter>(pos_filter);
                  return *this;
                }
            
                MsgGetList::Builder& MsgGetList::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetList::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);
if (this->pos_filter == nullptr) {
  throw proto::SchemaError("Nonoptional field pos_filter not set when packing");
}
msg["pos_filter"] = messages::toMsgpackObject(this->pos_filter);
msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetList> MsgGetList::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetList> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetList> MsgGetList::Builder::build() {
  return std::make_shared<veles::proto::MsgGetList>(qid, parent, tags, pos_filter, sub);
}
                MsgGetListReply::Builder& MsgGetListReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetListReply::Builder& MsgGetListReply::Builder::set_objs(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> objs) {
                  this->objs = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>>(objs);
                  return *this;
                }
            
                MsgGetListReply::Builder& MsgGetListReply::Builder::set_gone(std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> gone) {
                  this->gone = std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>>(gone);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetListReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->objs == nullptr) {
  throw proto::SchemaError("Nonoptional field objs not set when packing");
}
msg["objs"] = messages::toMsgpackObject(this->objs);
if (this->gone == nullptr) {
  throw proto::SchemaError("Nonoptional field gone not set when packing");
}
msg["gone"] = messages::toMsgpackObject(this->gone);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetListReply> MsgGetListReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetListReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetListReply> MsgGetListReply::Builder::build() {
  return std::make_shared<veles::proto::MsgGetListReply>(qid, objs, gone);
}
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_query(std::shared_ptr<std::string> query) {
                  this->query = std::shared_ptr<std::string>(query);
                  return *this;
                }
            
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_trace(bool trace) {
                  this->trace = trace;
                  return *this;
                }
            
                MsgGetQuery::Builder& MsgGetQuery::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetQuery::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->query == nullptr) {
  throw proto::SchemaError("Nonoptional field query not set when packing");
}
msg["query"] = messages::toMsgpackObject(this->query);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                msg["trace"] = messages::toMsgpackObject(this->trace);
msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetQuery> MsgGetQuery::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetQuery> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetQuery> MsgGetQuery::Builder::build() {
  return std::make_shared<veles::proto::MsgGetQuery>(qid, node, query, params, trace, sub);
}
                MsgGetQueryReply::Builder& MsgGetQueryReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgGetQueryReply::Builder& MsgGetQueryReply::Builder::set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) {
                  this->result = result;
                  return *this;
                }
            
                MsgGetQueryReply::Builder& MsgGetQueryReply::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgGetQueryReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->result.first) {
                  msg["result"] = messages::toMsgpackObject(this->result.second);
                } else {
                  msg["result"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgGetQueryReply> MsgGetQueryReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgGetQueryReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgGetQueryReply> MsgGetQueryReply::Builder::build() {
  return std::make_shared<veles::proto::MsgGetQueryReply>(qid, result, checks);
}
                MsgListConnections::Builder& MsgListConnections::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgListConnections::Builder& MsgListConnections::Builder::set_sub(bool sub) {
                  this->sub = sub;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgListConnections::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
msg["sub"] = messages::toMsgpackObject(this->sub);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgListConnections> MsgListConnections::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgListConnections> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgListConnections> MsgListConnections::Builder::build() {
  return std::make_shared<veles::proto::MsgListConnections>(qid, sub);
}
                MsgConnectionsReply::Builder& MsgConnectionsReply::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgConnectionsReply::Builder& MsgConnectionsReply::Builder::set_connections(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> connections) {
                  this->connections = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>>(connections);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgConnectionsReply::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->connections == nullptr) {
  throw proto::SchemaError("Nonoptional field connections not set when packing");
}
msg["connections"] = messages::toMsgpackObject(this->connections);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgConnectionsReply> MsgConnectionsReply::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgConnectionsReply> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgConnectionsReply> MsgConnectionsReply::Builder::build() {
  return std::make_shared<veles::proto::MsgConnectionsReply>(qid, connections);
}
                MsgQueryError::Builder& MsgQueryError::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
                MsgQueryError::Builder& MsgQueryError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
                MsgQueryError::Builder& MsgQueryError::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgQueryError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);
if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgQueryError> MsgQueryError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgQueryError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgQueryError> MsgQueryError::Builder::build() {
  return std::make_shared<veles::proto::MsgQueryError>(qid, err, checks);
}
                MsgCancelSubscription::Builder& MsgCancelSubscription::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgCancelSubscription::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgCancelSubscription> MsgCancelSubscription::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgCancelSubscription> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgCancelSubscription> MsgCancelSubscription::Builder::build() {
  return std::make_shared<veles::proto::MsgCancelSubscription>(qid);
}
                MsgSubscriptionCancelled::Builder& MsgSubscriptionCancelled::Builder::set_qid(uint64_t qid) {
                  this->qid = qid;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSubscriptionCancelled::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["qid"] = messages::toMsgpackObject(this->qid);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSubscriptionCancelled> MsgSubscriptionCancelled::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSubscriptionCancelled> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSubscriptionCancelled> MsgSubscriptionCancelled::Builder::build() {
  return std::make_shared<veles::proto::MsgSubscriptionCancelled>(qid);
}
                MsgCreate::Builder& MsgCreate::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_attr(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> attr) {
                  this->attr = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>>(attr);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_data(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> data) {
                  this->data = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>>(data);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_bindata(std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> bindata) {
                  this->bindata = std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>>(bindata);
                  return *this;
                }
            
                MsgCreate::Builder& MsgCreate::Builder::set_triggers(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> triggers) {
                  this->triggers = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(triggers);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgCreate::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);
if (this->attr == nullptr) {
  throw proto::SchemaError("Nonoptional field attr not set when packing");
}
msg["attr"] = messages::toMsgpackObject(this->attr);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);
if (this->bindata == nullptr) {
  throw proto::SchemaError("Nonoptional field bindata not set when packing");
}
msg["bindata"] = messages::toMsgpackObject(this->bindata);
if (this->triggers == nullptr) {
  throw proto::SchemaError("Nonoptional field triggers not set when packing");
}
msg["triggers"] = messages::toMsgpackObject(this->triggers);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgCreate> MsgCreate::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgCreate> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgCreate> MsgCreate::Builder::build() {
  return std::make_shared<veles::proto::MsgCreate>(rid, id, parent, pos_start, pos_end, tags, attr, data, bindata, triggers);
}
                MsgDelete::Builder& MsgDelete::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgDelete::Builder& MsgDelete::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgDelete::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgDelete> MsgDelete::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgDelete> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgDelete> MsgDelete::Builder::build() {
  return std::make_shared<veles::proto::MsgDelete>(rid, id);
}
                MsgSetParent::Builder& MsgSetParent::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgSetParent::Builder& MsgSetParent::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgSetParent::Builder& MsgSetParent::Builder::set_parent(std::shared_ptr<veles::data::NodeID> parent) {
                  this->parent = std::shared_ptr<veles::data::NodeID>(parent);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSetParent::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->parent == nullptr) {
  throw proto::SchemaError("Nonoptional field parent not set when packing");
}
msg["parent"] = messages::toMsgpackObject(this->parent);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSetParent> MsgSetParent::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSetParent> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSetParent> MsgSetParent::Builder::build() {
  return std::make_shared<veles::proto::MsgSetParent>(rid, id, parent);
}
                MsgSetPos::Builder& MsgSetPos::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgSetPos::Builder& MsgSetPos::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgSetPos::Builder& MsgSetPos::Builder::set_pos_start(const std::pair<bool, int64_t>& pos_start) {
                  this->pos_start = pos_start;
                  return *this;
                }
            
                MsgSetPos::Builder& MsgSetPos::Builder::set_pos_end(const std::pair<bool, int64_t>& pos_end) {
                  this->pos_end = pos_end;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSetPos::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->pos_start.first) {
                  msg["pos_start"] = messages::toMsgpackObject(this->pos_start.second);
                } else {
                  msg["pos_start"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->pos_end.first) {
                  msg["pos_end"] = messages::toMsgpackObject(this->pos_end.second);
                } else {
                  msg["pos_end"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSetPos> MsgSetPos::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSetPos> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSetPos> MsgSetPos::Builder::build() {
  return std::make_shared<veles::proto::MsgSetPos>(rid, id, pos_start, pos_end);
}
                MsgAddTag::Builder& MsgAddTag::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgAddTag::Builder& MsgAddTag::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgAddTag::Builder& MsgAddTag::Builder::set_tag(std::shared_ptr<std::string> tag) {
                  this->tag = std::shared_ptr<std::string>(tag);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgAddTag::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->tag == nullptr) {
  throw proto::SchemaError("Nonoptional field tag not set when packing");
}
msg["tag"] = messages::toMsgpackObject(this->tag);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgAddTag> MsgAddTag::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgAddTag> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgAddTag> MsgAddTag::Builder::build() {
  return std::make_shared<veles::proto::MsgAddTag>(rid, id, tag);
}
                MsgDelTag::Builder& MsgDelTag::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgDelTag::Builder& MsgDelTag::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgDelTag::Builder& MsgDelTag::Builder::set_tag(std::shared_ptr<std::string> tag) {
                  this->tag = std::shared_ptr<std::string>(tag);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgDelTag::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->tag == nullptr) {
  throw proto::SchemaError("Nonoptional field tag not set when packing");
}
msg["tag"] = messages::toMsgpackObject(this->tag);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgDelTag> MsgDelTag::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgDelTag> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgDelTag> MsgDelTag::Builder::build() {
  return std::make_shared<veles::proto::MsgDelTag>(rid, id, tag);
}
                MsgSetAttr::Builder& MsgSetAttr::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgSetAttr::Builder& MsgSetAttr::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgSetAttr::Builder& MsgSetAttr::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                MsgSetAttr::Builder& MsgSetAttr::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSetAttr::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSetAttr> MsgSetAttr::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSetAttr> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSetAttr> MsgSetAttr::Builder::build() {
  return std::make_shared<veles::proto::MsgSetAttr>(rid, id, key, data);
}
                MsgSetData::Builder& MsgSetData::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgSetData::Builder& MsgSetData::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgSetData::Builder& MsgSetData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                MsgSetData::Builder& MsgSetData::Builder::set_data(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& data) {
                  this->data = data;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSetData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
if (this->data.first) {
                  msg["data"] = messages::toMsgpackObject(this->data.second);
                } else {
                  msg["data"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSetData> MsgSetData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSetData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSetData> MsgSetData::Builder::build() {
  return std::make_shared<veles::proto::MsgSetData>(rid, id, key, data);
}
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_id(std::shared_ptr<veles::data::NodeID> id) {
                  this->id = std::shared_ptr<veles::data::NodeID>(id);
                  return *this;
                }
            
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_key(std::shared_ptr<std::string> key) {
                  this->key = std::shared_ptr<std::string>(key);
                  return *this;
                }
            
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_start(uint64_t start) {
                  this->start = start;
                  return *this;
                }
            
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_data(std::shared_ptr<std::vector<uint8_t>> data) {
                  this->data = std::shared_ptr<std::vector<uint8_t>>(data);
                  return *this;
                }
            
                MsgSetBinData::Builder& MsgSetBinData::Builder::set_truncate(bool truncate) {
                  this->truncate = truncate;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgSetBinData::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->id == nullptr) {
  throw proto::SchemaError("Nonoptional field id not set when packing");
}
msg["id"] = messages::toMsgpackObject(this->id);
if (this->key == nullptr) {
  throw proto::SchemaError("Nonoptional field key not set when packing");
}
msg["key"] = messages::toMsgpackObject(this->key);
msg["start"] = messages::toMsgpackObject(this->start);
if (this->data == nullptr) {
  throw proto::SchemaError("Nonoptional field data not set when packing");
}
msg["data"] = messages::toMsgpackObject(this->data);
msg["truncate"] = messages::toMsgpackObject(this->truncate);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgSetBinData> MsgSetBinData::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgSetBinData> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgSetBinData> MsgSetBinData::Builder::build() {
  return std::make_shared<veles::proto::MsgSetBinData>(rid, id, key, start, data, truncate);
}
                MsgTransaction::Builder& MsgTransaction::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgTransaction::Builder& MsgTransaction::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
                MsgTransaction::Builder& MsgTransaction::Builder::set_operations(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> operations) {
                  this->operations = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>>(operations);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgTransaction::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);
if (this->operations == nullptr) {
  throw proto::SchemaError("Nonoptional field operations not set when packing");
}
msg["operations"] = messages::toMsgpackObject(this->operations);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgTransaction> MsgTransaction::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgTransaction> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgTransaction> MsgTransaction::Builder::build() {
  return std::make_shared<veles::proto::MsgTransaction>(rid, checks, operations);
}
                MsgRequestAck::Builder& MsgRequestAck::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgRequestAck::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgRequestAck> MsgRequestAck::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgRequestAck> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgRequestAck> MsgRequestAck::Builder::build() {
  return std::make_shared<veles::proto::MsgRequestAck>(rid);
}
                MsgRequestError::Builder& MsgRequestError::Builder::set_rid(uint64_t rid) {
                  this->rid = rid;
                  return *this;
                }
            
                MsgRequestError::Builder& MsgRequestError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgRequestError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["rid"] = messages::toMsgpackObject(this->rid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgRequestError> MsgRequestError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgRequestError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgRequestError> MsgRequestError::Builder::build() {
  return std::make_shared<veles::proto::MsgRequestError>(rid, err);
}
                MsgMethodRun::Builder& MsgMethodRun::Builder::set_mid(uint64_t mid) {
                  this->mid = mid;
                  return *this;
                }
            
                MsgMethodRun::Builder& MsgMethodRun::Builder::set_node(std::shared_ptr<veles::data::NodeID> node) {
                  this->node = std::shared_ptr<veles::data::NodeID>(node);
                  return *this;
                }
            
                MsgMethodRun::Builder& MsgMethodRun::Builder::set_method(std::shared_ptr<std::string> method) {
                  this->method = std::shared_ptr<std::string>(method);
                  return *this;
                }
            
                MsgMethodRun::Builder& MsgMethodRun::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgMethodRun::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["mid"] = messages::toMsgpackObject(this->mid);
if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->method == nullptr) {
  throw proto::SchemaError("Nonoptional field method not set when packing");
}
msg["method"] = messages::toMsgpackObject(this->method);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgMethodRun> MsgMethodRun::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgMethodRun> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgMethodRun> MsgMethodRun::Builder::build() {
  return std::make_shared<veles::proto::MsgMethodRun>(mid, node, method, params);
}
                MsgMethodResult::Builder& MsgMethodResult::Builder::set_mid(uint64_t mid) {
                  this->mid = mid;
                  return *this;
                }
            
                MsgMethodResult::Builder& MsgMethodResult::Builder::set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) {
                  this->result = result;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgMethodResult::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["mid"] = messages::toMsgpackObject(this->mid);
if (this->result.first) {
                  msg["result"] = messages::toMsgpackObject(this->result.second);
                } else {
                  msg["result"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgMethodResult> MsgMethodResult::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgMethodResult> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgMethodResult> MsgMethodResult::Builder::build() {
  return std::make_shared<veles::proto::MsgMethodResult>(mid, result);
}
                MsgMethodError::Builder& MsgMethodError::Builder::set_mid(uint64_t mid) {
                  this->mid = mid;
                  return *this;
                }
            
                MsgMethodError::Builder& MsgMethodError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgMethodError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["mid"] = messages::toMsgpackObject(this->mid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgMethodError> MsgMethodError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgMethodError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgMethodError> MsgMethodError::Builder::build() {
  return std::make_shared<veles::proto::MsgMethodError>(mid, err);
}
                MsgBroadcastRun::Builder& MsgBroadcastRun::Builder::set_bid(uint64_t bid) {
                  this->bid = bid;
                  return *this;
                }
            
                MsgBroadcastRun::Builder& MsgBroadcastRun::Builder::set_broadcast(std::shared_ptr<std::string> broadcast) {
                  this->broadcast = std::shared_ptr<std::string>(broadcast);
                  return *this;
                }
            
                MsgBroadcastRun::Builder& MsgBroadcastRun::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgBroadcastRun::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["bid"] = messages::toMsgpackObject(this->bid);
if (this->broadcast == nullptr) {
  throw proto::SchemaError("Nonoptional field broadcast not set when packing");
}
msg["broadcast"] = messages::toMsgpackObject(this->broadcast);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgBroadcastRun> MsgBroadcastRun::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgBroadcastRun> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgBroadcastRun> MsgBroadcastRun::Builder::build() {
  return std::make_shared<veles::proto::MsgBroadcastRun>(bid, broadcast, params);
}
                MsgBroadcastResult::Builder& MsgBroadcastResult::Builder::set_bid(uint64_t bid) {
                  this->bid = bid;
                  return *this;
                }
            
                MsgBroadcastResult::Builder& MsgBroadcastResult::Builder::set_results(std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results) {
                  this->results = std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>>(results);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgBroadcastResult::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["bid"] = messages::toMsgpackObject(this->bid);
if (this->results == nullptr) {
  throw proto::SchemaError("Nonoptional field results not set when packing");
}
msg["results"] = messages::toMsgpackObject(this->results);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgBroadcastResult> MsgBroadcastResult::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgBroadcastResult> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgBroadcastResult> MsgBroadcastResult::Builder::build() {
  return std::make_shared<veles::proto::MsgBroadcastResult>(bid, results);
}
                MsgPluginMethodRegister::Builder& MsgPluginMethodRegister::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginMethodRegister::Builder& MsgPluginMethodRegister::Builder::set_name(std::shared_ptr<std::string> name) {
                  this->name = std::shared_ptr<std::string>(name);
                  return *this;
                }
            
                MsgPluginMethodRegister::Builder& MsgPluginMethodRegister::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginMethodRegister::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->name == nullptr) {
  throw proto::SchemaError("Nonoptional field name not set when packing");
}
msg["name"] = messages::toMsgpackObject(this->name);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginMethodRegister> MsgPluginMethodRegister::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginMethodRegister> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginMethodRegister> MsgPluginMethodRegister::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginMethodRegister>(phid, name, tags);
}
                MsgPluginMethodRun::Builder& MsgPluginMethodRun::Builder::set_pmid(uint64_t pmid) {
                  this->pmid = pmid;
                  return *this;
                }
            
                MsgPluginMethodRun::Builder& MsgPluginMethodRun::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginMethodRun::Builder& MsgPluginMethodRun::Builder::set_node(std::shared_ptr<veles::proto::Node> node) {
                  this->node = std::shared_ptr<veles::proto::Node>(node);
                  return *this;
                }
            
                MsgPluginMethodRun::Builder& MsgPluginMethodRun::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginMethodRun::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pmid"] = messages::toMsgpackObject(this->pmid);
msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginMethodRun> MsgPluginMethodRun::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginMethodRun> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginMethodRun> MsgPluginMethodRun::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginMethodRun>(pmid, phid, node, params);
}
                MsgPluginMethodResult::Builder& MsgPluginMethodResult::Builder::set_pmid(uint64_t pmid) {
                  this->pmid = pmid;
                  return *this;
                }
            
                MsgPluginMethodResult::Builder& MsgPluginMethodResult::Builder::set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) {
                  this->result = result;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginMethodResult::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pmid"] = messages::toMsgpackObject(this->pmid);
if (this->result.first) {
                  msg["result"] = messages::toMsgpackObject(this->result.second);
                } else {
                  msg["result"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginMethodResult> MsgPluginMethodResult::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginMethodResult> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginMethodResult> MsgPluginMethodResult::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginMethodResult>(pmid, result);
}
                MsgPluginMethodError::Builder& MsgPluginMethodError::Builder::set_pmid(uint64_t pmid) {
                  this->pmid = pmid;
                  return *this;
                }
            
                MsgPluginMethodError::Builder& MsgPluginMethodError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginMethodError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pmid"] = messages::toMsgpackObject(this->pmid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginMethodError> MsgPluginMethodError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginMethodError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginMethodError> MsgPluginMethodError::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginMethodError>(pmid, err);
}
                MsgPluginQueryRegister::Builder& MsgPluginQueryRegister::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginQueryRegister::Builder& MsgPluginQueryRegister::Builder::set_name(std::shared_ptr<std::string> name) {
                  this->name = std::shared_ptr<std::string>(name);
                  return *this;
                }
            
                MsgPluginQueryRegister::Builder& MsgPluginQueryRegister::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginQueryRegister::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->name == nullptr) {
  throw proto::SchemaError("Nonoptional field name not set when packing");
}
msg["name"] = messages::toMsgpackObject(this->name);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginQueryRegister> MsgPluginQueryRegister::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginQueryRegister> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginQueryRegister> MsgPluginQueryRegister::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginQueryRegister>(phid, name, tags);
}
                MsgPluginQueryGet::Builder& MsgPluginQueryGet::Builder::set_pqid(uint64_t pqid) {
                  this->pqid = pqid;
                  return *this;
                }
            
                MsgPluginQueryGet::Builder& MsgPluginQueryGet::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginQueryGet::Builder& MsgPluginQueryGet::Builder::set_node(std::shared_ptr<veles::proto::Node> node) {
                  this->node = std::shared_ptr<veles::proto::Node>(node);
                  return *this;
                }
            
                MsgPluginQueryGet::Builder& MsgPluginQueryGet::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginQueryGet::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pqid"] = messages::toMsgpackObject(this->pqid);
msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginQueryGet> MsgPluginQueryGet::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginQueryGet> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginQueryGet> MsgPluginQueryGet::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginQueryGet>(pqid, phid, node, params);
}
                MsgPluginQueryResult::Builder& MsgPluginQueryResult::Builder::set_pqid(uint64_t pqid) {
                  this->pqid = pqid;
                  return *this;
                }
            
                MsgPluginQueryResult::Builder& MsgPluginQueryResult::Builder::set_result(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& result) {
                  this->result = result;
                  return *this;
                }
            
                MsgPluginQueryResult::Builder& MsgPluginQueryResult::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginQueryResult::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pqid"] = messages::toMsgpackObject(this->pqid);
if (this->result.first) {
                  msg["result"] = messages::toMsgpackObject(this->result.second);
                } else {
                  msg["result"] = std::make_shared<messages::MsgpackObject>();
                }
                if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginQueryResult> MsgPluginQueryResult::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginQueryResult> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginQueryResult> MsgPluginQueryResult::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginQueryResult>(pqid, result, checks);
}
                MsgPluginQueryError::Builder& MsgPluginQueryError::Builder::set_pqid(uint64_t pqid) {
                  this->pqid = pqid;
                  return *this;
                }
            
                MsgPluginQueryError::Builder& MsgPluginQueryError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
                MsgPluginQueryError::Builder& MsgPluginQueryError::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginQueryError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pqid"] = messages::toMsgpackObject(this->pqid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);
if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginQueryError> MsgPluginQueryError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginQueryError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginQueryError> MsgPluginQueryError::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginQueryError>(pqid, err, checks);
}
                MsgPluginBroadcastRegister::Builder& MsgPluginBroadcastRegister::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginBroadcastRegister::Builder& MsgPluginBroadcastRegister::Builder::set_name(std::shared_ptr<std::string> name) {
                  this->name = std::shared_ptr<std::string>(name);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginBroadcastRegister::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->name == nullptr) {
  throw proto::SchemaError("Nonoptional field name not set when packing");
}
msg["name"] = messages::toMsgpackObject(this->name);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginBroadcastRegister> MsgPluginBroadcastRegister::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginBroadcastRegister> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginBroadcastRegister> MsgPluginBroadcastRegister::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginBroadcastRegister>(phid, name);
}
                MsgPluginBroadcastRun::Builder& MsgPluginBroadcastRun::Builder::set_pbid(uint64_t pbid) {
                  this->pbid = pbid;
                  return *this;
                }
            
                MsgPluginBroadcastRun::Builder& MsgPluginBroadcastRun::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginBroadcastRun::Builder& MsgPluginBroadcastRun::Builder::set_params(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& params) {
                  this->params = params;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginBroadcastRun::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pbid"] = messages::toMsgpackObject(this->pbid);
msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->params.first) {
                  msg["params"] = messages::toMsgpackObject(this->params.second);
                } else {
                  msg["params"] = std::make_shared<messages::MsgpackObject>();
                }
                
    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginBroadcastRun> MsgPluginBroadcastRun::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginBroadcastRun> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginBroadcastRun> MsgPluginBroadcastRun::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginBroadcastRun>(pbid, phid, params);
}
                MsgPluginBroadcastResult::Builder& MsgPluginBroadcastResult::Builder::set_pbid(uint64_t pbid) {
                  this->pbid = pbid;
                  return *this;
                }
            
                MsgPluginBroadcastResult::Builder& MsgPluginBroadcastResult::Builder::set_results(std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> results) {
                  this->results = std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>>(results);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginBroadcastResult::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["pbid"] = messages::toMsgpackObject(this->pbid);
if (this->results == nullptr) {
  throw proto::SchemaError("Nonoptional field results not set when packing");
}
msg["results"] = messages::toMsgpackObject(this->results);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginBroadcastResult> MsgPluginBroadcastResult::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginBroadcastResult> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginBroadcastResult> MsgPluginBroadcastResult::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginBroadcastResult>(pbid, results);
}
                MsgPluginTriggerRegister::Builder& MsgPluginTriggerRegister::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginTriggerRegister::Builder& MsgPluginTriggerRegister::Builder::set_name(std::shared_ptr<std::string> name) {
                  this->name = std::shared_ptr<std::string>(name);
                  return *this;
                }
            
                MsgPluginTriggerRegister::Builder& MsgPluginTriggerRegister::Builder::set_tags(std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> tags) {
                  this->tags = std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>>(tags);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginTriggerRegister::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->name == nullptr) {
  throw proto::SchemaError("Nonoptional field name not set when packing");
}
msg["name"] = messages::toMsgpackObject(this->name);
if (this->tags == nullptr) {
  throw proto::SchemaError("Nonoptional field tags not set when packing");
}
msg["tags"] = messages::toMsgpackObject(this->tags);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginTriggerRegister> MsgPluginTriggerRegister::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginTriggerRegister> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginTriggerRegister> MsgPluginTriggerRegister::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginTriggerRegister>(phid, name, tags);
}
                MsgPluginTriggerRun::Builder& MsgPluginTriggerRun::Builder::set_ptid(uint64_t ptid) {
                  this->ptid = ptid;
                  return *this;
                }
            
                MsgPluginTriggerRun::Builder& MsgPluginTriggerRun::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
                MsgPluginTriggerRun::Builder& MsgPluginTriggerRun::Builder::set_node(std::shared_ptr<veles::proto::Node> node) {
                  this->node = std::shared_ptr<veles::proto::Node>(node);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginTriggerRun::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["ptid"] = messages::toMsgpackObject(this->ptid);
msg["phid"] = messages::toMsgpackObject(this->phid);
if (this->node == nullptr) {
  throw proto::SchemaError("Nonoptional field node not set when packing");
}
msg["node"] = messages::toMsgpackObject(this->node);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginTriggerRun> MsgPluginTriggerRun::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginTriggerRun> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginTriggerRun> MsgPluginTriggerRun::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginTriggerRun>(ptid, phid, node);
}
                MsgPluginTriggerDone::Builder& MsgPluginTriggerDone::Builder::set_ptid(uint64_t ptid) {
                  this->ptid = ptid;
                  return *this;
                }
            
                MsgPluginTriggerDone::Builder& MsgPluginTriggerDone::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginTriggerDone::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["ptid"] = messages::toMsgpackObject(this->ptid);
if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginTriggerDone> MsgPluginTriggerDone::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginTriggerDone> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginTriggerDone> MsgPluginTriggerDone::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginTriggerDone>(ptid, checks);
}
                MsgPluginTriggerError::Builder& MsgPluginTriggerError::Builder::set_ptid(uint64_t ptid) {
                  this->ptid = ptid;
                  return *this;
                }
            
                MsgPluginTriggerError::Builder& MsgPluginTriggerError::Builder::set_err(std::shared_ptr<veles::proto::VelesException> err) {
                  this->err = std::shared_ptr<veles::proto::VelesException>(err);
                  return *this;
                }
            
                MsgPluginTriggerError::Builder& MsgPluginTriggerError::Builder::set_checks(std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> checks) {
                  this->checks = std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>>(checks);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginTriggerError::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["ptid"] = messages::toMsgpackObject(this->ptid);
if (this->err == nullptr) {
  throw proto::SchemaError("Nonoptional field err not set when packing");
}
msg["err"] = messages::toMsgpackObject(this->err);
if (this->checks == nullptr) {
  throw proto::SchemaError("Nonoptional field checks not set when packing");
}
msg["checks"] = messages::toMsgpackObject(this->checks);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginTriggerError> MsgPluginTriggerError::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginTriggerError> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginTriggerError> MsgPluginTriggerError::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginTriggerError>(ptid, err, checks);
}
                MsgPluginHandlerUnregister::Builder& MsgPluginHandlerUnregister::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginHandlerUnregister::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginHandlerUnregister> MsgPluginHandlerUnregister::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginHandlerUnregister> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginHandlerUnregister> MsgPluginHandlerUnregister::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginHandlerUnregister>(phid);
}
                MsgPluginHandlerUnregistered::Builder& MsgPluginHandlerUnregistered::Builder::set_phid(uint64_t phid) {
                  this->phid = phid;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MsgPluginHandlerUnregistered::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["phid"] = messages::toMsgpackObject(this->phid);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered> MsgPluginHandlerUnregistered::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered> MsgPluginHandlerUnregistered::Builder::build() {
  return std::make_shared<veles::proto::MsgPluginHandlerUnregistered>(phid);
}}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgpackMsg>* out) {
  auto& types = veles::proto::MsgpackMsg::objectTypes();
  if (types.size() == 0) {
    veles::proto::MsgpackMsg::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::proto::MsgpackMsg>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgConnect>* out) {
            veles::proto::MsgConnect::Builder b;
            auto it_proto_version = obj->getMap()->find("proto_version");
if (it_proto_version != obj->getMap()->end() && it_proto_version->second->type() != ObjectType::NIL) {
  int64_t obj_proto_version;
  fromMsgpackObject(it_proto_version->second, &obj_proto_version);
  b.set_proto_version(obj_proto_version);
} else {
  throw proto::SchemaError("Nonoptional field proto_version not found when unpacking");
}
auto it_client_name = obj->getMap()->find("client_name");
if (it_client_name != obj->getMap()->end() && it_client_name->second->type() != ObjectType::NIL) {
std::shared_ptr<std::string> obj_client_name;
  fromMsgpackObject(it_client_name->second, &obj_client_name);
  b.set_client_name(std::pair<bool, std::shared_ptr<std::string>>(true, obj_client_name));
}

auto it_client_version = obj->getMap()->find("client_version");
if (it_client_version != obj->getMap()->end() && it_client_version->second->type() != ObjectType::NIL) {
std::shared_ptr<std::string> obj_client_version;
  fromMsgpackObject(it_client_version->second, &obj_client_version);
  b.set_client_version(std::pair<bool, std::shared_ptr<std::string>>(true, obj_client_version));
}

auto it_client_description = obj->getMap()->find("client_description");
if (it_client_description != obj->getMap()->end() && it_client_description->second->type() != ObjectType::NIL) {
std::shared_ptr<std::string> obj_client_description;
  fromMsgpackObject(it_client_description->second, &obj_client_description);
  b.set_client_description(std::pair<bool, std::shared_ptr<std::string>>(true, obj_client_description));
}

auto it_client_type = obj->getMap()->find("client_type");
if (it_client_type != obj->getMap()->end() && it_client_type->second->type() != ObjectType::NIL) {
std::shared_ptr<std::string> obj_client_type;
  fromMsgpackObject(it_client_type->second, &obj_client_type);
  b.set_client_type(std::pair<bool, std::shared_ptr<std::string>>(true, obj_client_type));
}

auto it_quit_on_close = obj->getMap()->find("quit_on_close");
if (it_quit_on_close != obj->getMap()->end() && it_quit_on_close->second->type() != ObjectType::NIL) {
  bool obj_quit_on_close;
  fromMsgpackObject(it_quit_on_close->second, &obj_quit_on_close);
  b.set_quit_on_close(obj_quit_on_close);
} else {
  throw proto::SchemaError("Nonoptional field quit_on_close not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgConnect>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgConnected>* out) {
            veles::proto::MsgConnected::Builder b;
            auto it_proto_version = obj->getMap()->find("proto_version");
if (it_proto_version != obj->getMap()->end() && it_proto_version->second->type() != ObjectType::NIL) {
  int64_t obj_proto_version;
  fromMsgpackObject(it_proto_version->second, &obj_proto_version);
  b.set_proto_version(obj_proto_version);
} else {
  throw proto::SchemaError("Nonoptional field proto_version not found when unpacking");
}
auto it_server_name = obj->getMap()->find("server_name");
if (it_server_name != obj->getMap()->end() && it_server_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_server_name;
  fromMsgpackObject(it_server_name->second, &obj_server_name);
  b.set_server_name(obj_server_name);
} else {
  throw proto::SchemaError("Nonoptional field server_name not found when unpacking");
}
auto it_server_version = obj->getMap()->find("server_version");
if (it_server_version != obj->getMap()->end() && it_server_version->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_server_version;
  fromMsgpackObject(it_server_version->second, &obj_server_version);
  b.set_server_version(obj_server_version);
} else {
  throw proto::SchemaError("Nonoptional field server_version not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgConnected>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgConnectionError>* out) {
            veles::proto::MsgConnectionError::Builder b;
            auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgConnectionError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgProtoError>* out) {
            veles::proto::MsgProtoError::Builder b;
            auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgProtoError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGet>* out) {
            veles::proto::MsgGet::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGet>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetReply>* out) {
            veles::proto::MsgGetReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_obj = obj->getMap()->find("obj");
if (it_obj != obj->getMap()->end() && it_obj->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::Node> obj_obj;
  fromMsgpackObject(it_obj->second, &obj_obj);
  b.set_obj(obj_obj);
} else {
  throw proto::SchemaError("Nonoptional field obj not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetData>* out) {
            veles::proto::MsgGetData::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetDataReply>* out) {
            veles::proto::MsgGetDataReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetDataReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetBinData>* out) {
            veles::proto::MsgGetBinData::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_start = obj->getMap()->find("start");
if (it_start != obj->getMap()->end() && it_start->second->type() != ObjectType::NIL) {
  uint64_t obj_start;
  fromMsgpackObject(it_start->second, &obj_start);
  b.set_start(obj_start);
} else {
  throw proto::SchemaError("Nonoptional field start not found when unpacking");
}
auto it_end = obj->getMap()->find("end");
if (it_end != obj->getMap()->end() && it_end->second->type() != ObjectType::NIL) {
uint64_t obj_end;
  fromMsgpackObject(it_end->second, &obj_end);
  b.set_end(std::pair<bool, uint64_t>(true, obj_end));
}

auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetBinData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetBinDataReply>* out) {
            veles::proto::MsgGetBinDataReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetBinDataReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetList>* out) {
            veles::proto::MsgGetList::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
auto it_pos_filter = obj->getMap()->find("pos_filter");
if (it_pos_filter != obj->getMap()->end() && it_pos_filter->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::PosFilter> obj_pos_filter;
  fromMsgpackObject(it_pos_filter->second, &obj_pos_filter);
  b.set_pos_filter(obj_pos_filter);
} else {
  throw proto::SchemaError("Nonoptional field pos_filter not found when unpacking");
}
auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetList>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetListReply>* out) {
            veles::proto::MsgGetListReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_objs = obj->getMap()->find("objs");
if (it_objs != obj->getMap()->end() && it_objs->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Node>>> obj_objs;
  fromMsgpackObject(it_objs->second, &obj_objs);
  b.set_objs(obj_objs);
} else {
  throw proto::SchemaError("Nonoptional field objs not found when unpacking");
}
auto it_gone = obj->getMap()->find("gone");
if (it_gone != obj->getMap()->end() && it_gone->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::data::NodeID>>> obj_gone;
  fromMsgpackObject(it_gone->second, &obj_gone);
  b.set_gone(obj_gone);
} else {
  throw proto::SchemaError("Nonoptional field gone not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetListReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetQuery>* out) {
            veles::proto::MsgGetQuery::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_query = obj->getMap()->find("query");
if (it_query != obj->getMap()->end() && it_query->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_query;
  fromMsgpackObject(it_query->second, &obj_query);
  b.set_query(obj_query);
} else {
  throw proto::SchemaError("Nonoptional field query not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

auto it_trace = obj->getMap()->find("trace");
if (it_trace != obj->getMap()->end() && it_trace->second->type() != ObjectType::NIL) {
  bool obj_trace;
  fromMsgpackObject(it_trace->second, &obj_trace);
  b.set_trace(obj_trace);
} else {
  throw proto::SchemaError("Nonoptional field trace not found when unpacking");
}
auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetQuery>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgGetQueryReply>* out) {
            veles::proto::MsgGetQueryReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_result = obj->getMap()->find("result");
if (it_result != obj->getMap()->end() && it_result->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_result;
  fromMsgpackObject(it_result->second, &obj_result);
  b.set_result(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_result));
}

auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgGetQueryReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgListConnections>* out) {
            veles::proto::MsgListConnections::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_sub = obj->getMap()->find("sub");
if (it_sub != obj->getMap()->end() && it_sub->second->type() != ObjectType::NIL) {
  bool obj_sub;
  fromMsgpackObject(it_sub->second, &obj_sub);
  b.set_sub(obj_sub);
} else {
  throw proto::SchemaError("Nonoptional field sub not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgListConnections>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgConnectionsReply>* out) {
            veles::proto::MsgConnectionsReply::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_connections = obj->getMap()->find("connections");
if (it_connections != obj->getMap()->end() && it_connections->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Connection>>> obj_connections;
  fromMsgpackObject(it_connections->second, &obj_connections);
  b.set_connections(obj_connections);
} else {
  throw proto::SchemaError("Nonoptional field connections not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgConnectionsReply>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgQueryError>* out) {
            veles::proto::MsgQueryError::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgQueryError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgCancelSubscription>* out) {
            veles::proto::MsgCancelSubscription::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgCancelSubscription>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSubscriptionCancelled>* out) {
            veles::proto::MsgSubscriptionCancelled::Builder b;
            auto it_qid = obj->getMap()->find("qid");
if (it_qid != obj->getMap()->end() && it_qid->second->type() != ObjectType::NIL) {
  uint64_t obj_qid;
  fromMsgpackObject(it_qid->second, &obj_qid);
  b.set_qid(obj_qid);
} else {
  throw proto::SchemaError("Nonoptional field qid not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSubscriptionCancelled>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgCreate>* out) {
            veles::proto::MsgCreate::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
auto it_attr = obj->getMap()->find("attr");
if (it_attr != obj->getMap()->end() && it_attr->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> obj_attr;
  fromMsgpackObject(it_attr->second, &obj_attr);
  b.set_attr(obj_attr);
} else {
  throw proto::SchemaError("Nonoptional field attr not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<veles::messages::MsgpackObject>>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
auto it_bindata = obj->getMap()->find("bindata");
if (it_bindata != obj->getMap()->end() && it_bindata->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,std::shared_ptr<std::vector<uint8_t>>>> obj_bindata;
  fromMsgpackObject(it_bindata->second, &obj_bindata);
  b.set_bindata(obj_bindata);
} else {
  throw proto::SchemaError("Nonoptional field bindata not found when unpacking");
}
auto it_triggers = obj->getMap()->find("triggers");
if (it_triggers != obj->getMap()->end() && it_triggers->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_triggers;
  fromMsgpackObject(it_triggers->second, &obj_triggers);
  b.set_triggers(obj_triggers);
} else {
  throw proto::SchemaError("Nonoptional field triggers not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgCreate>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgDelete>* out) {
            veles::proto::MsgDelete::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgDelete>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSetParent>* out) {
            veles::proto::MsgSetParent::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_parent = obj->getMap()->find("parent");
if (it_parent != obj->getMap()->end() && it_parent->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_parent;
  fromMsgpackObject(it_parent->second, &obj_parent);
  b.set_parent(obj_parent);
} else {
  throw proto::SchemaError("Nonoptional field parent not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSetParent>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSetPos>* out) {
            veles::proto::MsgSetPos::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_pos_start = obj->getMap()->find("pos_start");
if (it_pos_start != obj->getMap()->end() && it_pos_start->second->type() != ObjectType::NIL) {
int64_t obj_pos_start;
  fromMsgpackObject(it_pos_start->second, &obj_pos_start);
  b.set_pos_start(std::pair<bool, int64_t>(true, obj_pos_start));
}

auto it_pos_end = obj->getMap()->find("pos_end");
if (it_pos_end != obj->getMap()->end() && it_pos_end->second->type() != ObjectType::NIL) {
int64_t obj_pos_end;
  fromMsgpackObject(it_pos_end->second, &obj_pos_end);
  b.set_pos_end(std::pair<bool, int64_t>(true, obj_pos_end));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSetPos>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgAddTag>* out) {
            veles::proto::MsgAddTag::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_tag = obj->getMap()->find("tag");
if (it_tag != obj->getMap()->end() && it_tag->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_tag;
  fromMsgpackObject(it_tag->second, &obj_tag);
  b.set_tag(obj_tag);
} else {
  throw proto::SchemaError("Nonoptional field tag not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgAddTag>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgDelTag>* out) {
            veles::proto::MsgDelTag::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_tag = obj->getMap()->find("tag");
if (it_tag != obj->getMap()->end() && it_tag->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_tag;
  fromMsgpackObject(it_tag->second, &obj_tag);
  b.set_tag(obj_tag);
} else {
  throw proto::SchemaError("Nonoptional field tag not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgDelTag>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSetAttr>* out) {
            veles::proto::MsgSetAttr::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSetAttr>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSetData>* out) {
            veles::proto::MsgSetData::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_data));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSetData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgSetBinData>* out) {
            veles::proto::MsgSetBinData::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_id = obj->getMap()->find("id");
if (it_id != obj->getMap()->end() && it_id->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_id;
  fromMsgpackObject(it_id->second, &obj_id);
  b.set_id(obj_id);
} else {
  throw proto::SchemaError("Nonoptional field id not found when unpacking");
}
auto it_key = obj->getMap()->find("key");
if (it_key != obj->getMap()->end() && it_key->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_key;
  fromMsgpackObject(it_key->second, &obj_key);
  b.set_key(obj_key);
} else {
  throw proto::SchemaError("Nonoptional field key not found when unpacking");
}
auto it_start = obj->getMap()->find("start");
if (it_start != obj->getMap()->end() && it_start->second->type() != ObjectType::NIL) {
  uint64_t obj_start;
  fromMsgpackObject(it_start->second, &obj_start);
  b.set_start(obj_start);
} else {
  throw proto::SchemaError("Nonoptional field start not found when unpacking");
}
auto it_data = obj->getMap()->find("data");
if (it_data != obj->getMap()->end() && it_data->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_data;
  fromMsgpackObject(it_data->second, &obj_data);
  b.set_data(obj_data);
} else {
  throw proto::SchemaError("Nonoptional field data not found when unpacking");
}
auto it_truncate = obj->getMap()->find("truncate");
if (it_truncate != obj->getMap()->end() && it_truncate->second->type() != ObjectType::NIL) {
  bool obj_truncate;
  fromMsgpackObject(it_truncate->second, &obj_truncate);
  b.set_truncate(obj_truncate);
} else {
  throw proto::SchemaError("Nonoptional field truncate not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgSetBinData>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgTransaction>* out) {
            veles::proto::MsgTransaction::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
auto it_operations = obj->getMap()->find("operations");
if (it_operations != obj->getMap()->end() && it_operations->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Operation>>> obj_operations;
  fromMsgpackObject(it_operations->second, &obj_operations);
  b.set_operations(obj_operations);
} else {
  throw proto::SchemaError("Nonoptional field operations not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgTransaction>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgRequestAck>* out) {
            veles::proto::MsgRequestAck::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgRequestAck>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgRequestError>* out) {
            veles::proto::MsgRequestError::Builder b;
            auto it_rid = obj->getMap()->find("rid");
if (it_rid != obj->getMap()->end() && it_rid->second->type() != ObjectType::NIL) {
  uint64_t obj_rid;
  fromMsgpackObject(it_rid->second, &obj_rid);
  b.set_rid(obj_rid);
} else {
  throw proto::SchemaError("Nonoptional field rid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgRequestError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgMethodRun>* out) {
            veles::proto::MsgMethodRun::Builder b;
            auto it_mid = obj->getMap()->find("mid");
if (it_mid != obj->getMap()->end() && it_mid->second->type() != ObjectType::NIL) {
  uint64_t obj_mid;
  fromMsgpackObject(it_mid->second, &obj_mid);
  b.set_mid(obj_mid);
} else {
  throw proto::SchemaError("Nonoptional field mid not found when unpacking");
}
auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_method = obj->getMap()->find("method");
if (it_method != obj->getMap()->end() && it_method->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_method;
  fromMsgpackObject(it_method->second, &obj_method);
  b.set_method(obj_method);
} else {
  throw proto::SchemaError("Nonoptional field method not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgMethodRun>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgMethodResult>* out) {
            veles::proto::MsgMethodResult::Builder b;
            auto it_mid = obj->getMap()->find("mid");
if (it_mid != obj->getMap()->end() && it_mid->second->type() != ObjectType::NIL) {
  uint64_t obj_mid;
  fromMsgpackObject(it_mid->second, &obj_mid);
  b.set_mid(obj_mid);
} else {
  throw proto::SchemaError("Nonoptional field mid not found when unpacking");
}
auto it_result = obj->getMap()->find("result");
if (it_result != obj->getMap()->end() && it_result->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_result;
  fromMsgpackObject(it_result->second, &obj_result);
  b.set_result(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_result));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgMethodResult>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgMethodError>* out) {
            veles::proto::MsgMethodError::Builder b;
            auto it_mid = obj->getMap()->find("mid");
if (it_mid != obj->getMap()->end() && it_mid->second->type() != ObjectType::NIL) {
  uint64_t obj_mid;
  fromMsgpackObject(it_mid->second, &obj_mid);
  b.set_mid(obj_mid);
} else {
  throw proto::SchemaError("Nonoptional field mid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgMethodError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgBroadcastRun>* out) {
            veles::proto::MsgBroadcastRun::Builder b;
            auto it_bid = obj->getMap()->find("bid");
if (it_bid != obj->getMap()->end() && it_bid->second->type() != ObjectType::NIL) {
  uint64_t obj_bid;
  fromMsgpackObject(it_bid->second, &obj_bid);
  b.set_bid(obj_bid);
} else {
  throw proto::SchemaError("Nonoptional field bid not found when unpacking");
}
auto it_broadcast = obj->getMap()->find("broadcast");
if (it_broadcast != obj->getMap()->end() && it_broadcast->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_broadcast;
  fromMsgpackObject(it_broadcast->second, &obj_broadcast);
  b.set_broadcast(obj_broadcast);
} else {
  throw proto::SchemaError("Nonoptional field broadcast not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgBroadcastRun>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgBroadcastResult>* out) {
            veles::proto::MsgBroadcastResult::Builder b;
            auto it_bid = obj->getMap()->find("bid");
if (it_bid != obj->getMap()->end() && it_bid->second->type() != ObjectType::NIL) {
  uint64_t obj_bid;
  fromMsgpackObject(it_bid->second, &obj_bid);
  b.set_bid(obj_bid);
} else {
  throw proto::SchemaError("Nonoptional field bid not found when unpacking");
}
auto it_results = obj->getMap()->find("results");
if (it_results != obj->getMap()->end() && it_results->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> obj_results;
  fromMsgpackObject(it_results->second, &obj_results);
  b.set_results(obj_results);
} else {
  throw proto::SchemaError("Nonoptional field results not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgBroadcastResult>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginMethodRegister>* out) {
            veles::proto::MsgPluginMethodRegister::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_name = obj->getMap()->find("name");
if (it_name != obj->getMap()->end() && it_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_name;
  fromMsgpackObject(it_name->second, &obj_name);
  b.set_name(obj_name);
} else {
  throw proto::SchemaError("Nonoptional field name not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginMethodRegister>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginMethodRun>* out) {
            veles::proto::MsgPluginMethodRun::Builder b;
            auto it_pmid = obj->getMap()->find("pmid");
if (it_pmid != obj->getMap()->end() && it_pmid->second->type() != ObjectType::NIL) {
  uint64_t obj_pmid;
  fromMsgpackObject(it_pmid->second, &obj_pmid);
  b.set_pmid(obj_pmid);
} else {
  throw proto::SchemaError("Nonoptional field pmid not found when unpacking");
}
auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::Node> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginMethodRun>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginMethodResult>* out) {
            veles::proto::MsgPluginMethodResult::Builder b;
            auto it_pmid = obj->getMap()->find("pmid");
if (it_pmid != obj->getMap()->end() && it_pmid->second->type() != ObjectType::NIL) {
  uint64_t obj_pmid;
  fromMsgpackObject(it_pmid->second, &obj_pmid);
  b.set_pmid(obj_pmid);
} else {
  throw proto::SchemaError("Nonoptional field pmid not found when unpacking");
}
auto it_result = obj->getMap()->find("result");
if (it_result != obj->getMap()->end() && it_result->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_result;
  fromMsgpackObject(it_result->second, &obj_result);
  b.set_result(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_result));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginMethodResult>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginMethodError>* out) {
            veles::proto::MsgPluginMethodError::Builder b;
            auto it_pmid = obj->getMap()->find("pmid");
if (it_pmid != obj->getMap()->end() && it_pmid->second->type() != ObjectType::NIL) {
  uint64_t obj_pmid;
  fromMsgpackObject(it_pmid->second, &obj_pmid);
  b.set_pmid(obj_pmid);
} else {
  throw proto::SchemaError("Nonoptional field pmid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginMethodError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginQueryRegister>* out) {
            veles::proto::MsgPluginQueryRegister::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_name = obj->getMap()->find("name");
if (it_name != obj->getMap()->end() && it_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_name;
  fromMsgpackObject(it_name->second, &obj_name);
  b.set_name(obj_name);
} else {
  throw proto::SchemaError("Nonoptional field name not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginQueryRegister>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginQueryGet>* out) {
            veles::proto::MsgPluginQueryGet::Builder b;
            auto it_pqid = obj->getMap()->find("pqid");
if (it_pqid != obj->getMap()->end() && it_pqid->second->type() != ObjectType::NIL) {
  uint64_t obj_pqid;
  fromMsgpackObject(it_pqid->second, &obj_pqid);
  b.set_pqid(obj_pqid);
} else {
  throw proto::SchemaError("Nonoptional field pqid not found when unpacking");
}
auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::Node> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginQueryGet>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginQueryResult>* out) {
            veles::proto::MsgPluginQueryResult::Builder b;
            auto it_pqid = obj->getMap()->find("pqid");
if (it_pqid != obj->getMap()->end() && it_pqid->second->type() != ObjectType::NIL) {
  uint64_t obj_pqid;
  fromMsgpackObject(it_pqid->second, &obj_pqid);
  b.set_pqid(obj_pqid);
} else {
  throw proto::SchemaError("Nonoptional field pqid not found when unpacking");
}
auto it_result = obj->getMap()->find("result");
if (it_result != obj->getMap()->end() && it_result->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_result;
  fromMsgpackObject(it_result->second, &obj_result);
  b.set_result(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_result));
}

auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginQueryResult>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginQueryError>* out) {
            veles::proto::MsgPluginQueryError::Builder b;
            auto it_pqid = obj->getMap()->find("pqid");
if (it_pqid != obj->getMap()->end() && it_pqid->second->type() != ObjectType::NIL) {
  uint64_t obj_pqid;
  fromMsgpackObject(it_pqid->second, &obj_pqid);
  b.set_pqid(obj_pqid);
} else {
  throw proto::SchemaError("Nonoptional field pqid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginQueryError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginBroadcastRegister>* out) {
            veles::proto::MsgPluginBroadcastRegister::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_name = obj->getMap()->find("name");
if (it_name != obj->getMap()->end() && it_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_name;
  fromMsgpackObject(it_name->second, &obj_name);
  b.set_name(obj_name);
} else {
  throw proto::SchemaError("Nonoptional field name not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginBroadcastRegister>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginBroadcastRun>* out) {
            veles::proto::MsgPluginBroadcastRun::Builder b;
            auto it_pbid = obj->getMap()->find("pbid");
if (it_pbid != obj->getMap()->end() && it_pbid->second->type() != ObjectType::NIL) {
  uint64_t obj_pbid;
  fromMsgpackObject(it_pbid->second, &obj_pbid);
  b.set_pbid(obj_pbid);
} else {
  throw proto::SchemaError("Nonoptional field pbid not found when unpacking");
}
auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_params = obj->getMap()->find("params");
if (it_params != obj->getMap()->end() && it_params->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_params;
  fromMsgpackObject(it_params->second, &obj_params);
  b.set_params(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_params));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginBroadcastRun>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginBroadcastResult>* out) {
            veles::proto::MsgPluginBroadcastResult::Builder b;
            auto it_pbid = obj->getMap()->find("pbid");
if (it_pbid != obj->getMap()->end() && it_pbid->second->type() != ObjectType::NIL) {
  uint64_t obj_pbid;
  fromMsgpackObject(it_pbid->second, &obj_pbid);
  b.set_pbid(obj_pbid);
} else {
  throw proto::SchemaError("Nonoptional field pbid not found when unpacking");
}
auto it_results = obj->getMap()->find("results");
if (it_results != obj->getMap()->end() && it_results->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::messages::MsgpackObject>>> obj_results;
  fromMsgpackObject(it_results->second, &obj_results);
  b.set_results(obj_results);
} else {
  throw proto::SchemaError("Nonoptional field results not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginBroadcastResult>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginTriggerRegister>* out) {
            veles::proto::MsgPluginTriggerRegister::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_name = obj->getMap()->find("name");
if (it_name != obj->getMap()->end() && it_name->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_name;
  fromMsgpackObject(it_name->second, &obj_name);
  b.set_name(obj_name);
} else {
  throw proto::SchemaError("Nonoptional field name not found when unpacking");
}
auto it_tags = obj->getMap()->find("tags");
if (it_tags != obj->getMap()->end() && it_tags->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<std::shared_ptr<std::string>>> obj_tags;
  fromMsgpackObject(it_tags->second, &obj_tags);
  b.set_tags(obj_tags);
} else {
  throw proto::SchemaError("Nonoptional field tags not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginTriggerRegister>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginTriggerRun>* out) {
            veles::proto::MsgPluginTriggerRun::Builder b;
            auto it_ptid = obj->getMap()->find("ptid");
if (it_ptid != obj->getMap()->end() && it_ptid->second->type() != ObjectType::NIL) {
  uint64_t obj_ptid;
  fromMsgpackObject(it_ptid->second, &obj_ptid);
  b.set_ptid(obj_ptid);
} else {
  throw proto::SchemaError("Nonoptional field ptid not found when unpacking");
}
auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
auto it_node = obj->getMap()->find("node");
if (it_node != obj->getMap()->end() && it_node->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::Node> obj_node;
  fromMsgpackObject(it_node->second, &obj_node);
  b.set_node(obj_node);
} else {
  throw proto::SchemaError("Nonoptional field node not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginTriggerRun>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginTriggerDone>* out) {
            veles::proto::MsgPluginTriggerDone::Builder b;
            auto it_ptid = obj->getMap()->find("ptid");
if (it_ptid != obj->getMap()->end() && it_ptid->second->type() != ObjectType::NIL) {
  uint64_t obj_ptid;
  fromMsgpackObject(it_ptid->second, &obj_ptid);
  b.set_ptid(obj_ptid);
} else {
  throw proto::SchemaError("Nonoptional field ptid not found when unpacking");
}
auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginTriggerDone>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginTriggerError>* out) {
            veles::proto::MsgPluginTriggerError::Builder b;
            auto it_ptid = obj->getMap()->find("ptid");
if (it_ptid != obj->getMap()->end() && it_ptid->second->type() != ObjectType::NIL) {
  uint64_t obj_ptid;
  fromMsgpackObject(it_ptid->second, &obj_ptid);
  b.set_ptid(obj_ptid);
} else {
  throw proto::SchemaError("Nonoptional field ptid not found when unpacking");
}
auto it_err = obj->getMap()->find("err");
if (it_err != obj->getMap()->end() && it_err->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::proto::VelesException> obj_err;
  fromMsgpackObject(it_err->second, &obj_err);
  b.set_err(obj_err);
} else {
  throw proto::SchemaError("Nonoptional field err not found when unpacking");
}
auto it_checks = obj->getMap()->find("checks");
if (it_checks != obj->getMap()->end() && it_checks->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<std::shared_ptr<veles::proto::Check>>> obj_checks;
  fromMsgpackObject(it_checks->second, &obj_checks);
  b.set_checks(obj_checks);
} else {
  throw proto::SchemaError("Nonoptional field checks not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginTriggerError>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginHandlerUnregister>* out) {
            veles::proto::MsgPluginHandlerUnregister::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginHandlerUnregister>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered>* out) {
            veles::proto::MsgPluginHandlerUnregistered::Builder b;
            auto it_phid = obj->getMap()->find("phid");
if (it_phid != obj->getMap()->end() && it_phid->second->type() != ObjectType::NIL) {
  uint64_t obj_phid;
  fromMsgpackObject(it_phid->second, &obj_phid);
  b.set_phid(obj_phid);
} else {
  throw proto::SchemaError("Nonoptional field phid not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::proto::MsgPluginHandlerUnregistered>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
namespace veles {
namespace proto {
}  // namespace proto
}  // namespace veles
namespace veles {
namespace messages {
}  // namespace messages
}  // namespace veles
namespace veles {
namespace tests {
namespace schema {

                Any::Builder& Any::Builder::set_a(std::shared_ptr<veles::messages::MsgpackObject> a) {
                  this->a = std::shared_ptr<veles::messages::MsgpackObject>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Any::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Any> Any::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Any> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Any> Any::Builder::build() {
  return std::make_shared<veles::tests::schema::Any>(a);
}
                AnyOptional::Builder& AnyOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> AnyOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::AnyOptional> AnyOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::AnyOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::AnyOptional> AnyOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::AnyOptional>(a);
}
                Integer::Builder& Integer::Builder::set_a(int64_t a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Integer::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Integer> Integer::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Integer> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Integer> Integer::Builder::build() {
  return std::make_shared<veles::tests::schema::Integer>(a);
}
                IntegerOptional::Builder& IntegerOptional::Builder::set_a(const std::pair<bool, int64_t>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> IntegerOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::IntegerOptional> IntegerOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::IntegerOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::IntegerOptional> IntegerOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::IntegerOptional>(a);
}
                UnsignedInteger::Builder& UnsignedInteger::Builder::set_a(uint64_t a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> UnsignedInteger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::UnsignedInteger> UnsignedInteger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::UnsignedInteger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::UnsignedInteger> UnsignedInteger::Builder::build() {
  return std::make_shared<veles::tests::schema::UnsignedInteger>(a);
}
                UnsignedIntegerOptional::Builder& UnsignedIntegerOptional::Builder::set_a(const std::pair<bool, uint64_t>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> UnsignedIntegerOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional> UnsignedIntegerOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional> UnsignedIntegerOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::UnsignedIntegerOptional>(a);
}
                SmallInteger::Builder& SmallInteger::Builder::set_a(int64_t a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SmallInteger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SmallInteger> SmallInteger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SmallInteger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SmallInteger> SmallInteger::Builder::build() {
  return std::make_shared<veles::tests::schema::SmallInteger>(a);
}
                SmallIntegerOptional::Builder& SmallIntegerOptional::Builder::set_a(const std::pair<bool, int64_t>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SmallIntegerOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SmallIntegerOptional> SmallIntegerOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SmallIntegerOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SmallIntegerOptional> SmallIntegerOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::SmallIntegerOptional>(a);
}
                SmallUnsignedInteger::Builder& SmallUnsignedInteger::Builder::set_a(uint64_t a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SmallUnsignedInteger::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SmallUnsignedInteger> SmallUnsignedInteger::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SmallUnsignedInteger> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SmallUnsignedInteger> SmallUnsignedInteger::Builder::build() {
  return std::make_shared<veles::tests::schema::SmallUnsignedInteger>(a);
}
                SmallUnsignedIntegerOptional::Builder& SmallUnsignedIntegerOptional::Builder::set_a(const std::pair<bool, uint64_t>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SmallUnsignedIntegerOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional> SmallUnsignedIntegerOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional> SmallUnsignedIntegerOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::SmallUnsignedIntegerOptional>(a);
}
                Boolean::Builder& Boolean::Builder::set_a(bool a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Boolean::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Boolean> Boolean::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Boolean> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Boolean> Boolean::Builder::build() {
  return std::make_shared<veles::tests::schema::Boolean>(a);
}
                BooleanOptional::Builder& BooleanOptional::Builder::set_a(const std::pair<bool, bool>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> BooleanOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::BooleanOptional> BooleanOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::BooleanOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::BooleanOptional> BooleanOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::BooleanOptional>(a);
}
                Float::Builder& Float::Builder::set_a(double a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Float::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Float> Float::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Float> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Float> Float::Builder::build() {
  return std::make_shared<veles::tests::schema::Float>(a);
}
                FloatOptional::Builder& FloatOptional::Builder::set_a(const std::pair<bool, double>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> FloatOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::FloatOptional> FloatOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::FloatOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::FloatOptional> FloatOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::FloatOptional>(a);
}
                String::Builder& String::Builder::set_a(std::shared_ptr<std::string> a) {
                  this->a = std::shared_ptr<std::string>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> String::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::String> String::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::String> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::String> String::Builder::build() {
  return std::make_shared<veles::tests::schema::String>(a);
}
                StringOptional::Builder& StringOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<std::string>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> StringOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::StringOptional> StringOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::StringOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::StringOptional> StringOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::StringOptional>(a);
}
                Binary::Builder& Binary::Builder::set_a(std::shared_ptr<std::vector<uint8_t>> a) {
                  this->a = std::shared_ptr<std::vector<uint8_t>>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Binary::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Binary> Binary::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Binary> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Binary> Binary::Builder::build() {
  return std::make_shared<veles::tests::schema::Binary>(a);
}
                BinaryOptional::Builder& BinaryOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<std::vector<uint8_t>>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> BinaryOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::BinaryOptional> BinaryOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::BinaryOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::BinaryOptional> BinaryOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::BinaryOptional>(a);
}
                NodeIDModel::Builder& NodeIDModel::Builder::set_a(std::shared_ptr<veles::data::NodeID> a) {
                  this->a = std::shared_ptr<veles::data::NodeID>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> NodeIDModel::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::NodeIDModel> NodeIDModel::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::NodeIDModel> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::NodeIDModel> NodeIDModel::Builder::build() {
  return std::make_shared<veles::tests::schema::NodeIDModel>(a);
}
                NodeIDModelOptional::Builder& NodeIDModelOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<veles::data::NodeID>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> NodeIDModelOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::NodeIDModelOptional> NodeIDModelOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::NodeIDModelOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::NodeIDModelOptional> NodeIDModelOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::NodeIDModelOptional>(a);
}
                BinDataModel::Builder& BinDataModel::Builder::set_a(std::shared_ptr<veles::data::BinData> a) {
                  this->a = std::shared_ptr<veles::data::BinData>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> BinDataModel::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::BinDataModel> BinDataModel::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::BinDataModel> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::BinDataModel> BinDataModel::Builder::build() {
  return std::make_shared<veles::tests::schema::BinDataModel>(a);
}
                BinDataModelOptional::Builder& BinDataModelOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<veles::data::BinData>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> BinDataModelOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::BinDataModelOptional> BinDataModelOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::BinDataModelOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::BinDataModelOptional> BinDataModelOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::BinDataModelOptional>(a);
}
                List::Builder& List::Builder::set_a(std::shared_ptr<std::vector<int64_t>> a) {
                  this->a = std::shared_ptr<std::vector<int64_t>>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> List::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::List> List::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::List> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::List> List::Builder::build() {
  return std::make_shared<veles::tests::schema::List>(a);
}
                ListOptional::Builder& ListOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<std::vector<int64_t>>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> ListOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::ListOptional> ListOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::ListOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::ListOptional> ListOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::ListOptional>(a);
}
                Set::Builder& Set::Builder::set_a(std::shared_ptr<std::unordered_set<int64_t>> a) {
                  this->a = std::shared_ptr<std::unordered_set<int64_t>>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Set::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Set> Set::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Set> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Set> Set::Builder::build() {
  return std::make_shared<veles::tests::schema::Set>(a);
}
                SetOptional::Builder& SetOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SetOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SetOptional> SetOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SetOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SetOptional> SetOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::SetOptional>(a);
}
                Map::Builder& Map::Builder::set_a(std::shared_ptr<std::unordered_map<std::string,int64_t>> a) {
                  this->a = std::shared_ptr<std::unordered_map<std::string,int64_t>>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Map::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Map> Map::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Map> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Map> Map::Builder::build() {
  return std::make_shared<veles::tests::schema::Map>(a);
}
                MapOptional::Builder& MapOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> MapOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::MapOptional> MapOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::MapOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::MapOptional> MapOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::MapOptional>(a);
}
                Object::Builder& Object::Builder::set_a(std::shared_ptr<veles::tests::schema::String> a) {
                  this->a = std::shared_ptr<veles::tests::schema::String>(a);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Object::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Object> Object::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Object> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Object> Object::Builder::build() {
  return std::make_shared<veles::tests::schema::Object>(a);
}
                ObjectOptional::Builder& ObjectOptional::Builder::set_a(const std::pair<bool, std::shared_ptr<veles::tests::schema::String>>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> ObjectOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::ObjectOptional> ObjectOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::ObjectOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::ObjectOptional> ObjectOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::ObjectOptional>(a);
}
                Enum::Builder& Enum::Builder::set_a(veles::tests::schema::TestEnum a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> Enum::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    msg["a"] = messages::toMsgpackObject(this->a);

    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::Enum> Enum::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::Enum> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::Enum> Enum::Builder::build() {
  return std::make_shared<veles::tests::schema::Enum>(a);
}
                EnumOptional::Builder& EnumOptional::Builder::set_a(const std::pair<bool, veles::tests::schema::TestEnum>& a) {
                  this->a = a;
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> EnumOptional::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a.first) {
                  msg["a"] = messages::toMsgpackObject(this->a.second);
                } else {
                  msg["a"] = std::make_shared<messages::MsgpackObject>();
                }
                
    
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::EnumOptional> EnumOptional::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::EnumOptional> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::EnumOptional> EnumOptional::Builder::build() {
  return std::make_shared<veles::tests::schema::EnumOptional>(a);
}
std::shared_ptr<BaseModel> BaseModel::polymorphicLoad(const msgpack::object& obj) {
    auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
    std::shared_ptr<BaseModel> out;
    fromMsgpackObject(loc_obj, &out);
    return out;
  }

                SubType1::Builder& SubType1::Builder::set_a(std::shared_ptr<std::string> a) {
                  this->a = std::shared_ptr<std::string>(a);
                  return *this;
                }
            
                SubType1::Builder& SubType1::Builder::set_b(std::shared_ptr<std::string> b) {
                  this->b = std::shared_ptr<std::string>(b);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SubType1::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);
if (this->b == nullptr) {
  throw proto::SchemaError("Nonoptional field b not set when packing");
}
msg["b"] = messages::toMsgpackObject(this->b);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SubType1> SubType1::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SubType1> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SubType1> SubType1::Builder::build() {
  return std::make_shared<veles::tests::schema::SubType1>(a, b);
}
                SubType2::Builder& SubType2::Builder::set_a(std::shared_ptr<std::string> a) {
                  this->a = std::shared_ptr<std::string>(a);
                  return *this;
                }
            
                SubType2::Builder& SubType2::Builder::set_b(std::shared_ptr<std::vector<uint8_t>> b) {
                  this->b = std::shared_ptr<std::vector<uint8_t>>(b);
                  return *this;
                }
            
  std::shared_ptr<messages::MsgpackObject> SubType2::serializeToMsgpackObject() {
    std::map<std::string, std::shared_ptr<messages::MsgpackObject>> msg;
    if (this->a == nullptr) {
  throw proto::SchemaError("Nonoptional field a not set when packing");
}
msg["a"] = messages::toMsgpackObject(this->a);
if (this->b == nullptr) {
  throw proto::SchemaError("Nonoptional field b not set when packing");
}
msg["b"] = messages::toMsgpackObject(this->b);

    msg["object_type"] = messages::toMsgpackObject(this->object_type);
    return std::make_shared<messages::MsgpackObject>(msg);
  }

std::shared_ptr<veles::tests::schema::SubType2> SubType2::loadMessagePack(const msgpack::object& obj) {
  auto loc_obj = std::make_shared<messages::MsgpackObject>(obj);
  std::shared_ptr<veles::tests::schema::SubType2> out;
  fromMsgpackObject(loc_obj, &out);
  return out;
}
std::shared_ptr<veles::tests::schema::SubType2> SubType2::Builder::build() {
  return std::make_shared<veles::tests::schema::SubType2>(a, b);
}}  // namespace schema
}  // namespace tests
}  // namespace veles
namespace veles {
namespace messages {
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj, veles::tests::schema::TestEnum* out) {
  if (*obj->getString() == "OPT1") {
    *out = veles::tests::schema::TestEnum::OPT1;
    return;
  }
  if (*obj->getString() == "OPT2") {
    *out = veles::tests::schema::TestEnum::OPT2;
    return;
  }
  throw proto::SchemaError("Unrecognized enum value");
}
std::shared_ptr<MsgpackObject> toMsgpackObject(veles::tests::schema::TestEnum val) {
  switch (val) {
    case veles::tests::schema::TestEnum::OPT1:
      return std::make_shared<MsgpackObject>("OPT1");
    case veles::tests::schema::TestEnum::OPT2:
      return std::make_shared<MsgpackObject>("OPT2");
    default:
      throw proto::SchemaError("Unrecognized enum value");
  }
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Any>* out) {
            veles::tests::schema::Any::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::messages::MsgpackObject> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Any>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::AnyOptional>* out) {
            veles::tests::schema::AnyOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::messages::MsgpackObject> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<veles::messages::MsgpackObject>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::AnyOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Integer>* out) {
            veles::tests::schema::Integer::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  int64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Integer>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::IntegerOptional>* out) {
            veles::tests::schema::IntegerOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
int64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, int64_t>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::IntegerOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::UnsignedInteger>* out) {
            veles::tests::schema::UnsignedInteger::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  uint64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::UnsignedInteger>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional>* out) {
            veles::tests::schema::UnsignedIntegerOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
uint64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, uint64_t>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::UnsignedIntegerOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SmallInteger>* out) {
            veles::tests::schema::SmallInteger::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  int64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SmallInteger>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SmallIntegerOptional>* out) {
            veles::tests::schema::SmallIntegerOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
int64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, int64_t>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SmallIntegerOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SmallUnsignedInteger>* out) {
            veles::tests::schema::SmallUnsignedInteger::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  uint64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SmallUnsignedInteger>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional>* out) {
            veles::tests::schema::SmallUnsignedIntegerOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
uint64_t obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, uint64_t>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SmallUnsignedIntegerOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Boolean>* out) {
            veles::tests::schema::Boolean::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  bool obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Boolean>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::BooleanOptional>* out) {
            veles::tests::schema::BooleanOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
bool obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, bool>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::BooleanOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Float>* out) {
            veles::tests::schema::Float::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  double obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Float>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::FloatOptional>* out) {
            veles::tests::schema::FloatOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
double obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, double>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::FloatOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::String>* out) {
            veles::tests::schema::String::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::String>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::StringOptional>* out) {
            veles::tests::schema::StringOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<std::string> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<std::string>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::StringOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Binary>* out) {
            veles::tests::schema::Binary::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Binary>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::BinaryOptional>* out) {
            veles::tests::schema::BinaryOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<std::vector<uint8_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<std::vector<uint8_t>>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::BinaryOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::NodeIDModel>* out) {
            veles::tests::schema::NodeIDModel::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::NodeID> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::NodeIDModel>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::NodeIDModelOptional>* out) {
            veles::tests::schema::NodeIDModelOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::data::NodeID> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<veles::data::NodeID>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::NodeIDModelOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::BinDataModel>* out) {
            veles::tests::schema::BinDataModel::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::data::BinData> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::BinDataModel>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::BinDataModelOptional>* out) {
            veles::tests::schema::BinDataModelOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::data::BinData> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<veles::data::BinData>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::BinDataModelOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::List>* out) {
            veles::tests::schema::List::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::List>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::ListOptional>* out) {
            veles::tests::schema::ListOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<std::vector<int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<std::vector<int64_t>>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::ListOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Set>* out) {
            veles::tests::schema::Set::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_set<int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Set>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SetOptional>* out) {
            veles::tests::schema::SetOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<std::unordered_set<int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<std::unordered_set<int64_t>>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SetOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Map>* out) {
            veles::tests::schema::Map::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::unordered_map<std::string,int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Map>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::MapOptional>* out) {
            veles::tests::schema::MapOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<std::unordered_map<std::string,int64_t>> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<std::unordered_map<std::string,int64_t>>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::MapOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Object>* out) {
            veles::tests::schema::Object::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<veles::tests::schema::String> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Object>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::ObjectOptional>* out) {
            veles::tests::schema::ObjectOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
std::shared_ptr<veles::tests::schema::String> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, std::shared_ptr<veles::tests::schema::String>>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::ObjectOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::Enum>* out) {
            veles::tests::schema::Enum::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  veles::tests::schema::TestEnum obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::Enum>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::EnumOptional>* out) {
            veles::tests::schema::EnumOptional::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
veles::tests::schema::TestEnum obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(std::pair<bool, veles::tests::schema::TestEnum>(true, obj_a));
}

            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::EnumOptional>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::BaseModel>* out) {
  auto& types = veles::tests::schema::BaseModel::objectTypes();
  if (types.size() == 0) {
    veles::tests::schema::BaseModel::initObjectTypes();
  }
  auto obj_type = *(*obj->getMap())["object_type"]->getString();
  if (types.find(obj_type) ==  types.end()) {
    throw proto::SchemaError("Unknown object_type: " + obj_type);
  }
  *out = types[obj_type](obj);
}

std::shared_ptr<MsgpackObject> toMsgpackObject(
    const std::shared_ptr<veles::tests::schema::BaseModel>& val) {
  return val->serializeToMsgpackObject();
}

void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SubType1>* out) {
            veles::tests::schema::SubType1::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
auto it_b = obj->getMap()->find("b");
if (it_b != obj->getMap()->end() && it_b->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_b;
  fromMsgpackObject(it_b->second, &obj_b);
  b.set_b(obj_b);
} else {
  throw proto::SchemaError("Nonoptional field b not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SubType1>& val) {
            return val->serializeToMsgpackObject();
          }
        
void fromMsgpackObject(const std::shared_ptr<MsgpackObject>& obj,    std::shared_ptr<veles::tests::schema::SubType2>* out) {
            veles::tests::schema::SubType2::Builder b;
            auto it_a = obj->getMap()->find("a");
if (it_a != obj->getMap()->end() && it_a->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::string> obj_a;
  fromMsgpackObject(it_a->second, &obj_a);
  b.set_a(obj_a);
} else {
  throw proto::SchemaError("Nonoptional field a not found when unpacking");
}
auto it_b = obj->getMap()->find("b");
if (it_b != obj->getMap()->end() && it_b->second->type() != ObjectType::NIL) {
  std::shared_ptr<std::vector<uint8_t>> obj_b;
  fromMsgpackObject(it_b->second, &obj_b);
  b.set_b(obj_b);
} else {
  throw proto::SchemaError("Nonoptional field b not found when unpacking");
}
            *out = b.build();
          }
        std::shared_ptr<MsgpackObject> toMsgpackObject(const std::shared_ptr<veles::tests::schema::SubType2>& val) {
            return val->serializeToMsgpackObject();
          }
        }  // namespace messages
}  // namespace veles
