/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dashboard;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.NewScanAlertEvent;
import com.subgraph.vega.api.model.alerts.ScanPauseStateChangedEvent;
import com.subgraph.vega.api.model.alerts.ScanStatusChangeEvent;
import com.subgraph.vega.ui.scanner.dashboard.AlertPane;
import com.subgraph.vega.ui.scanner.dashboard.CrawlerPane;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class DashboardPane
extends Composite
implements IEventHandler {
    private static final RGB GREY_TEXT_COLOR = new RGB(200, 200, 200);
    private static final String VEGA_LOGO = "icons/vega_small.png";
    private static final int UPDATE_INTERVAL = 100;
    private final Display display;
    private final Timer renderTimer = new Timer();
    private TimerTask renderTask;
    private CrawlerPane crawlerPane;
    private AlertPane alertPane;
    private IScanInstance scanInstance;
    private volatile boolean outputRenderNeeded;
    private volatile boolean crawlerRenderNeeded;
    private volatile boolean disableRenderTaskStart;
    private volatile boolean isProgressPaneVisible;
    private FormToolkit toolkit;
    private ScrolledForm scrolledForm;
    private ScrolledFormText scrolledFormText;
    private int lastStatus;
    private int lastCompletedCount;
    private int lastTotalCount;
    private String lastCurrentPath;
    private boolean isProxyInstance;
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");

    public DashboardPane(Composite composite) {
        super(composite, 0);
        this.display = composite.getDisplay();
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.display);
        this.toolkit.getColors().createColor("grey", GREY_TEXT_COLOR);
        this.createDashboardForm();
        this.renderOutput();
        this.createDisposeListener();
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DashboardPane.this.imageCache.dispose();
            }
        });
    }

    public void displayScanInstance(IScanInstance iScanInstance) {
        if (this.scanInstance == iScanInstance) {
            return;
        }
        this.cancelRenderTask();
        this.disableRenderTaskStart = true;
        if (this.scanInstance != null) {
            this.scanInstance.removeScanEventListener((IEventHandler)this);
        }
        this.scanInstance = iScanInstance;
        this.alertPane.reset();
        boolean bl = iScanInstance == null ? false : (this.isProxyInstance = iScanInstance.getScanId() == -1L);
        if (iScanInstance != null) {
            this.scanInstance.addScanEventListenerAndPopulate((IEventHandler)this);
            this.lastStatus = 0;
            this.lastCompletedCount = 0;
            this.lastTotalCount = 0;
            this.maybeUpdateCrawler(iScanInstance.getScanStatus(), iScanInstance.getScanCurrentPath(), iScanInstance.getScanCompletedCount(), iScanInstance.getScanTotalCount());
            this.maybeUpdateStatus(iScanInstance.getScanStatus());
        }
        boolean bl2 = !this.isProxyInstance && iScanInstance != null && iScanInstance.getScanStatus() == 3;
        this.setProgressPaneVisible(bl2);
        this.renderOutput();
        this.disableRenderTaskStart = false;
    }

    public IScanInstance getScanInstance() {
        return this.scanInstance;
    }

    public void reset() {
        this.alertPane.reset();
        if (this.scanInstance == null) {
            return;
        }
        for (IScanAlert iScanAlert : this.scanInstance.getAllAlerts()) {
            this.alertPane.addAlert(iScanAlert);
        }
    }

    private void setProgressPaneVisible(final boolean bl) {
        if (this.isProgressPaneVisible == bl) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DashboardPane.this.crawlerPane.setVisible(bl);
                DashboardPane.this.isProgressPaneVisible = bl;
                DashboardPane.this.layout();
                DashboardPane.this.crawlerPane.redraw();
            }
        });
    }

    private void createDashboardForm() {
        if (this.scrolledForm != null) {
            this.scrolledForm.dispose();
        }
        this.scrolledForm = DashboardPane.createForm(this, this.toolkit);
        this.scrolledFormText = DashboardPane.createFormText(this.scrolledForm.getBody(), this.toolkit);
        FormText formText = this.scrolledFormText.getFormText();
        formText.setColor("grey", this.toolkit.getColors().getColor("grey"));
        formText.setFont("big", JFaceResources.getBannerFont());
        formText.setFont("header", JFaceResources.getHeaderFont());
        formText.setImage("logo", this.imageCache.get(VEGA_LOGO));
        this.crawlerPane = new CrawlerPane((Composite)formText);
        this.crawlerPane.setData("FormWidgetFactory.drawBorder", "textBorder");
        this.toolkit.adapt((Composite)this.crawlerPane);
        formText.setControl("crawler", (Control)this.crawlerPane);
        this.alertPane = new AlertPane((Composite)formText);
        this.alertPane.setData("FormWidgetFactory.drawBorder", "textBorder");
        this.toolkit.adapt((Composite)this.alertPane);
        formText.setControl("alerts", (Control)this.alertPane);
        this.toolkit.paintBordersFor((Composite)formText);
        this.toolkit.decorateFormHeading(this.scrolledForm.getForm());
        this.layout();
    }

    private static ScrolledForm createForm(Composite composite, FormToolkit formToolkit) {
        ScrolledForm scrolledForm = formToolkit.createScrolledForm(composite);
        scrolledForm.getBody().setLayout((Layout)new FillLayout());
        return scrolledForm;
    }

    private static ScrolledFormText createFormText(Composite composite, FormToolkit formToolkit) {
        ScrolledFormText scrolledFormText = new ScrolledFormText(composite, 524864, false);
        FormText formText = formToolkit.createFormText((Composite)scrolledFormText, false);
        scrolledFormText.setFormText(formText);
        formText.marginWidth = 1;
        formText.marginHeight = 0;
        formText.setHyperlinkSettings((HyperlinkSettings)formToolkit.getHyperlinkGroup());
        formText.setMenu(composite.getMenu());
        formText.setWhitespaceNormalized(false);
        formToolkit.adapt((Composite)scrolledFormText);
        return scrolledFormText;
    }

    private void renderOutput() {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form>");
        this.addHeader(stringBuilder);
        this.renderCrawlerSection(stringBuilder);
        this.renderAlertSummary(stringBuilder);
        this.addVSpaces(stringBuilder, 2);
        stringBuilder.append("</form>");
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!DashboardPane.this.scrolledFormText.isDisposed()) {
                        DashboardPane.this.scrolledFormText.setText(stringBuilder.toString());
                    }
                    DashboardPane.this.outputRenderNeeded = false;
                }
            });
        }
    }

    private void renderCrawlerOutput() {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!DashboardPane.this.crawlerPane.isDisposed()) {
                        DashboardPane.this.crawlerPane.renderChanges();
                    }
                    DashboardPane.this.crawlerRenderNeeded = false;
                }
            });
        }
    }

    private void renderCrawlerSection(StringBuilder stringBuilder) {
        if (this.isProxyInstance) {
            return;
        }
        if (this.scanInstance == null || this.scanInstance.getScanStatus() != 3) {
            if (this.isProgressPaneVisible) {
                this.setProgressPaneVisible(false);
            }
            return;
        }
        if (!this.isProgressPaneVisible) {
            this.setProgressPaneVisible(true);
        }
        if (this.scanInstance.isScanPaused()) {
            this.crawlerPane.setScannerPaused(true);
            this.addIndented(stringBuilder, 10, "<span font='header'>Scanner Progress (Scanner Paused)</span>");
        } else {
            this.crawlerPane.setScannerPaused(false);
            this.addIndented(stringBuilder, 10, "<span font='header'>Scanner Progress</span>");
        }
        this.addVSpaces(stringBuilder, 2);
        this.crawlerPane.renderChanges();
        this.addIndented(stringBuilder, 20, "<control width='500' height='100' href='crawler'/>");
    }

    private void renderAlertSummary(StringBuilder stringBuilder) {
        this.addVSpaces(stringBuilder, 2);
        String string = this.isProxyInstance ? "Proxy Alert Summary" : "Scan Alert Summary";
        this.addIndented(stringBuilder, 10, "<span font='header'>" + string + "</span>");
        this.addVSpaces(stringBuilder, 2);
        this.addIndented(stringBuilder, 20, "<control width='500' href='alerts'/>");
        this.addVSpaces(stringBuilder, 2);
    }

    private void addIndented(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append("<p>");
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(" ");
            ++n2;
        }
        stringBuilder.append(string);
        stringBuilder.append("</p>");
    }

    private void addHeader(StringBuilder stringBuilder) {
        this.addVSpaces(stringBuilder, 2);
        this.addIndented(stringBuilder, 10, "<img href='logo'/>");
        this.addVSpaces(stringBuilder, 2);
    }

    private void addVSpaces(StringBuilder stringBuilder, int n) {
        stringBuilder.append("<p>");
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("\n");
            ++n2;
        }
        stringBuilder.append("</p>");
    }

    private void processAlert(IScanAlert iScanAlert) {
        this.alertPane.addAlert(iScanAlert);
        this.outputRenderNeeded = true;
    }

    private void handleScannerStatusChanged(ScanStatusChangeEvent scanStatusChangeEvent) {
        this.maybeUpdateCrawler(scanStatusChangeEvent.getStatus(), scanStatusChangeEvent.getCurrentPath(), scanStatusChangeEvent.getCompletedCount(), scanStatusChangeEvent.getTotalCount());
        this.maybeUpdateStatus(scanStatusChangeEvent.getStatus());
    }

    private void maybeUpdateCrawler(int n, String string, int n2, int n3) {
        if (string != this.lastCurrentPath || n2 != this.lastCompletedCount || n3 != this.lastTotalCount || n != this.lastStatus) {
            this.lastCurrentPath = string;
            this.lastCompletedCount = n2;
            this.lastTotalCount = n3;
            this.crawlerPane.updateCrawlerProgress(n, string, n3, n2);
            this.crawlerRenderNeeded = true;
        }
    }

    private void maybeUpdateStatus(int n) {
        if (n == this.lastStatus) {
            return;
        }
        this.lastStatus = n;
        this.outputRenderNeeded = true;
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (DashboardPane.this.outputRenderNeeded) {
                    DashboardPane.this.renderOutput();
                }
                if (DashboardPane.this.crawlerRenderNeeded) {
                    DashboardPane.this.renderCrawlerOutput();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRenderTask() {
        Timer timer = this.renderTimer;
        synchronized (timer) {
            if (this.renderTask != null) {
                this.renderTask.cancel();
                this.renderTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRenderTask() {
        Timer timer = this.renderTimer;
        synchronized (timer) {
            if (this.renderTask == null) {
                this.renderTask = this.createTimerTask();
                this.renderTimer.scheduleAtFixedRate(this.renderTask, 0L, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(IEvent iEvent) {
        Timer timer = this.renderTimer;
        synchronized (timer) {
            if (!this.disableRenderTaskStart && this.renderTask == null) {
                this.startRenderTask();
            }
        }
        if (iEvent instanceof ScanStatusChangeEvent) {
            this.handleScannerStatusChanged((ScanStatusChangeEvent)iEvent);
        } else if (iEvent instanceof NewScanAlertEvent) {
            this.processAlert(((NewScanAlertEvent)iEvent).getAlert());
        }
        if (iEvent instanceof ScanPauseStateChangedEvent) {
            this.outputRenderNeeded = true;
        }
    }
}

