/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.NewScanAlertEvent;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.ui.scanner.Activator;
import com.subgraph.vega.ui.scanner.alerts.AlertTreeContentProvider;
import com.subgraph.vega.ui.scanner.alerts.AlertTreeLabelProvider;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.PerspectiveTracker;
import com.subgraph.vega.ui.scanner.alerts.ScanAlertSorter;
import com.subgraph.vega.ui.scanner.alerts.ScopeTracker;
import com.subgraph.vega.ui.scanner.alerts.SelectionTracker;
import com.subgraph.vega.ui.scanner.alerts.WorkspaceTracker;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertHostNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertSeverityNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTitleNode;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class ScanAlertView
extends ViewPart
implements IDoubleClickListener,
IEventHandler {
    public static final String ID = "com.subgraph.vega.views.alert";
    private static final String ALERT_VIEW_ICON = "icons/alert_view.png";
    private final Logger logger = Logger.getLogger("scan-alert-view");
    private final Timer blinkTimer = new Timer();
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
    private IWorkspace currentWorkspace;
    private ScopeTracker scopeTracker;
    private IPartListener2 partListener;
    private TreeViewer viewer;
    private TimerTask blinkTask;
    private boolean isViewVisible;
    private boolean ignoreEvents;

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite);
        AlertTreeContentProvider alertTreeContentProvider = new AlertTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)alertTreeContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AlertTreeLabelProvider(alertTreeContentProvider));
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.viewer.setSorter((ViewerSorter)new ScanAlertSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionTracker(this.getSite().getPage()));
        this.createContextMenu(this.viewer);
        IModel iModel = Activator.getDefault().getModel();
        if (iModel == null) {
            this.logger.warning("Failed to obtain reference to model");
            return;
        }
        this.scopeTracker = new ScopeTracker((StructuredViewer)this.viewer);
        WorkspaceTracker.create(iModel, this, this.scopeTracker);
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveTracker(this.getSite().getPage(), (StructuredViewer)this.viewer));
        this.partListener = this.createPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
    }

    private IPartListener2 createPartListener() {
        return new IPartListener2(){

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                if (ScanAlertView.ID.equals(iWorkbenchPartReference.getId())) {
                    ScanAlertView.this.isViewVisible = true;
                    ScanAlertView.this.stopNotifier();
                }
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                if (ScanAlertView.ID.equals(iWorkbenchPartReference.getId())) {
                    ScanAlertView.this.isViewVisible = false;
                }
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        this.imageCache.dispose();
        super.dispose();
    }

    public void expandAll() {
        if (this.viewer != null) {
            this.viewer.expandAll();
        }
    }

    public void collapseAll() {
        if (this.viewer != null) {
            this.viewer.collapseAll();
        }
    }

    private void selectFirstScan() {
        if (this.viewer.getTree().getItemCount() > 0) {
            TreeItem treeItem = this.viewer.getTree().getItem(0);
            this.viewer.setSelection((ISelection)new StructuredSelection(treeItem.getData()));
        }
    }

    public void workspaceChanged(IWorkspace iWorkspace) {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.getScanAlertRepository().getProxyScanInstance().removeScanEventListener((IEventHandler)this);
        }
        this.currentWorkspace = iWorkspace;
        this.viewer.setInput((Object)iWorkspace);
        if (iWorkspace != null) {
            this.selectFirstScan();
            this.ignoreEvents = true;
            iWorkspace.getScanAlertRepository().getProxyScanInstance().addScanEventListenerAndPopulate((IEventHandler)this);
            this.ignoreEvents = false;
        }
    }

    public void startNotifier() {
        if (this.blinkTask == null) {
            this.blinkTask = this.createBlinkTask();
            this.blinkTimer.scheduleAtFixedRate(this.blinkTask, 0L, 500L);
        }
    }

    public void stopNotifier() {
        if (this.blinkTask != null) {
            this.blinkTask.cancel();
            this.setLabelImage(this.imageCache.get(ALERT_VIEW_ICON));
            this.blinkTask = null;
        }
    }

    private TimerTask createBlinkTask() {
        return new TimerTask(){
            private boolean state;

            @Override
            public void run() {
                boolean bl = this.state = !this.state;
                if (this.state) {
                    ScanAlertView.this.setLabelImage(ScanAlertView.this.imageCache.getDisabled(ScanAlertView.ALERT_VIEW_ICON));
                } else {
                    ScanAlertView.this.setLabelImage(ScanAlertView.this.imageCache.get(ScanAlertView.ALERT_VIEW_ICON));
                }
            }
        };
    }

    private void setLabelImage(final Image image) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScanAlertView.this.setTitleImage(image);
            }
        });
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
        this.stopNotifier();
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.viewer.isExpandable(object)) {
            this.viewer.setExpandedState(object, !this.viewer.getExpandedState(object));
        }
    }

    public IScan getSelection() {
        IScanInstance iScanInstance = this.getScanInstanceForSelection((IStructuredSelection)this.viewer.getSelection());
        if (iScanInstance == null) {
            return null;
        }
        return iScanInstance.getScan();
    }

    private IScanInstance getScanInstanceForSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IScanAlert) {
            return ((IScanAlert)object).getScanInstance();
        }
        if (object instanceof IAlertTreeNode) {
            return ((IAlertTreeNode)object).getScanInstance();
        }
        return null;
    }

    public void setTitleImage(Image image) {
        if (image != null && !image.isDisposed()) {
            super.setTitleImage(image);
        }
    }

    public void setFilterByScope(boolean bl) {
        this.scopeTracker.setFilterByScopeEnabled(bl);
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof NewScanAlertEvent && !this.isViewVisible && !this.ignoreEvents) {
            this.startNotifier();
        }
    }

    private void createContextMenu(TreeViewer treeViewer) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ScanAlertView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection == null) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IScanAlert) {
            this.createContextMenuForScanAlert(iMenuManager, (IScanAlert)object);
        } else if (object instanceof AlertScanNode) {
            this.createContextMenuForScanNode(iMenuManager, (AlertScanNode)object);
        } else if (object instanceof IAlertTreeNode) {
            this.createContextMenuForAlertTreeNode(iMenuManager, (IAlertTreeNode)object);
        }
    }

    private void createContextMenuForScanAlert(IMenuManager iMenuManager, final IScanAlert iScanAlert) {
        Action action = new Action(){

            public void run() {
                iScanAlert.getScanInstance().removeAlert(iScanAlert);
            }
        };
        action.setText("Remove alert");
        iMenuManager.add((IAction)action);
    }

    private void createContextMenuForScanNode(IMenuManager iMenuManager, final AlertScanNode alertScanNode) {
        if (alertScanNode.getScanId() == -1L || alertScanNode.getScanInstance().isActive()) {
            return;
        }
        Action action = new Action(){

            public void run() {
                ScanAlertView.this.currentWorkspace.getScanAlertRepository().removeScanInstance(alertScanNode.getScanInstance());
            }
        };
        action.setText("Remove Scan");
        iMenuManager.add((IAction)action);
    }

    private void createContextMenuForAlertTreeNode(IMenuManager iMenuManager, final IAlertTreeNode iAlertTreeNode) {
        final Collection<IScanAlert> collection = iAlertTreeNode.getAlerts();
        Action action = new Action(){

            public void run() {
                iAlertTreeNode.getScanInstance().removeAlerts(collection);
            }
        };
        action.setText(String.valueOf(this.getAlertTreeNodeString(iAlertTreeNode)) + this.getAlertCountString(collection.size()));
        iMenuManager.add((IAction)action);
    }

    private String getAlertCountString(int n) {
        if (n == 1) {
            return "1 alert";
        }
        return String.valueOf(Integer.toString(n)) + " alerts";
    }

    private String getAlertTreeNodeString(IAlertTreeNode iAlertTreeNode) {
        if (iAlertTreeNode instanceof AlertTitleNode) {
            return "Remove ";
        }
        if (iAlertTreeNode instanceof AlertSeverityNode) {
            return "Remove severity node with ";
        }
        if (iAlertTreeNode instanceof AlertHostNode) {
            return "Remove host node with ";
        }
        return "Remove ";
    }
}

