/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.request.view;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class WebEntitySelectionListener
implements ISelectionListener {
    private final IModel model;
    private final String instanceId;

    public WebEntitySelectionListener(IModel iModel, String string) {
        this.model = iModel;
        this.instanceId = string;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object[] objectArray = iStructuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IWebEntity) {
                this.handleWebEntitySelected((IWebEntity)object);
            }
            ++n2;
        }
    }

    private String getConditionSetId() {
        if (this.instanceId == null) {
            return "filter";
        }
        return "filter." + this.instanceId;
    }

    private void handleWebEntitySelected(IWebEntity iWebEntity) {
        IHttpConditionSet iHttpConditionSet = this.getConditionSet();
        if (iHttpConditionSet == null) {
            return;
        }
        iHttpConditionSet.clearTemporaryConditions(false);
        if (iWebEntity instanceof IWebHost) {
            this.handleWebHostSelected(iHttpConditionSet, (IWebHost)iWebEntity);
        } else if (iWebEntity instanceof IWebPath) {
            this.handleWebPathSelected(iHttpConditionSet, (IWebPath)iWebEntity);
        } else if (iWebEntity instanceof IWebResponse) {
            this.handleWebResponseSelected(iHttpConditionSet, (IWebResponse)iWebEntity);
        }
        iHttpConditionSet.notifyChanged();
    }

    private void handleWebHostSelected(IHttpConditionSet iHttpConditionSet, IWebHost iWebHost) {
        this.addHostnameCondition(iHttpConditionSet, iWebHost.getHostname());
    }

    private void handleWebPathSelected(IHttpConditionSet iHttpConditionSet, IWebPath iWebPath) {
        this.addHostnameCondition(iHttpConditionSet, iWebPath.getMountPoint().getWebHost().getHostname());
        this.addPathCondition(iHttpConditionSet, iWebPath.getFullPath());
    }

    private void handleWebResponseSelected(IHttpConditionSet iHttpConditionSet, IWebResponse iWebResponse) {
        this.handleWebPathSelected(iHttpConditionSet, iWebResponse.getPathEntity());
    }

    private void addHostnameCondition(IHttpConditionSet iHttpConditionSet, String string) {
        IHttpConditionType iHttpConditionType = iHttpConditionSet.getConditionManager().getConditionTypeByName("hostname");
        IHttpConditionMatchAction iHttpConditionMatchAction = iHttpConditionType.getMatchActionByName("contains");
        iHttpConditionMatchAction.setArgumentFromString(string);
        IHttpCondition iHttpCondition = iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
        iHttpConditionSet.appendTemporaryCondition(iHttpCondition, false);
    }

    private void addPathCondition(IHttpConditionSet iHttpConditionSet, String string) {
        IHttpConditionType iHttpConditionType = iHttpConditionSet.getConditionManager().getConditionTypeByName("request path");
        IHttpConditionMatchAction iHttpConditionMatchAction = iHttpConditionType.getMatchActionByName("starts with");
        iHttpConditionMatchAction.setArgumentFromString(string);
        IHttpCondition iHttpCondition = iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
        iHttpConditionSet.appendTemporaryCondition(iHttpCondition, false);
    }

    private IHttpConditionSet getConditionSet() {
        IHttpConditionManager iHttpConditionManager = this.getConditionManager();
        if (iHttpConditionManager == null) {
            return null;
        }
        String string = this.getConditionSetId();
        return iHttpConditionManager.getConditionSet(string);
    }

    private IHttpConditionManager getConditionManager() {
        IWorkspace iWorkspace = this.model.getCurrentWorkspace();
        if (iWorkspace == null) {
            return null;
        }
        return iWorkspace.getHttpConditionMananger();
    }
}

