/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.intercept.config;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.proxy.HttpInterceptorLevel;
import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.conditions.ConditionSetChanged;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.conditions.ConditionInput;
import com.subgraph.vega.ui.http.intercept.config.BreakpointEnabledEditingSupport;
import com.subgraph.vega.ui.http.intercept.config.BreakpointMatchTypeEditingSupport;
import com.subgraph.vega.ui.http.intercept.config.BreakpointPatternEditingSupport;
import com.subgraph.vega.ui.http.intercept.config.BreakpointTypeEditingSupport;
import com.subgraph.vega.ui.util.dialogs.IConfigDialogContent;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ConfigureInterceptionContent
implements IConfigDialogContent {
    private static final Image IMAGE_CHECKED = Activator.getImageDescriptor("icons/checked.png").createImage();
    private static final Image IMAGE_UNCHECKED = Activator.getImageDescriptor("icons/unchecked.png").createImage();
    private final IModel model;
    private final IProxyTransaction.TransactionDirection direction;
    private final IEventHandler conditionSetEventHandler;
    private ComboViewer comboViewerInterceptorLevel;
    private TableViewer tableViewerBreakpoints;
    private ConditionInput conditionInput;
    private IHttpInterceptor interceptor;
    private IHttpConditionSet conditionSet;
    private Composite composite;

    public ConfigureInterceptionContent(IModel iModel, IProxyTransaction.TransactionDirection transactionDirection) {
        this.model = iModel;
        IWorkspace iWorkspace = iModel.getCurrentWorkspace();
        IHttpConditionManager iHttpConditionManager = iWorkspace == null ? null : iWorkspace.getHttpConditionMananger();
        this.conditionInput = new ConditionInput(iHttpConditionManager);
        this.direction = transactionDirection;
        this.conditionSetEventHandler = this.createConditionSetEventHandler();
        this.conditionSet = iModel.addConditionSetTracker(this.getConditionSetName(), this.conditionSetEventHandler);
    }

    private IEventHandler createConditionSetEventHandler() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ConditionSetChanged) {
                    ConfigureInterceptionContent.this.onConditionSetChanged((ConditionSetChanged)iEvent);
                }
            }
        };
    }

    public Composite createContents(Composite composite) {
        this.composite = new Composite(composite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, true));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInterceptorOptions(this.composite).setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.createBreakpointsEditor(this.composite).setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.interceptor = Activator.getDefault().getProxyService().getInterceptor();
        this.comboViewerInterceptorLevel.setSelection((ISelection)new StructuredSelection((Object)this.interceptor.getInterceptLevel(this.direction)));
        this.setConditionSetInput();
        return this.composite;
    }

    public String getTitle() {
        return "Interceptor Options";
    }

    public String getMessage() {
        return "Set up breakpoint for interceptor";
    }

    public Control getFocusControl() {
        return this.composite;
    }

    public void onClose() {
        this.model.removeConditionSetTracker(this.getConditionSetName(), this.conditionSetEventHandler);
    }

    public void onOk() {
    }

    private String getConditionSetName() {
        switch (this.direction) {
            case DIRECTION_REQUEST: {
                return "breakpoints-request";
            }
            case DIRECTION_RESPONSE: {
                return "breakpoints-response";
            }
        }
        return null;
    }

    private void setConditionSetInput() {
        if (this.tableViewerBreakpoints == null || this.tableViewerBreakpoints.getContentProvider() == null) {
            return;
        }
        if (this.conditionSet == null) {
            this.tableViewerBreakpoints.setInput(null);
        } else {
            this.tableViewerBreakpoints.setInput((Object)this.conditionSet.getAllConditions());
        }
    }

    private void onConditionSetChanged(ConditionSetChanged conditionSetChanged) {
        this.conditionSet = conditionSetChanged.getConditionSet();
        this.setConditionSetInput();
    }

    protected Control createDialogArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createInterceptorOptions(composite).setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.createBreakpointsEditor(composite).setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.interceptor = Activator.getDefault().getProxyService().getInterceptor();
        this.comboViewerInterceptorLevel.setSelection((ISelection)new StructuredSelection((Object)this.interceptor.getInterceptLevel(this.direction)));
        this.setConditionSetInput();
        return composite;
    }

    void dispose() {
        this.model.removeConditionSetTracker(this.getConditionSetName(), this.conditionSetEventHandler);
    }

    public IProxyTransaction.TransactionDirection getDirection() {
        return this.direction;
    }

    private Composite createInterceptorOptions(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Interceptor Options");
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Intercept for:");
        this.comboViewerInterceptorLevel = new ComboViewer((Composite)group, 8);
        this.comboViewerInterceptorLevel.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewerInterceptorLevel.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((HttpInterceptorLevel)object).getName();
            }
        });
        this.comboViewerInterceptorLevel.setInput((Object)HttpInterceptorLevel.values());
        this.comboViewerInterceptorLevel.addSelectionChangedListener(this.createSelectionChangedListenerComboViewerInterceptorLevel());
        return group;
    }

    private ISelectionChangedListener createSelectionChangedListenerComboViewerInterceptorLevel() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                HttpInterceptorLevel httpInterceptorLevel = (HttpInterceptorLevel)((IStructuredSelection)ConfigureInterceptionContent.this.comboViewerInterceptorLevel.getSelection()).getFirstElement();
                if (httpInterceptorLevel != null) {
                    ConfigureInterceptionContent.this.interceptor.setInterceptLevel(ConfigureInterceptionContent.this.direction, httpInterceptorLevel);
                }
            }
        };
    }

    private Composite createBreakpointsEditor(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Breakpoints");
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        Composite composite2 = this.createTableBreakpoints((Composite)group, gridData, 7);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = this.createTableBreakpointsButtons((Composite)group);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Composite composite4 = this.createCreatorBreakpoints((Composite)group);
        composite4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite5 = this.createCreatorBreakpointsButtons((Composite)group);
        composite5.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        return group;
    }

    private Composite createTableBreakpoints(Composite composite, GridData gridData, int n) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.tableViewerBreakpoints = new TableViewer(composite2, 68354);
        this.createTableBreakpointsColumns(this.tableViewerBreakpoints, tableColumnLayout);
        this.tableViewerBreakpoints.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = this.tableViewerBreakpoints.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData.heightHint = table.getItemHeight() * n;
        return composite2;
    }

    private void createTableBreakpointsColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"", "Type", "Matches", "Pattern"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(16, false, true), new ColumnPixelData(150, true, true), new ColumnPixelData(150, true, true), new ColumnWeightData(100, 100, true)};
        EditingSupport[] editingSupportArray = new EditingSupport[]{new BreakpointEnabledEditingSupport(tableViewer), new BreakpointTypeEditingSupport(tableViewer), new BreakpointMatchTypeEditingSupport(tableViewer), new BreakpointPatternEditingSupport(tableViewer)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return null;
            }

            public Image getImage(Object object) {
                if (((IHttpCondition)object).isEnabled()) {
                    return IMAGE_CHECKED;
                }
                return IMAGE_UNCHECKED;
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpCondition)object).getType().getName();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                IHttpCondition iHttpCondition = (IHttpCondition)object;
                return iHttpCondition.getMatchAction().getLabel();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                IHttpCondition iHttpCondition = (IHttpCondition)object;
                return iHttpCondition.getMatchAction().getArgumentAsString();
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setEditingSupport(editingSupportArray[n]);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
    }

    private Composite createTableBreakpointsButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(composite2, 8);
        button.setText("remove");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener(this.createSelectionListenerButtonRemove());
        return composite2;
    }

    private SelectionListener createSelectionListenerButtonRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ConfigureInterceptionContent.this.tableViewerBreakpoints.getSelection();
                for (Object e : iStructuredSelection.toList()) {
                    if (!(e instanceof IHttpCondition) || ConfigureInterceptionContent.this.conditionSet == null) continue;
                    ConfigureInterceptionContent.this.conditionSet.removeCondition((IHttpCondition)e, true);
                }
                ConfigureInterceptionContent.this.tableViewerBreakpoints.refresh(true);
            }
        };
    }

    private Composite createCreatorBreakpoints(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.conditionInput.createConditionTypeCombo(composite2);
        this.conditionInput.createConditionMatchCombo(composite2);
        this.conditionInput.createInputPanel(composite2);
        return composite2;
    }

    private Composite createCreatorBreakpointsButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(composite2, 8);
        button.setText("create");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener(this.createSelectionListenerButtonCreateBreakpoint());
        return composite2;
    }

    private SelectionListener createSelectionListenerButtonCreateBreakpoint() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IHttpCondition iHttpCondition = ConfigureInterceptionContent.this.conditionInput.createConditionFromData();
                if (iHttpCondition == null) {
                    return;
                }
                if (ConfigureInterceptionContent.this.conditionSet != null) {
                    ConfigureInterceptionContent.this.conditionSet.appendCondition(iHttpCondition, true);
                }
                ConfigureInterceptionContent.this.conditionInput.reset();
                ConfigureInterceptionContent.this.tableViewerBreakpoints.refresh(true);
            }
        };
    }
}

