/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.conditions;

import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionIntegerMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionRangeMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionStringMatchAction;
import com.subgraph.vega.ui.http.conditions.ConditionTypeComboViewer;
import com.subgraph.vega.ui.http.conditions.MatchActionArgumentPanel;
import com.subgraph.vega.ui.http.conditions.MatchActionComboViewer;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Composite;

public class ConditionInput {
    private final IHttpConditionManager conditionManager;
    private ConditionTypeComboViewer conditionTypeViewer;
    private MatchActionComboViewer matchActionViewer;
    private MatchActionArgumentPanel matchActionArguments;

    public ConditionInput(IHttpConditionManager iHttpConditionManager) {
        this.conditionManager = iHttpConditionManager;
    }

    public ComboViewer createConditionTypeCombo(Composite composite) {
        this.conditionTypeViewer = new ConditionTypeComboViewer(composite, this.getConditionTypes(this.conditionManager));
        if (this.matchActionViewer != null) {
            this.conditionTypeViewer.setMatchTypeViewer(this.matchActionViewer);
        }
        return this.conditionTypeViewer;
    }

    private List<IHttpConditionType> getConditionTypes(IHttpConditionManager iHttpConditionManager) {
        if (iHttpConditionManager == null) {
            return Collections.emptyList();
        }
        return iHttpConditionManager.getConditionTypes();
    }

    public ComboViewer createConditionMatchCombo(Composite composite) {
        this.matchActionViewer = new MatchActionComboViewer(composite);
        if (this.conditionTypeViewer != null) {
            this.conditionTypeViewer.setMatchTypeViewer(this.matchActionViewer);
        }
        if (this.matchActionArguments != null) {
            this.matchActionViewer.setMatchActionArgumentPanel(this.matchActionArguments);
        }
        return this.matchActionViewer;
    }

    public Composite createInputPanel(Composite composite) {
        this.matchActionArguments = new MatchActionArgumentPanel(composite);
        if (this.matchActionViewer != null) {
            this.matchActionViewer.setMatchActionArgumentPanel(this.matchActionArguments);
        }
        return this.matchActionArguments;
    }

    public void reset() {
        this.conditionTypeViewer.reset();
        this.matchActionViewer.reset();
    }

    public IHttpCondition createConditionFromData() {
        IHttpConditionMatchAction iHttpConditionMatchAction = this.matchActionViewer.getSelectedMatchAction();
        IHttpConditionType iHttpConditionType = this.conditionTypeViewer.getSelectedConditionType();
        if (iHttpConditionMatchAction == null || iHttpConditionType == null) {
            return null;
        }
        switch (iHttpConditionMatchAction.getArgumentType()) {
            case ARGUMENT_STRING: {
                return this.createStringCondition(iHttpConditionType, iHttpConditionMatchAction, this.matchActionArguments.getStringText());
            }
            case ARGUMENT_REGEX: {
                return this.createStringCondition(iHttpConditionType, iHttpConditionMatchAction, this.matchActionArguments.getRegexText());
            }
            case ARGUMENT_INTEGER: {
                return this.createIntegerCondition(iHttpConditionType, iHttpConditionMatchAction, this.matchActionArguments.getIntegerText());
            }
            case ARGUMENT_RANGE: {
                return this.createRangeCondition(iHttpConditionType, iHttpConditionMatchAction, this.matchActionArguments.getRangeLowText(), this.matchActionArguments.getRangeHighText());
            }
        }
        return null;
    }

    private IHttpCondition createStringCondition(IHttpConditionType iHttpConditionType, IHttpConditionMatchAction iHttpConditionMatchAction, String string) {
        if (!string.isEmpty() && iHttpConditionMatchAction instanceof IHttpConditionStringMatchAction) {
            ((IHttpConditionStringMatchAction)iHttpConditionMatchAction).setString(string);
            return iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
        }
        return null;
    }

    private IHttpCondition createIntegerCondition(IHttpConditionType iHttpConditionType, IHttpConditionMatchAction iHttpConditionMatchAction, String string) {
        if (string.isEmpty() || !(iHttpConditionMatchAction instanceof IHttpConditionIntegerMatchAction)) {
            return null;
        }
        try {
            int n = Integer.parseInt(string);
            ((IHttpConditionIntegerMatchAction)iHttpConditionMatchAction).setInteger(n);
            return iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IHttpCondition createRangeCondition(IHttpConditionType iHttpConditionType, IHttpConditionMatchAction iHttpConditionMatchAction, String string, String string2) {
        int n;
        int n2;
        block4: {
            if (string.isEmpty() || string2.isEmpty() || !(iHttpConditionMatchAction instanceof IHttpConditionRangeMatchAction)) {
                return null;
            }
            try {
                n2 = Integer.parseInt(string);
                n = Integer.parseInt(string2);
                if (n2 >= 0 && n >= 0 && n2 <= n) break block4;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        ((IHttpConditionRangeMatchAction)iHttpConditionMatchAction).setRange(n2, n);
        return iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
    }
}

