/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.requests;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.impl.scanner.requests.AbstractParameterRequestBuilder;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;

public class PostParameterRequestBuilder
extends AbstractParameterRequestBuilder {
    public PostParameterRequestBuilder(IHttpRequestEngine iHttpRequestEngine, IWebPath iWebPath, List<NameValuePair> list, int n) {
        super(iHttpRequestEngine, iWebPath, list, n);
    }

    @Override
    public HttpUriRequest createBasicRequest() {
        return this.createPostRequest(this.parameters);
    }

    private HttpUriRequest createPostRequest(List<NameValuePair> list) {
        HttpUriRequest httpUriRequest = this.requestEngine.createPostRequest(this.webPath.getHttpHost(), this.getBasePath());
        ((HttpEntityEnclosingRequest)httpUriRequest).setEntity(this.createParameterEntity(list));
        return httpUriRequest;
    }

    @Override
    public HttpUriRequest createAlteredRequest(String string, boolean bl) {
        return this.createPostRequest(this.getAlteredParameters(string, bl, false));
    }

    @Override
    public HttpUriRequest createAlteredParameterNameRequest(String string) {
        return this.createPostRequest(this.getAlteredParameters(string, false, true));
    }

    private HttpEntity createParameterEntity(List<NameValuePair> list) {
        try {
            return new UrlEncodedFormEntity(list, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Failed to encode form parameters.", unsupportedEncodingException);
        }
    }

    public String toString() {
        return "POST " + this.getBasePath() + " (" + this.printParameters() + ") (idx = " + this.parameterFuzzIndex + ")";
    }

    private String printParameters() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (NameValuePair nameValuePair : this.parameters) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nameValuePair.getName());
            if (nameValuePair.getValue() == null) continue;
            stringBuilder.append("=");
            stringBuilder.append(nameValuePair.getValue());
        }
        return stringBuilder.toString();
    }
}

