/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.web.views;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.ui.web.Activator;
import com.subgraph.vega.ui.web.views.AbstractScopeAction;
import com.subgraph.vega.ui.web.views.AddScopeAction;
import com.subgraph.vega.ui.web.views.ExcludeScopeAction;
import com.subgraph.vega.ui.web.views.ScopeFilter;
import com.subgraph.vega.ui.web.views.Sorter;
import com.subgraph.vega.ui.web.views.WebsiteContentProvider;
import com.subgraph.vega.ui.web.views.WebsiteLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class WebsiteView
extends ViewPart
implements IDoubleClickListener {
    private TreeViewer viewer;
    private DrillDownAdapter drillDown;
    private WebsiteLabelProvider labelProvider;
    private ITargetScopeManager scopeManager;
    private IEventHandler scopeChangeHandler;
    private AbstractScopeAction addAction;
    private AbstractScopeAction excludeAction;
    private ViewerFilter scopeFilter;
    private boolean filterUnvisited;
    private boolean filterByScope;

    public void createPartControl(Composite composite) {
        IWorkspace iWorkspace;
        this.scopeChangeHandler = this.createScopeChangeHandler();
        this.viewer = new TreeViewer(composite);
        this.viewer.setContentProvider((IContentProvider)new WebsiteContentProvider());
        this.labelProvider = new WebsiteLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IModel iModel = Activator.getDefault().getModel();
        if (iModel != null && (iWorkspace = iModel.addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    WebsiteView.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    WebsiteView.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    WebsiteView.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        })) != null) {
            this.setScopeManager(iWorkspace.getTargetScopeManager());
            this.viewer.setInput((Object)iWorkspace);
        }
        this.scopeFilter = new ScopeFilter(iModel);
        this.viewer.setSorter((ViewerSorter)new Sorter());
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        iWorkspace = new MenuManager("");
        iWorkspace.setRemoveAllWhenShown(true);
        iWorkspace.addMenuListener(this.createMenuListener());
        this.addAction = new AddScopeAction((StructuredViewer)this.viewer, iModel);
        this.excludeAction = new ExcludeScopeAction((StructuredViewer)this.viewer, iModel);
        this.viewer.getControl().setMenu(iWorkspace.createContextMenu(this.viewer.getControl()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.drillDown = new DrillDownAdapter(this.viewer);
        this.contributeToActionBars();
    }

    private void setScopeManager(ITargetScopeManager iTargetScopeManager) {
        if (this.scopeManager != null) {
            this.scopeManager.removeActiveScopeChangeListener(this.scopeChangeHandler);
        }
        this.scopeManager = iTargetScopeManager;
        this.labelProvider.setTargetScopeManager(iTargetScopeManager);
        if (iTargetScopeManager != null) {
            iTargetScopeManager.addActiveScopeChangeListener(this.scopeChangeHandler);
        }
    }

    private IEventHandler createScopeChangeHandler() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                WebsiteView.this.viewer.refresh();
            }
        };
    }

    public void setHideUnvisitedSites(boolean bl) {
        this.filterUnvisited = bl;
        this.setFiltersForFlags();
    }

    public void setFilterByScope(boolean bl) {
        this.filterByScope = bl;
        this.setFiltersForFlags();
    }

    private void setFiltersForFlags() {
        ArrayList<ViewerFilter> arrayList = new ArrayList<ViewerFilter>();
        if (this.filterUnvisited) {
            arrayList.add(new UnvisitedFilter());
        }
        if (this.filterByScope) {
            arrayList.add(this.scopeFilter);
        }
        this.viewer.setFilters(arrayList.toArray(new ViewerFilter[0]));
    }

    private IMenuListener createMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (WebsiteView.this.addAction.isEnabledForSelection()) {
                    iMenuManager.add((IAction)WebsiteView.this.addAction);
                }
                if (WebsiteView.this.excludeAction.isEnabledForSelection()) {
                    iMenuManager.add((IAction)WebsiteView.this.excludeAction);
                }
            }
        };
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.setScopeManager(workspaceOpenEvent.getWorkspace().getTargetScopeManager());
        this.viewer.setInput((Object)workspaceOpenEvent.getWorkspace());
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.setScopeManager(null);
        this.viewer.setInput(null);
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.setScopeManager(workspaceResetEvent.getWorkspace().getTargetScopeManager());
        this.viewer.setInput(null);
        this.viewer.setInput((Object)workspaceResetEvent.getWorkspace());
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillToolBar(iActionBars.getToolBarManager());
    }

    private void fillToolBar(IToolBarManager iToolBarManager) {
        this.drillDown.addNavigationActions(iToolBarManager);
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.viewer.isExpandable(object)) {
            this.viewer.setExpandedState(object, !this.viewer.getExpandedState(object));
        }
    }

    public void collapseAll() {
        if (this.viewer != null) {
            this.viewer.collapseAll();
        }
    }

    public void expandAll() {
        if (this.viewer != null) {
            this.viewer.expandAll();
        }
    }

    private static class UnvisitedFilter
    extends ViewerFilter {
        private UnvisitedFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof IWebEntity) {
                IWebEntity iWebEntity = (IWebEntity)object2;
                return iWebEntity.isVisited();
            }
            return false;
        }
    }
}

