/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.http.requests.IPageFingerprint;
import java.util.Arrays;

public class PageFingerprint
implements IPageFingerprint {
    private static final int FP_SIZE = 10;
    private static final int FP_MAX_LEN = 15;
    private static final int FP_T_REL = 5;
    private static final int FP_T_ABS = 6;
    private static final int FP_B_FAIL = 3;
    private final int[] fpData = new int[10];
    private int fpCode;

    public static PageFingerprint generateFromCodeAndString(int n, String string) {
        PageFingerprint pageFingerprint = new PageFingerprint();
        pageFingerprint.setCode(n);
        if (string == null || string.isEmpty()) {
            return pageFingerprint;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c <= ' ' || c == '<' || c == '>' || c == '\'' || c == '\"') {
                if (!bl) {
                    bl = true;
                    pageFingerprint.addWordLength(n2);
                    n2 = 0;
                } else {
                    ++n2;
                }
            } else if (bl) {
                bl = false;
                pageFingerprint.addWordLength(n2);
                n2 = 0;
            } else {
                ++n2;
            }
            ++n3;
        }
        pageFingerprint.addWordLength(n2);
        return pageFingerprint;
    }

    public void setCode(int n) {
        this.fpCode = n;
    }

    public int getCode() {
        return this.fpCode;
    }

    public int[] getData() {
        return this.fpData;
    }

    public void addWordLength(int n) {
        if (n <= 15) {
            int n2 = n % 10;
            this.fpData[n2] = this.fpData[n2] + 1;
        }
    }

    public boolean isSame(IPageFingerprint iPageFingerprint) {
        if (iPageFingerprint == null || iPageFingerprint.getCode() != this.fpCode) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 10) {
            int n5;
            int n6 = this.fpData[n4] - iPageFingerprint.getData()[n4];
            if (!(this.isRelativeMatch(n6, n5 = this.fpData[n4] + iPageFingerprint.getData()[n4]) && Math.abs(n6) <= 6 || ++n3 <= 3)) {
                return false;
            }
            n += n6;
            n2 += n5;
            ++n4;
        }
        return this.isRelativeMatch(n, n2);
    }

    private boolean isRelativeMatch(int n, int n2) {
        return Math.abs(n) <= 1 + n2 * 5 / 100;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FP: (code=");
        stringBuilder.append(this.fpCode);
        stringBuilder.append(") [");
        int n = 0;
        while (n < 10) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.fpData[n]);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PageFingerprint) {
            PageFingerprint pageFingerprint = (PageFingerprint)object;
            return pageFingerprint.fpCode == this.fpCode && Arrays.equals(pageFingerprint.fpData, this.fpData);
        }
        return false;
    }

    public int hashCode() {
        return this.fpCode * 47 + Arrays.hashCode(this.fpData);
    }
}

