/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.search;

import java.util.List;
import org.eclipse.jface.text.IRegion;

class SearchResult {
    private final List<IRegion> matches;
    private int currentIndex;

    SearchResult(List<IRegion> list) {
        this.matches = list;
        this.currentIndex = 0;
    }

    int getCurrentIndex() {
        return this.currentIndex;
    }

    int getResultCount() {
        return this.matches.size();
    }

    boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    boolean hasNext() {
        return this.matches.size() > this.currentIndex + 1;
    }

    IRegion getFirstMatch() {
        if (this.matches.isEmpty()) {
            throw new RuntimeException("Trying to get first match on empty search result");
        }
        this.currentIndex = 0;
        return this.matches.get(0);
    }

    IRegion getNextMatch() {
        if (!this.hasNext()) {
            throw new RuntimeException("Next search match does not exist");
        }
        ++this.currentIndex;
        return this.matches.get(this.currentIndex);
    }

    IRegion getPreviousMatch() {
        if (!this.hasPrevious()) {
            throw new RuntimeException("Previous search match does not exist");
        }
        --this.currentIndex;
        return this.matches.get(this.currentIndex);
    }
}

