/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.annotations;

import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public abstract class EmbedAnnotation
extends Annotation {
    private final int height;
    private String cachedPaddingString;

    protected EmbedAnnotation(String string, int n) {
        super(string, false, "");
        this.height = n;
    }

    private String generatePaddingString(TextViewer textViewer) {
        GC gC = new GC((Drawable)textViewer.getTextWidget());
        StringBuilder stringBuilder = new StringBuilder();
        gC.setFont(textViewer.getTextWidget().getFont());
        while (gC.textExtent((String)stringBuilder.toString()).y < this.height) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String getPaddingString(TextViewer textViewer) {
        if (this.cachedPaddingString == null) {
            this.cachedPaddingString = this.generatePaddingString(textViewer);
        }
        return this.cachedPaddingString;
    }
}

