/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.HTMLCollectionImpl;
import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLInputElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLOptionsCollectionImpl;
import com.subgraph.vega.internal.html.dom.HTMLSelectElementImpl;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.Elements;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLFormElement;

public class HTMLFormElementImpl
extends HTMLElementImpl
implements HTMLFormElement {
    private HTMLCollection formElements;

    HTMLFormElementImpl(Element element, Document document) {
        super(element, document);
    }

    @Override
    public HTMLCollection getElements() {
        if (this.formElements != null) {
            return this.formElements;
        }
        ArrayList<HTMLElementImpl> arrayList = new ArrayList<HTMLElementImpl>();
        Elements elements = ((FormElement)this.jsoupElement).elements();
        for (Element element : elements) {
            this.addFormElementsToList(element, arrayList);
        }
        this.formElements = new HTMLCollectionImpl(arrayList);
        return this.formElements;
    }

    private void addFormElementsToList(Element element, List<HTMLElementImpl> list) {
        String string = element.tagName().toUpperCase();
        if ("INPUT".equals(string)) {
            list.add(new HTMLInputElementImpl(element, this, this.getOwnerDocument()));
            return;
        }
        if ("SELECT".equals(string)) {
            HTMLSelectElementImpl hTMLSelectElementImpl = new HTMLSelectElementImpl(element, this, this.getOwnerDocument());
            list.add(hTMLSelectElementImpl);
            HTMLOptionsCollectionImpl hTMLOptionsCollectionImpl = hTMLSelectElementImpl.getOptions();
            int n = 0;
            while (n < hTMLOptionsCollectionImpl.getLength()) {
                list.add(hTMLOptionsCollectionImpl.item(n));
                ++n;
            }
            return;
        }
        list.add(new HTMLElementImpl(element, this.getOwnerDocument()));
    }

    @Override
    public int getLength() {
        return this.getElements().getLength();
    }

    @Override
    public String getName() {
        return this.jsoupElement.attr("name");
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public String getAcceptCharset() {
        return this.jsoupElement.attr("accept");
    }

    @Override
    public void setAcceptCharset(String string) {
    }

    @Override
    public String getAction() {
        return this.jsoupElement.attr("action");
    }

    @Override
    public void setAction(String string) {
    }

    @Override
    public String getEnctype() {
        return this.jsoupElement.attr("enctype");
    }

    @Override
    public void setEnctype(String string) {
    }

    @Override
    public String getMethod() {
        return this.jsoupElement.attr("method");
    }

    @Override
    public void setMethod(String string) {
    }

    @Override
    public String getTarget() {
        return this.jsoupElement.attr("target");
    }

    @Override
    public void setTarget(String string) {
    }

    @Override
    public void submit() {
    }

    @Override
    public void reset() {
    }
}

