/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions.match;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionRangeMatchAction;
import com.subgraph.vega.internal.model.conditions.match.IHttpConditionMatchActionEx;

public class IsInsideRangeAction
implements IHttpConditionRangeMatchAction,
IHttpConditionMatchActionEx {
    private int rangeLowValue;
    private int rangeHighValue;

    IsInsideRangeAction() {
    }

    private IsInsideRangeAction(int n, int n2) {
        this.rangeLowValue = n;
        this.rangeHighValue = n2;
    }

    public String getLabel() {
        return "is inside range";
    }

    public void setRange(int n, int n2) {
        this.rangeLowValue = n;
        this.rangeHighValue = n2;
    }

    public boolean matchesValue(int n) {
        return n >= this.rangeLowValue && n < this.rangeHighValue;
    }

    @Override
    public Constraint constrainQuery(Query query) {
        return query.constrain((Object)this.rangeLowValue).greater().or(query.constrain((Object)this.rangeLowValue).equal()).and(query.constrain((Object)this.rangeHighValue).smaller());
    }

    @Override
    public IHttpConditionMatchAction createCopy() {
        return new IsInsideRangeAction(this.rangeLowValue, this.rangeHighValue);
    }

    public IHttpConditionMatchAction.MatchActionArgumentType getArgumentType() {
        return IHttpConditionMatchAction.MatchActionArgumentType.ARGUMENT_RANGE;
    }

    public String getArgumentAsString() {
        return String.valueOf(this.rangeLowValue) + " - " + this.rangeHighValue;
    }

    public boolean setArgumentFromString(String string) {
        Range range = this.stringToRange(string);
        if (range == null) {
            return false;
        }
        this.rangeLowValue = range.low;
        this.rangeHighValue = range.high;
        return true;
    }

    public boolean isValidArgumentString(String string) {
        return this.stringToRange(string) != null;
    }

    private Range stringToRange(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 2) {
            return null;
        }
        Integer n = this.stringToInteger(stringArray[0]);
        Integer n2 = this.stringToInteger(stringArray[1]);
        if (n == null || n2 == null || n > n2) {
            return null;
        }
        return new Range(n, n2);
    }

    private Integer stringToInteger(String string) {
        try {
            int n = Integer.parseInt(string.trim());
            return n < 0 ? null : Integer.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class Range {
        final int low;
        final int high;

        Range(int n, int n2) {
            this.low = n;
            this.high = n2;
        }
    }
}

