/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.sslprobe;

import com.subgraph.vega.internal.sslprobe.SSLServerScanResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public abstract class ProbeBase<T>
implements Callable<T>,
Runnable {
    private static final Logger logger = Logger.getLogger(ProbeBase.class.getName());
    private final SocketFactory socketFactory;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    protected final SSLServerScanResult scanResult;

    ProbeBase(SSLServerScanResult sSLServerScanResult) {
        this(sSLServerScanResult, SocketFactory.getDefault());
    }

    ProbeBase(SSLServerScanResult sSLServerScanResult, SocketFactory socketFactory) {
        this.scanResult = sSLServerScanResult;
        this.scanResult.incrementOutstandingProbeCount();
        this.socketFactory = socketFactory;
    }

    protected void skip(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(byteBuffer.position() + n);
    }

    protected void hexDump(ByteBuffer byteBuffer) {
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            if (++n % 16 == 0) {
                System.out.print("\n");
            }
            System.out.printf("%02X ", n2);
        }
        System.out.println();
        byteBuffer.rewind();
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unexpected exception during probe: " + exception, exception);
        }
    }

    @Override
    public T call() throws Exception {
        try {
            T t = this.runProbe();
            return t;
        }
        catch (UnknownHostException unknownHostException) {
            logger.warning("Unknown host exception executing probe.");
            this.scanResult.setTLSProbeFailure("Unknown host");
            return null;
        }
        catch (IOException iOException) {
            logger.warning("I/O error while executing probe: " + iOException);
            return null;
        }
        finally {
            this.scanResult.decrementOutstandingProbeCount();
            if (this.socket != null) {
                this.closeQuietly(this.socket);
            }
        }
    }

    protected abstract T runProbe() throws Exception;

    protected void closeConnection() {
        if (this.socket != null) {
            this.closeQuietly(this.socket);
            this.socket = null;
            this.input = null;
            this.output = null;
        }
    }

    protected Socket getSocket() throws UnknownHostException, IOException {
        if (this.socket == null) {
            if (System.getProperty("socksEnabled") != null) {
                if (System.getProperty("socksEnabled").equals("true")) {
                    InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(this.scanResult.getTargetHost(), this.scanResult.getTargetPort());
                    this.socket = this.socketFactory.createSocket();
                    this.socket.connect(inetSocketAddress);
                } else {
                    this.socket = this.socketFactory.createSocket(this.scanResult.getTargetHost(), this.scanResult.getTargetPort());
                }
            } else {
                this.socket = this.socketFactory.createSocket(this.scanResult.getTargetHost(), this.scanResult.getTargetPort());
            }
        }
        return this.socket;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.input == null) {
            this.input = this.getSocket().getInputStream();
        }
        return this.input;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = this.getSocket().getOutputStream();
        }
        return this.output;
    }

    protected boolean readAll(byte[] byArray) throws IOException {
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.getInputStream().read(byArray, n2, n);
            if (n3 == -1) {
                return false;
            }
            n -= n3;
            n2 += n3;
        }
        return true;
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }
}

