/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.impl.scanner.modules.scripting.RhinoExceptionFormatter;
import com.subgraph.vega.impl.scanner.modules.scripting.ScriptFile;
import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class ScriptCompiler {
    private final Scriptable parentScope;

    public ScriptCompiler(Scriptable scriptable) {
        this.parentScope = scriptable;
    }

    public boolean compile(ScriptFile scriptFile) {
        try {
            Context context = Context.enter();
            Scriptable scriptable = this.newScope(context);
            boolean bl = this.compile(scriptFile, context, scriptable);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    public boolean compile(ScriptFile scriptFile, Context context, Scriptable scriptable) {
        try {
            Scriptable scriptable2 = this.compileReader(scriptFile.createReader(), scriptFile.getPath(), context, scriptable);
            if (scriptable2 != null) {
                scriptFile.setCompiledScript(scriptable2);
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            scriptFile.setCompileFailed("I/O error compiling script " + scriptFile.getPath() + ": " + iOException.getMessage());
            return false;
        }
        catch (RhinoException rhinoException) {
            String string = "Failed to compile script " + scriptFile.getPath();
            scriptFile.setCompileFailed(new RhinoExceptionFormatter(string, rhinoException).toString());
            return false;
        }
        catch (Exception exception) {
            scriptFile.setCompileFailed("Unexpected exception compiling script: " + exception);
            return false;
        }
    }

    public Scriptable compileReader(Reader reader, String string, Context context, Scriptable scriptable) throws IOException {
        context.setLanguageVersion(170);
        Script script = context.compileReader(reader, string, 1, null);
        script.exec(context, scriptable);
        return scriptable;
    }

    public Scriptable newScope(Context context) {
        Scriptable scriptable = context.newObject(this.parentScope);
        scriptable.setPrototype(this.parentScope);
        scriptable.setParentScope(null);
        return scriptable;
    }
}

