/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules.scripting;

import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IHttpResponseCookie;
import java.util.List;
import org.apache.http.Header;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.html2.HTMLDocument;

public class ResponseJS
extends ScriptableObject {
    private static final long serialVersionUID = -1L;
    private IHttpResponse response;
    private Scriptable cachedDocument;

    public ResponseJS() {
        this.response = null;
        this.cachedDocument = null;
    }

    public ResponseJS(Object object) {
        this.response = (IHttpResponse)Context.jsToJava((Object)object, IHttpResponse.class);
    }

    private Scriptable createCachedDocument() {
        IHTMLParseResult iHTMLParseResult = this.response.getParsedHTML();
        if (iHTMLParseResult == null) {
            return null;
        }
        Context context = Context.getCurrentContext();
        HTMLDocument hTMLDocument = iHTMLParseResult.getDOMDocument();
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        Object object = Context.javaToJS((Object)hTMLDocument, (Scriptable)scriptable);
        Object[] objectArray = new Object[]{object};
        return context.newObject(scriptable, "HTMLDocument", objectArray);
    }

    IHttpResponse getResponse() {
        return this.response;
    }

    public int jsGet_code() {
        return this.response.getResponseCode();
    }

    public boolean jsFunction_hasHeader(String string) {
        return this.response.getRawResponse().containsHeader(string);
    }

    public Object jsFunction_getFirstHeader(String string) {
        Header header = this.response.getRawResponse().getFirstHeader(string);
        if (header == null) {
            return null;
        }
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)header, (Scriptable)scriptable);
    }

    public Object jsFunction_getHeaders(String string) {
        return this.headersToJS(this.response.getRawResponse().getHeaders(string));
    }

    public Object jsGet_allHeaders() {
        return this.headersToJS(this.response.getRawResponse().getAllHeaders());
    }

    public Object jsFunction_getCookies() {
        return this.cookiesToJS(this.response.getResponseCookies());
    }

    public Object jsGet_cookies() {
        return this.cookiesToJS(this.response.getResponseCookies());
    }

    private Object headersToJS(Header[] headerArray) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        Context context = Context.getCurrentContext();
        Scriptable scriptable2 = context.newArray(scriptable, headerArray.length);
        int n = 0;
        while (n < headerArray.length) {
            scriptable2.put(n, scriptable2, Context.javaToJS((Object)headerArray[n], (Scriptable)scriptable));
            ++n;
        }
        return scriptable2;
    }

    private Object cookiesToJS(List<IHttpResponseCookie> list) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        Context context = Context.getCurrentContext();
        Scriptable scriptable2 = context.newArray(scriptable, list.size());
        int n = 0;
        while (n < list.size()) {
            scriptable2.put(n, scriptable2, Context.javaToJS((Object)list.get(n), (Scriptable)scriptable));
            ++n;
        }
        return scriptable2;
    }

    public boolean jsGet_fetchFail() {
        return this.response.isFetchFail();
    }

    public Scriptable jsGet_document() {
        if (this.cachedDocument == null) {
            this.cachedDocument = this.createCachedDocument();
        }
        return this.cachedDocument;
    }

    public Object jsGet_originalRequest() {
        return this.export(this.response.getOriginalRequest());
    }

    public Object jsGet_rawResponse() {
        return this.export(this.response.getRawResponse());
    }

    public Object jsGet_host() {
        return this.export(this.response.getHost());
    }

    public String jsGet_bodyAsString() {
        return this.response.getBodyAsString();
    }

    public boolean jsGet_mostlyAscii() {
        return this.response.isMostlyAscii();
    }

    public Object jsGet_fingerprint() {
        return this.export(this.response.getPageFingerprint());
    }

    public int jsGet_milliseconds() {
        return (int)this.response.getRequestMilliseconds();
    }

    private Object export(Object object) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)object, (Scriptable)scriptable);
    }

    public String getClassName() {
        return "Response";
    }
}

