/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.modules;

import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.api.xml.IXmlRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlRepository
implements IXmlRepository {
    private final Logger logger = Logger.getLogger("xml-repository");
    private IPathFinder pathFinder;
    private File xmlDirectory;
    private DocumentBuilderFactory documentBuilderFactory;
    private Map<String, Document> xmlCache = new HashMap<String, Document>();

    void activate() {
        File file = this.pathFinder.getDataDirectory();
        this.xmlDirectory = new File(file, "xml");
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public synchronized Document getDocument(String string) {
        if (this.xmlCache.containsKey(string)) {
            return this.xmlCache.get(string);
        }
        Document document = this.loadXML(string);
        if (document != null) {
            this.xmlCache.put(string, document);
        }
        return document;
    }

    private Document loadXML(String string) {
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        File file = new File(this.xmlDirectory, string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warning("Could not find XML file: " + file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logger.log(Level.WARNING, "Error setting up XML parser:" + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            this.logger.log(Level.WARNING, "Error parsing XML document: " + file + " : " + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "I/O error reading XML file: " + file + " : " + iOException.getMessage(), iOException);
        }
        return null;
    }

    protected void setPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = iPathFinder;
    }

    protected void unsetPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = null;
    }
}

