# encoding: UTF-8

class Vulnerability
  module Urls
    # @return [ String ] The url to the metasploit module page
    def url_metasploit(module_path)
      # remove leading slash
      module_path = module_path.sub(/^\//, '')
      "http://www.rapid7.com/db/modules/#{module_path}"
    end

    def url_url(url)
      url
    end

    def url_cve(cve)
      "http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-#{cve}"
    end

    def url_osvdb(id)
      "http://osvdb.org/#{id}"
    end

    def url_secunia(id)
      "https://secunia.com/advisories/#{id}"
    end

    def url_exploitdb(id)
      "http://www.exploit-db.com/exploits/#{id}/"
    end

    def url_wpvulndb(id)
      "https://wpvulndb.com/vulnerabilities/#{id}"
    end
  end
end
