# encoding: UTF-8

class Vulnerability
  module Output

    # output the vulnerability
    def output(verbose = false)
      puts
      puts "#{critical('[!]')} Title: #{title}"
      references.each do |key, urls|
        methodname = "url_#{key}"
        urls.each do |u|
          url = send(methodname, u)
          puts "    Reference: #{url}" if url
        end
      end
      if !cvss.nil?
         puts "#{notice('[i]')} CVSS: #{cvss}"
      end
      if !fixed_in.nil?
         puts "#{notice('[i]')} Fixed in: #{fixed_in}"
      end
    end
  end
end
