/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class UniTools {
    private static List<String> backupFonts = new ArrayList<String>();
    private static String[] backupCandidates = new String[]{"Unifont", "Arial Unicode MS"};
    private static Font defaultUniFont = null;

    private static boolean fontExists(String name) {
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> availFonts = Arrays.asList(g.getAvailableFontFamilyNames());
        for (int i = 0; i < availFonts.size(); ++i) {
            availFonts.set(i, availFonts.get(i).toLowerCase());
        }
        return availFonts.contains(name.toLowerCase());
    }

    public static int getTabbedTextOffset(Segment segment, FontMetrics metrics, int tabBase, int x, TabExpander e, int startOffset) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        Font origFont = metrics.getFont();
        UniTools.getSegments(origFont, segment, segments, unis);
        Graphics g = new BufferedImage(1, 1, 2).getGraphics();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ofs = 0;
        int totalto = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            FontMetrics fm = (Boolean)unis.get(i) != false ? g.getFontMetrics(uniFont) : metrics;
            int to = Utilities.getTabbedTextOffset(seg, fm, tabBase + ofs, x, e, startOffset);
            totalto += to;
            ofs += fm.stringWidth(seg.toString());
            if (to < seg.length()) break;
        }
        return totalto;
    }

    private static void getSegments(Font f, Segment segment, List<Segment> segments, List<Boolean> unis) {
        int start = 0;
        int len = 0;
        boolean uni = false;
        for (int i = 0; i < segment.length(); ++i) {
            boolean newuni = false;
            if (!f.canDisplay(segment.charAt(i))) {
                newuni = true;
            }
            if (i > 0 && uni != newuni) {
                Segment s = new Segment(segment.array, segment.offset + start, len);
                segments.add(s);
                unis.add(uni);
                start = i;
                len = 0;
            }
            uni = newuni;
            ++len;
        }
        if (len > 0) {
            Segment s = new Segment(segment.array, segment.offset + start, len);
            segments.add(s);
            unis.add(uni);
        }
    }

    public static int getTabbedTextWidth(Segment segment, FontMetrics f, int x, TabExpander e, int startOffset) {
        Graphics g = new BufferedImage(1, 1, 2).getGraphics();
        g.setFont(f.getFont());
        return UniTools.getTabbedTextWidth(g, segment, x, e, startOffset);
    }

    public static int getTabbedTextWidth(Graphics g, Segment segment, int x, TabExpander e, int startOffset) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ret = 0;
        int pos = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            ret += Utilities.getTabbedTextWidth(seg, g.getFontMetrics((Boolean)unis.get(i) != false ? uniFont : origFont), 0, e, startOffset + pos);
            pos += seg.length();
        }
        return ret;
    }

    public static int drawTabbedText(Segment segment, int x, int y, Graphics g, TabExpander e, int startOffset) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ret = x;
        int pos = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            if (((Boolean)unis.get(i)).booleanValue()) {
                g.setFont(uniFont);
            } else {
                g.setFont(origFont);
            }
            ret = Utilities.drawTabbedText(seg, ret, y, g, e, startOffset + pos);
            pos += seg.length();
        }
        g.setFont(origFont);
        return ret;
    }

    public static int stringWidth(Graphics g, String string) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        Segment segment = new Segment(string.toCharArray(), 0, string.length());
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ret = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            ret += g.getFontMetrics((Boolean)unis.get(i) != false ? uniFont : origFont).stringWidth(seg.toString());
        }
        return ret;
    }

    static {
        for (String bc : backupCandidates) {
            if (!UniTools.fontExists(bc)) continue;
            defaultUniFont = new Font(bc, 0, 10);
        }
        if (defaultUniFont == null) {
            defaultUniFont = new JLabel().getFont();
        }
    }
}

