/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraitsListItem {
    private final Type type;
    private final boolean isStatic;
    private final ABC abc;
    private final int classIndex;
    private final int index;
    private final int scriptIndex;
    public String STR_INSTANCE_INITIALIZER = AppStrings.translate("abc.traitslist.instanceinitializer");
    public String STR_CLASS_INITIALIZER = AppStrings.translate("abc.traitslist.classinitializer");
    public String STR_SCRIPT_INITIALIZER = AppStrings.translate("abc.traitslist.scriptinitializer");

    public TraitsListItem(Type type, int index, boolean isStatic, ABC abc, int classIndex, int scriptIndex) {
        this.type = type;
        this.index = index;
        this.isStatic = isStatic;
        this.abc = abc;
        this.classIndex = classIndex;
        this.scriptIndex = scriptIndex;
    }

    public int getGlobalTraitId() {
        if (this.type == Type.INITIALIZER) {
            if (!this.isStatic) {
                return -1;
            }
            return -2;
        }
        if (this.type == Type.SCRIPT_INITIALIZER) {
            return -3;
        }
        if (this.isStatic) {
            return this.index;
        }
        return ((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.size() + this.index;
    }

    public String toStringName() {
        if (this.type == Type.INITIALIZER) {
            if (!this.isStatic) {
                return "__" + this.STR_INSTANCE_INITIALIZER;
            }
            return "__" + this.STR_CLASS_INITIALIZER;
        }
        if (this.type == Type.SCRIPT_INITIALIZER) {
            return "__" + this.STR_SCRIPT_INITIALIZER;
        }
        if (this.isStatic) {
            return ((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(this.index)).getName(this.abc).getName(this.abc.constants, null, false, true);
        }
        return ((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(this.index)).getName(this.abc).getName(this.abc.constants, null, false, true);
    }

    public String toString() {
        String s = "";
        try {
            if (this.type == Type.SCRIPT_INITIALIZER) {
                s = this.STR_SCRIPT_INITIALIZER;
            } else if (this.type == Type.INITIALIZER) {
                s = !this.isStatic ? this.STR_INSTANCE_INITIALIZER : this.STR_CLASS_INITIALIZER;
            } else if (this.isStatic) {
                ConvertData convertData = new ConvertData();
                ((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(this.index)).convertHeader(null, convertData, "", this.abc, true, ScriptExportMode.AS, this.scriptIndex, this.classIndex, new NulWriter(), new ArrayList(), false);
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
                ((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(this.index)).toStringHeader(null, convertData, "", this.abc, true, ScriptExportMode.AS, this.scriptIndex, this.classIndex, (GraphTextWriter)writer, new ArrayList(), false);
                s = writer.toString();
            } else {
                ConvertData convertData = new ConvertData();
                ((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(this.index)).convertHeader(null, convertData, "", this.abc, false, ScriptExportMode.AS, this.scriptIndex, this.classIndex, new NulWriter(), new ArrayList(), false);
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
                ((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(this.index)).toStringHeader(null, convertData, "", this.abc, false, ScriptExportMode.AS, this.scriptIndex, this.classIndex, (GraphTextWriter)writer, new ArrayList(), false);
                s = writer.toString();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TraitsListItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        s = s.replaceAll("[ \r\n]+", " ");
        return s;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public static enum Type {
        METHOD,
        VAR,
        CONST,
        INITIALIZER,
        SCRIPT_INITIALIZER;


        public static Type getTypeForTrait(Trait t) {
            if (t instanceof TraitMethodGetterSetter) {
                return METHOD;
            }
            if (t instanceof TraitSlotConst) {
                if (((TraitSlotConst)t).isConst()) {
                    return CONST;
                }
                return VAR;
            }
            return null;
        }
    }
}

