/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.TraitsListItem;
import java.awt.Component;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class IconListRenderer
extends DefaultListCellRenderer {
    private final Icon constIcon = View.getIcon("constant");
    private final Icon functionIcon = View.getIcon("function");
    private final Icon variableIcon = View.getIcon("variable");

    private Icon loadIcon(String path) {
        ClassLoader cldr = this.getClass().getClassLoader();
        URL imageURL = cldr.getResource(path);
        return new ImageIcon(imageURL);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        TraitsListItem tli = (TraitsListItem)value;
        if (tli.getType() == TraitsListItem.Type.CONST) {
            label.setIcon(this.constIcon);
        }
        if (tli.getType() == TraitsListItem.Type.VAR) {
            label.setIcon(this.variableIcon);
        }
        if (tli.getType() == TraitsListItem.Type.METHOD) {
            label.setIcon(this.functionIcon);
        }
        if (tli.getType() == TraitsListItem.Type.INITIALIZER) {
            label.setIcon(this.functionIcon);
        }
        if (tli.getType() == TraitsListItem.Type.SCRIPT_INITIALIZER) {
            label.setIcon(this.functionIcon);
        }
        return label;
    }
}

