/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParser;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.BinaryPanel;
import com.jpexs.decompiler.flash.gui.ButtonsPanel;
import com.jpexs.decompiler.flash.gui.FontPanel;
import com.jpexs.decompiler.flash.gui.GenericTagPanel;
import com.jpexs.decompiler.flash.gui.GenericTagTreePanel;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.ImagePanel;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.TextPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.player.FlashPlayerPanel;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.PlayerControls;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShapeTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.helpers.SerializableImage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PreviewPanel
extends JPersistentSplitPane
implements TagEditorPanel {
    private static final String FLASH_VIEWER_CARD = "FLASHVIEWER";
    private static final String DRAW_PREVIEW_CARD = "DRAWPREVIEW";
    private static final String GENERIC_TAG_CARD = "GENERICTAG";
    private static final String BINARY_TAG_CARD = "BINARYTAG";
    private static final String METADATA_TAG_CARD = "METADATATAG";
    private static final String EMPTY_CARD = "EMPTY";
    private static final String CARDTEXTPANEL = "Text card";
    private static final String CARDFONTPANEL = "Font card";
    private final MainPanel mainPanel;
    private final JPanel viewerCards;
    private final FlashPlayerPanel flashPanel;
    private File tempFile;
    private ImagePanel imagePanel;
    private PlayerControls imagePlayControls;
    private MediaDisplay media;
    private BinaryPanel binaryPanel;
    private LineMarkedEditorPane metadataEditor;
    private GenericTagPanel genericTagPanel;
    private JPanel displayWithPreview;
    private JButton replaceImageButton;
    private JButton replaceImageAlphaButton;
    private JButton prevFontsButton;
    private JButton nextFontsButton;
    private JButton replaceBinaryButton;
    private JButton metadataEditButton;
    private JButton metadataSaveButton;
    private JButton metadataCancelButton;
    private JButton genericEditButton;
    private JButton genericSaveButton;
    private JButton genericCancelButton;
    private JPanel parametersPanel;
    private FontPanel fontPanel;
    private int fontPageNum;
    private TextPanel textPanel;
    private MetadataTag metadataTag;
    private boolean readOnly = false;
    private final int dividerSize;

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setDividerSize(this.readOnly ? 0 : this.dividerSize);
        if (readOnly) {
            this.parametersPanel.setVisible(false);
        }
    }

    public PreviewPanel(MainPanel mainPanel, FlashPlayerPanel flashPanel) {
        super(1, (ConfigurationItem<Double>)Configuration.guiPreviewSplitPaneDividerLocationPercent);
        this.mainPanel = mainPanel;
        this.flashPanel = flashPanel;
        this.viewerCards = new JPanel();
        this.viewerCards.setLayout(new CardLayout());
        this.viewerCards.add((Component)this.createFlashPlayerPanel(flashPanel), FLASH_VIEWER_CARD);
        this.viewerCards.add((Component)this.createImagesCard(), DRAW_PREVIEW_CARD);
        this.viewerCards.add((Component)this.createBinaryCard(), BINARY_TAG_CARD);
        this.viewerCards.add((Component)this.createMetadataCard(), METADATA_TAG_CARD);
        this.viewerCards.add((Component)this.createGenericTagCard(), GENERIC_TAG_CARD);
        this.viewerCards.add((Component)this.createEmptyCard(), EMPTY_CARD);
        this.setLeftComponent(this.viewerCards);
        this.createParametersPanel();
        this.showCardLeft(FLASH_VIEWER_CARD);
        this.dividerSize = this.getDividerSize();
    }

    private JPanel createEmptyCard() {
        JPanel ret = new JPanel();
        ret.add(new JLabel("-"));
        return ret;
    }

    private void createParametersPanel() {
        this.displayWithPreview = new JPanel(new CardLayout());
        this.textPanel = new TextPanel(this.mainPanel);
        this.displayWithPreview.add((Component)this.textPanel, CARDTEXTPANEL);
        this.fontPanel = new FontPanel(this.mainPanel);
        this.displayWithPreview.add((Component)this.fontPanel, CARDFONTPANEL);
        HeaderLabel paramsLabel = new HeaderLabel(this.mainPanel.translate("parameters"));
        paramsLabel.setHorizontalAlignment(0);
        this.parametersPanel = new JPanel(new BorderLayout());
        this.parametersPanel.add((Component)paramsLabel, "North");
        this.parametersPanel.add((Component)this.displayWithPreview, "Center");
        this.setRightComponent(this.parametersPanel);
    }

    private JPanel createImageButtonsPanel() {
        this.replaceImageButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("replaceimage16"));
        this.replaceImageButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageButton.addActionListener(this.mainPanel::replaceButtonActionPerformed);
        this.replaceImageButton.setVisible(false);
        this.replaceImageAlphaButton = new JButton(this.mainPanel.translate("button.replaceAlphaChannel"), View.getIcon("replacealpha16"));
        this.replaceImageAlphaButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageAlphaButton.addActionListener(this.mainPanel::replaceAlphaButtonActionPerformed);
        this.replaceImageAlphaButton.setVisible(false);
        this.prevFontsButton = new JButton(this.mainPanel.translate("button.prev"), View.getIcon("prev16"));
        this.prevFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.prevFontsButton.addActionListener(this::prevFontsButtonActionPerformed);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton = new JButton(this.mainPanel.translate("button.next"), View.getIcon("next16"));
        this.nextFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.nextFontsButton.addActionListener(this::nextFontsButtonActionPerformed);
        this.nextFontsButton.setVisible(false);
        ButtonsPanel imageButtonsPanel = new ButtonsPanel();
        imageButtonsPanel.add(this.replaceImageButton);
        imageButtonsPanel.add(this.replaceImageAlphaButton);
        imageButtonsPanel.add(this.prevFontsButton);
        imageButtonsPanel.add(this.nextFontsButton);
        return imageButtonsPanel;
    }

    private JPanel createBinaryButtonsPanel() {
        this.replaceBinaryButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("edit16"));
        this.replaceBinaryButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceBinaryButton.addActionListener(this.mainPanel::replaceButtonActionPerformed);
        ButtonsPanel binaryButtonsPanel = new ButtonsPanel();
        binaryButtonsPanel.add(this.replaceBinaryButton);
        return binaryButtonsPanel;
    }

    private JPanel createGenericTagButtonsPanel() {
        this.genericEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.genericEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericEditButton.addActionListener(this::editGenericTagButtonActionPerformed);
        this.genericSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.genericSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericSaveButton.addActionListener(this::saveGenericTagButtonActionPerformed);
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.genericCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericCancelButton.addActionListener(this::cancelGenericTagButtonActionPerformed);
        this.genericCancelButton.setVisible(false);
        ButtonsPanel genericTagButtonsPanel = new ButtonsPanel();
        genericTagButtonsPanel.add(this.genericEditButton);
        genericTagButtonsPanel.add(this.genericSaveButton);
        genericTagButtonsPanel.add(this.genericCancelButton);
        return genericTagButtonsPanel;
    }

    private JPanel createMetadataButtonsPanel() {
        this.metadataEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.metadataEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataEditButton.addActionListener(this::editMetadataButtonActionPerformed);
        this.metadataSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.metadataSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataSaveButton.addActionListener(this::saveMetadataButtonActionPerformed);
        this.metadataSaveButton.setVisible(false);
        this.metadataCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.metadataCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataCancelButton.addActionListener(this::cancelMetadataButtonActionPerformed);
        this.metadataCancelButton.setVisible(false);
        ButtonsPanel metadataTagButtonsPanel = new ButtonsPanel();
        metadataTagButtonsPanel.add(this.metadataEditButton);
        metadataTagButtonsPanel.add(this.metadataSaveButton);
        metadataTagButtonsPanel.add(this.metadataCancelButton);
        return metadataTagButtonsPanel;
    }

    private JPanel createFlashPlayerPanel(FlashPlayerPanel flashPanel) {
        JPanel leftComponent;
        JPanel pan = new JPanel(new BorderLayout());
        HeaderLabel prevLabel = new HeaderLabel(this.mainPanel.translate("swfpreview"));
        prevLabel.setHorizontalAlignment(0);
        pan.add((Component)prevLabel, "North");
        if (flashPanel != null) {
            JPanel flashPlayPanel = new JPanel(new BorderLayout());
            flashPlayPanel.add((Component)flashPanel, "Center");
            JPanel flashPlayPanel2 = new JPanel(new BorderLayout());
            flashPlayPanel2.add((Component)flashPlayPanel, "Center");
            flashPlayPanel2.add((Component)new PlayerControls(this.mainPanel, flashPanel), "South");
            leftComponent = flashPlayPanel2;
        } else {
            JPanel swtPanel = new JPanel(new BorderLayout());
            swtPanel.add((Component)new JLabel("<html><center>" + this.mainPanel.translate("notavailonthisplatform") + "</center></html>", 0), "Center");
            swtPanel.setBackground(View.getDefaultBackgroundColor());
            leftComponent = swtPanel;
        }
        pan.add((Component)leftComponent, "Center");
        return pan;
    }

    private JPanel createImagesCard() {
        JPanel shapesCard = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        JPanel previewCnt = new JPanel(new BorderLayout());
        this.imagePanel = new ImagePanel();
        this.imagePanel.setLoop((Boolean)Configuration.loopMedia.get());
        previewCnt.add((Component)this.imagePanel, "Center");
        this.imagePlayControls = new PlayerControls(this.mainPanel, this.imagePanel);
        previewCnt.add((Component)this.imagePlayControls, "South");
        this.imagePlayControls.setMedia(this.imagePanel);
        previewPanel.add((Component)previewCnt, "Center");
        HeaderLabel prevIntLabel = new HeaderLabel(this.mainPanel.translate("swfpreview.internal"));
        prevIntLabel.setHorizontalAlignment(0);
        previewPanel.add((Component)prevIntLabel, "North");
        shapesCard.add((Component)previewPanel, "Center");
        shapesCard.add((Component)this.createImageButtonsPanel(), "South");
        return shapesCard;
    }

    private JPanel createMetadataCard() {
        JPanel metadataCard = new JPanel(new BorderLayout());
        this.metadataEditor = new LineMarkedEditorPane();
        metadataCard.add((Component)new JScrollPane(this.metadataEditor), "Center");
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setFont(Configuration.getSourceFont());
        this.metadataEditor.changeContentType("text/xml");
        this.metadataEditor.addTextChangedListener(this::metadataTextChanged);
        metadataCard.add((Component)this.createMetadataButtonsPanel(), "South");
        return metadataCard;
    }

    private boolean isMetadataModified() {
        return this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled();
    }

    private void setMetadataModified(boolean value) {
        this.metadataSaveButton.setEnabled(value);
        this.metadataCancelButton.setEnabled(value);
    }

    private void metadataTextChanged() {
        this.setMetadataModified(true);
    }

    private void updateMetadataButtonsVisibility() {
        boolean edit = this.metadataEditor.isEditable();
        boolean editorMode = (Boolean)Configuration.editorMode.get();
        this.metadataEditButton.setVisible(!this.readOnly && !edit);
        this.metadataSaveButton.setVisible(!this.readOnly && edit);
        boolean metadataModified = this.isMetadataModified();
        this.metadataCancelButton.setVisible(!this.readOnly && edit);
        this.metadataCancelButton.setEnabled(metadataModified || !editorMode);
    }

    private JPanel createBinaryCard() {
        JPanel binaryCard = new JPanel(new BorderLayout());
        this.binaryPanel = new BinaryPanel(this.mainPanel);
        binaryCard.add((Component)this.binaryPanel, "Center");
        binaryCard.add((Component)this.createBinaryButtonsPanel(), "South");
        return binaryCard;
    }

    private JPanel createGenericTagCard() {
        JPanel genericTagCard = new JPanel(new BorderLayout());
        this.genericTagPanel = new GenericTagTreePanel(this.mainPanel);
        genericTagCard.add((Component)this.genericTagPanel, "Center");
        genericTagCard.add((Component)this.createGenericTagButtonsPanel(), "South");
        return genericTagCard;
    }

    private void showCardLeft(String card) {
        CardLayout cl = (CardLayout)this.viewerCards.getLayout();
        cl.show(this.viewerCards, card);
    }

    private void showCardRight(String card) {
        CardLayout cl = (CardLayout)this.displayWithPreview.getLayout();
        cl.show(this.displayWithPreview, card);
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void setParametersPanelVisible(boolean show) {
        this.parametersPanel.setVisible(show);
    }

    public void showFlashViewerPanel() {
        this.parametersPanel.setVisible(false);
        this.showCardLeft(FLASH_VIEWER_CARD);
    }

    public void showImagePanel(Timelined timelined, SWF swf, int frame) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imagePanel.setTimelined(timelined, swf, frame);
    }

    public void showImagePanel(SerializableImage image) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imagePanel.setImage(image);
    }

    public void showTextComparePanel(TextTag textTag, TextTag newTextTag) {
        this.imagePanel.setText(textTag, newTextTag);
    }

    public void setMedia(MediaDisplay media) {
        this.media = media;
        this.imagePlayControls.setMedia(media);
    }

    public void showFontPanel(FontTag fontTag) {
        this.fontPageNum = 0;
        this.showFontPage(fontTag);
        this.showCardRight(CARDFONTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.fontPanel.showFontTag(fontTag);
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        if (pageCount > 1) {
            this.prevFontsButton.setVisible(true);
            this.nextFontsButton.setVisible(true);
        }
    }

    private void showFontPage(FontTag fontTag) {
        if (this.mainPanel.isInternalFlashViewerSelected()) {
            this.showImagePanel(MainPanel.makeTimelined((Tag)fontTag), fontTag.getSwf(), this.fontPageNum);
        }
    }

    public static int getFontPageCount(FontTag fontTag) {
        int pageCount = (fontTag.getGlyphShapeTable().size() - 1) / 400 + 1;
        if (pageCount < 1) {
            pageCount = 1;
        }
        return pageCount;
    }

    public void showEmpty() {
        this.showCardLeft(EMPTY_CARD);
    }

    public void showTextPanel(TextTag textTag) {
        if (this.mainPanel.isInternalFlashViewerSelected()) {
            this.showImagePanel(MainPanel.makeTimelined((Tag)textTag), textTag.getSwf(), 0);
        }
        this.showCardRight(CARDTEXTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.textPanel.setText(textTag);
    }

    public void focusTextPanel() {
        this.textPanel.focusTextValue();
    }

    public void clear() {
        this.imagePanel.clearAll();
        if (this.media != null) {
            try {
                this.media.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.binaryPanel.setBinaryData(null);
        this.genericTagPanel.clear();
        this.fontPanel.clear();
    }

    public void closeTag() {
        this.textPanel.closeTag();
    }

    public static String formatMetadata(String input, int indent) {
        input = input.replace("> <", "><");
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            StringWriter sw = new StringWriter();
            xmlOutput.setWriter(sw);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException e) {
            return input;
        }
    }

    public void showMetaDataPanel(MetadataTag metadataTag) {
        this.showCardLeft(METADATA_TAG_CARD);
        this.metadataTag = metadataTag;
        this.metadataEditor.setEditable(!this.readOnly && !metadataTag.isReadOnly() && (Boolean)Configuration.editorMode.get() != false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(metadataTag.xmlMetadata, 4));
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.parametersPanel.setVisible(false);
    }

    public void showBinaryPanel(DefineBinaryDataTag binaryDataTag) {
        this.showCardLeft(BINARY_TAG_CARD);
        this.binaryPanel.setBinaryData(binaryDataTag);
        this.parametersPanel.setVisible(false);
    }

    public void showGenericTagPanel(Tag tag) {
        this.showCardLeft(GENERIC_TAG_CARD);
        this.genericEditButton.setVisible(!tag.isReadOnly());
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton.setVisible(false);
        this.genericTagPanel.setEditMode(false, tag);
        this.parametersPanel.setVisible(false);
    }

    public void setImageReplaceButtonVisible(boolean show, boolean showAlpha) {
        if (this.readOnly) {
            show = false;
            showAlpha = false;
        }
        this.replaceImageButton.setVisible(show);
        this.replaceImageAlphaButton.setVisible(showAlpha);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton.setVisible(false);
    }

    private static Tag classicTag(Tag t) {
        if (t instanceof DefineCompactedFont) {
            return ((DefineCompactedFont)t).toClassicFont();
        }
        return t;
    }

    private static void writeTag(Tag t, SWFOutputStream sos) throws IOException {
        List chIdTags;
        t = PreviewPanel.classicTag(t);
        t.writeTag(sos);
        if (t instanceof CharacterIdTag && (chIdTags = t.getSwf().getCharacterIdTags(((CharacterIdTag)t).getCharacterId())) != null) {
            for (CharacterIdTag chIdTag : chIdTags) {
                if (chIdTag instanceof PlaceObjectTypeTag || chIdTag instanceof RemoveTag) continue;
                ((Tag)chIdTag).writeTag(sos);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createAndShowTempSwf(TreeItem treeItem) {
        SWF swf = null;
        try {
            byte[] data;
            SetBackgroundColorTag setBgColorTag;
            Frame fn;
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            this.tempFile = File.createTempFile("ffdec_view_", ".swf");
            this.tempFile.deleteOnExit();
            Color backgroundColor = View.getSwfBackgroundColor();
            if (treeItem instanceof Tag) {
                Tag tag = (Tag)treeItem;
                swf = tag.getSwf();
                if (tag instanceof FontTag) {
                    backgroundColor = View.getDefaultBackgroundColor();
                }
            } else if (treeItem instanceof Frame && fn.timeline.timelined == (swf = (fn = (Frame)treeItem).getSwf()) && (setBgColorTag = swf.getBackgroundColor()) != null) {
                backgroundColor = setBgColorTag.backgroundColor.toColor();
            }
            int frameCount = 1;
            float frameRate = swf.frameRate;
            HashMap videoFrames = new HashMap();
            if (treeItem instanceof DefineVideoStreamTag) {
                DefineVideoStreamTag vs = (DefineVideoStreamTag)treeItem;
                SWF.populateVideoFrames((int)vs.getCharacterId(), (Iterable)swf.getTags(), videoFrames);
                frameCount = videoFrames.size();
            }
            List soundFrames = new ArrayList();
            if (treeItem instanceof SoundStreamHeadTypeTag) {
                soundFrames = ((SoundStreamHeadTypeTag)treeItem).getBlocks();
                frameCount = soundFrames.size();
            }
            if (treeItem instanceof DefineMorphShapeTag || treeItem instanceof DefineMorphShape2Tag) {
                frameRate = 30.0f;
                frameCount = (int)(2.0f * frameRate);
            }
            if (treeItem instanceof DefineSoundTag) {
                frameCount = 1;
            }
            if (treeItem instanceof DefineSpriteTag) {
                frameCount = ((DefineSpriteTag)treeItem).frameCount;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                SetBackgroundColorTag setBgColorTag2;
                SWFOutputStream sos2 = new SWFOutputStream((OutputStream)baos, 10);
                RECT outrect = new RECT(swf.displayRect);
                RECT treeItemBounds = null;
                if (treeItem instanceof FontTag) {
                    outrect.Xmin = 0;
                    outrect.Ymin = 0;
                    outrect.Xmax = 10000;
                    outrect.Ymax = 10000;
                } else if (treeItem instanceof BoundedTag) {
                    treeItemBounds = ((BoundedTag)treeItem).getRect();
                } else if (treeItem instanceof Frame) {
                    treeItemBounds = ((Frame)treeItem).timeline.timelined.getRect();
                }
                if (treeItemBounds != null) {
                    if (outrect.getWidth() < treeItemBounds.getWidth()) {
                        outrect.Xmax += treeItemBounds.getWidth() - outrect.getWidth();
                    }
                    if (outrect.getHeight() < treeItemBounds.getHeight()) {
                        outrect.Ymax += treeItemBounds.getHeight() - outrect.getHeight();
                    }
                }
                int width = outrect.getWidth();
                int height = outrect.getHeight();
                sos2.writeRECT(outrect);
                sos2.writeFIXED8(frameRate);
                sos2.writeUI16(frameCount);
                FileAttributesTag fa = swf.getFileAttributes();
                if (fa != null) {
                    fa.writeTag(sos2);
                }
                if ((setBgColorTag2 = swf.getBackgroundColor()) == null) {
                    setBgColorTag2 = new SetBackgroundColorTag(swf, new RGB(backgroundColor));
                }
                setBgColorTag2.writeTag(sos2);
                if (treeItem instanceof Frame) {
                    Frame fn2 = (Frame)treeItem;
                    Timelined parent = fn2.timeline.timelined;
                    HashSet<Integer> doneCharacters = new HashSet<Integer>();
                    for (Object t : parent.getTags()) {
                        if (t instanceof FileAttributesTag || t instanceof SetBackgroundColorTag || t instanceof DoActionTag || t instanceof DoInitActionTag) continue;
                        HashSet hashSet = new HashSet();
                        t.getNeededCharactersDeep(hashSet);
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            int n = (Integer)iterator.next();
                            if (doneCharacters.contains(n)) continue;
                            PreviewPanel.writeTag((Tag)swf.getCharacter(n), sos2);
                            doneCharacters.add(n);
                        }
                        if (!(t instanceof CharacterTag)) continue;
                        int characterId = ((CharacterTag)t).getCharacterId();
                        doneCharacters.add(characterId);
                        PreviewPanel.writeTag((Tag)t, sos2);
                    }
                    RECT r = parent.getRect();
                    for (Map.Entry entry : fn2.layers.entrySet()) {
                        PlaceObjectTypeTag pot = ((DepthState)entry.getValue()).toPlaceObjectTag(((Integer)entry.getKey()).intValue());
                        MATRIX mat = new MATRIX(pot.getMatrix());
                        mat.translateX += width / 2 - r.getWidth() / 2;
                        mat.translateY += height / 2 - r.getHeight() / 2;
                        pot.setMatrix(mat);
                        pot.writeTag(sos2);
                    }
                    new ShowFrameTag(swf).writeTag(sos2);
                } else {
                    RECT r;
                    boolean isSprite = false;
                    if (treeItem instanceof DefineSpriteTag) {
                        isSprite = true;
                    }
                    int chtId = -1;
                    if (treeItem instanceof CharacterTag) {
                        chtId = ((CharacterTag)treeItem).getCharacterId();
                    }
                    if (treeItem instanceof DefineBitsTag) {
                        JPEGTablesTag jtt = swf.getJtt();
                        if (jtt != null) {
                            jtt.writeTag(sos2);
                        }
                    } else if (!(treeItem instanceof AloneTag)) {
                        HashSet needed = new HashSet();
                        ((Tag)treeItem).getNeededCharactersDeep(needed);
                        r = needed.iterator();
                        while (r.hasNext()) {
                            JPEGTablesTag jtt;
                            int n = (Integer)r.next();
                            if (isSprite && chtId == n) continue;
                            CharacterTag characterTag = swf.getCharacter(n);
                            if (characterTag instanceof DefineBitsTag && (jtt = swf.getJtt()) != null) {
                                jtt.writeTag(sos2);
                            }
                            PreviewPanel.writeTag((Tag)characterTag, sos2);
                        }
                    }
                    PreviewPanel.writeTag((Tag)treeItem, sos2);
                    MATRIX mat = new MATRIX();
                    mat.hasRotate = false;
                    mat.hasScale = false;
                    mat.translateX = 0;
                    mat.translateY = 0;
                    if (treeItem instanceof BoundedTag) {
                        r = ((BoundedTag)treeItem).getRect();
                        mat.translateX = -r.Xmin;
                        mat.translateY = -r.Ymin;
                        mat.translateX = mat.translateX + width / 2 - r.getWidth() / 2;
                        mat.translateY = mat.translateY + height / 2 - r.getHeight() / 2;
                    } else {
                        mat.translateX = width / 4;
                        mat.translateY = height / 4;
                    }
                    if (treeItem instanceof FontTag) {
                        FontTag ft = (FontTag)PreviewPanel.classicTag((Tag)treeItem);
                        int countGlyphsTotal = ft.getGlyphShapeTable().size();
                        int n = Math.min(400, countGlyphsTotal);
                        int fontId = ft.getFontId();
                        int cols = (int)Math.ceil(Math.sqrt(n));
                        int rows = (int)Math.ceil((float)n / (float)cols);
                        if (rows == 0) {
                            rows = 1;
                            cols = 1;
                        }
                        int x = 0;
                        int y = 0;
                        int firstGlyphIndex = this.fontPageNum * 400;
                        int n2 = Math.min(400, countGlyphsTotal - firstGlyphIndex);
                        List shapes = ft.getGlyphShapeTable();
                        int maxw = 0;
                        for (int f = firstGlyphIndex; f < firstGlyphIndex + n2; ++f) {
                            RECT b = ((SHAPE)shapes.get(f)).getBounds();
                            if (b.Xmin == Integer.MAX_VALUE || b.Ymin == Integer.MAX_VALUE) continue;
                            int w = (int)((double)b.getWidth() / ft.getDivider());
                            if (w > maxw) {
                                maxw = w;
                            }
                            ++x;
                        }
                        x = 0;
                        int BORDER = 60;
                        int textHeight = height / rows;
                        while ((double)(maxw * textHeight) / 1024.0 > (double)(width / cols - 2 * BORDER)) {
                            --textHeight;
                        }
                        MATRIX tmat = new MATRIX();
                        for (int f = firstGlyphIndex; f < firstGlyphIndex + n2; ++f) {
                            if (x >= cols) {
                                x = 0;
                                ++y;
                            }
                            ArrayList<TEXTRECORD> rec = new ArrayList<TEXTRECORD>();
                            TEXTRECORD tr = new TEXTRECORD();
                            RECT b = ((SHAPE)shapes.get(f)).getBounds();
                            int xmin = b.Xmin == Integer.MAX_VALUE ? 0 : (int)((double)b.Xmin / ft.getDivider());
                            xmin = (int)((double)xmin * ((double)textHeight / 1024.0));
                            int ymin = b.Ymin == Integer.MAX_VALUE ? 0 : (int)((double)b.Ymin / ft.getDivider());
                            ymin = (int)((double)ymin * ((double)textHeight / 1024.0));
                            int w = (int)((double)b.getWidth() / ft.getDivider());
                            w = (int)((double)w * ((double)textHeight / 1024.0));
                            int h = (int)((double)b.getHeight() / ft.getDivider());
                            h = (int)((double)h * ((double)textHeight / 1024.0));
                            tr.fontId = fontId;
                            tr.styleFlagsHasFont = true;
                            tr.textHeight = textHeight;
                            tr.xOffset = -xmin;
                            tr.yOffset = 0;
                            tr.styleFlagsHasXOffset = true;
                            tr.styleFlagsHasYOffset = true;
                            tr.glyphEntries = new ArrayList(1);
                            tr.styleFlagsHasColor = true;
                            tr.textColor = new RGB(0, 0, 0);
                            GLYPHENTRY ge = new GLYPHENTRY();
                            double ga = ft.getGlyphAdvance(f);
                            int cw = ga == -1.0 ? w : (int)(ga / ft.getDivider() * (double)textHeight / 1024.0);
                            ge.glyphAdvance = 0;
                            ge.glyphIndex = f;
                            tr.glyphEntries.add(ge);
                            rec.add(tr);
                            tmat.translateX = x * width / cols + width / cols / 2 - w / 2;
                            tmat.translateY = y * height / rows + height / rows / 2;
                            new DefineTextTag(swf, 999 + f, new RECT(0, cw, ymin, ymin + h), new MATRIX(), rec).writeTag(sos2);
                            new PlaceObject2Tag(swf, false, 1 + f, 999 + f, tmat, null, 0, null, -1, null).writeTag(sos2);
                            ++x;
                        }
                        new ShowFrameTag(swf).writeTag(sos2);
                    } else if (treeItem instanceof DefineMorphShapeTag || treeItem instanceof DefineMorphShape2Tag) {
                        new PlaceObject2Tag(swf, false, 1, chtId, mat, null, 0, null, -1, null).writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        for (int ratio = 0; ratio < 65536; ratio += 65536 / frameCount) {
                            new PlaceObject2Tag(swf, true, 1, chtId, mat, null, ratio, null, -1, null).writeTag(sos2);
                            new ShowFrameTag(swf).writeTag(sos2);
                        }
                    } else if (treeItem instanceof SoundStreamHeadTypeTag) {
                        for (SoundStreamBlockTag blk : soundFrames) {
                            blk.writeTag(sos2);
                            new ShowFrameTag(swf).writeTag(sos2);
                        }
                    } else if (treeItem instanceof DefineSoundTag) {
                        ExportAssetsTag ea = new ExportAssetsTag(swf);
                        DefineSoundTag ds = (DefineSoundTag)treeItem;
                        ea.tags.add(ds.soundId);
                        ea.names.add("my_define_sound");
                        ea.writeTag(sos2);
                        DoActionTag doa = new DoActionTag(swf, null);
                        ActionList actionList = ASMParser.parse((long)0L, (boolean)false, (String)"ConstantPool \"_root\" \"my_sound\" \"Sound\" \"my_define_sound\" \"attachSound\"\nPush \"_root\"\nGetVariable\nPush \"my_sound\" 0.0 \"Sound\"\nNewObject\nSetMember\nPush \"my_define_sound\" 1 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"attachSound\"\nCallMethod\nPop\nStop", (int)swf.version, (boolean)false);
                        doa.setActions((List)actionList);
                        doa.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        ActionList actionList2 = ASMParser.parse((long)0L, (boolean)false, (String)"ConstantPool \"_root\" \"my_sound\" \"Sound\" \"my_define_sound\" \"attachSound\" \"start\"\nStopSounds\nPush \"_root\"\nGetVariable\nPush \"my_sound\" 0.0 \"Sound\"\nNewObject\nSetMember\nPush \"my_define_sound\" 1 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"attachSound\"\nCallMethod\nPop\nPush 9999 0.0 2 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"start\"\nCallMethod\nPop\nStop", (int)swf.version, (boolean)false);
                        doa.setActions((List)actionList2);
                        doa.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        ActionList actionList3 = ASMParser.parse((long)0L, (boolean)false, (String)"ConstantPool \"_root\" \"my_sound\" \"Sound\" \"my_define_sound\" \"attachSound\" \"onSoundComplete\" \"start\" \"execParam\"\nStopSounds\nPush \"_root\"\nGetVariable\nPush \"my_sound\" 0.0 \"Sound\"\nNewObject\nSetMember\nPush \"my_define_sound\" 1 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"attachSound\"\nCallMethod\nPop\nPush \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"onSoundComplete\"\nDefineFunction2 \"\" 0 2 false true true false true false true false false  {\nPush 0.0 register1 \"my_sound\"\nGetMember\nPush \"start\"\nCallMethod\nPop\n}\nSetMember\nPush \"_root\"\nGetVariable\nPush \"execParam\"\nGetMember\nPush 1 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"start\"\nCallMethod\nPop\nStop", (int)swf.version, (boolean)false);
                        doa.setActions((List)actionList3);
                        doa.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        ActionList actionList4 = ASMParser.parse((long)0L, (boolean)false, (String)"StopSounds\nStop", (int)swf.version, (boolean)false);
                        doa.setActions((List)actionList4);
                        doa.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                    } else if (treeItem instanceof DefineVideoStreamTag) {
                        new PlaceObject2Tag(swf, false, 1, chtId, mat, null, -1, null, -1, null).writeTag(sos2);
                        ArrayList frs = new ArrayList(videoFrames.values());
                        Collections.sort(frs, new Comparator<VideoFrameTag>(){

                            @Override
                            public int compare(VideoFrameTag o1, VideoFrameTag o2) {
                                return o1.frameNum - o2.frameNum;
                            }
                        });
                        boolean first = true;
                        boolean bl = false;
                        for (VideoFrameTag f : frs) {
                            if (!first) {
                                void var23_49;
                                new PlaceObject2Tag(swf, true, 1, -1, null, null, (int)(++var23_49), null, -1, null).writeTag(sos2);
                            }
                            f.writeTag(sos2);
                            new ShowFrameTag(swf).writeTag(sos2);
                            first = false;
                        }
                    } else if (treeItem instanceof DefineSpriteTag) {
                        Tag t;
                        DefineSpriteTag s = (DefineSpriteTag)treeItem;
                        Tag lastTag = null;
                        Iterator iterator = s.getTags().iterator();
                        while (iterator.hasNext() && !((t = (Tag)iterator.next()) instanceof EndTag)) {
                            if (t instanceof PlaceObjectTypeTag) {
                                PlaceObjectTypeTag pt = (PlaceObjectTypeTag)t;
                                MATRIX m = pt.getMatrix();
                                MATRIX m2 = new Matrix(m).preConcatenate(new Matrix(mat)).toMATRIX();
                                pt.writeTagWithMatrix(sos2, m2);
                                lastTag = t;
                                continue;
                            }
                            t.writeTag(sos2);
                            lastTag = t;
                        }
                        if (!s.getTags().isEmpty() && lastTag != null && !(lastTag instanceof ShowFrameTag)) {
                            new ShowFrameTag(swf).writeTag(sos2);
                        }
                    } else {
                        new PlaceObject2Tag(swf, false, 1, chtId, mat, null, 0, null, -1, null).writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                    }
                }
                new EndTag(swf).writeTag(sos2);
                data = baos.toByteArray();
            }
            var10_12 = null;
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                SWFOutputStream sos = new SWFOutputStream((OutputStream)fos, Math.max(10, swf.version));
                sos.write("FWS".getBytes());
                sos.write(swf.version);
                sos.writeUI32(sos.getPos() + (long)data.length + 4L);
                sos.write(data);
                ((OutputStream)fos).flush();
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            if (this.flashPanel != null) {
                this.flashPanel.displaySWF(this.tempFile.getAbsolutePath(), backgroundColor, frameRate);
            }
            this.showFlashViewerPanel();
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showSwf(SWF swf) {
        Color backgroundColor = View.getDefaultBackgroundColor();
        SetBackgroundColorTag setBgColorTag = swf.getBackgroundColor();
        if (setBgColorTag != null) {
            backgroundColor = setBgColorTag.backgroundColor.toColor();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        try {
            this.tempFile = File.createTempFile("ffdec_view_", ".swf");
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                swf.saveTo((OutputStream)fos, false);
            }
            if (swf.isAS3() && ((Boolean)Configuration.autoOpenLoadedSWFs.get()).booleanValue() && !((Boolean)Configuration.internalFlashViewer.get()).booleanValue() && !DebuggerTools.hasDebugger(swf)) {
                SWF instrSWF;
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(this.tempFile));){
                    instrSWF = new SWF((InputStream)fis, false, false);
                }
                DebuggerTools.switchDebugger(instrSWF);
                DebuggerTools.injectDebugLoader(instrSWF);
                var6_10 = null;
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                    instrSWF.saveTo((OutputStream)fos);
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
            }
            this.flashPanel.displaySWF(this.tempFile.getAbsolutePath(), backgroundColor, swf.frameRate);
        }
        catch (IOException iex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, "Cannot create tempfile", iex);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void editMetadataButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.tagTree.getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof MetadataTag) {
            this.metadataEditor.setEditable(true);
            this.updateMetadataButtonsVisibility();
        }
    }

    private void saveMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataTag.xmlMetadata = this.metadataEditor.getText().replaceAll(">\r?\n<", "> <");
        this.metadataTag.setModified(true);
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.mainPanel.repaintTree();
    }

    private void cancelMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(this.metadataTag.xmlMetadata, 4));
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
    }

    private void editGenericTagButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.tagTree.getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if (item instanceof Tag) {
            this.genericEditButton.setVisible(false);
            this.genericSaveButton.setVisible(true);
            this.genericCancelButton.setVisible(true);
            this.genericTagPanel.setEditMode(true, (Tag)item);
        }
    }

    private void saveGenericTagButtonActionPerformed(ActionEvent evt) {
        if (this.genericTagPanel.save()) {
            Tag tag = this.genericTagPanel.getTag();
            SWF swf = tag.getSwf();
            swf.clearImageCache();
            swf.updateCharacters();
            tag.getTimelined().resetTimeline();
            swf.assignClassesToSymbols();
            swf.assignExportNamesToSymbols();
            this.mainPanel.refreshTree(swf);
            this.mainPanel.setTagTreeSelectedNode((TreeItem)tag);
            this.genericEditButton.setVisible(true);
            this.genericSaveButton.setVisible(false);
            this.genericCancelButton.setVisible(false);
            this.genericTagPanel.setEditMode(false, null);
        }
    }

    private void cancelGenericTagButtonActionPerformed(ActionEvent evt) {
        this.genericEditButton.setVisible(true);
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton.setVisible(false);
        this.genericTagPanel.setEditMode(false, null);
    }

    private void prevFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + pageCount - 1) % pageCount;
        if (this.mainPanel.isInternalFlashViewerSelected()) {
            this.imagePanel.setTimelined(MainPanel.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0);
        }
    }

    private void nextFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + 1) % pageCount;
        if (this.mainPanel.isInternalFlashViewerSelected()) {
            this.imagePanel.setTimelined(MainPanel.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0);
        }
    }

    @Override
    public boolean tryAutoSave() {
        if (this.textPanel.tryAutoSave()) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean isEditing() {
        return this.textPanel.isEditing() || this.genericSaveButton.isVisible() && this.genericSaveButton.isEnabled() || this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled();
    }
}

