/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public interface MenuBuilder {
    public static final int PRIORITY_LOW = 1;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_TOP = 3;

    public void initMenu();

    public void addSeparator(String var1);

    public void addMenuItem(String var1, String var2, String var3, ActionListener var4, int var5, ActionListener var6, boolean var7, HotKey var8, boolean var9);

    public void addToggleMenuItem(String var1, String var2, String var3, String var4, ActionListener var5, int var6, HotKey var7);

    public boolean isMenuChecked(String var1);

    public HotKey getMenuHotkey(String var1);

    public void setMenuChecked(String var1, boolean var2);

    public void setGroupSelection(String var1, String var2);

    public String getGroupSelection(String var1);

    public void clearMenu(String var1);

    public void setMenuEnabled(String var1, boolean var2);

    public void finishMenu(String var1);

    public boolean supportsMenuAction();

    public boolean supportsAppMenu();

    public static class HotKey {
        private static Map<Integer, String> keyCodesToNames = new HashMap<Integer, String>();
        private static Map<String, Integer> keyNamesToCodes = new HashMap<String, Integer>();
        public int key;
        public boolean shiftDown;
        public boolean ctrlDown;
        public boolean altDown;

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.key;
            hash = 41 * hash + (this.shiftDown ? 1 : 0);
            hash = 41 * hash + (this.ctrlDown ? 1 : 0);
            hash = 41 * hash + (this.altDown ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HotKey other = (HotKey)obj;
            if (this.key != other.key) {
                return false;
            }
            if (this.shiftDown != other.shiftDown) {
                return false;
            }
            if (this.ctrlDown != other.ctrlDown) {
                return false;
            }
            return this.altDown == other.altDown;
        }

        public boolean matches(KeyEvent ev) {
            return ev.getKeyCode() == this.key && ev.isControlDown() == this.ctrlDown && ev.isShiftDown() == this.shiftDown && ev.isAltDown() == this.altDown;
        }

        public int getModifier() {
            return (this.shiftDown ? 1 : 0) + (this.ctrlDown ? 2 : 0) + (this.altDown ? 8 : 0);
        }

        public HotKey(String h) {
            String[] parts;
            String[] stringArray;
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                if (!fieldName.startsWith("VK")) continue;
                try {
                    int keyCode = fields[i].getInt(null);
                    String keyName = fieldName.substring(3);
                    keyCodesToNames.put(keyCode, keyName);
                    keyNamesToCodes.put(keyName, keyCode);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (h.contains("+")) {
                stringArray = h.split("\\+");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = h;
            }
            String[] stringArray3 = parts = stringArray;
            int n = stringArray3.length;
            block13: for (int i = 0; i < n; ++i) {
                String s;
                switch (s = stringArray3[i]) {
                    case "SHIFT": {
                        this.shiftDown = true;
                        continue block13;
                    }
                    case "CTRL": {
                        this.ctrlDown = true;
                        continue block13;
                    }
                    case "ALT": {
                        this.altDown = true;
                        continue block13;
                    }
                    default: {
                        if (keyNamesToCodes.containsKey(s)) {
                            this.key = keyNamesToCodes.get(s);
                            continue block13;
                        }
                        throw new IllegalArgumentException("Key " + s + " not found!");
                    }
                }
            }
        }

        public HotKey(KeyEvent ev) {
            this(ev.getKeyCode(), ev.isShiftDown(), ev.isControlDown(), ev.isAltDown());
        }

        public HotKey(int key) {
            this(key, false, false, false);
        }

        public HotKey(int key, boolean shiftDown, boolean ctrlDown, boolean altDown) {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                if (!fieldName.startsWith("VK")) continue;
                try {
                    int keyCode = fields[i].getInt(null);
                    String keyName = fieldName.substring(3);
                    keyCodesToNames.put(keyCode, keyName);
                    keyNamesToCodes.put(keyName, keyCode);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.key = key;
            this.shiftDown = shiftDown;
            this.ctrlDown = ctrlDown;
            this.altDown = altDown;
        }

        public String toString() {
            String s = "";
            if (this.shiftDown) {
                s = s + "SHIFT";
            }
            if (this.ctrlDown) {
                if (!s.isEmpty()) {
                    s = s + "+";
                }
                s = s + "CTRL";
            }
            if (this.altDown) {
                if (!s.isEmpty()) {
                    s = s + "+";
                }
                s = s + "ALT";
            }
            if (!s.isEmpty()) {
                s = s + "+";
            }
            s = s + keyCodesToNames.get(this.key);
            return s;
        }
    }
}

