/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.MainFrameClassic;
import com.jpexs.decompiler.flash.gui.MainFrameMenu;
import com.jpexs.decompiler.flash.gui.MenuBuilder;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrameClassicMenu
extends MainFrameMenu {
    private final MainFrameClassic mainFrame;
    private final Map<String, MenuElement> menuElements = new HashMap<String, MenuElement>();
    private final Map<String, Set<String>> menuGroups = new HashMap<String, Set<String>>();
    private final Map<String, ButtonGroup> menuButtonGroups = new HashMap<String, ButtonGroup>();

    public MainFrameClassicMenu(MainFrameClassic mainFrame, boolean externalFlashPlayerUnavailable) {
        super(mainFrame, externalFlashPlayerUnavailable);
        this.mainFrame = mainFrame;
    }

    private void addMenu(String path, String title, String icon, final ActionListener subLoader) {
        MenuElement parentMenu;
        final String fpath = path = this.mapping(path);
        if (path.equals("_") || path.startsWith("_/")) {
            return;
        }
        String parentPath = "";
        if (path.contains("/")) {
            parentPath = path.substring(0, path.lastIndexOf(47));
        }
        if ((parentMenu = this.menuElements.get(parentPath)) == null) {
            throw new IllegalArgumentException("Parent menu " + path + " does not exist");
        }
        final JMenu menu = new JMenu(title);
        if (icon != null) {
            menu.setIcon(View.getIcon(icon, 16));
        }
        if (parentMenu instanceof JMenuBar) {
            ((JMenuBar)parentMenu).add(menu);
        }
        if (parentMenu instanceof JMenu) {
            ((JMenu)parentMenu).add(menu);
            if (subLoader != null) {
                ((JMenu)parentMenu).addMenuListener(new MenuListener(){

                    @Override
                    public void menuSelected(MenuEvent e) {
                        subLoader.actionPerformed(new ActionEvent(menu, 0, "load:" + fpath));
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }
                });
            }
        }
        this.menuElements.put(path, menu);
    }

    @Override
    public void addMenuItem(String path, String title, String icon, ActionListener action, int priority, ActionListener subLoader, boolean isLeaf, MenuBuilder.HotKey key, boolean isOptional) {
        MenuElement parentMenu;
        path = this.mapping(path);
        this.menuHotkeys.put(path, key);
        this.menuActions.put(path, action);
        if (!isLeaf) {
            this.addMenu(path, title, icon, subLoader);
            return;
        }
        if (path.startsWith("_/")) {
            return;
        }
        String parentPath = "";
        if (path.contains("/")) {
            parentPath = path.substring(0, path.lastIndexOf(47));
        }
        if ((parentMenu = this.menuElements.get(parentPath)) == null) {
            throw new IllegalArgumentException("Parent menu " + path + " does not exist");
        }
        JMenuItem menuItem = new JMenuItem(title);
        if (icon != null) {
            menuItem.setIcon(View.getIcon(icon, 16));
        }
        if (action != null) {
            menuItem.addActionListener(action);
        }
        if (key != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(key.key, key.getModifier()));
        }
        if (!(parentMenu instanceof JMenu)) {
            throw new IllegalArgumentException("Parent path " + path + " is not a menu");
        }
        ((JMenu)parentMenu).add(menuItem);
        this.menuElements.put(path, menuItem);
    }

    @Override
    public void addToggleMenuItem(String path, String title, String group, String icon, ActionListener action, int priority, MenuBuilder.HotKey key) {
        JMenuItem menuItem;
        MenuElement parentMenu;
        path = this.mapping(path);
        this.menuHotkeys.put(path, key);
        String parentPath = "";
        if (path.contains("/")) {
            parentPath = path.substring(0, path.lastIndexOf(47));
        }
        if ((parentMenu = this.menuElements.get(parentPath)) == null) {
            throw new IllegalArgumentException("Parent menu " + path + " does not exist");
        }
        if (group == null) {
            menuItem = new JCheckBoxMenuItem(title);
        } else {
            menuItem = new JRadioButtonMenuItem(title);
            if (!this.menuGroups.containsKey(group)) {
                this.menuGroups.put(group, new HashSet());
            }
            if (!this.menuButtonGroups.containsKey(group)) {
                this.menuButtonGroups.put(group, new ButtonGroup());
            }
            this.menuGroups.get(group).add(path);
            this.menuButtonGroups.get(group).add(menuItem);
        }
        if (icon != null) {
            menuItem.setIcon(View.getIcon(icon, 16));
        }
        if (action != null) {
            menuItem.addActionListener(action);
        }
        if (!(parentMenu instanceof JMenu)) {
            throw new IllegalArgumentException("Parent path " + path + " is not a menu");
        }
        ((JMenu)parentMenu).add(menuItem);
        this.menuElements.put(path, menuItem);
    }

    @Override
    public String getGroupSelection(String group) {
        if (!this.menuGroups.containsKey(group)) {
            return null;
        }
        for (String path : this.menuGroups.get(group)) {
            if (!this.isMenuChecked(path)) continue;
            return path;
        }
        return null;
    }

    @Override
    public void clearMenu(String path) {
        if ((path = this.mapping(path)).equals("_") || path.startsWith("_/")) {
            return;
        }
        MenuElement menu = this.menuElements.get(path);
        if (menu == null) {
            throw new IllegalArgumentException("Menu " + path + " does not exist");
        }
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).removeAll();
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).removeAll();
        } else {
            throw new IllegalArgumentException(path + " is not a menu");
        }
    }

    @Override
    public void setMenuEnabled(String path, boolean enabled) {
        if ((path = this.mapping(path)).equals("_") || path.startsWith("_/")) {
            return;
        }
        MenuElement menu = this.menuElements.get(path);
        if (menu == null) {
            throw new IllegalArgumentException("Menu " + path + " does not exist");
        }
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).setEnabled(enabled);
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).setEnabled(enabled);
        } else if (menu instanceof JMenuItem) {
            ((JMenuItem)menu).setEnabled(enabled);
        } else {
            throw new IllegalArgumentException(path + " is not a menu");
        }
    }

    @Override
    public boolean isMenuChecked(String path) {
        MenuElement menu = this.menuElements.get(path = this.mapping(path));
        if (menu == null) {
            throw new IllegalArgumentException("Menu " + path + " does not exist");
        }
        if (menu instanceof JCheckBoxMenuItem) {
            return ((JCheckBoxMenuItem)menu).isSelected();
        }
        if (menu instanceof JRadioButtonMenuItem) {
            return ((JRadioButtonMenuItem)menu).isSelected();
        }
        throw new IllegalArgumentException(path + " is not selectable menu item");
    }

    @Override
    public void setMenuChecked(String path, boolean checked) {
        MenuElement menu = this.menuElements.get(path = this.mapping(path));
        if (menu == null) {
            throw new IllegalArgumentException("Menu " + path + " does not exist");
        }
        if (menu instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)menu).setSelected(checked);
        } else if (menu instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)menu).setSelected(checked);
        } else {
            throw new IllegalArgumentException(path + " is not selectable menu item");
        }
    }

    @Override
    public void setGroupSelection(String group, String selected) {
        selected = this.mapping(selected);
        for (String path : this.menuGroups.get(group)) {
            this.setMenuChecked(path, path.equals(selected));
        }
    }

    @Override
    public void initMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.menuElements.put("", menuBar);
        this.mainFrame.setJMenuBar(menuBar);
    }

    @Override
    public void finishMenu(String path) {
        JMenu jm;
        if ((path = this.mapping(path)).equals("_") || path.startsWith("_/")) {
            return;
        }
        if (!this.menuElements.containsKey(path)) {
            throw new IllegalArgumentException("Invalid menu: " + path);
        }
        if (path.startsWith("/file/recent")) {
            return;
        }
        MenuElement me = this.menuElements.get(path);
        if (me instanceof JMenu && (jm = (JMenu)me).getMenuComponentCount() == 1) {
            String parentPath = path.contains("/") ? path.substring(0, path.lastIndexOf(47)) : "";
            MenuElement parMe = this.menuElements.get(parentPath);
            JMenuItem mi = (JMenuItem)jm.getMenuComponent(0);
            jm.remove(mi);
            if (parMe instanceof JMenu) {
                JMenu parMenu = (JMenu)parMe;
                parMenu.remove(jm);
                parMenu.add(mi);
            } else if (parMe instanceof JMenuBar) {
                JMenuBar parMenuBar = (JMenuBar)parMe;
                parMenuBar.remove(jm);
                parMenuBar.add(mi);
            }
        }
    }

    @Override
    public void addSeparator(String parentPath) {
        if ((parentPath = this.mapping(parentPath)).equals("_") || parentPath.startsWith("_/")) {
            return;
        }
        if (!this.menuElements.containsKey(parentPath)) {
            throw new IllegalArgumentException("Menu does not exist: " + parentPath);
        }
        MenuElement parent = this.menuElements.get(parentPath);
        if (!(parent instanceof JMenu)) {
            throw new IllegalArgumentException("Not a menu: " + parentPath);
        }
        ((JMenu)parent).addSeparator();
    }

    @Override
    public boolean supportsMenuAction() {
        return false;
    }

    @Override
    public boolean supportsAppMenu() {
        return false;
    }

    private String mapping(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("/file/view", "/view");
        for (String k : map.keySet()) {
            String v = (String)map.get(k);
            if (!s.startsWith(k)) continue;
            s = v + s.substring(k.length());
            return s;
        }
        return s;
    }

    @Override
    public void hilightPath(String path) {
    }

    @Override
    public void setPathVisible(String path, boolean val) {
        MenuElement me = this.menuElements.get(path);
        if (me instanceof JComponent) {
            ((JComponent)((Object)me)).setVisible(val);
        }
    }
}

