/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWFSourceInfo;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.SearchInMemory;
import com.jpexs.decompiler.flash.gui.SearchInMemoryListener;
import com.jpexs.decompiler.flash.gui.SwfInMemory;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReReadableInputStream;
import com.jpexs.process.Process;
import com.jpexs.process.ProcessTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class LoadFromMemoryFrame
extends AppFrame {
    private MainFrame mainFrame;
    private List<Process> processList;
    private List<SwfInMemory> foundIs;
    private List<Process> selProcesses;
    private JList<Process> list;
    private DefaultListModel<Process> model;
    private DefaultTableModel resTableModel;
    private final JTable tableRes;
    private final JLabel stateLabel;
    private boolean processing = false;
    private final JProgressBar progress;

    private void addResultRow(SwfInMemory swf) {
        if (swf != null) {
            Process process = swf.process;
            this.resTableModel.addRow(new Object[]{swf.version, swf.fileSize, process.getPid(), process.getFileName(), swf.address});
        } else {
            String notFound = this.translate("notfound");
            this.resTableModel.addRow(new Object[]{notFound, 0, "", "", 0});
        }
    }

    private void refreshList() {
        this.model.clear();
        this.processList = ProcessTools.listProcesses();
        if (this.processList != null) {
            Collections.sort(this.processList);
            for (Process p : this.processList) {
                this.model.addElement(p);
            }
        }
    }

    private void openSwf() {
        if (this.foundIs == null) {
            return;
        }
        int index = this.tableRes.getRowSorter().convertRowIndexToModel(this.tableRes.getSelectedRow());
        if (index > -1) {
            SwfInMemory swf = this.foundIs.get(index);
            ReReadableInputStream str = swf.is;
            try {
                str.seek(0L);
            }
            catch (IOException ex) {
                Logger.getLogger(LoadFromMemoryFrame.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            str.mark(Integer.MAX_VALUE);
            SWFSourceInfo sourceInfo = new SWFSourceInfo((InputStream)str, null, swf.process + " [" + (index + 1) + "]");
            Main.openFile(sourceInfo);
        }
    }

    private void selectProcess() {
        if (this.processing) {
            return;
        }
        this.selProcesses = this.list.getSelectedValuesList();
        if (!this.selProcesses.isEmpty()) {
            this.processing = true;
            this.tableRes.setEnabled(false);
            this.resTableModel.getDataVector().removeAllElements();
            this.resTableModel.fireTableDataChanged();
            this.foundIs = null;
            this.progress.setIndeterminate(true);
            this.progress.setString(this.translate("searching"));
            this.progress.setStringPainted(true);
            this.progress.setVisible(true);
            SelectProcessWorker wrk = new SelectProcessWorker(this.selProcesses);
            wrk.addPropertyChangeListener(evt -> {
                switch (evt.getPropertyName()) {
                    case "progress": {
                        this.progress.setIndeterminate(false);
                        this.progress.setStringPainted(false);
                        this.progress.setValue((Integer)evt.getNewValue());
                        break;
                    }
                    case "state": {
                        if ((SwingWorker.StateValue)((Object)((Object)evt.getNewValue())) != SwingWorker.StateValue.DONE) break;
                        try {
                            this.foundIs = (List)wrk.get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Logger.getLogger(LoadFromMemoryFrame.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        if (this.foundIs == null) {
                            this.addResultRow(null);
                        }
                        this.tableRes.setEnabled(this.foundIs != null);
                        this.progress.setVisible(false);
                        this.processing = false;
                    }
                }
            });
            wrk.execute();
        }
    }

    public LoadFromMemoryFrame(final MainFrame mainFrame) {
        this.setSize(800, 600);
        this.setTitle(this.translate("dialog.title"));
        this.mainFrame = mainFrame;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!mainFrame.isVisible()) {
                    mainFrame.setVisible(true);
                }
            }
        });
        this.model = new DefaultListModel();
        this.resTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Integer.class;
                    }
                    case 1: {
                        return Integer.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return String.class;
                    }
                    case 4: {
                        return Long.class;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.resTableModel.addColumn(this.translate("column.version"));
        this.resTableModel.addColumn(this.translate("column.fileSize"));
        this.resTableModel.addColumn(this.translate("column.pid"));
        this.resTableModel.addColumn(this.translate("column.processName"));
        this.resTableModel.addColumn(this.translate("column.address"));
        this.tableRes = new JTable(this.resTableModel);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.resTableModel);
        this.tableRes.setRowSorter(sorter);
        this.list = new JList<Process>(this.model);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoadFromMemoryFrame.this.selectProcess();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    LoadFromMemoryFrame.this.selectProcess();
                }
            }
        });
        this.tableRes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    LoadFromMemoryFrame.this.openSwf();
                }
            }
        });
        this.tableRes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoadFromMemoryFrame.this.openSwf();
                }
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Process && ((Process)value).getIcon() != null) {
                    label.setIcon(new ImageIcon(((Process)value).getIcon()));
                }
                if (!isSelected) {
                    label.setBackground(Color.white);
                }
                return label;
            }
        });
        this.refreshList();
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)new JScrollPane(this.list), "Center");
        JPanel leftButtonsPanel = new JPanel(new FlowLayout());
        JButton selectButton = new JButton(this.translate("button.select"));
        selectButton.addActionListener(this::selectProcessButtonActionPerformed);
        JButton refreshButton = new JButton(this.translate("button.refresh"));
        refreshButton.addActionListener(this::refreshProcessListButtonActionPerformed);
        leftButtonsPanel.add(selectButton);
        leftButtonsPanel.add(refreshButton);
        leftPanel.add((Component)leftButtonsPanel, "South");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)new JScrollPane(this.tableRes), "Center");
        JPanel rightButtonsPanel = new JPanel(new FlowLayout());
        JButton openButton = new JButton(this.translate("button.open"));
        openButton.addActionListener(this::openSwfButtonActionPerformed);
        JButton saveButton = new JButton(this.translate("button.save"));
        saveButton.addActionListener(this::saveButtonActionPerformed);
        rightButtonsPanel.add(openButton);
        rightButtonsPanel.add(saveButton);
        rightPanel.add((Component)rightButtonsPanel, "South");
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BoxLayout(statePanel, 1));
        this.stateLabel = new JLabel(this.translate("noprocess"));
        statePanel.add(this.stateLabel);
        this.progress = new JProgressBar(0, 100);
        statePanel.add(this.progress);
        this.progress.setVisible(false);
        rightPanel.add((Component)statePanel, "North");
        cnt.add((Component)new JSplitPane(1, leftPanel, rightPanel), "Center");
        View.setWindowIcon(this);
        View.centerScreen(this);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage("loadmemory16"));
        images.add(View.loadImage("loadmemory32"));
        this.setIconImages(images);
    }

    private void selectProcessButtonActionPerformed(ActionEvent evt) {
        this.selectProcess();
    }

    private void openSwfButtonActionPerformed(ActionEvent evt) {
        this.openSwf();
    }

    private void refreshProcessListButtonActionPerformed(ActionEvent evt) {
        this.refreshList();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.foundIs == null) {
            return;
        }
        int[] selected = this.tableRes.getSelectedRows();
        if (selected.length > 0) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
            if (selected.length > 1) {
                fc.setFileSelectionMode(1);
            } else {
                fc.setSelectedFile(new File((String)Configuration.lastSaveDir.get(), "movie.swf"));
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".swf") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return AppStrings.translate("filter.swf");
                    }
                });
            }
            fc.setAcceptAllFileFilterUsed(false);
            JFrame f = new JFrame();
            View.setWindowIcon(f);
            if (fc.showSaveDialog(f) == 0) {
                File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                try {
                    if (selected.length == 1) {
                        SwfInMemory swf = this.foundIs.get(this.tableRes.getRowSorter().convertRowIndexToModel(selected[0]));
                        ReReadableInputStream bis = swf.is;
                        bis.seek(0L);
                        Helper.saveStream((InputStream)bis, (File)file);
                    } else {
                        for (int sel : selected) {
                            SwfInMemory swf = this.foundIs.get(this.tableRes.getRowSorter().convertRowIndexToModel(sel));
                            ReReadableInputStream bis = swf.is;
                            bis.seek(0L);
                            Helper.saveStream((InputStream)bis, (File)new File(file, "movie" + sel + ".swf"));
                        }
                    }
                    Configuration.lastSaveDir.set((Object)file.getParentFile().getAbsolutePath());
                }
                catch (IOException ex) {
                    View.showMessageDialog(null, this.translate("error.file.write"));
                }
            }
        }
    }

    private class SelectProcessWorker
    extends SwingWorker<List<SwfInMemory>, Object> {
        private final List<Process> procs;

        public SelectProcessWorker(List<Process> procs) {
            this.procs = procs;
        }

        @Override
        protected void process(List<Object> chunks) {
            for (Object s : chunks) {
                if (s instanceof Process) {
                    LoadFromMemoryFrame.this.stateLabel.setText(s.toString());
                }
                if (!(s instanceof SwfInMemory)) continue;
                SwfInMemory swf = (SwfInMemory)s;
                LoadFromMemoryFrame.this.addResultRow(swf);
            }
        }

        @Override
        protected List<SwfInMemory> doInBackground() throws Exception {
            return new SearchInMemory(new SearchInMemoryListener(){

                @Override
                public void publish(Object ... chunks) {
                    SelectProcessWorker.this.publish(chunks);
                }

                @Override
                public void setProgress(int progress) {
                    SelectProcessWorker.this.setProgress(progress);
                }
            }).search(this.procs);
        }
    }
}

