/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import java.io.IOException;
import java.io.InputStream;

public class IndexInputStream
extends InputStream {
    private final InputStream is;
    public long pos = 0L;

    public long getPos() {
        return this.pos;
    }

    public IndexInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int r = this.is.read();
        ++this.pos;
        return r;
    }

    public long readUInt32() throws IOException {
        long r = (long)this.read() + (long)(this.read() << 8) + (long)(this.read() << 16) + (long)(this.read() << 24) & 0xFFFFFFFFL;
        return r;
    }

    public long readUInt64() throws IOException {
        return this.readUInt32() + (this.readUInt32() << 32);
    }

    public long readInt64() throws IOException {
        return this.readUInt64();
    }

    public int readInt32() throws IOException {
        return (int)this.readUInt32();
    }

    public int readInt16() throws IOException {
        return (short)(this.read() + (this.read() << 8));
    }

    public long readInt() throws IOException {
        return this.readInt32();
    }

    public String readString() throws IOException {
        int len = (int)this.readInt();
        byte[] data = new byte[len];
        if (this.read(data) != len) {
            throw new IOException();
        }
        return new String(data);
    }
}

