/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFBorder;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFAnnot
extends PDFObject
implements Serializable {
    public static final short SOLID = 0;
    public static final short DASHED = 1;
    public static final short BEVELED = 2;
    public static final short INSET = 3;
    public static final short UNDERLINED = 4;
    private String subtype;
    private int l;
    private int b;
    private int r;
    private int t;
    private String s;
    private static final int FULL_PAGE = -9999;
    private PDFObject dest;
    private int fl;
    private int fb;
    private int fr;
    private int ft;
    private PDFBorder border;

    protected PDFAnnot(String s, int l, int b, int r, int t) {
        super("/Annot");
        this.subtype = s;
        this.l = l;
        this.b = b;
        this.r = r;
        this.t = t;
    }

    public PDFAnnot(int l, int b, int r, int t, String s) {
        this("/Text", l, b, r, t);
        this.s = s;
    }

    public PDFAnnot(int l, int b, int r, int t, PDFObject dest) {
        this("/Link", l, b, r, t);
        this.dest = dest;
        this.fl = -9999;
    }

    public PDFAnnot(int l, int b, int r, int t, PDFObject dest, int fl, int fb, int fr, int ft) {
        this("/Link", l, b, r, t);
        this.dest = dest;
        this.fl = fl;
        this.fb = fb;
        this.fr = fr;
        this.ft = ft;
    }

    public void setBorder(short style, double width) {
        this.border = new PDFBorder(style, width);
        this.pdfDocument.add(this.border);
    }

    public void setBorder(double width, double[] dash) {
        this.border = new PDFBorder(width, dash);
        this.pdfDocument.add(this.border);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        os.write("/Subtype ".getBytes());
        os.write(this.subtype.getBytes());
        os.write("\n/Rect [".getBytes());
        os.write(Integer.toString(this.l).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString(this.b).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString(this.r).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString(this.t).getBytes());
        os.write("]\n".getBytes());
        if (this.border == null) {
            os.write("/Border [0 0 0]\n".getBytes());
        } else {
            os.write("/BS ".getBytes());
            os.write(this.border.toString().getBytes());
            os.write("\n".getBytes());
        }
        if (this.subtype.equals("/Text")) {
            os.write("/Contents ".getBytes());
            os.write(PDFStringHelper.makePDFString(this.s).getBytes());
            os.write("\n".getBytes());
        } else if (this.subtype.equals("/Link")) {
            os.write("/Dest [".getBytes());
            os.write(this.dest.toString().getBytes());
            if (this.fl == -9999) {
                os.write(" /Fit]".getBytes());
            } else {
                os.write(" /FitR ".getBytes());
                os.write(Integer.toString(this.fl).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.fb).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.fr).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.ft).getBytes());
                os.write("]".getBytes());
            }
            os.write("\n".getBytes());
        }
        this.writeEnd(os);
    }
}

