/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.FinalProcessLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.EqualsTypeItem;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartMulti;
import com.jpexs.decompiler.graph.GraphPartQueue;
import com.jpexs.decompiler.graph.GraphPath;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.MarkItem;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.DoWhileItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.ForItem;
import com.jpexs.decompiler.graph.model.GotoItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.IntegerValueItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LabelItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LogicalOpItem;
import com.jpexs.decompiler.graph.model.LoopItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.UniversalLoopItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Graph {
    public List<GraphPart> heads;
    protected GraphSource code;
    private final List<Integer> alternateEntries;
    public static final int SOP_USE_STATIC = 0;
    public static final int SOP_SKIP_STATIC = 1;
    public static final int SOP_REMOVE_STATIC = 2;
    public static final String INDENTOPEN = "INDENTOPEN";
    public static final String INDENTCLOSE = "INDENTCLOSE";

    public Map<GraphPart, List<GraphPart>> identifyLoopBreaks(BaseLocalData localData, Set<GraphPart> allParts) {
        HashMap<GraphPart, List<GraphPart>> lb = new HashMap<GraphPart, List<GraphPart>>();
        for (GraphPart b0 : allParts) {
            ArrayList<GraphPart> np = new ArrayList<GraphPart>(b0.nextParts);
            np.addAll(b0.throwParts);
            for (GraphPart b : np) {
                GraphPart hdr = b0.type == 1 || b0.type == 2 ? b0 : b0.iloop_header;
                if (hdr == null || b.iloop_header == hdr || b.iloop_header != hdr.iloop_header || b == hdr) continue;
                if (!lb.containsKey(hdr)) {
                    lb.put(hdr, new ArrayList());
                }
                if (((List)lb.get(hdr)).contains(b)) continue;
                ((List)lb.get(hdr)).add(b);
            }
        }
        return lb;
    }

    public void identifyLoops(BaseLocalData localData, List<GraphPart> loopContinues, List<GraphPart> heads, Set<GraphPart> appParts) {
        for (GraphPart b : appParts) {
            b.traversed = false;
            b.DFSP_pos = 0;
            b.irreducible = false;
            b.type = 0;
        }
        for (GraphPart h0 : heads) {
            this.trav_loops_DFS(localData, loopContinues, h0, 1);
        }
    }

    protected void tag_lhead(GraphPart b, GraphPart h) {
        if (b == h || h == null) {
            return;
        }
        GraphPart cur1 = b;
        GraphPart cur2 = h;
        while (cur1.iloop_header != null) {
            GraphPart ih = cur1.iloop_header;
            if (ih == cur2) {
                return;
            }
            if (ih.DFSP_pos < cur2.DFSP_pos) {
                cur1.iloop_header = cur2;
                cur1 = cur2;
                cur2 = ih;
                continue;
            }
            cur1 = h;
        }
        if (cur1 == cur2) {
            return;
        }
        cur1.iloop_header = cur2;
    }

    protected List<GraphTargetItem> filter(List<GraphTargetItem> list) {
        return new ArrayList<GraphTargetItem>(list);
    }

    protected GraphPart trav_loops_DFS(BaseLocalData localData, List<GraphPart> loopHeaders, GraphPart b0, int DFSP_pos) {
        ArrayList<GraphPart> folParts = new ArrayList<GraphPart>(b0.nextParts);
        folParts.addAll(b0.throwParts);
        b0.traversed = true;
        b0.DFSP_pos = DFSP_pos;
        block0: for (GraphPart b : folParts) {
            if ((b = this.checkPart(null, localData, b, null)) == null) continue;
            if (!b.traversed) {
                GraphPart nh = this.trav_loops_DFS(localData, loopHeaders, b, DFSP_pos + 1);
                this.tag_lhead(b0, nh);
                continue;
            }
            if (b.DFSP_pos > 0) {
                if (b.type != 1) {
                    b.type = 1;
                    loopHeaders.add(b);
                }
                this.tag_lhead(b0, b);
                continue;
            }
            if (b.iloop_header == null) continue;
            GraphPart h = b.iloop_header;
            if (h.DFSP_pos > 0) {
                this.tag_lhead(b0, h);
                continue;
            }
            b.type = 2;
            h.irreducible = true;
            while (h.iloop_header != null) {
                h = h.iloop_header;
                if (h.DFSP_pos > 0) {
                    this.tag_lhead(b0, h);
                    continue block0;
                }
                h.irreducible = true;
            }
        }
        b0.DFSP_pos = 0;
        return b0.iloop_header;
    }

    public Graph(GraphSource code, List<Integer> alternateEntries) {
        this.code = code;
        this.alternateEntries = alternateEntries;
    }

    public void init(BaseLocalData localData) throws InterruptedException {
        if (this.heads != null) {
            return;
        }
        this.heads = this.makeGraph(this.code, new ArrayList<GraphPart>(), this.alternateEntries);
        int time = 1;
        ArrayList<GraphPart> ordered = new ArrayList<GraphPart>();
        ArrayList<GraphPart> visited = new ArrayList<GraphPart>();
        for (GraphPart head : this.heads) {
            time = head.setTime(time, ordered, visited);
        }
    }

    protected static void populateParts(GraphPart part, Set<GraphPart> allParts) {
        if (allParts.contains(part)) {
            return;
        }
        allParts.add(part);
        for (GraphPart p : part.nextParts) {
            Graph.populateParts(p, allParts);
        }
    }

    public GraphPart deepCopy(GraphPart part) {
        return this.deepCopy(part, new HashMap<GraphPart, GraphPart>());
    }

    private GraphPart deepCopy(GraphPart part, Map<GraphPart, GraphPart> copies) {
        int i;
        GraphPart copy = copies.get(part);
        if (copy != null) {
            return copy;
        }
        copy = new GraphPart(part.start, part.end);
        copy.path = part.path;
        copies.put(part, copy);
        copy.nextParts = new ArrayList<GraphPart>();
        for (i = 0; i < part.nextParts.size(); ++i) {
            copy.nextParts.add(this.deepCopy(part.nextParts.get(i), copies));
        }
        for (i = 0; i < part.refs.size(); ++i) {
            copy.refs.add(this.deepCopy(part.refs.get(i), copies));
        }
        return copy;
    }

    public void resetGraph(GraphPart part, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        int pos = 0;
        for (GraphPart p : part.nextParts) {
            if (!visited.contains(p)) {
                p.path = part.path.sub(pos, p.end);
            }
            this.resetGraph(p, visited);
            ++pos;
        }
    }

    private void getReachableParts(GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops) {
        this.getReachableParts(part, ret, loops, true);
    }

    private void getReachableParts(GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops, boolean first) {
        Stack<GraphPartQueue> stack = new Stack<GraphPartQueue>();
        GraphPartQueue queue = new GraphPartQueue();
        queue.add(part);
        stack.add(queue);
        block0: while (!stack.isEmpty()) {
            queue = (GraphPartQueue)stack.peek();
            if (!queue.isEmpty()) {
                part = (GraphPart)queue.remove();
            } else if (queue.currentLoop != null) {
                Loop cLoop = queue.currentLoop;
                part = cLoop.loopBreak;
                queue.currentLoop = null;
                if (ret.contains(part)) continue;
                ret.add(part);
                cLoop.reachableMark = 2;
            } else {
                stack.pop();
                continue;
            }
            for (Loop loop : loops) {
                loop.reachableMark = 0;
            }
            Loop currentLoop = null;
            for (Loop l : loops) {
                if ((l.phase == 1 || l.reachableMark == 1) && (l.loopContinue == part || l.loopBreak == part || l.loopPreContinue == part)) continue block0;
                if (l.reachableMark != 0 || l.loopContinue != part) continue;
                l.reachableMark = 1;
                currentLoop = l;
            }
            GraphPartQueue graphPartQueue = new GraphPartQueue();
            block3: for (GraphPart next : part.nextParts) {
                for (Loop l : loops) {
                    if (l.phase != 1 && l.reachableMark != 1 || l.loopContinue != next && l.loopBreak != next && l.loopPreContinue != next) continue;
                    continue block3;
                }
                if (ret.contains(next)) continue;
                graphPartQueue.add(next);
            }
            ret.addAll(graphPartQueue);
            if (currentLoop != null && currentLoop.loopBreak != null) {
                graphPartQueue.currentLoop = currentLoop;
            }
            if (graphPartQueue.isEmpty() && graphPartQueue.currentLoop == null) continue;
            stack.add(graphPartQueue);
        }
    }

    public GraphPart getNextCommonPart(BaseLocalData localData, GraphPart part, List<Loop> loops) throws InterruptedException {
        return this.getCommonPart(localData, part.nextParts, loops);
    }

    public GraphPart getCommonPart(BaseLocalData localData, List<GraphPart> parts, List<Loop> loops) throws InterruptedException {
        Object p;
        if (parts.isEmpty()) {
            return null;
        }
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
        }
        Iterator<Serializable> iterator = parts.iterator();
        while (iterator.hasNext() && !loopContinues.contains(p = (GraphPart)iterator.next())) {
            boolean common = true;
            for (GraphPart q : parts) {
                if (q == p || q.leadsTo(localData, this, this.code, (GraphPart)p, loops)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            return p;
        }
        ArrayList<LinkedHashSet<GraphPart>> reachable = new ArrayList<LinkedHashSet<GraphPart>>();
        for (GraphPart p2 : parts) {
            LinkedHashSet<GraphPart> r1 = new LinkedHashSet<GraphPart>();
            this.getReachableParts(p2, r1, loops);
            r1.add(p2);
            reachable.add(r1);
        }
        Set first = (Set)reachable.get(0);
        for (GraphPart p3 : first) {
            if ((p3 = this.checkPart(null, localData, p3, null)) == null) continue;
            boolean common = true;
            for (Set set : reachable) {
                if (set.contains(p3)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            return p3;
        }
        return null;
    }

    public GraphPart getMostCommonPart(BaseLocalData localData, List<GraphPart> parts, List<Loop> loops) throws InterruptedException {
        GraphPart p;
        if (parts.isEmpty()) {
            return null;
        }
        HashSet<GraphPart> s = new HashSet<GraphPart>(parts);
        parts = new ArrayList<GraphPart>(s);
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
            loopContinues.add(l.loopPreContinue);
        }
        Iterator<Serializable> iterator = parts.iterator();
        while (iterator.hasNext() && !loopContinues.contains(p = (GraphPart)iterator.next())) {
            boolean common = true;
            for (GraphPart graphPart : parts) {
                if (graphPart == p || graphPart.leadsTo(localData, this, this.code, p, loops)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            return p;
        }
        block3: for (int i = 0; i < parts.size(); ++i) {
            for (int j = 0; j < parts.size(); ++j) {
                if (j == i || !parts.get(i).leadsTo(localData, this, this.code, parts.get(j), loops)) continue;
                parts.remove(i);
                --i;
                continue block3;
            }
        }
        ArrayList reachable = new ArrayList();
        for (GraphPart p2 : parts) {
            LinkedHashSet r1 = new LinkedHashSet();
            this.getReachableParts(p2, r1, loops);
            LinkedHashSet<GraphPart> linkedHashSet = new LinkedHashSet<GraphPart>();
            linkedHashSet.add(p2);
            linkedHashSet.addAll(r1);
            reachable.add(linkedHashSet);
        }
        HashMap<GraphPart, Integer> levelMap = new HashMap<GraphPart, Integer>();
        for (Set set : reachable) {
            GraphPart p3;
            int maxclevel = 0;
            HashSet<GraphPart> visited = new HashSet<GraphPart>();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !loopContinues.contains(p3 = (GraphPart)iterator2.next())) {
                if (visited.contains(p3)) continue;
                visited.add(p3);
                boolean common = true;
                int commonLevel = 1;
                for (Set set2 : reachable) {
                    if (set2 == set || !set2.contains(p3)) continue;
                    ++commonLevel;
                }
                if (commonLevel <= maxclevel) continue;
                maxclevel = commonLevel;
                if (levelMap.containsKey(p3) && (Integer)levelMap.get(p3) > commonLevel) {
                    commonLevel = (Integer)levelMap.get(p3);
                }
                levelMap.put(p3, commonLevel);
                if (!common) continue;
            }
        }
        for (int i = reachable.size() - 1; i >= 2; --i) {
            for (GraphPart p4 : levelMap.keySet()) {
                if ((Integer)levelMap.get(p4) != i) continue;
                return p4;
            }
        }
        for (GraphPart graphPart : levelMap.keySet()) {
            if (((Integer)levelMap.get(graphPart)).intValue() != parts.size()) continue;
            return graphPart;
        }
        return null;
    }

    public GraphPart getNextNoJump(GraphPart part, BaseLocalData localData) {
        while (this.code.get(part.start).isJump()) {
            part = part.getSubParts().get((int)0).nextParts.get(0);
        }
        return part;
    }

    public static List<GraphTargetItem> translateViaGraph(BaseLocalData localData, String path, GraphSource code, List<Integer> alternateEntries, int staticOperation) throws InterruptedException {
        Graph g = new Graph(code, alternateEntries);
        g.init(localData);
        return g.translate(localData, staticOperation, path);
    }

    public List<GraphTargetItem> translate(BaseLocalData localData, int staticOperation, String path) throws InterruptedException {
        HashSet<GraphPart> allParts = new HashSet<GraphPart>();
        for (GraphPart head : this.heads) {
            Graph.populateParts(head, allParts);
        }
        TranslateStack stack = new TranslateStack(path);
        ArrayList<Loop> loops = new ArrayList<Loop>();
        boolean newLoopDetection = false;
        this.getLoops(localData, this.heads.get(0), loops, null);
        this.getPrecontinues(path, localData, null, this.heads.get(0), allParts, loops, null);
        List<GraphTargetItem> ret = this.printGraph(new HashMap<GraphPart, List<GraphTargetItem>>(), new HashMap<GraphPart, Integer>(), localData, stack, allParts, null, this.heads.get(0), null, loops, staticOperation, path);
        this.processIfs(ret);
        this.finalProcessStack(stack, ret);
        this.finalProcessAll(ret, 0, new FinalProcessLocalData());
        return ret;
    }

    public void finalProcessStack(TranslateStack stack, List<GraphTargetItem> output) {
    }

    private void finalProcessAll(List<GraphTargetItem> list, int level, FinalProcessLocalData localData) throws InterruptedException {
        this.finalProcess(list, level, localData);
        for (GraphTargetItem item : list) {
            if (!(item instanceof Block)) continue;
            List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
            for (List<GraphTargetItem> sub : subs) {
                this.finalProcessAll(sub, level + 1, localData);
            }
        }
        this.finalProcessAfter(list, level, localData);
    }

    private boolean processSubBlk(Block b, GraphTargetItem replacement) {
        boolean allSubPush = true;
        boolean atleastOne = false;
        for (List<GraphTargetItem> sub : b.getSubs()) {
            if (sub.isEmpty()) continue;
            int lastPos = sub.size() - 1;
            GraphTargetItem last = sub.get(sub.size() - 1);
            GraphTargetItem br = null;
            if (last instanceof BreakItem && sub.size() >= 2) {
                br = last;
                last = sub.get(--lastPos);
            }
            if (last instanceof Block) {
                if (!this.processSubBlk((Block)((Object)last), replacement)) {
                    allSubPush = false;
                    continue;
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof PushItem) {
                if (replacement != null) {
                    GraphTargetItem e2 = replacement.clone();
                    e2.value = last.value;
                    sub.set(lastPos, e2);
                    if (br != null) {
                        sub.remove(sub.size() - 1);
                    }
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof ExitItem) continue;
            allSubPush = false;
        }
        return allSubPush && atleastOne;
    }

    protected void finalProcessAfter(List<GraphTargetItem> list, int level, FinalProcessLocalData localData) {
        if (list.size() >= 2 && list.get(list.size() - 1) instanceof ExitItem) {
            Block b;
            ExitItem e = (ExitItem)((Object)list.get(list.size() - 1));
            if (list.get((int)(list.size() - 1)).value instanceof PopItem && list.get(list.size() - 2) instanceof Block && this.processSubBlk(b = (Block)((Object)list.get(list.size() - 2)), (GraphTargetItem)((Object)e))) {
                list.remove(list.size() - 1);
            }
        }
    }

    protected void finalProcess(List<GraphTargetItem> list, int level, FinalProcessLocalData localData) throws InterruptedException {
        int i;
        boolean[] toDelete = new boolean[list.size()];
        for (i = 0; i < list.size(); ++i) {
            GraphTargetItem itemJ;
            int j;
            WhileItem whi;
            int whileExprLine;
            ArrayList<GraphTargetItem> forFirstCommands;
            ForItem fori;
            int exprLine;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            GraphTargetItem itemI = list.get(i);
            if (itemI instanceof ForItem && (exprLine = (fori = (ForItem)itemI).getLine()) > 0) {
                forFirstCommands = new ArrayList<GraphTargetItem>();
                for (int j2 = i - 1; j2 >= 0 && list.get(j2).getLine() == exprLine && !(list.get(j2) instanceof LoopItem); --j2) {
                    forFirstCommands.add(0, list.get(j2));
                    toDelete[j2] = true;
                }
                fori.firstCommands.addAll(0, forFirstCommands);
            }
            if (!(itemI instanceof WhileItem) || (whileExprLine = (whi = (WhileItem)itemI).getLine()) <= 0) continue;
            forFirstCommands = new ArrayList();
            ArrayList<GraphTargetItem> forFinalCommands = new ArrayList<GraphTargetItem>();
            for (j = i - 1; j >= 0 && (itemJ = list.get(j)).getLine() == whileExprLine && !(itemJ instanceof LoopItem); --j) {
                forFirstCommands.add(0, itemJ);
                toDelete[j] = true;
            }
            for (j = whi.commands.size() - 1; j >= 0 && whi.commands.get(j).getLine() == whileExprLine && !(whi.commands.get(j) instanceof LoopItem); --j) {
                forFinalCommands.add(0, whi.commands.remove(j));
            }
            if (forFirstCommands.isEmpty() && forFinalCommands.isEmpty()) continue;
            if (forFirstCommands.size() > 2 || forFinalCommands.size() > 2) {
                for (int k = 0; k < forFirstCommands.size(); ++k) {
                    toDelete[i - 1 - k] = false;
                }
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            if (whi.commands.isEmpty() && forFirstCommands.isEmpty()) {
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            GraphTargetItem lastExpr = whi.expression.remove(whi.expression.size() - 1);
            forFirstCommands.addAll(whi.expression);
            list.set(i, new ForItem(whi.getSrc(), whi.getLineStartItem(), whi.loop, forFirstCommands, lastExpr, forFinalCommands, whi.commands));
        }
        for (i = toDelete.length - 1; i >= 0; --i) {
            if (!toDelete[i]) continue;
            list.remove(i);
        }
    }

    private void processIfs(List<GraphTargetItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem last;
            List<List<GraphTargetItem>> subs;
            GraphTargetItem item = list.get(i);
            if (item instanceof LoopItem && item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                    this.checkContinueAtTheEnd(sub, ((LoopItem)item).loop);
                }
            } else if (item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                }
            }
            if (!(item instanceof IfItem)) continue;
            IfItem ifi = (IfItem)item;
            List<GraphTargetItem> onTrue = ifi.onTrue;
            List<GraphTargetItem> onFalse = ifi.onFalse;
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && onFalse.get(onFalse.size() - 1) instanceof ContinueItem && ((ContinueItem)onTrue.get((int)(onTrue.size() - 1))).loopId == ((ContinueItem)onFalse.get((int)(onFalse.size() - 1))).loopId) {
                onTrue.remove(onTrue.size() - 1);
                list.add(i + 1, onFalse.remove(onFalse.size() - 1));
            }
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && ((last = onTrue.get(onTrue.size() - 1)) instanceof ExitItem || last instanceof ContinueItem || last instanceof BreakItem)) {
                list.addAll(i + 1, onFalse);
                onFalse.clear();
            }
            if (onTrue.isEmpty() || onFalse.isEmpty() || !(onFalse.get(onFalse.size() - 1) instanceof ExitItem) || !(onTrue.get(onTrue.size() - 1) instanceof ContinueItem)) continue;
            list.add(i + 1, onTrue.remove(onTrue.size() - 1));
        }
    }

    protected List<GraphPart> getLoopsContinuesPreAndBreaks(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue != null) {
                ret.add(l.loopContinue);
            }
            if (l.loopPreContinue != null) {
                ret.add(l.loopPreContinue);
            }
            if (l.loopBreak == null) continue;
            ret.add(l.loopBreak);
        }
        return ret;
    }

    protected List<GraphPart> getLoopsContinuesAndPre(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue != null) {
                ret.add(l.loopContinue);
            }
            if (l.loopPreContinue == null) continue;
            ret.add(l.loopPreContinue);
        }
        return ret;
    }

    protected List<GraphPart> getLoopsContinues(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue == null) continue;
            ret.add(l.loopContinue);
        }
        return ret;
    }

    protected GraphTargetItem checkLoop(GraphPart part, List<GraphPart> stopPart, List<Loop> loops) {
        if (stopPart.contains(part)) {
            return null;
        }
        GraphSourceItem firstIns = null;
        if (part != null && part.start >= 0 && part.start < this.code.size()) {
            firstIns = this.code.get(part.start);
        }
        for (Loop l : loops) {
            if (l.loopContinue == part) {
                return new ContinueItem(null, firstIns, l.id);
            }
            if (l.loopBreak != part) continue;
            return new BreakItem(null, firstIns, l.id);
        }
        return null;
    }

    private void checkContinueAtTheEnd(List<GraphTargetItem> commands, Loop loop) {
        if (!commands.isEmpty()) {
            int i;
            for (i = commands.size() - 1; i >= 0 && (commands.get(i) instanceof ContinueItem || commands.get(i) instanceof BreakItem); --i) {
            }
            if (i < commands.size() - 1) {
                for (int k = i + 2; k < commands.size(); ++k) {
                    commands.remove(k);
                }
            }
            if (commands.get(commands.size() - 1) instanceof ContinueItem && ((ContinueItem)commands.get((int)(commands.size() - 1))).loopId == loop.id) {
                commands.remove(commands.size() - 1);
            }
        }
    }

    protected boolean isEmpty(List<GraphTargetItem> output) {
        if (output.isEmpty()) {
            return true;
        }
        return output.size() == 1 && output.get(0) instanceof MarkItem;
    }

    protected List<GraphTargetItem> check(Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<Loop> loops, List<GraphTargetItem> output, Loop currentLoop, int staticOperation, String path) throws InterruptedException {
        return null;
    }

    protected GraphPart checkPart(TranslateStack stack, BaseLocalData localData, GraphPart part, Set<GraphPart> allParts) {
        return part;
    }

    protected GraphTargetItem translatePartGetStack(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation) throws InterruptedException {
        stack = (TranslateStack)stack.clone();
        this.translatePart(localData, part, stack, staticOperation, null);
        return stack.pop();
    }

    protected List<GraphTargetItem> translatePart(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation, String path) throws InterruptedException {
        List<GraphPart> sub = part.getSubParts();
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        for (GraphPart p : sub) {
            if (p.end == -1) {
                p.end = this.code.size() - 1;
            }
            if (p.start == this.code.size()) continue;
            if (p.end == this.code.size()) {
                // empty if block
            }
            int end = --p.end;
            int start = p.start;
            ret.addAll(this.code.translatePart(part, localData, stack, start, end, staticOperation, path));
        }
        return ret;
    }

    private void markBranchEnd(List<GraphTargetItem> items) {
        if (!items.isEmpty()) {
            if (items.get(items.size() - 1) instanceof BreakItem) {
                return;
            }
            if (items.get(items.size() - 1) instanceof ContinueItem) {
                return;
            }
            if (items.get(items.size() - 1) instanceof ExitItem) {
                return;
            }
        }
        items.add(new MarkItem("finish"));
    }

    private static GraphTargetItem getLastNoEnd(List<GraphTargetItem> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.get(list.size() - 1) instanceof ScriptEndItem) {
            if (list.size() >= 2) {
                return list.get(list.size() - 2);
            }
            return list.get(list.size() - 1);
        }
        return list.get(list.size() - 1);
    }

    private static void removeLastNoEnd(List<GraphTargetItem> list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1) instanceof ScriptEndItem) {
            if (list.size() >= 2) {
                list.remove(list.size() - 2);
            }
            return;
        }
        list.remove(list.size() - 1);
    }

    protected List<GraphTargetItem> printGraph(Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<Loop> loops, int staticOperation, String path) throws InterruptedException {
        return this.printGraph(partCodes, partCodePos, new HashSet<GraphPart>(), localData, stack, allParts, parent, part, stopPart, loops, null, staticOperation, path, 0);
    }

    protected GraphTargetItem checkLoop(LoopItem loopItem, BaseLocalData localData, List<Loop> loops) {
        return loopItem;
    }

    private void getPrecontinues(String path, BaseLocalData localData, GraphPart parent, GraphPart part, Set<GraphPart> allParts, List<Loop> loops, List<GraphPart> stopPart) throws InterruptedException {
        try {
            this.markLevels(path, localData, part, allParts, loops);
        }
        catch (InterruptedException | ThreadDeath iex) {
            throw iex;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        block3: for (Loop l : loops) {
            if (l.loopContinue == null) continue;
            HashSet<GraphPart> uniqueRefs = new HashSet<GraphPart>();
            uniqueRefs.addAll(l.loopContinue.refs);
            if (uniqueRefs.size() != 2) continue;
            ArrayList uniqueRefsList = new ArrayList(uniqueRefs);
            part = ((GraphPart)uniqueRefsList.get((int)0)).discoveredTime > ((GraphPart)uniqueRefsList.get((int)1)).discoveredTime ? (GraphPart)uniqueRefsList.get(0) : (GraphPart)uniqueRefsList.get(1);
            if (part == l.loopContinue) continue;
            while (part.refs.size() == 1) {
                if (part.refs.get((int)0).nextParts.size() != 1) continue block3;
                part = part.refs.get(0);
                if (part != l.loopContinue) continue;
            }
            if (part.level != 0 || part == l.loopContinue) continue;
            l.loopPreContinue = part;
        }
    }

    private void markLevels(String path, BaseLocalData localData, GraphPart part, Set<GraphPart> allParts, List<Loop> loops) throws InterruptedException {
        this.clearLoops(loops);
        this.markLevels(path, localData, part, allParts, loops, new ArrayList<GraphPart>(), 1, new HashSet<GraphPart>(), 0);
        this.clearLoops(loops);
    }

    private void markLevels(String path, BaseLocalData localData, GraphPart part, Set<GraphPart> allParts, List<Loop> loops, List<GraphPart> stopPart, int level, Set<GraphPart> visited, int recursionLevel) throws InterruptedException {
        GraphPart next;
        List<GraphPart> nextParts;
        boolean debugMode = false;
        if (stopPart == null) {
            stopPart = new ArrayList<GraphPart>();
        }
        if (recursionLevel > allParts.size() + 1) {
            throw new RuntimeException(path + ": markLevels max recursion level reached");
        }
        if (debugMode) {
            System.err.println("markLevels " + part);
        }
        if (stopPart.contains(part)) {
            return;
        }
        for (Loop el : loops) {
            if (el.phase == 2 && el.loopContinue == part) {
                return;
            }
            if (el.phase != 1) {
                if (!debugMode) continue;
                continue;
            }
            if (el.loopContinue == part) {
                return;
            }
            if (el.loopPreContinue == part) {
                return;
            }
            if (el.loopBreak != part) continue;
            return;
        }
        if (visited.contains(part)) {
            part.level = 0;
        } else {
            visited.add(part);
            part.level = level;
        }
        boolean isLoop = false;
        Loop currentLoop = null;
        for (Loop el : loops) {
            if (el.phase != 0 || el.loopContinue != part) continue;
            isLoop = true;
            currentLoop = el;
            el.phase = 1;
            break;
        }
        if ((nextParts = this.checkPrecoNextParts(part)) == null) {
            nextParts = part.nextParts;
        }
        if (nextParts.size() == 2) {
            next = this.getCommonPart(localData, nextParts, loops);
            ArrayList<GraphPart> stopParts2 = new ArrayList<GraphPart>();
            if (next != null) {
                stopParts2.add(next);
            } else if (!stopPart.isEmpty()) {
                stopParts2.add(stopPart.get(stopPart.size() - 1));
            }
            if (next != nextParts.get(0)) {
                this.markLevels(path, localData, nextParts.get(0), allParts, loops, next == null ? stopPart : stopParts2, level + 1, visited, recursionLevel + 1);
            }
            if (next != nextParts.get(1)) {
                this.markLevels(path, localData, nextParts.get(1), allParts, loops, next == null ? stopPart : stopParts2, level + 1, visited, recursionLevel + 1);
            }
            if (next != null) {
                this.markLevels(path, localData, next, allParts, loops, stopPart, level, visited, recursionLevel + 1);
            }
        }
        if (nextParts.size() > 2) {
            next = this.getMostCommonPart(localData, nextParts, loops);
            ArrayList<GraphPart> vis = new ArrayList<GraphPart>();
            for (GraphPart p : nextParts) {
                if (vis.contains(p)) continue;
                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>();
                if (next != null) {
                    stopPart2.add(next);
                } else if (!stopPart.isEmpty()) {
                    stopPart2.add(stopPart.get(stopPart.size() - 1));
                }
                for (GraphPart p2 : nextParts) {
                    if (p2 == p || stopPart2.contains(p2)) continue;
                    stopPart2.add(p2);
                }
                if (next == p) continue;
                this.markLevels(path, localData, p, allParts, loops, stopPart2, level + 1, visited, recursionLevel + 1);
                vis.add(p);
            }
            if (next != null) {
                this.markLevels(path, localData, next, allParts, loops, stopPart, level, visited, recursionLevel + 1);
            }
        }
        if (nextParts.size() == 1) {
            this.markLevels(path, localData, nextParts.get(0), allParts, loops, stopPart, level, visited, recursionLevel + 1);
        }
        for (GraphPart t : part.throwParts) {
            if (visited.contains(t)) continue;
            ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>();
            ArrayList<GraphPart> cmn = new ArrayList<GraphPart>();
            cmn.add(part);
            cmn.add(t);
            GraphPart next2 = this.getCommonPart(localData, cmn, loops);
            if (next2 != null) {
                stopPart2.add(next2);
            } else {
                stopPart2 = stopPart;
            }
            this.markLevels(path, localData, t, allParts, loops, stopPart2, level, visited, recursionLevel + 1);
        }
        if (isLoop && currentLoop != null && currentLoop.loopBreak != null) {
            currentLoop.phase = 2;
            this.markLevels(path, localData, currentLoop.loopBreak, allParts, loops, stopPart, level, visited, recursionLevel + 1);
        }
    }

    private void clearLoops(List<Loop> loops) {
        for (Loop l : loops) {
            l.phase = 0;
        }
    }

    private void getLoops(BaseLocalData localData, GraphPart part, List<Loop> loops, List<GraphPart> stopPart) throws InterruptedException {
        this.clearLoops(loops);
        this.getLoops(localData, part, loops, stopPart, true, 1, new ArrayList<GraphPart>());
        this.clearLoops(loops);
    }

    /*
     * WARNING - void declaration
     */
    private void getLoops(BaseLocalData localData, GraphPart part, List<Loop> loops, List<GraphPart> stopPart, boolean first, int level, List<GraphPart> visited) throws InterruptedException {
        boolean debugMode = false;
        if (part == null) {
            return;
        }
        if ((part = this.checkPart(null, localData, part, null)) == null) {
            return;
        }
        if (!visited.contains(part)) {
            visited.add(part);
        }
        if (debugMode) {
            System.err.println("getloops: " + part);
        }
        Loop lastP1 = null;
        for (Loop el : loops) {
            if (el.phase != 1 || el.loopBreak != null) continue;
            if (el.loopContinue != part) {
                lastP1 = el;
                continue;
            }
            lastP1 = null;
        }
        if (lastP1 != null) {
            if (lastP1.breakCandidates.contains(part)) {
                lastP1.breakCandidates.add(part);
                lastP1.breakCandidatesLevels.add(level);
                return;
            }
            ArrayList<Loop> loops2 = new ArrayList<Loop>(loops);
            loops2.remove(lastP1);
            if (!part.leadsTo(localData, this, this.code, lastP1.loopContinue, (List<Loop>)loops2) && lastP1.breakCandidatesLocked == 0) {
                if (debugMode) {
                    System.err.println("added breakCandidate " + part + " to " + lastP1);
                }
                lastP1.breakCandidates.add(part);
                lastP1.breakCandidatesLevels.add(level);
                return;
            }
        }
        for (Loop el : loops) {
            if (el.loopContinue != part) continue;
            return;
        }
        if (stopPart != null && stopPart.contains(part)) {
            return;
        }
        part.level = level;
        boolean isLoop = part.leadsTo(localData, this, this.code, part, loops);
        Loop currentLoop = null;
        if (isLoop) {
            currentLoop = new Loop(loops.size(), part, null);
            currentLoop.phase = 1;
            loops.add(currentLoop);
        }
        if (part.nextParts.size() == 2) {
            ArrayList<GraphPart> stopPart2;
            List<GraphPart> nps = part.nextParts;
            Iterator<Object> next = this.getCommonPart(localData, nps, loops);
            ArrayList<GraphPart> arrayList = stopPart2 = stopPart == null ? new ArrayList<GraphPart>() : new ArrayList<GraphPart>(stopPart);
            if (next != null) {
                stopPart2.add((GraphPart)((Object)next));
            }
            if (next != nps.get(0)) {
                this.getLoops(localData, nps.get(0), loops, stopPart2, false, level + 1, visited);
            }
            if (next != nps.get(1)) {
                this.getLoops(localData, nps.get(1), loops, stopPart2, false, level + 1, visited);
            }
            if (next != null) {
                this.getLoops(localData, (GraphPart)((Object)next), loops, stopPart, false, level, visited);
            }
        } else if (part.nextParts.size() > 2) {
            GraphPart next = this.getNextCommonPart(localData, part, loops);
            for (GraphPart p : part.nextParts) {
                ArrayList<GraphPart> stopPart2;
                ArrayList<GraphPart> arrayList = stopPart2 = stopPart == null ? new ArrayList<GraphPart>() : new ArrayList<GraphPart>(stopPart);
                if (next != null) {
                    stopPart2.add(next);
                }
                for (GraphPart p2 : part.nextParts) {
                    if (p2 == p || stopPart2.contains(p2)) continue;
                    stopPart2.add(p2);
                }
                if (next == p) continue;
                this.getLoops(localData, p, loops, stopPart2, false, level + 1, visited);
            }
            if (next != null) {
                this.getLoops(localData, next, loops, stopPart, false, level, visited);
            }
        } else if (part.nextParts.size() == 1) {
            this.getLoops(localData, part.nextParts.get(0), loops, stopPart, false, level, visited);
        }
        ArrayList<Loop> loops2 = new ArrayList<Loop>(loops);
        for (Loop l : loops2) {
            ++l.breakCandidatesLocked;
        }
        for (GraphPart t : part.throwParts) {
            if (visited.contains(t)) continue;
            this.getLoops(localData, t, loops, stopPart, false, level, visited);
        }
        for (Loop l : loops2) {
            --l.breakCandidatesLocked;
        }
        if (isLoop && currentLoop != null) {
            void var18_32;
            GraphPart found;
            HashMap<GraphPart, Integer> removed = new HashMap<GraphPart, Integer>();
            do {
                found = null;
                for (int i = 0; i < currentLoop.breakCandidates.size(); ++i) {
                    GraphPart ch = this.checkPart(null, localData, currentLoop.breakCandidates.get(i), null);
                    if (ch != null) continue;
                    currentLoop.breakCandidates.remove(i);
                    --i;
                }
                block9: for (GraphPart cand : currentLoop.breakCandidates) {
                    for (GraphPart graphPart : currentLoop.breakCandidates) {
                        if (cand == graphPart || !cand.leadsTo(localData, this, this.code, graphPart, loops)) continue;
                        int lev1 = Integer.MAX_VALUE;
                        int lev2 = Integer.MAX_VALUE;
                        for (int i = 0; i < currentLoop.breakCandidates.size(); ++i) {
                            if (currentLoop.breakCandidates.get(i) == cand && currentLoop.breakCandidatesLevels.get(i) < lev1) {
                                lev1 = currentLoop.breakCandidatesLevels.get(i);
                            }
                            if (currentLoop.breakCandidates.get(i) != graphPart || currentLoop.breakCandidatesLevels.get(i) >= lev2) continue;
                            lev2 = currentLoop.breakCandidatesLevels.get(i);
                        }
                        if (lev1 <= lev2) {
                            found = graphPart;
                            break block9;
                        }
                        found = cand;
                        break block9;
                    }
                }
                if (found == null) continue;
                int maxlevel = 0;
                while (currentLoop.breakCandidates.contains(found)) {
                    int ind = currentLoop.breakCandidates.indexOf(found);
                    currentLoop.breakCandidates.remove(ind);
                    int lev = currentLoop.breakCandidatesLevels.remove(ind);
                    if (lev <= maxlevel) continue;
                    maxlevel = lev;
                }
                if (removed.containsKey(found) && (Integer)removed.get(found) > maxlevel) {
                    maxlevel = (Integer)removed.get(found);
                }
                removed.put(found, maxlevel);
            } while (found != null && currentLoop.breakCandidates.size() > 1);
            HashMap<GraphPart, Integer> count = new HashMap<GraphPart, Integer>();
            GraphPart winner = null;
            int winnerCount = 0;
            for (GraphPart cand : currentLoop.breakCandidates) {
                if (!count.containsKey(cand)) {
                    count.put(cand, 0);
                }
                count.put(cand, (Integer)count.get(cand) + 1);
                boolean otherBreakCandidate = false;
                for (Loop el : loops) {
                    if (el == currentLoop || !el.breakCandidates.contains(cand)) continue;
                    otherBreakCandidate = true;
                    break;
                }
                if (otherBreakCandidate) continue;
                if ((Integer)count.get(cand) > winnerCount) {
                    winnerCount = (Integer)count.get(cand);
                    winner = cand;
                    continue;
                }
                if ((Integer)count.get(cand) != winnerCount || winner == null || cand.path.length() >= winner.path.length()) continue;
                winner = cand;
            }
            boolean bl = false;
            while (var18_32 < currentLoop.breakCandidates.size()) {
                GraphPart cand = currentLoop.breakCandidates.get((int)var18_32);
                if (cand != winner) {
                    int lev = currentLoop.breakCandidatesLevels.get((int)var18_32);
                    if (removed.containsKey(cand) && (Integer)removed.get(cand) > lev) {
                        lev = (Integer)removed.get(cand);
                    }
                    removed.put(cand, lev);
                }
                ++var18_32;
            }
            currentLoop.loopBreak = winner;
            currentLoop.phase = 2;
            boolean bl2 = false;
            for (int l = 0; l < loops.size(); ++l) {
                boolean bl3;
                Loop el = loops.get(l);
                if (bl3) {
                    el.phase = 1;
                }
                if (el != currentLoop) continue;
                bl3 = true;
            }
            ArrayList<GraphPart> removedVisited = new ArrayList<GraphPart>();
            for (GraphPart r : removed.keySet()) {
                if (removedVisited.contains(r)) continue;
                this.getLoops(localData, r, loops, stopPart, false, (Integer)removed.get(r), visited);
                removedVisited.add(r);
            }
            boolean bl4 = false;
            for (int l = 0; l < loops.size(); ++l) {
                boolean bl5;
                Loop el = loops.get(l);
                if (el == currentLoop) {
                    bl5 = true;
                }
                if (!bl5) continue;
                el.phase = 2;
            }
            this.getLoops(localData, currentLoop.loopBreak, loops, stopPart, false, level, visited);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<GraphTargetItem> printGraph(Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<Loop> loops, List<GraphTargetItem> ret, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        boolean debugMode;
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (stopPart == null) {
            stopPart = new ArrayList<GraphPart>();
        }
        if (recursionLevel > allParts.size() + 1) {
            throw new TranslateException("printGraph max recursion level reached.");
        }
        if (ret == null) {
            ret = new ArrayList<GraphTargetItem>();
        }
        if (debugMode = false) {
            System.err.println("PART " + part + " nextsize:" + part.nextParts.size());
        }
        if (part == null) {
            return ret;
        }
        if ((part = this.checkPart(stack, localData, part, allParts)) == null) {
            return ret;
        }
        if (part.ignored) {
            return ret;
        }
        boolean isLoop = false;
        Loop currentLoop = null;
        for (Loop el : loops) {
            if (el.loopContinue != part || el.phase != 0) continue;
            currentLoop = el;
            currentLoop.phase = 1;
            isLoop = true;
            break;
        }
        if (debugMode) {
            System.err.println("loopsize:" + loops.size());
        }
        for (int l = loops.size() - 1; l >= 0; --l) {
            Loop el;
            el = loops.get(l);
            if (el == currentLoop) {
                if (!debugMode) continue;
                System.err.println("ignoring current loop " + el);
                continue;
            }
            if (el.phase != 1) {
                if (!debugMode) continue;
                System.err.println("ignoring loop " + el);
                continue;
            }
            if (el.loopBreak == part) {
                if (currentLoop != null) {
                    currentLoop.phase = 0;
                }
                if (debugMode) {
                    System.err.println("Adding break");
                }
                ret.add(new BreakItem(null, localData.lineStartInstruction, el.id));
                return ret;
            }
            if (el.loopPreContinue == part) {
                if (currentLoop != null) {
                    currentLoop.phase = 0;
                }
                if (debugMode) {
                    System.err.println("Adding precontinue");
                }
                ret.add(new ContinueItem(null, localData.lineStartInstruction, el.id));
                return ret;
            }
            if (el.loopContinue != part) continue;
            if (currentLoop != null) {
                currentLoop.phase = 0;
            }
            if (debugMode) {
                System.err.println("Adding continue");
            }
            ret.add(new ContinueItem(null, localData.lineStartInstruction, el.id));
            return ret;
        }
        if (stopPart.contains(part)) {
            if (currentLoop != null) {
                currentLoop.phase = 0;
            }
            if (debugMode) {
                System.err.println("Stopped on part " + part);
            }
            return ret;
        }
        if (this.code.size() <= part.start) {
            ret.add(new ScriptEndItem());
            return ret;
        }
        if (visited.contains(part)) {
            String labelName = "addr" + part.start;
            List<GraphTargetItem> firstCode = partCodes.get(part);
            int firstCodePos = partCodePos.get(part);
            if (firstCodePos > firstCode.size()) {
                firstCodePos = firstCode.size();
            }
            if (firstCode.size() > firstCodePos && firstCode.get(firstCodePos) instanceof LabelItem) {
                labelName = ((LabelItem)firstCode.get((int)firstCodePos)).labelName;
            } else {
                firstCode.add(firstCodePos, new LabelItem(null, localData.lineStartInstruction, labelName));
            }
            ret.add(new GotoItem(null, localData.lineStartInstruction, labelName));
            return ret;
        }
        visited.add(part);
        partCodes.put(part, ret);
        partCodePos.put(part, ret.size());
        List<GraphTargetItem> currentRet = ret;
        UniversalLoopItem loopItem = null;
        TranslateStack sPreLoop = stack;
        if (isLoop) {
            stack = (TranslateStack)stack.clone();
            stack.clear();
            loopItem = new UniversalLoopItem(null, localData.lineStartInstruction, currentLoop);
            currentRet.add(loopItem);
            loopItem.commands = new ArrayList<GraphTargetItem>();
            currentRet = loopItem.commands;
        }
        boolean parseNext = true;
        ArrayList<GraphTargetItem> output = new ArrayList<GraphTargetItem>();
        List<Object> parts = new ArrayList<GraphPart>();
        if (part instanceof GraphPartMulti) {
            parts = ((GraphPartMulti)part).parts;
        } else {
            parts.add(part);
        }
        for (GraphPart graphPart : parts) {
            int end = graphPart.end;
            int start = graphPart.start;
            output.addAll(this.code.translatePart(graphPart, localData, stack, start, end, staticOperation, path));
            if (end < this.code.size() - 1 || !graphPart.nextParts.isEmpty()) continue;
            output.add(new ScriptEndItem());
        }
        if (parseNext) {
            List<GraphTargetItem> retCheck = this.check(partCodes, partCodePos, this.code, localData, allParts, stack, parent, part, stopPart, loops, output, currentLoop, staticOperation, path);
            if (retCheck != null) {
                if (!retCheck.isEmpty()) {
                    currentRet.addAll(retCheck);
                }
                parseNext = false;
            } else {
                currentRet.addAll(output);
            }
        }
        if (parseNext) {
            if (part.nextParts.size() > 2) {
                List lastc;
                GraphPart next = this.getMostCommonPart(localData, part.nextParts, loops);
                ArrayList<GraphPart> arrayList = new ArrayList<GraphPart>();
                GraphTargetItem switchedItem = stack.pop();
                Graph.makeAllCommands(currentRet, stack);
                ArrayList<GraphTargetItem> caseValues = new ArrayList<GraphTargetItem>();
                ArrayList<List<GraphTargetItem>> caseCommands = new ArrayList<List<GraphTargetItem>>();
                ArrayList<Integer> valueMappings = new ArrayList<Integer>();
                Loop swLoop = new Loop(loops.size(), null, next);
                swLoop.phase = 1;
                loops.add(swLoop);
                boolean first = false;
                HashMap caseExpressions = new HashMap();
                HashMap<Integer, GraphTargetItem> caseExpressionLeftSides = new HashMap<Integer, GraphTargetItem>();
                HashMap<Integer, GraphTargetItem> caseExpressionRightSides = new HashMap<Integer, GraphTargetItem>();
                GraphTargetItem it = switchedItem;
                int defaultBranch = 0;
                boolean hasExpr = false;
                while (it instanceof TernarOpItem) {
                    TernarOpItem to = (TernarOpItem)it;
                    if (to.expression instanceof EqualsTypeItem) {
                        if (!(to.onTrue instanceof IntegerValueTypeItem)) break;
                        int cpos = ((IntegerValueTypeItem)((Object)to.onTrue)).intValue();
                        caseExpressionLeftSides.put(cpos, ((EqualsTypeItem)((Object)to.expression)).getLeftSide());
                        caseExpressionRightSides.put(cpos, ((EqualsTypeItem)((Object)to.expression)).getRightSide());
                        it = to.onFalse;
                        continue;
                    }
                    if (to.expression instanceof FalseItem) {
                        it = to.onFalse;
                        continue;
                    }
                    if (!(to.expression instanceof TrueItem)) break;
                    it = to.onTrue;
                }
                if (it instanceof IntegerValueTypeItem) {
                    defaultBranch = ((IntegerValueTypeItem)((Object)it)).intValue();
                }
                if (!caseExpressionRightSides.isEmpty()) {
                    GraphTargetItem firstItem = (GraphTargetItem)caseExpressionRightSides.values().toArray()[0];
                    boolean sameRight = true;
                    for (Object cit : caseExpressionRightSides.values()) {
                        if (cit.equals(firstItem)) continue;
                        sameRight = false;
                        break;
                    }
                    if (sameRight) {
                        caseExpressions = caseExpressionLeftSides;
                        switchedItem = firstItem;
                        hasExpr = true;
                    } else {
                        firstItem = (GraphTargetItem)caseExpressionLeftSides.values().toArray()[0];
                        boolean sameLeft = true;
                        for (GraphTargetItem cit : caseExpressionLeftSides.values()) {
                            if (cit.equals(firstItem)) continue;
                            sameLeft = false;
                            break;
                        }
                        if (sameLeft) {
                            caseExpressions = caseExpressionRightSides;
                            switchedItem = firstItem;
                            hasExpr = true;
                        }
                    }
                }
                first = true;
                int pos = 0;
                GraphPart defaultPart = hasExpr ? part.nextParts.get(1 + defaultBranch) : part.nextParts.get(0);
                for (int i = 1; i < part.nextParts.size(); ++i) {
                    if (caseExpressions.containsKey(pos)) {
                        caseValues.add((GraphTargetItem)caseExpressions.get(pos));
                    } else if (part.nextParts.get(i) == defaultPart) {
                        caseValues.add(new DefaultItem());
                    } else {
                        caseValues.add(new IntegerValueItem(null, localData.lineStartInstruction, pos));
                    }
                    ++pos;
                }
                first = true;
                pos = 0;
                ArrayList<GraphTargetItem> nextCommands = new ArrayList();
                for (int i = 1; i < part.nextParts.size(); ++i) {
                    GraphPart p = part.nextParts.get(i);
                    if (arrayList.contains(p)) {
                        valueMappings.add(caseCommands.size() - 1);
                        continue;
                    }
                    valueMappings.add(caseCommands.size());
                    ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>();
                    if (next != null) {
                        stopPart2.add(next);
                    } else if (!stopPart.isEmpty()) {
                        stopPart2.add(stopPart.get(stopPart.size() - 1));
                    }
                    for (GraphPart p2 : part.nextParts) {
                        if (p2 == p || stopPart2.contains(p2)) continue;
                        stopPart2.add(p2);
                    }
                    if (next != p) {
                        TranslateStack s2 = (TranslateStack)stack.clone();
                        s2.clear();
                        nextCommands = this.printGraph(partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), s2, allParts, part, p, stopPart2, loops, null, staticOperation, path, recursionLevel + 1);
                        Graph.makeAllCommands(nextCommands, s2);
                        caseCommands.add(nextCommands);
                        arrayList.add(p);
                    } else {
                        caseCommands.add(nextCommands);
                    }
                    first = false;
                    ++pos;
                }
                if (!caseCommands.isEmpty()) {
                    List lastc2 = (List)caseCommands.get(caseCommands.size() - 1);
                    if (!lastc2.isEmpty() && lastc2.get(lastc2.size() - 1) instanceof BreakItem) {
                        BreakItem bi = (BreakItem)lastc2.get(lastc2.size() - 1);
                        if (bi.loopId == swLoop.id) {
                            lastc2.remove(lastc2.size() - 1);
                        }
                    }
                    if (lastc2.isEmpty()) {
                        int cnt = 0;
                        if (caseValues.get(caseValues.size() - 1) instanceof DefaultItem) {
                            for (int i = valueMappings.size() - 1; i >= 0; --i) {
                                if ((Integer)valueMappings.get(i) != caseCommands.size() - 1) continue;
                                ++cnt;
                            }
                            if (cnt == 1) {
                                caseValues.remove(caseValues.size() - 1);
                                valueMappings.remove(valueMappings.size() - 1);
                                caseCommands.remove(lastc2);
                            }
                        }
                    }
                }
                if (!caseCommands.isEmpty() && !(lastc = (List)caseCommands.get(caseCommands.size() - 1)).isEmpty() && lastc.get(lastc.size() - 1) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)lastc.get(lastc.size() - 1);
                    if (bi.loopId == swLoop.id) {
                        lastc.remove(lastc.size() - 1);
                    }
                }
                SwitchItem sw = new SwitchItem(null, localData.lineStartInstruction, swLoop, switchedItem, caseValues, caseCommands, valueMappings);
                currentRet.add(sw);
                swLoop.phase = 2;
                if (next != null) {
                    currentRet.addAll(this.printGraph(partCodes, partCodePos, visited, localData, stack, allParts, part, next, stopPart, loops, null, staticOperation, path, recursionLevel + 1));
                }
                ++pos;
            }
            GraphPart nextOnePart = null;
            if (part.nextParts.size() == 2) {
                GraphTargetItem graphTargetItem = stack.pop();
                if (nextOnePart == null) {
                    List<GraphPart> nps = part.nextParts;
                    boolean isEmpty = nps.get(0) == nps.get(1);
                    Object next = this.getCommonPart(localData, nps, loops);
                    TranslateStack trueStack = (TranslateStack)stack.clone();
                    TranslateStack falseStack = (TranslateStack)stack.clone();
                    trueStack.clear();
                    falseStack.clear();
                    if (isEmpty) {
                        next = nps.get(0);
                    }
                    boolean hasOntrue = nps.get(1) != next;
                    boolean hasOnFalse = nps.get(0) != next;
                    ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                    if (!isEmpty && next != null) {
                        stopPart2.add((GraphPart)next);
                    }
                    List<GraphTargetItem> onTrue = new ArrayList<GraphTargetItem>();
                    if (!isEmpty && hasOntrue) {
                        onTrue = this.printGraph(partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), trueStack, allParts, part, nps.get(1), stopPart2, loops, null, staticOperation, path, recursionLevel + 1);
                    }
                    List<GraphTargetItem> onFalse = new ArrayList<GraphTargetItem>();
                    if (!isEmpty && hasOnFalse) {
                        onFalse = this.printGraph(partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), falseStack, allParts, part, nps.get(0), stopPart2, loops, null, staticOperation, path, recursionLevel + 1);
                    }
                    Graph.makeAllCommands(onTrue, trueStack);
                    Graph.makeAllCommands(onFalse, falseStack);
                    List<GraphTargetItem> filteredOnTrue = this.filter(onTrue);
                    List<GraphTargetItem> filteredOnFalse = this.filter(onFalse);
                    if (!this.isEmpty(filteredOnTrue) && !this.isEmpty(filteredOnFalse) && filteredOnTrue.size() == 1 && filteredOnFalse.size() == 1 && filteredOnTrue.get(0) instanceof PushItem && filteredOnFalse.get(0) instanceof PushItem) {
                        stack.push(new TernarOpItem(null, localData.lineStartInstruction, graphTargetItem.invert(null), ((PushItem)filteredOnTrue.get((int)0)).value, ((PushItem)filteredOnFalse.get((int)0)).value));
                    } else {
                        void var25_34;
                        boolean isIf = true;
                        if (filteredOnTrue.isEmpty() && !filteredOnFalse.isEmpty()) {
                            GraphTargetItem graphTargetItem2 = graphTargetItem.invert(null);
                            List<GraphTargetItem> tmp = onTrue;
                            onTrue = onFalse;
                            onFalse = tmp;
                            filteredOnTrue = filteredOnFalse;
                        }
                        if (!stack.isEmpty() && (filteredOnTrue.size() == 1 && filteredOnTrue.get(0) instanceof PopItem || filteredOnTrue.size() >= 2 && filteredOnTrue.get(0) instanceof PopItem && filteredOnTrue.get(filteredOnTrue.size() - 1) instanceof PushItem)) {
                            if (filteredOnTrue.size() > 1) {
                                GraphTargetItem rightSide = ((PushItem)filteredOnTrue.get((int)(filteredOnTrue.size() - 1))).value;
                                GraphTargetItem prevExpr = stack.pop();
                                GraphTargetItem leftSide = var25_34.getNotCoercedNoDup();
                                if (leftSide instanceof DuplicateItem) {
                                    isIf = false;
                                    stack.push(new OrItem(null, localData.lineStartInstruction, prevExpr, rightSide));
                                } else if (leftSide.invert(null).getNotCoercedNoDup() instanceof DuplicateItem) {
                                    isIf = false;
                                    stack.push(new AndItem(null, localData.lineStartInstruction, prevExpr, rightSide));
                                } else if (prevExpr instanceof FalseItem) {
                                    isIf = false;
                                    leftSide = leftSide.invert(null);
                                    stack.push(new AndItem(null, localData.lineStartInstruction, leftSide, rightSide));
                                } else if (prevExpr instanceof TrueItem) {
                                    isIf = false;
                                    stack.push(new OrItem(null, localData.lineStartInstruction, leftSide, rightSide));
                                }
                            } else {
                                isIf = false;
                            }
                        }
                        if (isIf) {
                            Graph.makeAllCommands(currentRet, stack);
                            IfItem b = new IfItem(null, localData.lineStartInstruction, var25_34.invert(null), onTrue, onFalse);
                            currentRet.add(b);
                            if (this.processSubBlk(b, null)) {
                                stack.push(new PopItem(null, localData.lineStartInstruction));
                            }
                        }
                    }
                    if (next != null) {
                        this.printGraph(partCodes, partCodePos, visited, localData, stack, allParts, part, (GraphPart)next, stopPart, loops, currentRet, staticOperation, path, recursionLevel + 1);
                    }
                }
            }
            if (part.nextParts.size() == 1) {
                nextOnePart = part.nextParts.get(0);
            }
            if (nextOnePart != null) {
                this.printGraph(partCodes, partCodePos, visited, localData, stack, allParts, part, part.nextParts.get(0), stopPart, loops, currentRet, staticOperation, path, recursionLevel + 1);
            }
        }
        if (isLoop && loopItem != null && currentLoop != null) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            List<GraphTargetItem> bodyBranch;
            IfItem ifi;
            LoopItem li = loopItem;
            boolean bl4 = false;
            boolean hasContinue = false;
            this.processIfs(loopItem.commands);
            this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
            List<ContinueItem> continues = loopItem.getContinues();
            for (ContinueItem c : continues) {
                if (c.loopId != currentLoop.id) continue;
                hasContinue = true;
                break;
            }
            if (!hasContinue && currentLoop.loopPreContinue != null) {
                ArrayList<GraphPart> stopContPart = new ArrayList<GraphPart>();
                stopContPart.add(currentLoop.loopContinue);
                GraphPart precoBackup = currentLoop.loopPreContinue;
                currentLoop.loopPreContinue = null;
                loopItem.commands.addAll(this.printGraph(partCodes, partCodePos, visited, localData, new TranslateStack(path), allParts, null, precoBackup, stopContPart, loops, null, staticOperation, path, recursionLevel + 1));
            }
            if (!bl4 && !loopItem.commands.isEmpty() && loopItem.commands.get(0) instanceof IfItem) {
                ifi = (IfItem)loopItem.commands.get(0);
                bodyBranch = null;
                boolean inverted = false;
                boolean breakpos2 = false;
                if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onTrue.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onFalse;
                        inverted = true;
                    }
                } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onFalse.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onTrue;
                    }
                } else if (loopItem.commands.size() == 2 && loopItem.commands.get(1) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)loopItem.commands.get(1);
                    if (bi.loopId == currentLoop.id) {
                        if (ifi.onTrue.isEmpty()) {
                            inverted = true;
                        }
                        bodyBranch = inverted ? ifi.onFalse : ifi.onTrue;
                        breakpos2 = true;
                    }
                }
                if (bodyBranch != null) {
                    int index = ret.indexOf(loopItem);
                    ret.remove(index);
                    ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                    GraphTargetItem expr = ifi.expression;
                    if (inverted) {
                        expr = expr instanceof LogicalOpItem ? ((LogicalOpItem)((Object)expr)).invert(null) : new NotItem(null, expr.getLineStartItem(), expr);
                    }
                    exprList.add(expr);
                    ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                    commands.addAll(bodyBranch);
                    loopItem.commands.remove(0);
                    if (breakpos2) {
                        loopItem.commands.remove(0);
                    }
                    commands.addAll(loopItem.commands);
                    this.checkContinueAtTheEnd(commands, currentLoop);
                    List<GraphTargetItem> finalComm = new ArrayList<GraphTargetItem>();
                    if (currentLoop.loopPreContinue != null) {
                        GraphPart backup = currentLoop.loopPreContinue;
                        currentLoop.loopPreContinue = null;
                        ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                        stopPart2.add(currentLoop.loopContinue);
                        finalComm = this.printGraph(partCodes, partCodePos, visited, localData, new TranslateStack(path), allParts, null, backup, stopPart2, loops, null, staticOperation, path, recursionLevel + 1);
                        currentLoop.loopPreContinue = backup;
                        this.checkContinueAtTheEnd(finalComm, currentLoop);
                    }
                    if (!finalComm.isEmpty()) {
                        li = new ForItem(expr.getSrc(), expr.getLineStartItem(), currentLoop, new ArrayList<GraphTargetItem>(), (GraphTargetItem)exprList.get(exprList.size() - 1), finalComm, commands);
                        ret.add(index, li);
                    } else {
                        li = new WhileItem(expr.getSrc(), expr.getLineStartItem(), currentLoop, exprList, commands);
                        ret.add(index, li);
                    }
                    bl3 = true;
                }
            }
            if (!bl3 && !loopItem.commands.isEmpty() && loopItem.commands.get(loopItem.commands.size() - 1) instanceof IfItem) {
                ifi = (IfItem)loopItem.commands.get(loopItem.commands.size() - 1);
                bodyBranch = null;
                boolean inverted = false;
                if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onTrue.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onFalse;
                        inverted = true;
                    }
                } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onFalse.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onTrue;
                    }
                }
                if (bodyBranch != null) {
                    int index = ret.indexOf(loopItem);
                    ret.remove(index);
                    ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                    GraphTargetItem expr = ifi.expression;
                    if (inverted) {
                        expr = expr.invert(null);
                    }
                    this.checkContinueAtTheEnd(bodyBranch, currentLoop);
                    ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                    if (!bodyBranch.isEmpty()) {
                        ret.add(index, loopItem);
                    } else {
                        loopItem.commands.remove(loopItem.commands.size() - 1);
                        commands.addAll(loopItem.commands);
                        commands.addAll(bodyBranch);
                        exprList.add(expr);
                        this.checkContinueAtTheEnd(commands, currentLoop);
                        li = new DoWhileItem(null, ((GraphTargetItem)exprList.get(0)).getLineStartItem(), currentLoop, commands, exprList);
                        ret.add(index, li);
                    }
                    bl2 = true;
                }
            }
            if (!bl2 && currentLoop.loopPreContinue != null) {
                bl = true;
                GraphPart backup = currentLoop.loopPreContinue;
                currentLoop.loopPreContinue = null;
                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                stopPart2.add(currentLoop.loopContinue);
                List<GraphTargetItem> finalComm = this.printGraph(partCodes, partCodePos, visited, localData, new TranslateStack(path), allParts, null, backup, stopPart2, loops, null, staticOperation, path, recursionLevel + 1);
                currentLoop.loopPreContinue = backup;
                this.checkContinueAtTheEnd(finalComm, currentLoop);
                if (!finalComm.isEmpty() && finalComm.get(finalComm.size() - 1) instanceof IfItem) {
                    IfItem ifi2 = (IfItem)finalComm.get(finalComm.size() - 1);
                    boolean ok = false;
                    boolean invert = false;
                    if (ifi2.onTrue.size() == 1 && ifi2.onTrue.get(0) instanceof BreakItem && ((BreakItem)ifi2.onTrue.get((int)0)).loopId == currentLoop.id && ifi2.onFalse.size() == 1 && ifi2.onFalse.get(0) instanceof ContinueItem && ((ContinueItem)ifi2.onFalse.get((int)0)).loopId == currentLoop.id) {
                        ok = true;
                        invert = true;
                    }
                    if (ifi2.onTrue.size() == 1 && ifi2.onTrue.get(0) instanceof ContinueItem && ((ContinueItem)ifi2.onTrue.get((int)0)).loopId == currentLoop.id && ifi2.onFalse.size() == 1 && ifi2.onFalse.get(0) instanceof BreakItem && ((BreakItem)ifi2.onFalse.get((int)0)).loopId == currentLoop.id) {
                        ok = true;
                    }
                    if (ok) {
                        finalComm.remove(finalComm.size() - 1);
                        int index = ret.indexOf(loopItem);
                        ret.remove(index);
                        ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>(finalComm);
                        GraphTargetItem expr = ifi2.expression;
                        if (invert) {
                            expr = expr.invert(null);
                        }
                        exprList.add(expr);
                        li = new DoWhileItem(null, expr.getLineStartItem(), currentLoop, loopItem.commands, exprList);
                        ret.add(index, li);
                    }
                }
            }
            if (!bl) {
                this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
            }
            currentLoop.phase = 2;
            GraphTargetItem replaced = this.checkLoop(li, localData, loops);
            if (replaced != li) {
                int index = ret.indexOf(li);
                ret.remove(index);
                if (replaced != null) {
                    ret.add(index, replaced);
                }
            }
            if (currentLoop.loopBreak != null) {
                ret.addAll(this.printGraph(partCodes, partCodePos, visited, localData, sPreLoop, allParts, part, currentLoop.loopBreak, stopPart, loops, null, staticOperation, path, recursionLevel + 1));
            }
        }
        return ret;
    }

    protected void checkGraph(List<GraphPart> allBlocks) {
    }

    private List<GraphPart> makeGraph(GraphSource code, List<GraphPart> allBlocks, List<Integer> alternateEntries) throws InterruptedException {
        HashMap<Integer, List<Integer>> refs = code.visitCode(alternateEntries);
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        boolean[] visited = new boolean[code.size()];
        ret.add(this.makeGraph(null, new GraphPath(), code, 0, 0, allBlocks, refs, visited));
        for (int pos : alternateEntries) {
            GraphPart e1 = new GraphPart(-1, -1);
            e1.path = new GraphPath("e");
            ret.add(this.makeGraph(e1, new GraphPath("e"), code, pos, pos, allBlocks, refs, visited));
        }
        this.checkGraph(allBlocks);
        return ret;
    }

    protected int checkIp(int ip) {
        return ip;
    }

    private GraphPart makeGraph(GraphPart parent, GraphPath path, GraphSource code, int startip, int lastIp, List<GraphPart> allBlocks, HashMap<Integer, List<Integer>> refs, boolean[] visited2) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        int ip = startip;
        for (GraphPart p : allBlocks) {
            if (p.start != ip) continue;
            p.refs.add(parent);
            return p;
        }
        GraphPart ret = new GraphPart(ip, -1);
        ret.path = path;
        GraphPart part = ret;
        while (ip < code.size()) {
            GraphPart g;
            if (visited2[ip] || ip != startip && refs.get(ip).size() > 1) {
                part.end = lastIp;
                GraphPart found = null;
                for (GraphPart p : allBlocks) {
                    if (p.start != ip) continue;
                    found = p;
                    break;
                }
                allBlocks.add(part);
                if (found != null) {
                    part.nextParts.add(found);
                    found.refs.add(part);
                    break;
                }
                GraphPart gp = new GraphPart(ip, -1);
                gp.path = path;
                part.nextParts.add(gp);
                gp.refs.add(part);
                part = gp;
            }
            lastIp = ip = this.checkIp(ip);
            GraphSourceItem ins = code.get(ip);
            if (ins.isIgnored()) {
                ++ip;
                continue;
            }
            if (ins instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)ins);
                if (!(ins instanceof Action)) continue;
                long endAddr = ((Action)ins).getAddress() + cnt.getHeaderSize();
                for (long size : cnt.getContainerSizes()) {
                    endAddr += size;
                }
                ip = code.adr2pos(endAddr);
                continue;
            }
            if (ins.isExit()) {
                part.end = ip;
                allBlocks.add(part);
                break;
            }
            if (ins.isJump()) {
                part.end = ip;
                allBlocks.add(part);
                ip = ins.getBranches(code).get(0);
                g = this.makeGraph(part, path, code, ip, lastIp, allBlocks, refs, visited2);
                part.nextParts.add(g);
                g.refs.add(part);
                break;
            }
            if (ins.isBranch()) {
                part.end = ip;
                allBlocks.add(part);
                List<Integer> branches = ins.getBranches(code);
                for (int i = 0; i < branches.size(); ++i) {
                    g = this.makeGraph(part, path.sub(i, ip), code, branches.get(i), ip, allBlocks, refs, visited2);
                    part.nextParts.add(g);
                    g.refs.add(part);
                }
                break;
            }
            ++ip;
        }
        if (part.end == -1 && ip >= code.size()) {
            if (part.start == code.size()) {
                part.end = code.size();
                allBlocks.add(part);
            } else {
                part.end = ip - 1;
                for (GraphPart p : allBlocks) {
                    if (p.start != ip) continue;
                    p.refs.add(part);
                    part.nextParts.add(p);
                    allBlocks.add(part);
                    return ret;
                }
                GraphPart gp = new GraphPart(ip, ip);
                allBlocks.add(gp);
                gp.refs.add(part);
                part.nextParts.add(gp);
                allBlocks.add(part);
            }
        }
        return ret;
    }

    public static GraphTextWriter graphToString(List<GraphTargetItem> tree, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        for (GraphTargetItem ti : tree) {
            if (ti.isEmpty()) continue;
            ti.toStringSemicoloned(writer, localData).newLine();
        }
        return writer;
    }

    public BaseLocalData prepareBranchLocalData(BaseLocalData localData) {
        return localData;
    }

    protected List<GraphPart> checkPrecoNextParts(GraphPart part) {
        return null;
    }

    protected GraphPart makeMultiPart(GraphPart part) {
        ArrayList<GraphPart> parts = new ArrayList<GraphPart>();
        do {
            parts.add(part);
        } while ((part = part.nextParts.size() == 1 && part.nextParts.get((int)0).refs.size() == 1 ? part.nextParts.get(0) : null) != null);
        if (parts.size() > 1) {
            GraphPartMulti ret = new GraphPartMulti(parts);
            ret.refs.addAll(((GraphPart)parts.get((int)0)).refs);
            ret.nextParts.addAll(((GraphPart)parts.get((int)(parts.size() - 1))).nextParts);
            return ret;
        }
        return (GraphPart)parts.get(0);
    }

    protected List<GraphSourceItem> getPartItems(GraphPart part) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        do {
            for (int i = 0; i < part.getHeight(); ++i) {
                GraphSourceItem s;
                if (part.getPosAt(i) >= this.code.size() || part.getPosAt(i) < 0 || (s = this.code.get(part.getPosAt(i))).isJump()) continue;
                ret.add(s);
            }
        } while ((part = part.nextParts.size() == 1 && part.nextParts.get((int)0).refs.size() == 1 ? part.nextParts.get(0) : null) != null);
        return ret;
    }

    protected static void makeAllStack(List<GraphTargetItem> commands, TranslateStack stack) {
        int i;
        int pcnt = 0;
        for (i = commands.size() - 1; i >= 0 && commands.get(i) instanceof PushItem; --i) {
            ++pcnt;
        }
        for (i = commands.size() - pcnt; i < commands.size(); ++i) {
            stack.push(commands.remove((int)i).value);
            --i;
        }
    }

    protected static void makeAllCommands(List<GraphTargetItem> commands, TranslateStack stack) {
        int clen = commands.size();
        if (!commands.isEmpty() && commands.get(commands.size() - 1) instanceof BreakItem) {
            --clen;
        }
        while (stack.size() > 0) {
            GraphTargetItem p = stack.pop();
            if (p instanceof PopItem) continue;
            if (p instanceof FunctionActionItem) {
                commands.add(clen, p);
                continue;
            }
            commands.add(clen, new PushItem(p));
        }
    }
}

