/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import java.io.IOException;
import java.io.Serializable;

public class EdgeType
implements Serializable {
    private static final int[] sizes = new int[]{1, 2, 1, 2, 1, 2, 3, 4, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int Edge_H12 = 0;
    private static final int Edge_H20 = 1;
    private static final int Edge_V12 = 2;
    private static final int Edge_V20 = 3;
    private static final int Edge_L6 = 4;
    private static final int Edge_L10 = 5;
    private static final int Edge_L14 = 6;
    private static final int Edge_L18 = 7;
    private static final int Edge_C5 = 8;
    private static final int Edge_C7 = 9;
    private static final int Edge_C9 = 10;
    private static final int Edge_C11 = 11;
    private static final int Edge_C13 = 12;
    private static final int Edge_C15 = 13;
    private static final int Edge_C17 = 14;
    private static final int Edge_C19 = 15;
    private static final int Edge_HLine = 0;
    private static final int Edge_VLine = 1;
    private static final int Edge_Line = 2;
    private static final int Edge_Quad = 3;
    public int[] data;

    public EdgeType(boolean vertical, int v) {
        this.data = new int[]{vertical ? 1 : 0, v};
    }

    public EdgeType(int x, int y) {
        this.data = new int[]{2, x, y};
    }

    public EdgeType(int cx, int cy, int ax, int ay) {
        this.data = new int[]{3, cx, cy, ax, ay};
    }

    public String toString() {
        String ret = "[Edge data:";
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                ret = ret + ", ";
            }
            ret = ret + "" + this.data[i];
        }
        ret = ret + "]";
        return ret;
    }

    public EdgeType(GFxInputStream sis) throws IOException {
        this.data = this.readEdge(sis);
    }

    private static int SInt8(int val) {
        return (byte)val;
    }

    public SHAPERECORD toSHAPERECORD() {
        int multiplier = 1;
        switch (this.data[0]) {
            case 0: {
                StraightEdgeRecord ser = new StraightEdgeRecord();
                ser.generalLineFlag = false;
                ser.deltaX = this.data[1] * multiplier;
                ser.calculateBits();
                return ser;
            }
            case 1: {
                StraightEdgeRecord ser = new StraightEdgeRecord();
                ser.generalLineFlag = false;
                ser.vertLineFlag = true;
                ser.deltaY = this.data[1] * multiplier;
                ser.calculateBits();
                return ser;
            }
            case 2: {
                StraightEdgeRecord ser = new StraightEdgeRecord();
                ser.generalLineFlag = true;
                ser.deltaX = this.data[1] * multiplier;
                ser.deltaY = this.data[2] * multiplier;
                ser.calculateBits();
                return ser;
            }
            case 3: {
                CurvedEdgeRecord cer = new CurvedEdgeRecord();
                cer.controlDeltaX = this.data[1] * multiplier;
                cer.controlDeltaY = this.data[2] * multiplier;
                cer.anchorDeltaX = this.data[3] * multiplier;
                cer.anchorDeltaY = this.data[4] * multiplier;
                cer.calculateBits();
                return cer;
            }
        }
        return null;
    }

    private int[] readEdge(GFxInputStream sis) throws IOException {
        byte firstByte = (byte)sis.readUI8("firstByte");
        byte raw1 = (byte)sis.readUI8("byte1");
        int[] data = new int[5];
        switch (firstByte & 0xF) {
            case 0: {
                data[0] = 0;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8(raw1 & 0xFF) << 4;
                break;
            }
            case 1: {
                byte raw2 = (byte)sis.readUI8("byte2");
                data[0] = 0;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8(raw2 & 0xFF) << 12;
                break;
            }
            case 2: {
                data[0] = 1;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8(raw1 & 0xFF) << 4;
                break;
            }
            case 3: {
                data[0] = 1;
                byte raw2 = (byte)sis.readUI8("byte2");
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8(raw2 & 0xFF) << 12;
                break;
            }
            case 4: {
                data[0] = 2;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 6) >> 2;
                data[2] = EdgeType.SInt8(raw1 & 0xFF) >> 2;
                break;
            }
            case 5: {
                byte raw2 = (byte)sis.readUI8("byte2");
                data[0] = 2;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 2) << 2;
                data[2] = (raw1 & 0xFF) >> 6 | EdgeType.SInt8(raw2 & 0xFF) << 2;
                break;
            }
            case 6: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                data[0] = 2;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8((raw2 & 0xFF) << 6) << 6;
                data[2] = (raw2 & 0xFF) >> 2 | EdgeType.SInt8(raw3 & 0xFF) << 6;
                break;
            }
            case 7: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                data[0] = 2;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8((raw2 & 0xFF) << 2) << 10;
                data[2] = (raw2 & 0xFF) >> 6 | (raw3 & 0xFF) << 2 | EdgeType.SInt8(raw4 & 0xFF) << 10;
                break;
            }
            case 8: {
                byte raw2 = (byte)sis.readUI8("byte2");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 7) >> 3;
                data[2] = EdgeType.SInt8((raw1 & 0xFF) << 2) >> 3;
                data[3] = (raw1 & 0xFF) >> 6 | EdgeType.SInt8((raw2 & 0xFF) << 5) >> 3;
                data[4] = EdgeType.SInt8(raw2 & 0xFF) >> 3;
                break;
            }
            case 9: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 5) >> 1;
                data[2] = (raw1 & 0xFF) >> 3 | EdgeType.SInt8((raw2 & 0xFF) << 6) >> 1;
                data[3] = (raw2 & 0xFF) >> 2 | EdgeType.SInt8((raw3 & 0xFF) << 7) >> 1;
                data[4] = EdgeType.SInt8(raw3) >> 1;
                break;
            }
            case 10: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 3) << 1;
                data[2] = (raw1 & 0xFF) >> 5 | EdgeType.SInt8((raw2 & 0xFF) << 2) << 1;
                data[3] = (raw2 & 0xFF) >> 6 | EdgeType.SInt8((raw3 & 0xFF) << 1) << 1;
                data[4] = (raw3 & 0xFF) >> 7 | EdgeType.SInt8(raw4 & 0xFF) << 1;
                break;
            }
            case 11: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                byte raw5 = (byte)sis.readUI8("byte5");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | EdgeType.SInt8((raw1 & 0xFF) << 1) << 3;
                data[2] = raw1 >> 7 | (raw2 & 0xFF) << 1 | EdgeType.SInt8((raw3 & 0xFF) << 6) << 3;
                data[3] = (raw3 & 0xFF) >> 2 | EdgeType.SInt8((raw4 & 0xFF) << 3) << 3;
                data[4] = (raw4 & 0xFF) >> 5 | EdgeType.SInt8(raw5 & 0xFF) << 3;
                break;
            }
            case 12: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                byte raw5 = (byte)sis.readUI8("byte5");
                byte raw6 = (byte)sis.readUI8("byte6");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8((raw2 & 0xFF) << 7) << 5;
                data[2] = (raw2 & 0xFF) >> 1 | EdgeType.SInt8((raw3 & 0xFF) << 2) << 5;
                data[3] = (raw3 & 0xFF) >> 6 | (raw4 & 0xFF) << 2 | EdgeType.SInt8((raw5 & 0xFF) << 5) << 5;
                data[4] = (raw5 & 0xFF) >> 3 | EdgeType.SInt8(raw6 & 0xFF) << 5;
                break;
            }
            case 13: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                byte raw5 = (byte)sis.readUI8("byte5");
                byte raw6 = (byte)sis.readUI8("byte6");
                byte raw7 = (byte)sis.readUI8("byte7");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8((raw2 & 0xFF) << 5) << 7;
                data[2] = (raw2 & 0xFF) >> 3 | (raw3 & 0xFF) << 5 | EdgeType.SInt8((raw4 & 0xFF) << 6) << 7;
                data[3] = (raw4 & 0xFF) >> 2 | (raw5 & 0xFF) << 6 | EdgeType.SInt8((raw6 & 0xFF) << 7) << 7;
                data[4] = (raw6 & 0xFF) >> 1 | EdgeType.SInt8(raw7 & 0xFF) << 7;
                break;
            }
            case 14: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                byte raw5 = (byte)sis.readUI8("byte5");
                byte raw6 = (byte)sis.readUI8("byte6");
                byte raw7 = (byte)sis.readUI8("byte7");
                byte raw8 = (byte)sis.readUI8("byte8");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8((raw2 & 0xFF) << 3) << 9;
                data[2] = (raw2 & 0xFF) >> 5 | (raw3 & 0xFF) << 3 | EdgeType.SInt8((raw4 & 0xFF) << 2) << 9;
                data[3] = (raw4 & 0xFF) >> 6 | (raw5 & 0xFF) << 2 | EdgeType.SInt8((raw6 & 0xFF) << 1) << 9;
                data[4] = (raw6 & 0xFF) >> 7 | (raw7 & 0xFF) << 1 | EdgeType.SInt8(raw8 & 0xFF) << 9;
                break;
            }
            case 15: {
                byte raw2 = (byte)sis.readUI8("byte2");
                byte raw3 = (byte)sis.readUI8("byte3");
                byte raw4 = (byte)sis.readUI8("byte4");
                byte raw5 = (byte)sis.readUI8("byte5");
                byte raw6 = (byte)sis.readUI8("byte6");
                byte raw7 = (byte)sis.readUI8("byte7");
                byte raw8 = (byte)sis.readUI8("byte8");
                byte raw9 = (byte)sis.readUI8("byte9");
                data[0] = 3;
                data[1] = (firstByte & 0xFF) >> 4 | (raw1 & 0xFF) << 4 | EdgeType.SInt8(raw2 << 1) << 11;
                data[2] = (raw2 & 0xFF) >> 7 | (raw3 & 0xFF) << 1 | (raw4 & 0xFF) << 9 | EdgeType.SInt8(raw5 << 6) << 11;
                data[3] = (raw5 & 0xFF) >> 2 | (raw6 & 0xFF) << 6 | EdgeType.SInt8(raw7 << 3) << 11;
                data[4] = (raw7 & 0xFF) >> 5 | (raw8 & 0xFF) << 3 | EdgeType.SInt8(raw9) << 11;
            }
        }
        return data;
    }

    public void write(GFxOutputStream sos) throws IOException {
        int m1 = 1;
        int m2 = 3;
        int m3 = 7;
        int m4 = 15;
        int m5 = 31;
        int m6 = 63;
        int m7 = 127;
        switch (this.data[0]) {
            case 0: {
                int x = this.data[1];
                if (x >= -2048 && x <= 2047) {
                    sos.writeUI8(x << 4 | 0);
                    sos.writeUI8(x >> 4);
                    return;
                }
                sos.writeUI8(x << 4 | 1);
                sos.writeUI8(x >> 4);
                sos.writeUI8(x >> 12);
                break;
            }
            case 1: {
                int y = this.data[1];
                if (y >= -2048 && y <= 2047) {
                    sos.writeUI8(y << 4 | 2);
                    sos.writeUI8(y >> 4);
                    return;
                }
                sos.writeUI8(y << 4 | 3);
                sos.writeUI8(y >> 4);
                sos.writeUI8(y >> 12);
                return;
            }
            case 2: {
                int x = this.data[1];
                int y = this.data[2];
                if (x >= -32 && x <= 31 && y >= -32 && y <= 31) {
                    sos.writeUI8(x << 4 | 4);
                    sos.writeUI8(x >> 4 & m2 | y << 2);
                    return;
                }
                if (x >= -512 && x <= 511 && y >= -512 && y <= 511) {
                    sos.writeUI8(x << 4 | 5);
                    sos.writeUI8(x >> 4 & m6 | y << 6);
                    sos.writeUI8(y >> 2);
                    return;
                }
                if (x >= -8192 && x <= 8191 && y >= -8192 && y <= 8191) {
                    sos.writeUI8(x << 4 | 6);
                    sos.writeUI8(x >> 4);
                    sos.writeUI8(x >> 12 & m2 | y << 2);
                    sos.writeUI8(y >> 6);
                    return;
                }
                sos.writeUI8(x << 4 | 7);
                sos.writeUI8(x >> 4);
                sos.writeUI8(x >> 12 & m6 | y << 6);
                sos.writeUI8(y >> 2);
                sos.writeUI8(y >> 10);
                return;
            }
            case 3: {
                int cx = this.data[1];
                int cy = this.data[2];
                int ax = this.data[3];
                int ay = this.data[4];
                int minV = cx;
                int maxV = cx;
                if (cy < minV) {
                    minV = cy;
                }
                if (cy > maxV) {
                    maxV = cy;
                }
                if (ax < minV) {
                    minV = ax;
                }
                if (ax > maxV) {
                    maxV = ax;
                }
                if (ay < minV) {
                    minV = ay;
                }
                if (ay > maxV) {
                    maxV = ay;
                }
                if (minV >= -16 && maxV <= 15) {
                    sos.writeUI8(cx << 4 | 8);
                    sos.writeUI8(cx >> 4 & m1 | cy << 1 & m6 | ax << 6);
                    sos.writeUI8(ax >> 2 & m3 | ay << 3);
                    return;
                }
                if (minV >= -64 && maxV <= 63) {
                    sos.writeUI8(cx << 4 | 9);
                    sos.writeUI8(cx >> 4 & m3 | cy << 3);
                    sos.writeUI8(cy >> 5 & m2 | ax << 2);
                    sos.writeUI8(ax >> 6 & m1 | ay << 1);
                    return;
                }
                if (minV >= -256 && maxV <= 255) {
                    sos.writeUI8(cx << 4 | 0xA);
                    sos.writeUI8(cx >> 4 & m5 | cy << 5);
                    sos.writeUI8(cy >> 3 & m6 | ax << 6);
                    sos.writeUI8(ax >> 2 & m7 | ay << 7);
                    sos.writeUI8(ay >> 1);
                    return;
                }
                if (minV >= -1024 && maxV <= 1023) {
                    sos.writeUI8(cx << 4 | 0xB);
                    sos.writeUI8(cx >> 4 & m7 | cy << 7);
                    sos.writeUI8(cy >> 1);
                    sos.writeUI8(cy >> 9 & m2 | ax << 2);
                    sos.writeUI8(ax >> 6 & m5 | ay << 5);
                    sos.writeUI8(ay >> 3);
                    return;
                }
                if (minV >= -4096 && maxV <= 4095) {
                    sos.writeUI8(cx << 4 | 0xC);
                    sos.writeUI8(cx >> 4);
                    sos.writeUI8(cx >> 12 & m1 | cy << 1);
                    sos.writeUI8(cy >> 7 & m6 | ax << 6);
                    sos.writeUI8(ax >> 2);
                    sos.writeUI8(ax >> 10 & m3 | ay << 3);
                    sos.writeUI8(ay >> 5);
                    return;
                }
                if (minV >= -16384 && maxV <= 16383) {
                    sos.writeUI8(cx << 4 | 0xD);
                    sos.writeUI8(cx >> 4);
                    sos.writeUI8(cx >> 12 & m3 | cy << 3);
                    sos.writeUI8(cy >> 5);
                    sos.writeUI8(cy >> 13 & m2 | ax << 2);
                    sos.writeUI8(ax >> 6);
                    sos.writeUI8(ax >> 14 & m1 | ay << 1);
                    sos.writeUI8(ay >> 7);
                    return;
                }
                if (minV >= -65536 && maxV <= 65535) {
                    sos.writeUI8(cx << 4 | 0xE);
                    sos.writeUI8(cx >> 4);
                    sos.writeUI8(cx >> 12 & m5 | cy << 5);
                    sos.writeUI8(cy >> 3);
                    sos.writeUI8(cy >> 11 & m6 | ax << 6);
                    sos.writeUI8(ax >> 2);
                    sos.writeUI8(ax >> 10 & m7 | ay << 7);
                    sos.writeUI8(ay >> 1);
                    sos.writeUI8(ay >> 9);
                    return;
                }
                sos.writeUI8(cx << 4 | 0xF);
                sos.writeUI8(cx >> 4);
                sos.writeUI8(cx >> 12 & m7 | cy << 7);
                sos.writeUI8(cy >> 1);
                sos.writeUI8(cy >> 9);
                sos.writeUI8(cy >> 17 & m2 | ax << 2);
                sos.writeUI8(ax >> 6);
                sos.writeUI8(ax >> 14 & m5 | ay << 5);
                sos.writeUI8(ay >> 3);
                sos.writeUI8(ay >> 11);
            }
        }
    }
}

