/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject4Tag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DepthState {
    public int characterId = -1;
    public MATRIX matrix;
    public String instanceName;
    public ColorTransform colorTransForm;
    public boolean cacheAsBitmap = false;
    public int blendMode = 0;
    public List<FILTER> filters = new ArrayList<FILTER>();
    public boolean isVisible = true;
    public RGBA backGroundColor;
    public CLIPACTIONS clipActions;
    public byte[] amfData;
    public int ratio = -1;
    public boolean key = false;
    public int clipDepth = -1;
    public int time = 0;
    private final SWF swf;
    public Frame frame;
    public PlaceObjectTypeTag placeObjectTag;
    public int minPlaceObjectNum;
    public long instanceId;
    public boolean motionTween = false;
    private static AtomicLong lastInstanceId = new AtomicLong(0L);

    public static long getNewInstanceId() {
        return lastInstanceId.addAndGet(1L);
    }

    public DepthState(SWF swf, Frame frame) {
        this.swf = swf;
        this.frame = frame;
        this.instanceId = DepthState.getNewInstanceId();
    }

    public DepthState(DepthState obj, Frame frame, boolean sameInstance) {
        this.frame = frame;
        this.swf = obj.swf;
        this.characterId = obj.characterId;
        this.matrix = obj.matrix;
        this.instanceName = obj.instanceName;
        this.colorTransForm = obj.colorTransForm;
        this.cacheAsBitmap = obj.cacheAsBitmap;
        this.blendMode = obj.blendMode;
        this.filters = obj.filters;
        this.isVisible = obj.isVisible;
        this.backGroundColor = obj.backGroundColor;
        this.clipActions = obj.clipActions;
        this.ratio = obj.ratio;
        this.clipDepth = obj.clipDepth;
        this.time = obj.time;
        this.placeObjectTag = obj.placeObjectTag;
        this.minPlaceObjectNum = obj.minPlaceObjectNum;
        if (sameInstance) {
            ++this.time;
            this.instanceId = obj.instanceId;
        } else {
            this.instanceId = DepthState.getNewInstanceId();
        }
    }

    public boolean cacheAsBitmap() {
        return this.placeObjectTag != null && this.placeObjectTag.cacheAsBitmap() || this.filters != null && this.filters.size() > 0;
    }

    public PlaceObjectTypeTag toPlaceObjectTag(int depth) {
        if (this.minPlaceObjectNum <= 1) {
            CXFORM cxForm0 = this.colorTransForm == null ? null : new CXFORM(this.colorTransForm);
            return new PlaceObjectTag(this.swf, this.characterId, depth, this.matrix, cxForm0);
        }
        if (this.minPlaceObjectNum == 2) {
            CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
            return new PlaceObject2Tag(this.swf, false, depth, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.clipActions);
        }
        if (this.minPlaceObjectNum == 3) {
            CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
            return new PlaceObject3Tag(this.swf, false, depth, null, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.filters, this.blendMode, this.cacheAsBitmap ? 1 : 0, this.isVisible ? 1 : 0, this.backGroundColor, this.clipActions);
        }
        CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
        return new PlaceObject4Tag(this.swf, false, depth, null, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.filters, this.blendMode, this.cacheAsBitmap ? 1 : 0, this.isVisible ? 1 : 0, this.backGroundColor, this.clipActions, null);
    }
}

