/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.importers.TagImporter;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ImageImporter
extends TagImporter {
    public Tag importImage(ImageTag it, byte[] newData) throws IOException {
        return this.importImage(it, newData, 0);
    }

    public Tag importImage(ImageTag it, byte[] newData, int tagType) throws IOException {
        if (newData[0] == 66 && newData[1] == 77) {
            BufferedImage b = ImageHelper.read(newData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageHelper.write(b, ImageFormat.PNG, baos);
            newData = baos.toByteArray();
        }
        if (tagType == 0) {
            tagType = it instanceof DefineBitsTag ? 21 : it.getId();
        }
        if (it.getId() != tagType) {
            ImageTag imageTag;
            SWF swf = it.getSwf();
            ByteArrayRange range = it.getOriginalRange();
            int characterId = it.getCharacterId();
            switch (tagType) {
                case 21: {
                    imageTag = new DefineBitsJPEG2Tag(swf, range, characterId, newData);
                    break;
                }
                case 35: {
                    imageTag = new DefineBitsJPEG3Tag(swf, range, characterId, newData);
                    break;
                }
                case 90: {
                    imageTag = new DefineBitsJPEG4Tag(swf, range, characterId, newData);
                    break;
                }
                case 20: {
                    DefineBitsLosslessTag losslessTag = new DefineBitsLosslessTag(swf, range, characterId);
                    losslessTag.setImage(newData);
                    imageTag = losslessTag;
                    break;
                }
                case 36: {
                    DefineBitsLossless2Tag lossless2Tag = new DefineBitsLossless2Tag(swf, range, characterId);
                    lossless2Tag.setImage(newData);
                    imageTag = lossless2Tag;
                    break;
                }
                default: {
                    throw new Error("Unsupported image type tag.");
                }
            }
            imageTag.setModified(true);
            swf.replaceTag(it, (Tag)imageTag);
            swf.updateCharacters();
            return imageTag;
        }
        it.setImage(newData);
        return null;
    }

    public Tag importImageAlpha(ImageTag it, byte[] newData) throws IOException {
        try {
            BufferedImage img = ImageHelper.read(newData);
            int width = img.getWidth();
            int height = img.getHeight();
            byte[] data = new byte[width * height];
            int[] imgData = img.getRGB(0, 0, width, height, null, 0, width);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int alpha = imgData[y * width + x] >> 24 & 0xFF;
                    data[y * width + x] = (byte)alpha;
                }
            }
            newData = data;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (it instanceof DefineBitsJPEG3Tag) {
            ((DefineBitsJPEG3Tag)it).setImageAlpha(newData);
        } else if (it instanceof DefineBitsJPEG4Tag) {
            ((DefineBitsJPEG4Tag)it).setImageAlpha(newData);
        }
        return null;
    }

    public void convertImage(ImageTag it, int tagType) throws IOException {
        this.importImage(it, Helper.readStream(it.getImageData()), tagType);
    }

    public static int getImageTagType(String format) {
        int res = 0;
        switch (format) {
            case "lossless": {
                res = 20;
                break;
            }
            case "lossless2": {
                res = 36;
                break;
            }
            case "jpeg2": {
                res = 21;
                break;
            }
            case "jpeg3": {
                res = 35;
                break;
            }
            case "jpeg4": {
                res = 90;
            }
        }
        return res;
    }
}

