/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.swf;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyType;
import com.jpexs.decompiler.flash.importers.SwfXmlImporter;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SwfToSwcExporter {
    private static final String DEPENDENCY_NAMESPACE = "n";
    private static final String DEPENDENCY_INHERITANCE = "i";
    private static final String DEPENDENCY_EXPRESSION = "e";
    private static final String DEPENDENCY_SIGNATURE = "s";

    private static String sha256(InputStream is) {
        String output;
        byte[] buffer = new byte[8192];
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] hash = digest.digest();
            BigInteger bigInt = new BigInteger(1, hash);
            output = bigInt.toString(16);
            while (output.length() < 32) {
                output = "0" + output;
            }
        }
        catch (Exception e) {
            return null;
        }
        return output;
    }

    private String dottedChainToId(DottedChain dc) {
        if (dc.getWithoutLast().isEmpty()) {
            return dc.getLast();
        }
        return dc.getWithoutLast().toRawString() + ":" + dc.getLast();
    }

    private String generateCatalog(SWF swf, byte[] swfBytes, boolean skipDependencies) {
        StringBuilder sb = new StringBuilder();
        String libraryFileName = "library.swf";
        String SWC_VERSION = "1.2";
        String FLEX_VERSION = "4.6.0";
        String FLEX_BUILD = "23201";
        String MINIMUM_SUPPORTED_VERSION = "3.0.0";
        sb.append("<?xml version=\"1.0\" encoding =\"utf-8\"?>\n").append("<swc xmlns=\"http://www.adobe.com/flash/swccatalog/9\">\n").append("  <versions>\n").append("    <swc version=\"").append("1.2").append("\" />\n").append("    <flex version=\"").append("4.6.0").append("\" build=\"").append("23201").append("\" minimumSupportedVersion=\"").append("3.0.0").append("\" />\n").append("  </versions>\n").append("  <features>\n").append("    <feature-script-deps />\n").append("    <feature-files />\n").append("  </features>\n").append("  <libraries>\n").append("    <library path=\"").append("library.swf").append("\">\n");
        long TIME_NOW = new Date().getTime();
        HashSet<DottedChain> definedObjects = new HashSet<DottedChain>();
        List<ABCContainerTag> abcTagList = swf.getAbcList();
        List<ScriptPack> packs = swf.getAS3Packs();
        for (ScriptPack pack : packs) {
            ClassPath cp = pack.getClassPath();
            definedObjects.add(cp.packageStr.add(cp.className, ""));
        }
        ArrayList<ABC> allAbcList = new ArrayList<ABC>();
        for (int i = 0; i < abcTagList.size(); ++i) {
            allAbcList.add(abcTagList.get(i).getABC());
        }
        for (ABCContainerTag abcContainer : abcTagList) {
            if (!(abcContainer instanceof DoABC2Tag)) continue;
            DoABC2Tag abcTag = (DoABC2Tag)abcContainer;
            String scriptName = abcTag.name;
            sb.append("      <script name=\"").append(scriptName).append("\" mod=\"").append(TIME_NOW).append("\">\n");
            List<ScriptPack> tagPacks = abcTag.getABC().getScriptPacks(null, allAbcList);
            for (ScriptPack pack : tagPacks) {
                ClassPath cp = pack.getClassPath();
                String defId = this.dottedChainToId(cp.packageStr.add(cp.className, ""));
                sb.append("        <def id=\"").append(defId).append("\" />\n");
                HashSet<DottedChain> allDeps = new HashSet<DottedChain>();
                allDeps.add(new DottedChain(new String[]{"AS3"}, ""));
                sb.append("        <dep id=\"AS3\" type=\"").append(DEPENDENCY_NAMESPACE).append("\" />\n");
                if (skipDependencies) continue;
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                ArrayList<String> uses = new ArrayList<String>();
                pack.abc.script_info.get((int)pack.scriptIndex).traits.getDependencies(null, pack.abc, dependencies, uses, new DottedChain(new String[]{"NO:PACKAGE"}, ""), new ArrayList<DottedChain>());
                for (Dependency d : dependencies) {
                    if ("*".equals(d.getId().getLast()) || d.getId().getWithoutLast().isEmpty() && !definedObjects.contains(d.getId()) || allDeps.contains(d.getId())) continue;
                    sb.append("        <dep id=\"").append(this.dottedChainToId(d.getId())).append("\" type=\"").append(SwfToSwcExporter.getDependencyStr(d.getType())).append("\" />\n");
                    allDeps.add(d.getId());
                }
            }
            sb.append("      </script>\n");
        }
        String sha256Hash = SwfToSwcExporter.sha256(new ByteArrayInputStream(swfBytes));
        sb.append("      <digests>\n").append("        <digest type=\"SHA-256\" signed=\"false\" value=\"").append(sha256Hash).append("\" />\n").append("      </digests>\n").append("    </library>\n").append("  </libraries>\n").append("  <files>\n").append("  </files>\n").append("</swc>\n");
        return sb.toString();
    }

    private static String getDependencyStr(DependencyType depType) {
        switch (depType) {
            case EXPRESSION: {
                return DEPENDENCY_EXPRESSION;
            }
            case INHERITANCE: {
                return DEPENDENCY_INHERITANCE;
            }
            case SIGNATURE: {
                return DEPENDENCY_SIGNATURE;
            }
            case NAMESPACE: {
                return DEPENDENCY_NAMESPACE;
            }
        }
        return null;
    }

    private SWF recompileSWF(SWF swf) throws IOException, InterruptedException {
        ByteArrayOutputStream swfOrigBaos = new ByteArrayOutputStream();
        swf.saveTo(swfOrigBaos);
        return new SWF((InputStream)new ByteArrayInputStream(swfOrigBaos.toByteArray()), Configuration.parallelSpeedUp.get(), false);
    }

    private static void printDelay(String title, long t1, long t2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSwf(SWF swf, File outSwcFile, boolean skipDependencies) throws IOException {
        long t4 = 0L;
        try {
            int i;
            long t1 = System.currentTimeMillis();
            swf = this.recompileSWF(swf);
            long t2 = System.currentTimeMillis();
            SwfToSwcExporter.printDelay("swc.recompile", t1, t2);
            String HASH = "myhash";
            String abcTagXml = new String(Helper.readStream(SwfToSwcExporter.class.getResourceAsStream("/com/jpexs/decompiler/flash/exporters/swf/swc_main_abctag.xml")), "UTF-8");
            abcTagXml = abcTagXml.replace("%hash%", "myhash");
            SwfXmlImporter xmlImporter = new SwfXmlImporter();
            DoABC2Tag mainAbcTag = (DoABC2Tag)xmlImporter.importObject(abcTagXml, DoABC2Tag.class, swf);
            ReadOnlyTagList list = swf.getTags();
            String documentClassStub = "_%hash%_flash_display_Sprite";
            String documentClass = "_%hash%_flash_display_Sprite".replace("%hash%", "myhash");
            boolean documentClassSet = false;
            for (i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof ABCContainerTag)) continue;
                swf.addTag(i, mainAbcTag);
                break;
            }
            block14: for (i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof SymbolClassTag)) continue;
                SymbolClassTag sct = (SymbolClassTag)list.get(i);
                for (int j = 0; j < sct.tags.size(); ++j) {
                    if (sct.tags.get(j) != 0) continue;
                    sct.names.set(j, documentClass);
                    documentClassSet = true;
                    continue block14;
                }
            }
            long t3 = System.currentTimeMillis();
            SwfToSwcExporter.printDelay("swc.documentTag", t2, t3);
            if (!documentClassSet) {
                throw new IOException("Original document class not found!");
            }
            swf = this.recompileSWF(swf);
            t4 = System.currentTimeMillis();
            SwfToSwcExporter.printDelay("swc.recompile2", t3, t4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
            throw new RuntimeException(ex);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        swf.saveTo(baos);
        byte[] swfBytes = baos.toByteArray();
        long t5 = System.currentTimeMillis();
        SwfToSwcExporter.printDelay("swc.getBytes", t4, t5);
        String catalogStr = this.generateCatalog(swf, swfBytes, skipDependencies);
        long t6 = System.currentTimeMillis();
        SwfToSwcExporter.printDelay("swc.generateCatalog", t5, t6);
        File tempFile = new File(outSwcFile.getAbsolutePath() + ".tmp");
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(tempFile);
            zos = new ZipOutputStream(fos);
            ZipEntry libraryEntry = new ZipEntry("library.swf");
            zos.putNextEntry(libraryEntry);
            zos.write(swfBytes);
            zos.closeEntry();
            ZipEntry catalogEntry = new ZipEntry("catalog.xml");
            zos.putNextEntry(catalogEntry);
            zos.write(catalogStr.getBytes("UTF-8"));
            zos.closeEntry();
            zos.close();
            zos = null;
            fos.close();
            fos = null;
            outSwcFile.delete();
            tempFile.renameTo(outSwcFile);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException libraryEntry) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException libraryEntry) {}
            }
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
        long t7 = System.currentTimeMillis();
        SwfToSwcExporter.printDelay("swc.zip", t6, t7);
    }
}

