/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;

public abstract class DefaultSVGShapeExporter
extends ShapeExporterBase {
    protected static final String DRAW_COMMAND_L = "L";
    protected static final String DRAW_COMMAND_Q = "Q";
    protected String currentDrawCommand = "";
    protected StringBuilder pathData;
    protected double zoom;

    public DefaultSVGShapeExporter(SWF swf, SHAPE shape, ColorTransform colorTransform, double zoom) {
        super(swf, shape, colorTransform);
        this.zoom = zoom;
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        if (close) {
            this.pathData.append("Z");
        }
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color) {
        this.finalizePath();
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        this.finalizePath();
    }

    @Override
    public void endFill() {
        this.finalizePath();
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
    }

    @Override
    public void moveTo(double x, double y) {
        this.currentDrawCommand = "";
        this.pathData.append("M").append(this.roundPixels20(x * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y * this.zoom / 20.0)).append(" ");
    }

    @Override
    public void lineTo(double x, double y) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_L)) {
            this.currentDrawCommand = DRAW_COMMAND_L;
            this.pathData.append(DRAW_COMMAND_L);
        }
        this.pathData.append(this.roundPixels20(x * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y * this.zoom / 20.0)).append(" ");
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_Q)) {
            this.currentDrawCommand = DRAW_COMMAND_Q;
            this.pathData.append(DRAW_COMMAND_Q);
        }
        this.pathData.append(this.roundPixels20(controlX * this.zoom / 20.0)).append(" ").append(this.roundPixels20(controlY * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorX * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorY * this.zoom / 20.0)).append(" ");
    }

    protected void finalizePath() {
        this.pathData = new StringBuilder();
        this.currentDrawCommand = "";
    }

    protected double roundPixels20(double pixels) {
        return (double)Math.round(pixels * 100.0) / 100.0;
    }
}

