/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ShapeExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ShapeExporter {
    public List<File> exportShapes(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, ShapeExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ShapeTag st = (ShapeTag)t;
            if (evl != null) {
                evl.handleExportingEvent("shape", currentIndex, count, t.getName());
            }
            int characterID = st.getCharacterId();
            String ext = ".svg";
            if (settings.mode == ShapeExportMode.PNG) {
                ext = ".png";
            }
            if (settings.mode == ShapeExportMode.BMP) {
                ext = ".bmp";
            }
            if (settings.mode == ShapeExportMode.CANVAS) {
                ext = ".html";
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName() + ext));
            new RetryTask(() -> ShapeExporter.lambda$exportShapes$0(settings, file, st), handler).run();
            ret.add(file);
            if (evl != null) {
                evl.handleExportedEvent("shape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == ShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$exportShapes$0(ShapeExportSettings settings, File file, ShapeTag st) throws IOException, InterruptedException {
        switch (1.$SwitchMap$com$jpexs$decompiler$flash$exporters$modes$ShapeExportMode[settings.mode.ordinal()]) {
            case 1: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var4_5 = null;
                rect = new ExportRectangle(st.getRect());
                rect.xMax *= settings.zoom;
                rect.yMax *= settings.zoom;
                rect.xMin *= settings.zoom;
                rect.yMin *= settings.zoom;
                exporter = new SVGExporter(rect, settings.zoom);
                st.toSVG(exporter, -2, new CXFORMWITHALPHA(), 0);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var4_5 == null) ** GOTO lbl22
                try {
                    fos.close();
                }
                catch (Throwable rect) {
                    var4_5.addSuppressed(rect);
                }
                break;
lbl22:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect) {
                    try {
                        var4_5 = rect;
                        throw rect;
                    }
                    catch (Throwable var7_13) {
                        if (fos != null) {
                            if (var4_5 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var8_15) {
                                    var4_5.addSuppressed(var8_15);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var7_13;
                    }
                }
            }
            case 2: 
            case 3: {
                rect = st.getRect();
                newWidth = (int)((double)rect.getWidth() * settings.zoom / 20.0) + 1;
                newHeight = (int)((double)rect.getHeight() * settings.zoom / 20.0) + 1;
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
                m = Matrix.getScaleInstance(settings.zoom);
                m.translate(-rect.Xmin, -rect.Ymin);
                st.toImage(0, 0, 0, new RenderContext(), img, false, m, m, m, new CXFORMWITHALPHA());
                if (settings.mode == ShapeExportMode.PNG) {
                    ImageHelper.write(img.getBufferedImage(), ImageFormat.PNG, file);
                    break;
                }
                BMPFile.saveBitmap(img.getBufferedImage(), file);
                break;
            }
            case 4: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var9_17 = null;
                shp = st.getShapes();
                deltaX = -shp.getBounds().Xmin;
                deltaY = -shp.getBounds().Ymin;
                cse = new CanvasShapeExporter(null, 20.0 / settings.zoom, st.getSwf(), shp, new CXFORMWITHALPHA(), deltaX, deltaY);
                cse.export();
                needed = new HashSet<Integer>();
                needed.add(st.getCharacterId());
                st.getNeededCharactersDeep(needed);
                baos = new ByteArrayOutputStream();
                SWF.writeLibrary(st.getSwf(), needed, baos);
                fos.write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(st) + st.getCharacterId(), st.getRect())));
                if (fos == null) break;
                if (var9_17 == null) ** GOTO lbl77
                try {
                    fos.close();
                }
                catch (Throwable var10_19) {
                    var9_17.addSuppressed(var10_19);
                }
                break;
lbl77:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var10_20) {
                    try {
                        var9_17 = var10_20;
                        throw var10_20;
                    }
                    catch (Throwable var16_26) {
                        if (fos != null) {
                            if (var9_17 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var17_27) {
                                    var9_17.addSuppressed(var17_27);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var16_26;
                    }
                }
            }
        }
    }
}

