/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.configuration.ConfigurationCategory;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultBoolean;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultCalendar;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultDouble;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultInt;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultString;
import com.jpexs.decompiler.flash.configuration.ConfigurationDirectory;
import com.jpexs.decompiler.flash.configuration.ConfigurationFile;
import com.jpexs.decompiler.flash.configuration.ConfigurationInternal;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationName;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.exporters.modes.ExeExportMode;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.FontHelper;
import com.jpexs.decompiler.flash.importers.TextImportResizeTextBoundsMode;
import com.jpexs.helpers.Helper;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class Configuration {
    private static final String CONFIG_NAME = "config.bin";
    private static final File unspecifiedFile;
    private static File directory;
    public static final Level logLevel;
    public static boolean showStat;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> openMultipleFiles;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> decompile;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="decompilation")
    public static final ConfigurationItem<Boolean> parallelSpeedUp;
    @ConfigurationDefaultInt(value=10)
    @ConfigurationCategory(value="decompilation")
    public static final ConfigurationItem<Integer> parallelSpeedUpThreadCount;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> autoDeobfuscate;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="")
    public static final ConfigurationItem<Boolean> cacheOnDisk;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="")
    public static final ConfigurationItem<Boolean> cacheImages;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Boolean> internalFlashViewer;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Integer> setMovieDelay;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Boolean> dumpView;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Boolean> useHexColorFormat;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Boolean> showOldTextDuringTextEditing;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> gotoMainClassOnStartup;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> autoRenameIdentifiers;
    @ConfigurationDefaultBoolean(value=false)
    public static final ConfigurationItem<Boolean> offeredAssociation;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> decimalAddress;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> showAllAddresses;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static final ConfigurationItem<Boolean> useFrameCache;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> useRibbonInterface;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> overwriteExistingFiles;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> openFolderAfterFlaExport;
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<String> overrideTextExportFileName;
    @ConfigurationDefaultBoolean(value=false)
    public static final ConfigurationItem<Boolean> useDetailedLogging;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> _debugMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> _showDebugMenu;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> resolveConstants;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> showFileOffsetInPcodeHex;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> showOriginalBytesInPcodeHex;
    @ConfigurationDefaultInt(value=500)
    @ConfigurationCategory(value="limit")
    public static final ConfigurationItem<Integer> sublimiter;
    @ConfigurationDefaultInt(value=1800)
    @ConfigurationCategory(value="limit")
    public static final ConfigurationItem<Integer> exportTimeout;
    @ConfigurationDefaultInt(value=300)
    @ConfigurationCategory(value="limit")
    public static final ConfigurationItem<Integer> decompilationTimeoutFile;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> paramNamesEnable;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> displayFileName;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> _debugCopy;
    @ConfigurationDefaultBoolean(value=false)
    public static final ConfigurationItem<Boolean> dumpTags;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> setFFDecVersionInExportedFont;
    @ConfigurationDefaultInt(value=60)
    @ConfigurationCategory(value="limit")
    public static final ConfigurationItem<Integer> decompilationTimeoutSingleMethod;
    @ConfigurationDefaultInt(value=1)
    public static final ConfigurationItem<Integer> lastRenameType;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static final ConfigurationItem<String> lastSaveDir;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static final ConfigurationItem<String> lastOpenDir;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static final ConfigurationItem<String> lastExportDir;
    @ConfigurationDefaultString(value="en")
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<String> locale;
    @ConfigurationDefaultString(value="_loc%d_")
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<String> registerNameFormat;
    @ConfigurationDefaultInt(value=15)
    public static final ConfigurationItem<Integer> maxRecentFileCount;
    public static final ConfigurationItem<String> recentFiles;
    public static final ConfigurationItem<HashMap<String, String>> fontPairingMap;
    public static final ConfigurationItem<HashMap<String, SwfSpecificConfiguration>> swfSpecificConfigs;
    @ConfigurationDefaultCalendar(value=0L)
    public static final ConfigurationItem<Calendar> lastUpdatesCheckDate;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationName(value="gui.window.width")
    public static final ConfigurationItem<Integer> guiWindowWidth;
    @ConfigurationDefaultInt(value=700)
    @ConfigurationName(value="gui.window.height")
    public static final ConfigurationItem<Integer> guiWindowHeight;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="gui.window.maximized.horizontal")
    public static final ConfigurationItem<Boolean> guiWindowMaximizedHorizontal;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="gui.window.maximized.vertical")
    public static final ConfigurationItem<Boolean> guiWindowMaximizedVertical;
    @ConfigurationDefaultDouble(value=1.0)
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="gui.fontSizeMultiplier")
    public static final ConfigurationItem<Double> guiFontSizeMultiplier;
    @ConfigurationDefaultString(value="Monospaced-Plain-12")
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="gui.sourceFont")
    public static final ConfigurationItem<String> sourceFontString;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.avm2.splitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiAvm2SplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.actionSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiActionSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.previewSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiPreviewSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.3333333333)
    @ConfigurationName(value="gui.splitPane1.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiSplitPane1DividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.splitPane2.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiSplitPane2DividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.timeLineSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiTimeLineSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.dump.splitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiDumpSplitPaneDividerLocationPercent;
    @ConfigurationDefaultString(value="com.jpexs.decompiler.flash.gui.OceanicSkin")
    @ConfigurationName(value="gui.skin")
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<String> guiSkin;
    @ConfigurationDefaultInt(value=3)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Integer> saveAsExeScaleMode;
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<ExeExportMode> exeExportMode;
    @ConfigurationDefaultInt(value=0x100000)
    @ConfigurationCategory(value="limit")
    public static final ConfigurationItem<Integer> syntaxHighlightLimit;
    public static final ConfigurationItem<Integer> guiFontPreviewSampleText;
    @ConfigurationName(value="gui.fontPreviewWindow.width")
    public static final ConfigurationItem<Integer> guiFontPreviewWidth;
    @ConfigurationName(value="gui.fontPreviewWindow.height")
    public static final ConfigurationItem<Integer> guiFontPreviewHeight;
    @ConfigurationName(value="gui.fontPreviewWindow.posX")
    public static final ConfigurationItem<Integer> guiFontPreviewPosX;
    @ConfigurationName(value="gui.fontPreviewWindow.posY")
    public static final ConfigurationItem<Integer> guiFontPreviewPosY;
    @ConfigurationDefaultInt(value=3)
    @ConfigurationName(value="formatting.indent.size")
    @ConfigurationCategory(value="format")
    public static final ConfigurationItem<Integer> indentSize;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="formatting.indent.useTabs")
    @ConfigurationCategory(value="format")
    public static final ConfigurationItem<Boolean> indentUseTabs;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="format")
    public static final ConfigurationItem<Boolean> beginBlockOnNewLine;
    @ConfigurationDefaultInt(value=86400000)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.delay")
    public static final ConfigurationItem<Integer> checkForUpdatesDelay;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.stable")
    public static final ConfigurationItem<Boolean> checkForUpdatesStable;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.nightly")
    public static final ConfigurationItem<Boolean> checkForUpdatesNightly;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.enabled")
    public static final ConfigurationItem<Boolean> checkForUpdatesAuto;
    @ConfigurationCategory(value="update")
    public static final ConfigurationItem<String> updateProxyAddress;
    @ConfigurationDefaultString(value="")
    @ConfigurationName(value="export.formats")
    public static final ConfigurationItem<String> lastSelectedExportFormats;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> textExportSingleFile;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> scriptExportSingleFile;
    @ConfigurationDefaultString(value="--- SEPARATOR ---")
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<String> textExportSingleFileSeparator;
    @ConfigurationDefaultString(value="--- RECORDSEPARATOR ---")
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<String> textExportSingleFileRecordSeparator;
    @ConfigurationCategory(value="import")
    public static final ConfigurationItem<TextImportResizeTextBoundsMode> textImportResizeTextBoundsMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="import")
    public static final ConfigurationItem<Boolean> resetLetterSpacingOnTextImport;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.experimental.as12edit")
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> warningExperimentalAS12Edit;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.experimental.as3edit")
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> warningExperimentalAS3Edit;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> showCodeSavedMessage;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> showTraitSavedMessage;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> packJavaScripts;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static final ConfigurationItem<Boolean> textExportExportFontFace;
    @ConfigurationDefaultInt(value=128)
    public static final ConfigurationItem<Integer> lzmaFastBytes;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> showMethodBodyId;
    @ConfigurationDefaultDouble(value=1.0)
    @ConfigurationName(value="export.zoom")
    public static final ConfigurationItem<Double> lastSelectedExportZoom;
    public static final ConfigurationItem<String> pluginPath;
    @ConfigurationDefaultInt(value=55556)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Integer> debuggerPort;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> randomDebuggerPackage;
    @ConfigurationDefaultBoolean(value=true)
    public static final ConfigurationItem<Boolean> displayDebuggerInfo;
    @ConfigurationDefaultString(value="debugConsole")
    public static final ConfigurationItem<String> lastDebuggerReplaceFunction;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> getLocalNamesFromDebugInfo;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> tagTreeShowEmptyFolders;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> autoLoadEmbeddedSwfs;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> showCloseConfirmation;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> editorMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> autoSaveTagModifications;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> saveSessionOnExit;
    public static final ConfigurationItem<String> lastSessionFiles;
    public static final ConfigurationItem<String> lastSessionFileTitles;
    public static final ConfigurationItem<String> lastSessionSelection;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> loopMedia;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> allowOnlyOneInstance;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> ignoreCLikePackages;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> smartNumberFormatting;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> enableScriptInitializerDisplay;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> autoOpenLoadedSWFs;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile
    public static final ConfigurationItem<String> playerLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile
    public static final ConfigurationItem<String> playerDebugLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile(value=".*\\.swc$")
    public static final ConfigurationItem<String> playerLibLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationDirectory
    public static final ConfigurationItem<String> flexSdkLocation;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.avm2.splitPane.vars.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiAvm2VarsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.action.splitPane.vars.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiActionVarsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> debugHalt;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.svgImport")
    @ConfigurationCategory(value="import")
    public static final ConfigurationItem<Boolean> warningSvgImport;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.hexViewNotUpToDate")
    @ConfigurationCategory(value="import")
    public static final ConfigurationItem<Boolean> warningHexViewNotUpToDate;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="shapeImport.useNonSmoothedFill")
    @ConfigurationCategory(value="import")
    public static final ConfigurationItem<Boolean> shapeImportUseNonSmoothedFill;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="internalFlashViewer.execute.as12")
    public static final ConfigurationItem<Boolean> internalFlashViewerExecuteAs12;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> displayDupInstructions;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> useRegExprLiteral;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> handleSkinPartsAutomatically;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> _ignoreAdditionalFlexClasses;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> _enableFlexExport;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> simplifyExpressions;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static final ConfigurationItem<Boolean> hwAcceleratedGraphics;
    @ConfigurationDefaultDouble(value=0.85)
    @ConfigurationName(value="gui.avm2.splitPane.docs.dividerLocationPercent")
    @ConfigurationInternal
    public static final ConfigurationItem<Double> guiAvm2DocsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static final ConfigurationItem<Boolean> useFlexAs3Compiler;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static final ConfigurationItem<Boolean> showSetAdvanceValuesMessage;

    private static OSId getOSId() {
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        OSId id = OSId.UNIX;
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            if (osName.toLowerCase().startsWith("mac os x")) {
                id = OSId.OSX;
            } else if (osName.contains("Windows")) {
                id = OSId.WINDOWS;
            }
        }
        return id;
    }

    public static String getFFDecHome() {
        String ret;
        if (directory == unspecifiedFile) {
            directory = null;
            String userHome = null;
            try {
                userHome = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (userHome != null) {
                String applicationId = "FFDec";
                OSId osId = Configuration.getOSId();
                if (osId == OSId.WINDOWS) {
                    File appDataDir = null;
                    try {
                        String appDataEV = System.getenv("APPDATA");
                        if (appDataEV != null && appDataEV.length() > 0) {
                            appDataDir = new File(appDataEV);
                        }
                    }
                    catch (SecurityException appDataEV) {
                        // empty catch block
                    }
                    String vendorId = "JPEXS";
                    if (appDataDir != null && appDataDir.isDirectory()) {
                        String path = vendorId + "\\" + applicationId + "\\";
                        directory = new File(appDataDir, path);
                    } else {
                        String path = "Application Data\\" + vendorId + "\\" + applicationId + "\\";
                        directory = new File(userHome, path);
                    }
                } else if (osId == OSId.OSX) {
                    String path = "Library/Application Support/" + applicationId + "/";
                    directory = new File(userHome, path);
                } else {
                    String path = "." + applicationId + "/";
                    directory = new File(userHome, path);
                }
            } else {
                directory = new File(".");
            }
        }
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            directory = new File(".");
        }
        if (!(ret = directory.getAbsolutePath()).endsWith(File.separator)) {
            ret = ret + File.separator;
        }
        return ret;
    }

    public static Font getSourceFont() {
        return FontHelper.stringToFont(sourceFontString.get());
    }

    public static List<String> getRecentFiles() {
        String files = recentFiles.get();
        if (files == null || files.isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(files.split("::"));
    }

    public static void addRecentFile(String path) {
        ArrayList<String> recentFilesArray = new ArrayList<String>(Configuration.getRecentFiles());
        int idx = recentFilesArray.indexOf(path);
        if (idx != -1) {
            recentFilesArray.remove(idx);
        }
        recentFilesArray.add(path);
        while (recentFilesArray.size() > maxRecentFileCount.get()) {
            recentFilesArray.remove(0);
        }
        recentFiles.set(Helper.joinStrings(recentFilesArray, "::"));
    }

    public static void removeRecentFile(String path) {
        ArrayList<String> recentFilesArray = new ArrayList<String>(Configuration.getRecentFiles());
        int idx = recentFilesArray.indexOf(path);
        if (idx != -1) {
            recentFilesArray.remove(idx);
        }
        recentFiles.set(Helper.joinStrings(recentFilesArray, "::"));
    }

    public static Map<String, String> getFontToNameMap() {
        HashMap<String, String> map = fontPairingMap.get();
        if (map == null) {
            map = new HashMap();
            fontPairingMap.set(map);
        }
        return map;
    }

    public static void addFontPair(String fileName, int fontId, String fontName, String installedName) {
        Map<String, String> fontPairs = Configuration.getFontToNameMap();
        fontPairs.put(fontName, installedName);
        SwfSpecificConfiguration swfConf = Configuration.getOrCreateSwfSpecificConfiguration(fileName);
        swfConf.fontPairingMap.put(fontId + "_" + fontName, installedName);
    }

    public static SwfSpecificConfiguration getSwfSpecificConfiguration(String fileName) {
        HashMap<String, SwfSpecificConfiguration> map = swfSpecificConfigs.get();
        if (map == null) {
            map = new HashMap();
            swfSpecificConfigs.set(map);
        }
        return map.get(fileName);
    }

    public static SwfSpecificConfiguration getOrCreateSwfSpecificConfiguration(String fileName) {
        SwfSpecificConfiguration swfConf = Configuration.getSwfSpecificConfiguration(fileName);
        if (swfConf == null) {
            swfConf = new SwfSpecificConfiguration();
            swfSpecificConfigs.get().put(fileName, swfConf);
        }
        return swfConf;
    }

    private static String getConfigFile() throws IOException {
        return Configuration.getFFDecHome() + CONFIG_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap<String, Object> loadFromFile(String file) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            HashMap cfg;
            HashMap hashMap = cfg = (HashMap)ois.readObject();
            return hashMap;
        }
        catch (IOException | ClassNotFoundException exception) {
            return new HashMap<String, Object>();
        }
    }

    private static void saveToFile(String file) {
        HashMap config = new HashMap();
        for (Map.Entry<String, Field> entry : Configuration.getConfigurationFields().entrySet()) {
            try {
                String name = entry.getKey();
                Field field = entry.getValue();
                ConfigurationItem item = (ConfigurationItem)field.get(null);
                if (!item.hasValue) continue;
                config.put(name, item.get());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            oos.writeObject(config);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Cannot save configuration.", "Error", 0);
            Logger.getLogger(Configuration.class.getName()).severe("Configuration directory is read only.");
        }
    }

    public static void saveConfig() {
        try {
            Configuration.saveToFile(Configuration.getConfigFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setConfigurationFields() {
        File swcFile;
        try {
            HashMap<String, Object> config = Configuration.loadFromFile(Configuration.getConfigFile());
            for (Map.Entry<String, Field> entry : Configuration.getConfigurationFields().entrySet()) {
                String name = entry.getKey();
                Field field = entry.getValue();
                Field modifiersField = field.getClass().getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                Object defaultValue = Configuration.getDefaultValue(field);
                Object value = null;
                if (config.containsKey(name)) {
                    value = config.get(name);
                    Type type2 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    Class type = type2 instanceof Class ? (Class)type2 : (Class)((ParameterizedType)type2).getRawType();
                    if (value != null && !type.isAssignableFrom(value.getClass())) {
                        System.out.println("Configuration item has a wrong type: " + name + " expected: " + type.getSimpleName() + " actual: " + value.getClass().getSimpleName());
                        value = null;
                    }
                }
                if (value != null) {
                    field.set(null, new ConfigurationItem<Object>(name, defaultValue, value));
                    continue;
                }
                field.set(null, new ConfigurationItem<Object>(name, defaultValue));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new Error(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (playerLibLocation.get("").isEmpty() && (swcFile = Configuration.getPlayerSwcOld()) != null) {
            playerLibLocation.set(swcFile.getAbsolutePath());
        }
    }

    public static Object getDefaultValue(Field field) {
        ConfigurationDefaultCalendar aCalendar;
        ConfigurationDefaultDouble aDouble;
        ConfigurationDefaultString aString;
        ConfigurationDefaultInt aInt;
        Object defaultValue = null;
        ConfigurationDefaultBoolean aBool = field.getAnnotation(ConfigurationDefaultBoolean.class);
        if (aBool != null) {
            defaultValue = aBool.value();
        }
        if ((aInt = field.getAnnotation(ConfigurationDefaultInt.class)) != null) {
            defaultValue = aInt.value();
        }
        if ((aString = field.getAnnotation(ConfigurationDefaultString.class)) != null) {
            defaultValue = aString.value();
        }
        if ((aDouble = field.getAnnotation(ConfigurationDefaultDouble.class)) != null) {
            defaultValue = aDouble.value();
        }
        if ((aCalendar = field.getAnnotation(ConfigurationDefaultCalendar.class)) != null) {
            GregorianCalendar mingc = new GregorianCalendar();
            mingc.setTime(new Date(aCalendar.value()));
            defaultValue = mingc;
        }
        return defaultValue;
    }

    public static Map<String, Field> getConfigurationFields() {
        Field[] fields = Configuration.class.getFields();
        HashMap<String, Field> result = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!ConfigurationItem.class.isAssignableFrom(field.getType())) continue;
            ConfigurationName annotation = field.getAnnotation(ConfigurationName.class);
            String name = annotation == null ? field.getName() : annotation.value();
            result.put(name, field);
        }
        return result;
    }

    public static CodeFormatting getCodeFormatting() {
        CodeFormatting ret = new CodeFormatting();
        String indentString = "";
        for (int i = 0; i < indentSize.get(); ++i) {
            indentString = indentString + (indentUseTabs.get() != false ? "\t" : " ");
        }
        ret.indentString = indentString;
        ret.beginBlockOnNewLine = beginBlockOnNewLine.get();
        return ret;
    }

    public static int getParallelThreadCount() {
        int count = parallelSpeedUpThreadCount.get();
        if (count < 2) {
            count = 2;
        }
        return count;
    }

    public static File getPath(String folder) {
        String home = Configuration.getFFDecHome();
        File dir = new File(home + folder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getFlashLibPath() {
        return Configuration.getPath("flashlib");
    }

    public static File getProjectorPath() {
        return Configuration.getPath("projector");
    }

    private static String getDownloadsHtml() throws IOException {
        String html = Helper.downloadUrlString("https://www.adobe.com/support/flashplayer/downloads.html");
        return html;
    }

    private static String getUrlFromDownloadsHtml(String urlPatternString) {
        try {
            String html = Configuration.getDownloadsHtml();
            Pattern urlPattern = Pattern.compile(urlPatternString, 32);
            Matcher matcher = urlPattern.matcher(html);
            if (matcher.matches()) {
                String url = matcher.group(1);
                int a = url.length();
                return url;
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String getLatestPlayerGlobalUrl() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*playerglobal[^\"]*\\.swc)\".*");
    }

    private static String getLatestProjectorUrlWin() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.exe)\".*");
    }

    private static String getLatestProjectorUrlMac() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.dmg)\".*");
    }

    private static String getLatestProjectorUrlLinux() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.i386\\.tar\\.gz)\".*");
    }

    public static File getPlayerSWC() {
        String libLocation = playerLibLocation.get("");
        File ret = null;
        if (!libLocation.isEmpty()) {
            ret = new File(libLocation);
        }
        if (!(ret != null && ret.exists() || (ret = Configuration.getPlayerSwcOld()) == null)) {
            playerLibLocation.set(ret.getAbsolutePath());
        }
        return ret;
    }

    private static File getPlayerSwcOld() {
        File libsDir = Configuration.getFlashLibPath();
        if (libsDir != null && libsDir.exists()) {
            File[] libs = libsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("playerglobal");
                }
            });
            ArrayList<String> libNames = new ArrayList<String>();
            for (File f : libs) {
                libNames.add(f.getName());
            }
            Collections.sort(libNames);
            if (!libNames.isEmpty()) {
                return new File(libsDir.getAbsolutePath() + File.separator + (String)libNames.get(libNames.size() - 1));
            }
            return null;
        }
        return null;
    }

    public static File getProjectorFile(final ExeExportMode exportMode) {
        File projectoDir = Configuration.getProjectorPath();
        if (projectoDir != null && projectoDir.exists()) {
            File[] projectors = projectoDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    switch (exportMode) {
                        case PROJECTOR_WIN: {
                            return name.toLowerCase().endsWith(".exe");
                        }
                        case PROJECTOR_MAC: {
                            return name.toLowerCase().endsWith(".dmg");
                        }
                        case PROJECTOR_LINUX: {
                            return name.toLowerCase().endsWith(".gz");
                        }
                    }
                    return false;
                }
            });
            ArrayList<String> projectorNames = new ArrayList<String>();
            for (File f : projectors) {
                projectorNames.add(f.getName());
            }
            Collections.sort(projectorNames);
            if (!projectorNames.isEmpty()) {
                return new File(projectoDir.getAbsolutePath() + File.separator + (String)projectorNames.get(projectorNames.size() - 1));
            }
            return null;
        }
        return null;
    }

    static {
        directory = unspecifiedFile = new File("unspecified");
        openMultipleFiles = null;
        decompile = null;
        parallelSpeedUp = null;
        parallelSpeedUpThreadCount = null;
        autoDeobfuscate = null;
        cacheOnDisk = null;
        cacheImages = null;
        internalFlashViewer = null;
        setMovieDelay = null;
        dumpView = null;
        useHexColorFormat = null;
        showOldTextDuringTextEditing = null;
        gotoMainClassOnStartup = null;
        autoRenameIdentifiers = null;
        offeredAssociation = null;
        decimalAddress = null;
        showAllAddresses = null;
        useFrameCache = null;
        useRibbonInterface = null;
        overwriteExistingFiles = null;
        openFolderAfterFlaExport = null;
        overrideTextExportFileName = null;
        useDetailedLogging = null;
        _debugMode = null;
        _showDebugMenu = null;
        resolveConstants = null;
        showFileOffsetInPcodeHex = null;
        showOriginalBytesInPcodeHex = null;
        sublimiter = null;
        exportTimeout = null;
        decompilationTimeoutFile = null;
        paramNamesEnable = null;
        displayFileName = null;
        _debugCopy = null;
        dumpTags = null;
        setFFDecVersionInExportedFont = null;
        decompilationTimeoutSingleMethod = null;
        lastRenameType = null;
        lastSaveDir = null;
        lastOpenDir = null;
        lastExportDir = null;
        locale = null;
        registerNameFormat = null;
        maxRecentFileCount = null;
        recentFiles = null;
        fontPairingMap = null;
        swfSpecificConfigs = null;
        lastUpdatesCheckDate = null;
        guiWindowWidth = null;
        guiWindowHeight = null;
        guiWindowMaximizedHorizontal = null;
        guiWindowMaximizedVertical = null;
        guiFontSizeMultiplier = null;
        sourceFontString = null;
        guiAvm2SplitPaneDividerLocationPercent = null;
        guiActionSplitPaneDividerLocationPercent = null;
        guiPreviewSplitPaneDividerLocationPercent = null;
        guiSplitPane1DividerLocationPercent = null;
        guiSplitPane2DividerLocationPercent = null;
        guiTimeLineSplitPaneDividerLocationPercent = null;
        guiDumpSplitPaneDividerLocationPercent = null;
        guiSkin = null;
        saveAsExeScaleMode = null;
        exeExportMode = null;
        syntaxHighlightLimit = null;
        guiFontPreviewSampleText = null;
        guiFontPreviewWidth = null;
        guiFontPreviewHeight = null;
        guiFontPreviewPosX = null;
        guiFontPreviewPosY = null;
        indentSize = null;
        indentUseTabs = null;
        beginBlockOnNewLine = null;
        checkForUpdatesDelay = null;
        checkForUpdatesStable = null;
        checkForUpdatesNightly = null;
        checkForUpdatesAuto = null;
        updateProxyAddress = null;
        lastSelectedExportFormats = null;
        textExportSingleFile = null;
        scriptExportSingleFile = null;
        textExportSingleFileSeparator = null;
        textExportSingleFileRecordSeparator = null;
        textImportResizeTextBoundsMode = null;
        resetLetterSpacingOnTextImport = null;
        warningExperimentalAS12Edit = null;
        warningExperimentalAS3Edit = null;
        showCodeSavedMessage = null;
        showTraitSavedMessage = null;
        packJavaScripts = null;
        textExportExportFontFace = null;
        lzmaFastBytes = null;
        showMethodBodyId = null;
        lastSelectedExportZoom = null;
        pluginPath = null;
        debuggerPort = null;
        randomDebuggerPackage = null;
        displayDebuggerInfo = null;
        lastDebuggerReplaceFunction = null;
        getLocalNamesFromDebugInfo = null;
        tagTreeShowEmptyFolders = null;
        autoLoadEmbeddedSwfs = null;
        showCloseConfirmation = null;
        editorMode = null;
        autoSaveTagModifications = null;
        saveSessionOnExit = null;
        lastSessionFiles = null;
        lastSessionFileTitles = null;
        lastSessionSelection = null;
        loopMedia = null;
        allowOnlyOneInstance = null;
        ignoreCLikePackages = null;
        smartNumberFormatting = null;
        enableScriptInitializerDisplay = null;
        autoOpenLoadedSWFs = null;
        playerLocation = null;
        playerDebugLocation = null;
        playerLibLocation = null;
        flexSdkLocation = null;
        guiAvm2VarsSplitPaneDividerLocationPercent = null;
        guiActionVarsSplitPaneDividerLocationPercent = null;
        debugHalt = null;
        warningSvgImport = null;
        warningHexViewNotUpToDate = null;
        shapeImportUseNonSmoothedFill = null;
        internalFlashViewerExecuteAs12 = null;
        displayDupInstructions = null;
        useRegExprLiteral = null;
        handleSkinPartsAutomatically = null;
        _ignoreAdditionalFlexClasses = null;
        _enableFlexExport = null;
        simplifyExpressions = null;
        hwAcceleratedGraphics = null;
        guiAvm2DocsSplitPaneDividerLocationPercent = null;
        useFlexAs3Compiler = null;
        showSetAdvanceValuesMessage = null;
        Configuration.setConfigurationFields();
        logLevel = useDetailedLogging.get() != false ? Level.FINEST : (_debugMode.get() != false ? Level.INFO : Level.WARNING);
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

