/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.action.ActionGraph;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionLocalData;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.deobfuscation.ActionDeobfuscator;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.ExtendsActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.ImplementsOpActionItem;
import com.jpexs.decompiler.flash.action.model.NewObjectActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.SetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.SetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.model.TemporaryRegister;
import com.jpexs.decompiler.flash.action.model.clauses.ClassActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.InterfaceActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.special.ActionEnd;
import com.jpexs.decompiler.flash.action.special.ActionStore;
import com.jpexs.decompiler.flash.action.swf4.ActionEquals;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionNot;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf5.ActionWith;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.action.swf7.ActionTry;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.CommentItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Action
implements GraphSourceItem {
    private static final int INFORM_LISTENER_RESOLUTION = 100;
    private boolean ignored = false;
    public long fileOffset = -1L;
    private int actionCode;
    protected int actionLength;
    private long address;
    public static final String[] propertyNames = new String[]{"_X", "_Y", "_xscale", "_yscale", "_currentframe", "_totalframes", "_alpha", "_visible", "_width", "_height", "_rotation", "_target", "_framesloaded", "_name", "_droptarget", "_url", "_highquality", "_focusrect", "_soundbuftime", "_quality", "_xmouse", "_ymouse"};
    public static final List<String> propertyNamesList = Arrays.asList(propertyNames);
    private static final Logger logger = Logger.getLogger(Action.class.getName());

    @Override
    public long getLineOffset() {
        return this.fileOffset;
    }

    public Action(int actionCode, int actionLength) {
        this.actionCode = actionCode;
        this.actionLength = actionLength;
    }

    public Action() {
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public int getActionCode() {
        return this.actionCode;
    }

    public void getRef(Set<Long> refs) {
    }

    public static Set<Long> getActionsAllRefs(List<Action> list) {
        HashSet<Long> ret = new HashSet<Long>();
        for (Action a : list) {
            a.getRef(ret);
        }
        return ret;
    }

    public int getTotalActionLength() {
        return this.actionLength + 1 + (this.actionCode >= 128 ? 2 : 0);
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public String toString() {
        return "Action" + this.actionCode;
    }

    protected String lexString(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.yylex();
        if (symb.type != 1) {
            throw new ActionParseException("String expected", lex.yyline());
        }
        return (String)symb.value;
    }

    protected void lexBlockOpen(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.yylex();
        if (symb.type != 10) {
            throw new ActionParseException("Block startServer ", lex.yyline());
        }
    }

    protected String lexIdentifier(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.yylex();
        if (symb.type != 6) {
            throw new ActionParseException("Identifier expected", lex.yyline());
        }
        return (String)symb.value;
    }

    protected long lexLong(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.yylex();
        if (symb.type != 4) {
            throw new ActionParseException("Integer expected", lex.yyline());
        }
        return (Long)symb.value;
    }

    protected boolean lexBoolean(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.yylex();
        if (symb.type != 11) {
            throw new ActionParseException("Boolean expected", lex.yyline());
        }
        return (Boolean)symb.value;
    }

    public final byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            this.getContentBytes(sos);
            sos.close();
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return this.surroundWithAction(baos.toByteArray(), version);
    }

    protected void getContentBytes(SWFOutputStream sos) throws IOException {
    }

    public final int getBytesLength() {
        return this.getContentBytesLength() + (this.actionCode >= 128 ? 3 : 1);
    }

    protected int getContentBytesLength() {
        return 0;
    }

    public void updateLength() {
        int length = this.getBytesLength();
        this.actionLength = length - 1 - (this.actionCode >= 128 ? 2 : 0);
    }

    private byte[] surroundWithAction(byte[] data, int version) {
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        SWFOutputStream sos2 = new SWFOutputStream(baos2, version);
        try {
            sos2.writeUI8(this.actionCode);
            if (this.actionCode >= 128) {
                sos2.writeUI16(data.length);
            }
            sos2.write(data);
            sos2.close();
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return baos2.toByteArray();
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public static byte[] actionsToBytes(List<Action> list, boolean addZero, int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Action lastAction = null;
        for (Action a : list) {
            try {
                lastAction = a;
                baos.write(a.getBytes(version));
            }
            catch (IOException iOException) {}
        }
        if (addZero && (lastAction == null || !(lastAction instanceof ActionEnd))) {
            baos.write(0);
        }
        return baos.toByteArray();
    }

    public static ByteArrayRange actionsToByteArrayRange(List<Action> list, boolean addZero, int version) {
        byte[] bytes = Action.actionsToBytes(list, addZero, version);
        return new ByteArrayRange(bytes);
    }

    public static void setConstantPools(ASMSource src, List<List<String>> constantPools, boolean tryInline) throws ConstantPoolTooBigException {
        try {
            ActionList actions = src.getActions();
            int poolIdx = 0;
            for (Action action : actions) {
                if (!(action instanceof ActionConstantPool)) continue;
                ActionConstantPool cPool = (ActionConstantPool)action;
                List<String> constantPool = constantPools.get(poolIdx);
                int size = ActionConstantPool.calculateSize(constantPool);
                if (size > 65535 && tryInline) {
                    for (int i = 0; i < constantPool.size(); ++i) {
                        int refCount = actions.getConstantPoolIndexReferenceCount(i);
                        if (refCount != 1) continue;
                        actions.inlineConstantPoolString(i, constantPool.get(i));
                        constantPool.set(i, "");
                    }
                    size = ActionConstantPool.calculateSize(constantPool);
                }
                if (size > 65535) {
                    throw new ConstantPoolTooBigException(poolIdx, size);
                }
                cPool.constantPool = constantPool;
                if (constantPools.size() > ++poolIdx) continue;
                break;
            }
            actions.removeNonReferencedConstantPoolItems();
            src.setActions(actions);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static void setActionsAddresses(List<Action> list, long baseAddress) {
        long offset = baseAddress;
        for (Action a : list) {
            a.setAddress(offset);
            offset += (long)a.getTotalActionLength();
        }
    }

    private static void informListeners(List<DisassemblyListener> listeners, int pos, int count) {
        if (pos % 100 == 0) {
            DisassemblyListener[] listenersArray;
            for (DisassemblyListener listener : listenersArray = listeners.toArray(new DisassemblyListener[listeners.size()])) {
                listener.progressToString(pos + 1, count);
            }
        }
    }

    public static GraphTextWriter actionsToString(List<DisassemblyListener> listeners, long address, ActionList list, int version, ScriptExportMode exportMode, GraphTextWriter writer) {
        if (exportMode == ScriptExportMode.CONSTANTS) {
            return Action.constantPoolActionsToString(listeners, address, list, version, exportMode, writer);
        }
        Set<Long> importantOffsets = Action.getActionsAllRefs(list);
        HashMap containers = new HashMap();
        HashMap<GraphSourceItemContainer, Integer> containersPos = new HashMap<GraphSourceItemContainer, Integer>();
        long offset = address;
        int pos = 0;
        boolean lastPush = false;
        byte[] fileData = list.fileData;
        for (Action a : list) {
            Action.informListeners(listeners, pos, list.size());
            if (exportMode == ScriptExportMode.PCODE_HEX) {
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                writer.appendNoHilight("; ");
                long fileOffset = a.getFileOffset();
                if (Configuration.showFileOffsetInPcodeHex.get().booleanValue()) {
                    writer.appendNoHilight("@");
                    writer.appendNoHilight(Helper.formatHex(fileOffset, 8));
                    writer.appendNoHilight(" ");
                }
                byte[] bytes = a.getBytes(version);
                writer.appendNoHilight(Helper.bytesToHexString(bytes));
                if (Configuration.showOriginalBytesInPcodeHex.get().booleanValue() && fileData != null && fileOffset != -1L && (long)fileData.length > fileOffset + (long)bytes.length - 1L) {
                    int i;
                    boolean same = true;
                    for (i = 0; i < bytes.length; ++i) {
                        byte b = fileData[(int)(fileOffset + (long)i)];
                        if (b == bytes[i]) continue;
                        same = false;
                        break;
                    }
                    if (!same) {
                        writer.appendNoHilight(" (");
                        for (i = 0; i < bytes.length; ++i) {
                            if (i != 0) {
                                writer.appendNoHilight(" ");
                            }
                            writer.appendNoHilight(Helper.byteToHex(fileData[(int)(fileOffset + (long)i)]));
                        }
                        writer.appendNoHilight(")");
                    }
                }
                writer.newLine();
            }
            offset = a.getAddress();
            if (!a.isIgnored() && a instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)a);
                containersPos.put(cnt, 0);
                List<Long> sizes = cnt.getContainerSizes();
                long addr = ((Action)((Object)cnt)).getAddress() + cnt.getHeaderSize();
                for (Long size : sizes) {
                    addr += size.longValue();
                    if (size == 0L) continue;
                    if (!containers.containsKey(addr)) {
                        containers.put(addr, new ArrayList());
                    }
                    ((List)containers.get(addr)).add(cnt);
                }
            }
            if (containers.containsKey(offset)) {
                for (int i = 0; i < ((List)containers.get(offset)).size(); ++i) {
                    if (lastPush) {
                        writer.newLine();
                        lastPush = false;
                    }
                    writer.appendNoHilight("}").newLine();
                    GraphSourceItemContainer cnt = (GraphSourceItemContainer)((List)containers.get(offset)).get(i);
                    int cntPos = (Integer)containersPos.get(cnt);
                    writer.appendNoHilight(cnt.getASMSourceBetween(cntPos));
                    containersPos.put(cnt, ++cntPos);
                }
            }
            if (Configuration.showAllAddresses.get().booleanValue() || importantOffsets.contains(offset)) {
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                writer.appendNoHilight("loc");
                writer.appendNoHilight(Helper.formatAddress(offset));
                writer.appendNoHilight(":");
            }
            if (a.isIgnored()) {
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                if (!(a instanceof ActionEnd)) {
                    int len = a.getTotalActionLength();
                    for (int i = 0; i < len; ++i) {
                        writer.appendNoHilight("Nop").newLine();
                    }
                }
            } else {
                String add = "";
                if (a instanceof ActionPush && lastPush) {
                    writer.appendNoHilight(" ");
                    ((ActionPush)a).paramsToStringReplaced(list, importantOffsets, exportMode, writer);
                } else {
                    if (lastPush) {
                        writer.newLine();
                    }
                    writer.append("", offset, a.getFileOffset());
                    int fixBranch = -1;
                    if (a instanceof ActionIf) {
                        ActionIf aif = (ActionIf)a;
                        if (aif.jumpUsed && !aif.ignoreUsed) {
                            fixBranch = 0;
                        }
                        if (!aif.jumpUsed && aif.ignoreUsed) {
                            fixBranch = 1;
                        }
                    }
                    if (fixBranch > -1) {
                        writer.appendNoHilight("FFDec_DeobfuscatePop");
                        if (fixBranch == 0) {
                            writer.newLine();
                            writer.appendNoHilight("Jump loc");
                            writer.appendNoHilight(Helper.formatAddress(((ActionIf)a).getTargetAddress()));
                        }
                    } else {
                        a.getASMSourceReplaced(list, importantOffsets, exportMode, writer);
                    }
                    writer.appendNoHilight(a.isIgnored() ? "; ignored" : "");
                    writer.appendNoHilight(add);
                    if (!(a instanceof ActionPush)) {
                        writer.newLine();
                    }
                }
                lastPush = a instanceof ActionPush;
            }
            offset += (long)a.getTotalActionLength();
            ++pos;
        }
        if (lastPush) {
            writer.newLine();
        }
        if (containers.containsKey(offset)) {
            for (int i = 0; i < ((List)containers.get(offset)).size(); ++i) {
                writer.appendNoHilight("}");
                writer.newLine();
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((List)containers.get(offset)).get(i);
                int cntPos = (Integer)containersPos.get(cnt);
                writer.appendNoHilight(cnt.getASMSourceBetween(cntPos));
                containersPos.put(cnt, ++cntPos);
            }
        }
        if (importantOffsets.contains(offset)) {
            writer.appendNoHilight("loc");
            writer.appendNoHilight(Helper.formatAddress(offset));
            writer.appendNoHilight(":");
            writer.newLine();
        }
        return writer;
    }

    public static GraphTextWriter constantPoolActionsToString(List<DisassemblyListener> listeners, long address, ActionList list, int version, ScriptExportMode exportMode, GraphTextWriter writer) {
        int poolIdx = 0;
        writer.appendNoHilight(Helper.constants).newLine();
        for (Action a : list) {
            if (!(a instanceof ActionConstantPool)) continue;
            if (poolIdx > 0) {
                writer.appendNoHilight("---").newLine();
            }
            ActionConstantPool cPool = (ActionConstantPool)a;
            int constIdx = 0;
            for (String c : cPool.constantPool) {
                writer.appendNoHilight(constIdx);
                writer.appendNoHilight("|");
                writer.appendNoHilight(Helper.escapeString(c));
                writer.newLine();
                ++constIdx;
            }
            ++poolIdx;
        }
        return writer;
    }

    public String getASMSource(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode) {
        return this.toString();
    }

    public abstract boolean execute(LocalDataArea var1);

    public void translate(GraphSourceItem lineStartIns, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) throws InterruptedException {
    }

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        return 0;
    }

    @Override
    public int getStackPushCount(BaseLocalData localData, TranslateStack stack) {
        return 0;
    }

    protected long popLong(TranslateStack stack) {
        GraphTargetItem item = stack.pop();
        if (item instanceof DirectValueActionItem) {
            return (long)EcmaScript.toNumberAs2(((DirectValueActionItem)item).value).doubleValue();
        }
        return 0L;
    }

    public static long ip2adr(List<Action> actions, int ip) {
        if (ip >= actions.size()) {
            if (actions.isEmpty()) {
                return 0L;
            }
            return actions.get(actions.size() - 1).getAddress() + (long)actions.get(actions.size() - 1).getTotalActionLength();
        }
        if (ip == -1) {
            return 0L;
        }
        return actions.get(ip).getAddress();
    }

    public static int adr2ip(List<Action> actions, long addr) {
        long outpos;
        for (int ip = 0; ip < actions.size(); ++ip) {
            if (actions.get(ip).getAddress() != addr) continue;
            return ip;
        }
        if (actions.size() > 0 && addr == (outpos = actions.get(actions.size() - 1).getAddress() + (long)actions.get(actions.size() - 1).getTotalActionLength())) {
            return actions.size();
        }
        return -1;
    }

    public static List<GraphTargetItem> actionsToTree(List<Action> actions, int version, int staticOperation, String path) throws InterruptedException {
        return Action.actionsToTree(new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>(), actions, version, staticOperation, path);
    }

    public static GraphTextWriter actionsToSource(ASMSource asm, final List<Action> actions, final String path, GraphTextWriter writer) throws InterruptedException {
        writer.suspendMeasure();
        List<GraphTargetItem> tree = null;
        Throwable convertException = null;
        int timeout = Configuration.decompilationTimeoutSingleMethod.get();
        final SWF swf = asm == null ? null : asm.getSwf();
        final int version = swf == null ? 10 : swf.version;
        try {
            tree = CancellableWorker.call(new Callable<List<GraphTargetItem>>(){

                @Override
                public List<GraphTargetItem> call() throws Exception {
                    int staticOperation = 0;
                    List<GraphTargetItem> tree = Action.actionsToTree(new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>(), actions, version, staticOperation, path);
                    SWFDecompilerPlugin.fireActionTreeCreated(tree, swf);
                    if (Configuration.autoDeobfuscate.get().booleanValue()) {
                        new ActionDeobfuscator().actionTreeCreated(tree, swf);
                    }
                    Graph.graphToString(tree, new NulWriter(), new LocalData());
                    return tree;
                }
            }, timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception | OutOfMemoryError | StackOverflowError ex) {
            convertException = ex;
            Throwable cause = ex.getCause();
            if (ex instanceof ExecutionException && cause instanceof Exception) {
                convertException = cause;
            }
            if (convertException instanceof TimeoutException) {
                logger.log(Level.SEVERE, "Decompilation timeout in: " + path, convertException);
            }
            logger.log(Level.SEVERE, "Decompilation error in: " + path, convertException);
        }
        writer.continueMeasure();
        if (asm != null) {
            asm.getActionSourcePrefix(writer);
        }
        if (convertException == null) {
            Graph.graphToString(tree, writer, new LocalData());
        } else if (convertException instanceof TimeoutException) {
            Helper.appendTimeoutCommentAs2(writer, timeout, actions.size());
        } else {
            Helper.appendErrorComment(writer, convertException);
        }
        if (asm != null) {
            asm.getActionSourceSuffix(writer);
        }
        return writer;
    }

    public static List<GraphTargetItem> actionsToTree(HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, List<Action> actions, int version, int staticOperation, String path) throws InterruptedException {
        return ActionGraph.translateViaGraph(regNames, variables, functions, actions, version, staticOperation, path);
    }

    @Override
    public void translate(BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output, int staticOperation, String path) throws InterruptedException {
        ActionLocalData aLocalData = (ActionLocalData)localData;
        this.translate(aLocalData.lineStartAction, stack, output, aLocalData.regNames, aLocalData.variables, aLocalData.functions, staticOperation, path);
    }

    @Override
    public boolean isJump() {
        return false;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    @Override
    public boolean isExit() {
        return false;
    }

    @Override
    public List<Integer> getBranches(GraphSource code) {
        return new ArrayList<Integer>();
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public void setIgnored(boolean ignored, int pos) {
        this.ignored = ignored;
    }

    public static List<GraphTargetItem> actionsPartToTree(Reference<GraphSourceItem> fi, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, TranslateStack stack, List<Action> actions, int start, int end, int version, int staticOperation, String path) throws InterruptedException {
        if (start < actions.size() && end > 0 && start > 0) {
            logger.log(Level.FINE, "Entering {0}-{1}{2}", new Object[]{start, end, actions.size() > 0 ? " (" + actions.get(start).toString() + " - " + actions.get(end == actions.size() ? end - 1 : end) + ")" : ""});
        }
        ActionLocalData localData = new ActionLocalData(registerNames, variables, functions);
        localData.lineStartAction = fi.getVal();
        ArrayList<GraphTargetItem> output = new ArrayList<GraphTargetItem>();
        int ip = start;
        boolean isWhile = false;
        boolean isForIn = false;
        Object inItem = null;
        boolean loopStart = false;
        while (ip <= end) {
            Action action;
            long addr = Action.ip2adr(actions, ip);
            if (ip > end) break;
            if (ip >= actions.size()) {
                output.add(new ScriptEndItem());
                break;
            }
            if (Configuration.simplifyExpressions.get().booleanValue()) {
                stack.simplify();
            }
            if ((action = actions.get(ip)).isIgnored()) {
                ++ip;
                continue;
            }
            boolean isStackEmpty = true;
            for (int i = 0; i < stack.size(); ++i) {
                if (stack.get(i) instanceof FunctionActionItem) continue;
                isStackEmpty = false;
                break;
            }
            if (isStackEmpty) {
                localData.lineStartAction = action;
                fi.setVal(action);
            }
            if (action instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)action);
                long endAddr = action.getAddress() + cnt.getHeaderSize();
                String cntName = cnt.getName();
                ArrayList<List<GraphTargetItem>> outs = new ArrayList<List<GraphTargetItem>>();
                HashMap<String, GraphTargetItem> variables2 = Helper.deepCopy(variables);
                if (cnt instanceof ActionDefineFunction || cnt instanceof ActionDefineFunction2) {
                    for (int r = 0; r < 256; ++r) {
                        if (!variables2.containsKey("__register" + r)) continue;
                        variables2.remove("__register" + r);
                    }
                }
                for (long size : cnt.getContainerSizes()) {
                    List<GraphTargetItem> out;
                    if (size == 0L) {
                        outs.add(new ArrayList());
                        continue;
                    }
                    try {
                        HashMap<Integer, String> regNames = cnt.getRegNames();
                        if (action instanceof ActionWith || action instanceof ActionTry) {
                            for (Map.Entry<Integer, String> e : registerNames.entrySet()) {
                                if (regNames.containsKey(e.getKey())) continue;
                                regNames.put(e.getKey(), e.getValue());
                            }
                        }
                        out = ActionGraph.translateViaGraph(regNames, variables2, functions, actions.subList(Action.adr2ip(actions, endAddr), Action.adr2ip(actions, endAddr + size)), version, staticOperation, path + (cntName == null ? "" : "/" + cntName));
                    }
                    catch (TranslateException | OutOfMemoryError | StackOverflowError ex) {
                        logger.log(Level.SEVERE, "Decompilation error in: " + path, ex);
                        if (ex instanceof OutOfMemoryError) {
                            Helper.freeMem();
                        }
                        out = new ArrayList<CommentItem>();
                        out.add(new CommentItem(new String[]{"", " * " + AppResources.translate("decompilationError"), " * " + AppResources.translate("decompilationError.obfuscated"), Helper.decompilationErrorAdd == null ? null : " * " + Helper.decompilationErrorAdd, " * " + AppResources.translate("decompilationError.errorType") + ": " + ex.getClass().getSimpleName(), ""}));
                    }
                    outs.add(out);
                    endAddr += size;
                }
                ((GraphSourceItemContainer)((Object)action)).translateContainer(outs, action, stack, output, registerNames, variables, functions);
                ip = Action.adr2ip(actions, endAddr);
                continue;
            }
            if (action instanceof ActionPush && ((ActionPush)action).values.size() == 1 && ((ActionPush)action).values.get(0) == Null.INSTANCE && ip + 3 <= end && (actions.get(ip + 1) instanceof ActionEquals || actions.get(ip + 1) instanceof ActionEquals2) && actions.get(ip + 2) instanceof ActionNot && actions.get(ip + 3) instanceof ActionIf) {
                ActionIf aif = (ActionIf)actions.get(ip + 3);
                if (Action.adr2ip(actions, Action.ip2adr(actions, ip + 4) + (long)aif.getJumpOffset()) == ip) {
                    ip += 4;
                    continue;
                }
            }
            if (action instanceof ActionStore) {
                ActionStore store = (ActionStore)((Object)action);
                store.setStore(actions.subList(ip + 1, ip + 1 + store.getStoreSize()));
                ip = ip + 1 + store.getStoreSize() - 1;
            }
            action.translate(localData, stack, output, staticOperation, path);
            ++ip;
        }
        logger.log(Level.FINE, "Leaving {0}-{1}", new Object[]{start, end});
        return output;
    }

    public static GraphTargetItem getWithoutGlobal(GraphTargetItem ti) {
        GraphTargetItem t = ti;
        if (!(t instanceof GetMemberActionItem)) {
            return ti;
        }
        GetMemberActionItem lastMember = null;
        while (((GetMemberActionItem)t).object instanceof GetMemberActionItem) {
            lastMember = (GetMemberActionItem)t;
            t = ((GetMemberActionItem)t).object;
        }
        if (((GetMemberActionItem)t).object instanceof GetVariableActionItem) {
            GetVariableActionItem v = (GetVariableActionItem)((GetMemberActionItem)t).object;
            if (v.name instanceof DirectValueActionItem && ((DirectValueActionItem)v.name).value instanceof String && ((DirectValueActionItem)v.name).value.equals("_global")) {
                GetVariableActionItem gvt = new GetVariableActionItem(null, null, ((GetMemberActionItem)t).memberName);
                if (lastMember == null) {
                    return gvt;
                }
                lastMember.object = gvt;
            }
        }
        return ti;
    }

    public static List<GraphTargetItem> checkClass(List<GraphTargetItem> output) {
        ArrayList ret = new ArrayList();
        ArrayList<GraphTargetItem> functions = new ArrayList<GraphTargetItem>();
        ArrayList<GraphTargetItem> staticFunctions = new ArrayList<GraphTargetItem>();
        ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>> vars = new ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>>();
        ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>> staticVars = new ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>>();
        GraphTargetItem extendsOp = null;
        List<Object> implementsOp = new ArrayList();
        boolean ok = true;
        int prevCount = 0;
        for (GraphTargetItem t : output) {
            if (t instanceof IfItem) {
                IfItem it = (IfItem)t;
                if (it.expression instanceof NotItem) {
                    NotItem nti = (NotItem)it.expression;
                    if (nti.value instanceof GetMemberActionItem || nti.value instanceof GetVariableActionItem) {
                        if (it.onTrue.size() != 1 || !(it.onTrue.get(0) instanceof SetMemberActionItem) || !(((SetMemberActionItem)it.onTrue.get((int)0)).value instanceof NewObjectActionItem)) {
                            List<GraphTargetItem> parts = it.onTrue;
                            GraphTargetItem className = Action.getWithoutGlobal(nti.value);
                            if (parts.size() >= 1) {
                                int ipos = 0;
                                while (parts.get(ipos) instanceof PopItem || parts.get(ipos) instanceof IfItem && ((IfItem)parts.get((int)ipos)).onTrue.size() == 1 && ((IfItem)parts.get((int)ipos)).onTrue.get(0) instanceof SetMemberActionItem && ((SetMemberActionItem)((IfItem)parts.get((int)ipos)).onTrue.get((int)0)).value instanceof NewObjectActionItem) {
                                    ++ipos;
                                }
                                if (parts.get(ipos) instanceof ExtendsActionItem) {
                                    ExtendsActionItem et = (ExtendsActionItem)parts.get(ipos);
                                    extendsOp = Action.getWithoutGlobal(et.superclass);
                                    ++ipos;
                                }
                                if (parts.get(ipos) instanceof StoreRegisterActionItem) {
                                    StoreRegisterActionItem sr = (StoreRegisterActionItem)parts.get(ipos);
                                    int instanceReg = sr.register.number;
                                    if (sr.value instanceof GetMemberActionItem) {
                                        GetMemberActionItem gm = (GetMemberActionItem)sr.value;
                                        if (gm.object instanceof TemporaryRegister) {
                                            TemporaryRegister tm = (TemporaryRegister)gm.object;
                                            int classReg = tm.getRegId();
                                            if (tm.value instanceof SetMemberActionItem) {
                                                SetMemberActionItem sm = (SetMemberActionItem)tm.value;
                                                if (sm.value instanceof StoreRegisterActionItem) {
                                                    sr = (StoreRegisterActionItem)sm.value;
                                                    if (sr.value instanceof FunctionActionItem) {
                                                        ((FunctionActionItem)sr.value).calculatedFunctionName = className instanceof GetMemberActionItem ? ((GetMemberActionItem)className).memberName : className;
                                                        functions.add((FunctionActionItem)sr.value);
                                                        while (ipos < parts.size()) {
                                                            if (parts.get(ipos) instanceof ImplementsOpActionItem) {
                                                                ImplementsOpActionItem io = (ImplementsOpActionItem)parts.get(ipos);
                                                                implementsOp = io.superclasses;
                                                            } else if (parts.get(ipos) instanceof SetMemberActionItem) {
                                                                sm = (SetMemberActionItem)parts.get(ipos);
                                                                int rnum = -1;
                                                                if (sm.object instanceof DirectValueActionItem) {
                                                                    DirectValueActionItem dv = (DirectValueActionItem)sm.object;
                                                                    if (dv.value instanceof RegisterNumber) {
                                                                        RegisterNumber rn = (RegisterNumber)dv.value;
                                                                        rnum = rn.number;
                                                                    }
                                                                }
                                                                if (sm.object instanceof TemporaryRegister) {
                                                                    rnum = ((TemporaryRegister)sm.object).getRegId();
                                                                }
                                                                if (rnum == instanceReg) {
                                                                    if (sm.value instanceof FunctionActionItem) {
                                                                        ((FunctionActionItem)sm.value).calculatedFunctionName = sm.objectName;
                                                                        functions.add((FunctionActionItem)sm.value);
                                                                    } else {
                                                                        vars.add(new MyEntry<GraphTargetItem, GraphTargetItem>(sm.objectName, sm.value));
                                                                    }
                                                                } else if (rnum == classReg) {
                                                                    if (sm.value instanceof FunctionActionItem) {
                                                                        ((FunctionActionItem)sm.value).calculatedFunctionName = sm.objectName;
                                                                        staticFunctions.add((FunctionActionItem)sm.value);
                                                                    } else {
                                                                        staticVars.add(new MyEntry<GraphTargetItem, GraphTargetItem>(sm.objectName, sm.value));
                                                                    }
                                                                }
                                                            }
                                                            ++ipos;
                                                        }
                                                    }
                                                }
                                            }
                                            ArrayList<GraphTargetItem> output2 = new ArrayList<GraphTargetItem>();
                                            for (int i = 0; i < prevCount; ++i) {
                                                output2.add(output.get(i));
                                            }
                                            output2.add(new ClassActionItem(className, extendsOp, implementsOp, null, functions, vars, staticFunctions, staticVars));
                                            return output2;
                                        }
                                    }
                                } else if (parts.get(ipos) instanceof SetMemberActionItem) {
                                    SetMemberActionItem sm = (SetMemberActionItem)parts.get(0);
                                    if (sm.value instanceof FunctionActionItem) {
                                        FunctionActionItem f = (FunctionActionItem)sm.value;
                                        if (f.actions.isEmpty()) {
                                            if (parts.size() == 2) {
                                                if (!(parts.get(1) instanceof ImplementsOpActionItem)) break;
                                                ImplementsOpActionItem iot = (ImplementsOpActionItem)parts.get(1);
                                                implementsOp = iot.superclasses;
                                            }
                                            ArrayList<GraphTargetItem> output2 = new ArrayList<GraphTargetItem>();
                                            for (int i = 0; i < prevCount; ++i) {
                                                output2.add(output.get(i));
                                            }
                                            output2.add(new InterfaceActionItem(sm.objectName, implementsOp));
                                            return output2;
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            } else if (!(t instanceof PopItem)) {
                ++prevCount;
            }
            if (ok) continue;
            break;
        }
        return output;
    }

    @Override
    public boolean ignoredLoops() {
        return false;
    }

    public static void setConstantPool(List<? extends GraphSourceItem> actions, ConstantPool cpool) {
        for (GraphSourceItem graphSourceItem : actions) {
            if (graphSourceItem instanceof ActionPush && cpool != null) {
                ((ActionPush)graphSourceItem).constantPool = cpool.constants;
            }
            if (!(graphSourceItem instanceof ActionDefineFunction) || cpool != null) {
                // empty if block
            }
            if (graphSourceItem instanceof ActionDefineFunction2 && cpool == null) continue;
        }
    }

    public GraphTextWriter getASMSourceReplaced(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode, GraphTextWriter writer) {
        writer.appendNoHilight(this.getASMSource(container, knownAddreses, exportMode));
        return writer;
    }

    public static double toFloatPoint(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o == Null.INSTANCE) {
            return Double.NaN;
        }
        if (o == Undefined.INSTANCE) {
            return Double.NaN;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
        return 0.0;
    }

    public static GraphTargetItem gettoset(GraphTargetItem get, GraphTargetItem value, List<VariableActionItem> variables) {
        GraphTargetItem ret = get;
        boolean boxed = false;
        if (get instanceof VariableActionItem) {
            boxed = true;
            ret = ((VariableActionItem)ret).getBoxedValue();
        }
        if (ret instanceof GetVariableActionItem) {
            GetVariableActionItem gv = (GetVariableActionItem)ret;
            ret = new SetVariableActionItem(null, null, gv.name, value);
        } else if (ret instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)ret;
            ret = new SetMemberActionItem(null, null, mem.object, mem.memberName, value);
        } else if (ret instanceof DirectValueActionItem && ((DirectValueActionItem)ret).value instanceof RegisterNumber) {
            ret = new StoreRegisterActionItem(null, null, (RegisterNumber)((DirectValueActionItem)ret).value, value, false);
        } else if (ret instanceof GetPropertyActionItem) {
            GetPropertyActionItem gp = (GetPropertyActionItem)ret;
            ret = new SetPropertyActionItem(null, null, gp.target, gp.propertyIndex, value);
        }
        if (boxed) {
            GraphTargetItem b = ret;
            ret = new VariableActionItem(((VariableActionItem)get).getVariableName(), value, ((VariableActionItem)get).isDefinition());
            ((VariableActionItem)ret).setBoxedValue((ActionItem)b);
            variables.remove((VariableActionItem)get);
            variables.add((VariableActionItem)ret);
        }
        return ret;
    }

    @Override
    public boolean isDeobfuscatePop() {
        return false;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public String getFile() {
        return null;
    }
}

