/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;

public class Namespace {
    public static final int KIND_NAMESPACE = 8;
    public static final int KIND_PRIVATE = 5;
    public static final int KIND_PACKAGE = 22;
    public static final int KIND_PACKAGE_INTERNAL = 23;
    public static final int KIND_PROTECTED = 24;
    public static final int KIND_EXPLICIT = 25;
    public static final int KIND_STATIC_PROTECTED = 26;
    public static final int[] nameSpaceKinds = new int[]{8, 5, 22, 23, 24, 25, 26};
    public static final String[] nameSpaceKindNames = new String[]{"Namespace", "PrivateNamespace", "PackageNamespace", "PackageInternalNs", "ProtectedNamespace", "ExplicitNamespace", "StaticProtectedNs"};
    public static final String[] namePrefixes = new String[]{"", "private", "public", "", "protected", "explicit", "protected"};
    public int kind;
    public int name_index;
    @Internal
    public boolean deleted;

    public static String kindToStr(int kind) {
        for (int i = 0; i < nameSpaceKinds.length; ++i) {
            if (nameSpaceKinds[i] != kind) continue;
            return nameSpaceKindNames[i];
        }
        return null;
    }

    public static String kindToPrefix(int kind) {
        for (int i = 0; i < nameSpaceKinds.length; ++i) {
            if (nameSpaceKinds[i] != kind) continue;
            return namePrefixes[i];
        }
        return null;
    }

    public Namespace() {
    }

    public Namespace(int kind, int name_index) {
        this.kind = kind;
        this.name_index = name_index;
    }

    public String getKindStr() {
        String kindStr = "?";
        for (int k = 0; k < nameSpaceKinds.length; ++k) {
            if (nameSpaceKinds[k] != this.kind) continue;
            kindStr = nameSpaceKindNames[k];
            break;
        }
        return kindStr;
    }

    public String toString() {
        return "Namespace: kind=" + this.getKindStr() + " name_index=" + this.name_index;
    }

    public String toString(AVM2ConstantPool constants) {
        return this.getName(constants).toPrintableString(true);
    }

    public String getNameWithKind(AVM2ConstantPool constants) {
        String kindStr = this.getKindStr();
        String nameStr = constants.getString(this.name_index);
        return kindStr + (nameStr == null || nameStr.isEmpty() ? "" : " " + nameStr);
    }

    public String getPrefix(ABC abc) {
        String kindStr = "?";
        for (int k = 0; k < nameSpaceKinds.length; ++k) {
            if (nameSpaceKinds[k] != this.kind) continue;
            kindStr = namePrefixes[k];
            break;
        }
        return kindStr;
    }

    public DottedChain getName(AVM2ConstantPool constants) {
        if (this.name_index == 0 || this.name_index == -1) {
            return DottedChain.EMPTY;
        }
        return constants.getDottedChain(this.name_index);
    }

    public boolean hasName(String name, AVM2ConstantPool constants) {
        if (name == null && this.name_index == 0) {
            return true;
        }
        if (name == null) {
            return false;
        }
        if (name.isEmpty() && this.name_index == 0) {
            return true;
        }
        if (this.name_index == 0) {
            return false;
        }
        return constants.getString(this.name_index).equals(name);
    }
}

