/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.OrItem;
import java.util.ArrayList;
import java.util.List;

public abstract class AssignableAVM2Item
extends AVM2Item {
    protected GraphTargetItem assignedValue;

    protected GraphTargetItem makeCoerced(GraphTargetItem assignedValue, GraphTargetItem targetType) {
        if (assignedValue instanceof OrItem) {
            OrItem oi = (OrItem)assignedValue;
            return new OrItem(assignedValue.getSrc(), assignedValue.getLineStartItem(), this.makeCoerced(oi.leftSide, targetType), this.makeCoerced(oi.rightSide, targetType));
        }
        return new CoerceAVM2Item(null, null, assignedValue, targetType);
    }

    public AssignableAVM2Item() {
        this(null);
    }

    public abstract AssignableAVM2Item copy();

    public AssignableAVM2Item(GraphTargetItem storeValue) {
        super(null, null, 0);
        this.assignedValue = storeValue;
    }

    public abstract List<GraphSourceItem> toSourceChange(SourceGeneratorLocalData var1, SourceGenerator var2, boolean var3, boolean var4, boolean var5) throws CompilationException;

    public GraphTargetItem getAssignedValue() {
        return this.assignedValue;
    }

    public void setAssignedValue(GraphTargetItem storeValue) {
        this.assignedValue = storeValue;
    }

    public static List<GraphSourceItem> dupSetTemp(SourceGeneratorLocalData localData, SourceGenerator generator, Reference<Integer> register) {
        register.setVal(AssignableAVM2Item.getFreeRegister(localData, generator));
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(AssignableAVM2Item.ins(42, new Integer[0]));
        ret.add(AssignableAVM2Item.generateSetLoc(register.getVal()));
        return ret;
    }

    public static List<GraphSourceItem> setTemp(SourceGeneratorLocalData localData, SourceGenerator generator, Reference<Integer> register) {
        register.setVal(AssignableAVM2Item.getFreeRegister(localData, generator));
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(AssignableAVM2Item.generateSetLoc(register.getVal()));
        return ret;
    }

    public static List<GraphSourceItem> getTemp(SourceGeneratorLocalData localData, SourceGenerator generator, Reference<Integer> register) {
        if (register.getVal() < 0) {
            return new ArrayList<GraphSourceItem>();
        }
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(AssignableAVM2Item.generateGetLoc(register.getVal()));
        return ret;
    }

    public static List<GraphSourceItem> killTemp(SourceGeneratorLocalData localData, SourceGenerator generator, List<Reference<Integer>> registers) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        for (Reference<Integer> register : registers) {
            if (register.getVal() < 0) continue;
            AssignableAVM2Item.killRegister(localData, generator, register.getVal());
            ret.add(AssignableAVM2Item.ins(8, register.getVal()));
        }
        return ret;
    }

    public static AVM2Instruction generateSetLoc(int regNumber) {
        switch (regNumber) {
            case -1: {
                return null;
            }
            case 0: {
                return AssignableAVM2Item.ins(212, new Integer[0]);
            }
            case 1: {
                return AssignableAVM2Item.ins(213, new Integer[0]);
            }
            case 2: {
                return AssignableAVM2Item.ins(214, new Integer[0]);
            }
            case 3: {
                return AssignableAVM2Item.ins(215, new Integer[0]);
            }
        }
        return AssignableAVM2Item.ins(99, regNumber);
    }

    public static AVM2Instruction generateGetLoc(int regNumber) {
        switch (regNumber) {
            case -1: {
                return null;
            }
            case 0: {
                return AssignableAVM2Item.ins(208, new Integer[0]);
            }
            case 1: {
                return AssignableAVM2Item.ins(209, new Integer[0]);
            }
            case 2: {
                return AssignableAVM2Item.ins(210, new Integer[0]);
            }
            case 3: {
                return AssignableAVM2Item.ins(211, new Integer[0]);
            }
        }
        return AssignableAVM2Item.ins(98, regNumber);
    }

    public static List<GraphSourceItem> generateGetSlot(int slotScope, int slotNumber) {
        if (slotNumber == -1) {
            return null;
        }
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(AssignableAVM2Item.ins(101, slotScope));
        ret.add(AssignableAVM2Item.ins(108, slotNumber));
        return ret;
    }

    public static List<GraphSourceItem> generateSetSlot(SourceGeneratorLocalData localData, SourceGenerator generator, GraphTargetItem val, int slotScope, int slotNumber) throws CompilationException {
        if (slotNumber == -1) {
            return null;
        }
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(AssignableAVM2Item.ins(101, slotScope));
        ret.addAll(val.toSource(localData, generator));
        ret.add(AssignableAVM2Item.ins(109, slotNumber));
        return ret;
    }
}

