/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ABCMethodIndexing {
    private final ABC abc;
    private Map<MethodInfo, Integer> bodyIdxFromMethod = new HashMap<MethodInfo, Integer>();

    public ABCMethodIndexing(ABC abc) {
        this.abc = abc;
        this.createBodyIdxFromMethodIdxMap(abc);
    }

    public final void createBodyIdxFromMethodIdxMap(ABC abc) {
        List<MethodBody> bodies = abc.bodies;
        HashMap<MethodInfo, Integer> map = new HashMap<MethodInfo, Integer>(bodies.size());
        for (int i = 0; i < bodies.size(); ++i) {
            MethodBody mb = bodies.get(i);
            map.put(abc.method_info.get(mb.method_info), i);
        }
        this.bodyIdxFromMethod = map;
    }

    public int findMethodBodyIndex(MethodInfo methodInfo) {
        Integer bi = this.bodyIdxFromMethod.get(methodInfo);
        if (bi == null) {
            return -1;
        }
        return bi;
    }

    public int findMethodBodyIndex(int methodInfo) {
        if (methodInfo < 0 || methodInfo >= this.abc.method_info.size()) {
            return -1;
        }
        MethodInfo mi = this.abc.method_info.get(methodInfo);
        return this.findMethodBodyIndex(mi);
    }

    public MethodBody findMethodBody(MethodInfo methodInfo) {
        int bi = this.findMethodBodyIndex(methodInfo);
        if (bi != -1) {
            return this.abc.bodies.get(bi);
        }
        return null;
    }

    public MethodBody findMethodBody(int methodInfo) {
        int bi = this.findMethodBodyIndex(methodInfo);
        if (bi != -1) {
            return this.abc.bodies.get(bi);
        }
        return null;
    }

    public List<Trait> findMethodTraits(ScriptPack pack, int bodyIndex) {
        int methodInfo = this.abc.bodies.get((int)bodyIndex).method_info;
        List<Trait> traits = this.abc.script_info.get((int)pack.scriptIndex).traits.traits;
        ArrayList<Trait> resultTraits = new ArrayList<Trait>();
        for (int ti : pack.traitIndices) {
            Trait t = traits.get(ti);
            ABCMethodIndexing.findTraits(this.abc, t, methodInfo, resultTraits);
        }
        return resultTraits;
    }

    private static void findTraits(ABC abc, Trait trait, int methodInfo, List<Trait> result) {
        if (trait instanceof TraitSlotConst) {
            TraitSlotConst traitSlotConst = (TraitSlotConst)trait;
        } else if (trait instanceof TraitFunction) {
            TraitFunction tf = (TraitFunction)trait;
            if (tf.method_info == methodInfo) {
                result.add(trait);
            }
        } else if (trait instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)trait;
            if (tmgs.method_info == methodInfo) {
                result.add(trait);
            }
        } else if (trait instanceof TraitClass) {
            TraitClass tc = (TraitClass)trait;
            InstanceInfo instanceInfo = abc.instance_info.get(tc.class_info);
            for (Trait t : instanceInfo.instance_traits.traits) {
                ABCMethodIndexing.findTraits(abc, t, methodInfo, result);
            }
            ClassInfo classInfo = abc.class_info.get(tc.class_info);
            for (Trait t : classInfo.static_traits.traits) {
                ABCMethodIndexing.findTraits(abc, t, methodInfo, result);
            }
        }
    }
}

