/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.javactivex;

import com.jpexs.javactivex.ActiveXControl;
import com.jpexs.javactivex.ActiveXEventListener;
import com.jpexs.javactivex.ActiveXException;
import com.jpexs.javactivex.AddListener;
import com.jpexs.javactivex.GUID;
import com.jpexs.javactivex.Getter;
import com.jpexs.javactivex.ICOMInstance;
import com.jpexs.javactivex.RemoveListener;
import com.jpexs.javactivex.Setter;
import java.awt.Panel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public class ActiveX {
    public static <E> E createObject(Class<E> cls) {
        return ActiveX.createObject(cls, null);
    }

    public static <E> E createObject(Class<E> cls, Panel host) {
        GUID g = cls.getAnnotation(GUID.class);
        if (g == null) {
            throw new ActiveXException("Interface must have GUID");
        }
        return (E)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)new MyHandler(g.base().equals("") ? g.value() : g.base(), g.value(), host));
    }

    public static <E> E getObject(Class<E> cls, long cid) {
        GUID g = cls.getAnnotation(GUID.class);
        if (g == null) {
            throw new ActiveXException("Interface must have GUID");
        }
        return (E)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls, ICOMInstance.class}, (InvocationHandler)new MyHandler(cid));
    }

    public static void generateClassFromTLB(String clsid, String outdir, String pkg) {
        ActiveX.generate(clsid, clsid, new HashSet<String>(), outdir, pkg);
    }

    private static void generate(String baseguid, String guid, Set<String> generatedGuids, String outdir, String pkg) {
        if (generatedGuids.contains(baseguid + ':' + guid)) {
            return;
        }
        File fdir = new File(outdir);
        if (!fdir.exists()) {
            fdir.mkdirs();
        }
        if (!fdir.exists()) {
            return;
        }
        generatedGuids.add(baseguid + ':' + guid);
        try (FileOutputStream fos = new FileOutputStream(outdir + File.separator + ActiveXControl.getClassName(baseguid, guid) + ".java");){
            HashSet<String> neededGuids = new HashSet<String>();
            fos.write(ActiveXControl.getJavaDefinition(baseguid, guid, neededGuids, pkg).getBytes("UTF-8"));
            for (String n : neededGuids) {
                String[] pts = n.split(":");
                ActiveX.generate(pts[0], pts[1], generatedGuids, outdir, pkg);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static void unload() {
        ActiveXControl.unload();
    }

    private static class MyHandler
    implements InvocationHandler {
        private final ActiveXControl c;

        public MyHandler(String baseguid, String guid, Panel host) {
            this.c = new ActiveXControl(baseguid, guid, host);
        }

        public MyHandler(long cid) {
            this.c = ActiveXControl.getInstance(cid);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Getter g = method.getAnnotation(Getter.class);
            if (g != null) {
                return this.c.getPropertyValue(method.getReturnType(), g.value());
            }
            Setter s = method.getAnnotation(Setter.class);
            if (s != null) {
                this.c.setPropertyValue(method.getParameterTypes()[0], s.value(), args[0]);
                return null;
            }
            AddListener al = method.getAnnotation(AddListener.class);
            if (al != null) {
                this.c.addEventListener(al.value(), (ActiveXEventListener)args[0]);
                return null;
            }
            RemoveListener rl = method.getAnnotation(RemoveListener.class);
            if (al != null) {
                this.c.removeEventListener(rl.value(), (ActiveXEventListener)args[0]);
                return null;
            }
            if (method.getName().equals("getCid")) {
                return this.c.getCid();
            }
            return this.c.callMethodArr(method.getName(), args == null ? new Object[]{} : args, method.getParameterTypes(), method.getGenericParameterTypes(), method.getReturnType());
        }
    }
}

