/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;

public class CompositeBitmapGlyph
extends BitmapGlyph {
    private int numComponentsOffset;
    private int componentArrayOffset;

    protected CompositeBitmapGlyph(ReadableFontData readableFontData, int n) {
        super(readableFontData, n);
        this.initialize(n);
    }

    private void initialize(int n) {
        if (n == 8) {
            this.numComponentsOffset = BitmapGlyph.Offset.glyphFormat8_numComponents.offset;
            this.componentArrayOffset = BitmapGlyph.Offset.glyphFormat8_componentArray.offset;
        } else if (n == 9) {
            this.numComponentsOffset = BitmapGlyph.Offset.glyphFormat9_numComponents.offset;
            this.componentArrayOffset = BitmapGlyph.Offset.glyphFormat9_componentArray.offset;
        } else {
            throw new IllegalStateException("Attempt to create a Composite Bitmap Glyph with a non-composite format.");
        }
    }

    public int numComponents() {
        return this.data.readUShort(this.numComponentsOffset);
    }

    public Component component(int n) {
        int n2 = this.componentArrayOffset + n * BitmapGlyph.Offset.ebdtComponentLength.offset;
        return new Component(this.data.readUShort(n2 + BitmapGlyph.Offset.ebdtComponent_glyphCode.offset), this.data.readChar(n2 + BitmapGlyph.Offset.ebdtComponent_xOffset.offset), this.data.readChar(n2 + BitmapGlyph.Offset.ebdtComponent_yOffset.offset));
    }

    public static class Builder
    extends BitmapGlyph.Builder<CompositeBitmapGlyph> {
        protected Builder(WritableFontData writableFontData, int n) {
            super(writableFontData, n);
        }

        protected Builder(ReadableFontData readableFontData, int n) {
            super(readableFontData, n);
        }

        @Override
        protected CompositeBitmapGlyph subBuildTable(ReadableFontData readableFontData) {
            return new CompositeBitmapGlyph(readableFontData, this.format());
        }
    }

    public static final class Component {
        private final int glyphCode;
        private int xOffset;
        private int yOffset;

        protected Component(int n, int n2, int n3) {
            this.glyphCode = n;
            this.xOffset = n2;
            this.yOffset = n3;
        }

        public int glyphCode() {
            return this.glyphCode;
        }

        public int xOffset() {
            return this.xOffset;
        }

        public int yOffset() {
            return this.yOffset;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.glyphCode;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Component)) {
                return false;
            }
            Component component = (Component)object;
            return this.glyphCode == component.glyphCode;
        }
    }
}

