/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;

public abstract class FontData {
    protected static final int GROWABLE_SIZE = Integer.MAX_VALUE;
    protected final ByteArray<? extends ByteArray<?>> array;
    private int boundOffset;
    private int boundLength = Integer.MAX_VALUE;

    protected FontData(ByteArray<? extends ByteArray<?>> byteArray) {
        this.array = byteArray;
    }

    protected FontData(FontData fontData, int n, int n2) {
        this(fontData.array);
        this.bound(fontData.boundOffset + n, n2);
    }

    protected FontData(FontData fontData, int n) {
        this(fontData.array);
        this.bound(fontData.boundOffset + n, fontData.boundLength == Integer.MAX_VALUE ? Integer.MAX_VALUE : fontData.boundLength - n);
    }

    public boolean bound(int n, int n2) {
        if (n + n2 > this.size() || n < 0 || n2 < 0) {
            return false;
        }
        this.boundOffset += n;
        this.boundLength = n2;
        return true;
    }

    public boolean bound(int n) {
        if (n > this.size() || n < 0) {
            return false;
        }
        this.boundOffset += n;
        return true;
    }

    public abstract FontData slice(int var1, int var2);

    public abstract FontData slice(int var1);

    public int length() {
        return Math.min(this.array.length() - this.boundOffset, this.boundLength);
    }

    public int size() {
        return Math.min(this.array.size() - this.boundOffset, this.boundLength);
    }

    protected final int boundOffset(int n) {
        return n + this.boundOffset;
    }

    protected final int boundLength(int n, int n2) {
        return Math.min(n2, this.boundLength - n);
    }

    public static enum DataSize {
        BYTE(1),
        CHAR(1),
        USHORT(2),
        SHORT(2),
        UINT24(3),
        ULONG(4),
        LONG(4),
        Fixed(4),
        FUNIT(4),
        FWORD(2),
        UFWORD(2),
        F2DOT14(2),
        LONGDATETIME(8),
        Tag(4),
        GlyphID(2),
        Offset(2);

        private final int size;

        private DataSize(int n2) {
            this.size = n2;
        }

        public int size() {
            return this.size;
        }
    }
}

