/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.QuadraticSegment;

public class CubicSegment {
    public static final int LINE = 0;
    public static final int CURVE = 1;
    private EContourPoint m_startPoint = null;
    private EContourPoint m_controlPoint1 = null;
    private EContourPoint m_controlPoint2 = null;
    private EContourPoint m_endPoint = null;
    private int m_type = 0;

    public static ArrayList<CubicSegment> toSegments(EContour a_contour) {
        ArrayList<CubicSegment> retval = new ArrayList<CubicSegment>();
        ArrayList<EContourPoint> points = a_contour.getContourPoints();
        if (points.size() < 2) {
            return retval;
        }
        EContourPoint startPoint = points.get(points.size() - 1);
        for (int i = 0; i < points.size(); ++i) {
            EContourPoint endPoint = points.get(i);
            retval.add(new CubicSegment(startPoint, endPoint));
            startPoint = endPoint;
        }
        return retval;
    }

    public CubicSegment(EContourPoint a_startPoint, EContourPoint a_endPoint) {
        this.m_startPoint = a_startPoint;
        this.m_endPoint = a_endPoint;
        if (!a_startPoint.hasControlPoint2() && !a_endPoint.hasControlPoint1()) {
            this.m_type = 0;
            return;
        }
        if (a_startPoint.hasControlPoint2() || a_endPoint.hasControlPoint1()) {
            this.m_type = 1;
            this.m_controlPoint1 = a_startPoint.hasControlPoint2() ? a_startPoint.getControlPoint2().getContourPoint() : a_startPoint;
            if (a_endPoint.hasControlPoint1()) {
                this.m_controlPoint2 = a_endPoint.getControlPoint1().getContourPoint();
            } else {
                this.m_controlPoint1 = a_endPoint;
            }
        }
    }

    public CubicSegment(EContourPoint a_startPoint, EContourPoint a_controlPoint1, EContourPoint a_controlPoint2, EContourPoint a_endPoint) {
        this.m_startPoint = a_startPoint;
        this.m_controlPoint1 = a_controlPoint1;
        this.m_controlPoint2 = a_controlPoint2;
        this.m_endPoint = a_endPoint;
        this.m_type = 1;
    }

    public ArrayList<QuadraticSegment> toQuadraticSegments() {
        ArrayList<QuadraticSegment> retval = new ArrayList<QuadraticSegment>();
        if (this.m_type == 0) {
            retval.add(new QuadraticSegment(this.m_startPoint, null, this.m_endPoint));
            return retval;
        }
        return this.toQuadraticSegments(0);
    }

    private static Point2D.Double movePoint(Point2D point, double dx, double dy) {
        return new Point2D.Double(point.getX() + dx, point.getY() + dy);
    }

    private static Point2D getMidPoint(Point2D p0, Point2D p1) {
        return CubicSegment.getPointOnSegment(p0, p1, 0.5);
    }

    private static Point2D getPointOnSegment(Point2D p0, Point2D p1, double ratio) {
        double x = p0.getX() + (p1.getX() - p0.getX()) * ratio;
        double y = p0.getY() + (p1.getY() - p0.getY()) * ratio;
        return new Point2D.Double(x, y);
    }

    private static double[][] approximateCubic(double[] cubicControlPointCoords) {
        if (cubicControlPointCoords.length < 8) {
            throw new IllegalArgumentException("Must have at least 8 coordinates");
        }
        Point2D.Double p0 = new Point2D.Double(cubicControlPointCoords[0], cubicControlPointCoords[1]);
        Point2D.Double p1 = new Point2D.Double(cubicControlPointCoords[2], cubicControlPointCoords[3]);
        Point2D.Double p2 = new Point2D.Double(cubicControlPointCoords[4], cubicControlPointCoords[5]);
        Point2D.Double p3 = new Point2D.Double(cubicControlPointCoords[6], cubicControlPointCoords[7]);
        Point2D pa = CubicSegment.getPointOnSegment(p0, p1, 0.75);
        Point2D pb = CubicSegment.getPointOnSegment(p3, p2, 0.75);
        double dx = (((Point2D)p3).getX() - ((Point2D)p0).getX()) / 16.0;
        double dy = (((Point2D)p3).getY() - ((Point2D)p0).getY()) / 16.0;
        Point2D pc1 = CubicSegment.getPointOnSegment(p0, p1, 0.375);
        Point2D pc2 = CubicSegment.getPointOnSegment(pa, pb, 0.375);
        pc2 = CubicSegment.movePoint(pc2, -dx, -dy);
        Point2D pc3 = CubicSegment.getPointOnSegment(pb, pa, 0.375);
        pc3 = CubicSegment.movePoint(pc3, dx, dy);
        Point2D pc4 = CubicSegment.getPointOnSegment(p3, p2, 0.375);
        Point2D pa1 = CubicSegment.getMidPoint(pc1, pc2);
        Point2D pa2 = CubicSegment.getMidPoint(pa, pb);
        Point2D pa3 = CubicSegment.getMidPoint(pc3, pc4);
        return new double[][]{{pc1.getX(), pc1.getY(), pa1.getX(), pa1.getY()}, {pc2.getX(), pc2.getY(), pa2.getX(), pa2.getY()}, {pc3.getX(), pc3.getY(), pa3.getX(), pa3.getY()}, {pc4.getX(), pc4.getY(), ((Point2D)p3).getX(), ((Point2D)p3).getY()}};
    }

    private ArrayList<QuadraticSegment> toQuadraticSegments(int a_trial) {
        ArrayList<QuadraticSegment> retval = new ArrayList<QuadraticSegment>();
        double[][] quadCoords = CubicSegment.approximateCubic(new double[]{this.m_startPoint.getX(), this.m_startPoint.getY(), this.m_controlPoint1.getX(), this.m_controlPoint1.getY(), this.m_controlPoint2.getX(), this.m_controlPoint2.getY(), this.m_endPoint.getX(), this.m_endPoint.getY()});
        EContourPoint lastPoint = this.m_startPoint;
        for (int i = 0; i < quadCoords.length; ++i) {
            retval.add(new QuadraticSegment(lastPoint, new EContourPoint(quadCoords[i][0], quadCoords[i][1], true), new EContourPoint(quadCoords[i][2], quadCoords[i][3], false)));
            lastPoint = new EContourPoint(quadCoords[i][2], quadCoords[i][3], true);
        }
        return retval;
    }
}

