/*
 * Decompiled with CFR 0.152.
 */
package com.jpacker;

import com.jpacker.JPackerEncoding;
import com.jpacker.JPackerWord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JPackerWords {
    private JPackerEncoding encoding;
    private static final Pattern WORDS = Pattern.compile("\\w+");
    private List<JPackerWord> words = new ArrayList<JPackerWord>();

    public JPackerWords(String script, JPackerEncoding encoding) {
        this.encoding = encoding;
        Matcher matcher = WORDS.matcher(script);
        while (matcher.find()) {
            this.add(new JPackerWord(matcher.group()));
        }
        this.encode();
    }

    private void add(JPackerWord word) {
        if (!this.words.contains(word)) {
            this.words.add(word);
        }
        JPackerWord w = this.find(word);
        w.setCount(w.getCount() + 1);
    }

    private void encode() {
        Collections.sort(this.words, new Comparator<JPackerWord>(){

            @Override
            public int compare(JPackerWord x, JPackerWord y) {
                return y.getCount() - x.getCount();
            }
        });
        HashMap<String, Integer> encoded = new HashMap<String, Integer>();
        for (int i = 0; i < this.words.size(); ++i) {
            encoded.put(this.encoding.getEncoder().encode(i), i);
        }
        int index = 0;
        for (JPackerWord word : this.words) {
            if (encoded.containsKey(word.getWord())) {
                word.setIndex((Integer)encoded.get(word.getWord()));
                word.setReplacement("");
            } else {
                while (this.words.contains(new JPackerWord(this.encoding.getEncoder().encode(index)))) {
                    ++index;
                }
                word.setIndex(index++);
                word.setReplacement(word.getWord());
            }
            word.setEncoded(this.encoding.getEncoder().encode(word.getIndex()));
        }
        Collections.sort(this.words, new Comparator<JPackerWord>(){

            @Override
            public int compare(JPackerWord x, JPackerWord y) {
                return x.getIndex() - y.getIndex();
            }
        });
    }

    public JPackerWord find(JPackerWord word) {
        for (JPackerWord pw : this.words) {
            if (!pw.equals(word)) continue;
            return pw;
        }
        return null;
    }

    public List<JPackerWord> getWords() {
        return this.words;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (JPackerWord word : this.words) {
            sb.append(word.getReplacement()).append('|');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

