#!/usr/bin/python
#coding: utf-8
'''
//=============================================================================
//
//  File : ufo_scanlistwidget.py
//  Creation date : Thu Gen 02 14:30:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                    Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys, os.path,platform
import time
from core import ufo_translator
from core.ufo_picsfinder import *
from core import *
from core.ufo_wpasupplicant import WPASupplicantObj
from ui import ufo_scanelement

if platform.system() == "Windows":
	from core.ufo_windowsconnect import WindowsConnectObj
    
class UFOScannListWidget(QListWidget):
    def __init__(self,parent = None):
        super(UFOScannListWidget, self).__init__(parent)
        self.parent = parent

        self.mobjpresent = False
        self.connected = False
        self.clipboard = QApplication.clipboard()
        self.setContextMenuPolicy(Qt.CustomContextMenu)
        self.connect(self, SIGNAL('customContextMenuRequested(const QPoint&)'), self.on_context_menu)

        self.cpEssid= QAction(get_icon("copy.png"),_("Copy Essid"), self)
        self.cpMac = QAction(get_icon("copy.png"),_("Copy MAC"), self)
        self.cpPwd = QAction(get_icon("copy.png"),_("Copy key"), self)

        self.daTimer= QAction(get_icon("refreshOFF.png"),_("Refresh OFF"), self)
        self.fiveTimer = QAction(get_icon("clock.png"),_("Scan 5 sec"), self)
        self.fiveTimer.setCheckable(True)
        self.tenTimer = QAction(get_icon("clock.png"),_("Scan 10 sec"), self)
        self.tenTimer.setCheckable(True)
        self.tenFiveTimer = QAction(get_icon("clock.png"),_("Scan 15 sec"), self)
        self.tenFiveTimer.setCheckable(True)
        self.twTimer = QAction(get_icon("clock.png"),_("Scan 20 sec"), self)
        self.twTimer.setCheckable(True)
        self.trTimer = QAction(get_icon("clock.png"),_("Scan 30 sec"), self)
        self.trTimer.setCheckable(True)
        
        self.popMenu = QMenu(self)
        self.timerSubMenu =QMenu(self.popMenu)
        
        self.popMenu.addAction(self.cpEssid)
        self.popMenu.addAction(self.cpMac)
        self.popMenu.addAction(self.cpPwd)

        self.timerSubMenu.setTitle(_("Refresh settings"))
        self.timerSubMenu.setIcon(get_icon("refresh.png"))
        self.timerSubMenu.addAction(self.daTimer)
        self.timerSubMenu.addAction(self.fiveTimer)
        self.timerSubMenu.addAction(self.tenTimer)
        self.timerSubMenu.addAction(self.tenFiveTimer)
        self.timerSubMenu.addAction(self.twTimer)
        self.timerSubMenu.addAction(self.trTimer)        
        
   
                    
        self.popMenu.addMenu(self.timerSubMenu)
        self.cpEssid.triggered.connect(lambda : self.clipboard.setText(self.itemSsid))
        self.cpMac.triggered.connect(lambda : self.clipboard.setText(self.itemMac))
        self.cpPwd.triggered.connect(lambda : self.multiple_pwd_msg())
        
        self.daTimer.triggered.connect(lambda : self.set_scann_timer(0))
        self.fiveTimer.triggered.connect(lambda : self.set_scann_timer(5000))
        self.tenTimer.triggered.connect(lambda : self.set_scann_timer(10000))
        self.tenFiveTimer.triggered.connect(lambda : self.set_scann_timer(15000))
        self.twTimer.triggered.connect(lambda : self.set_scann_timer(20000))
        self.trTimer.triggered.connect(lambda : self.set_scann_timer(30000))
        
    def set_scann_timer(self,t):
        if t == 0 and self.parent.timerEnabled == True:
            self.parent.timer.stop()
            self.parent.timerEnabled = False
            self.daTimer.setText(_("Refresh ON"))
            self.daTimer.setIcon(get_icon("refresh.png"))
            
            self.fiveTimer.setChecked(False)           
            self.tenTimer.setChecked(False)
            self.tenFiveTimer.setChecked(False)
            self.twTimer.setChecked(False)
            self.trTimer.setChecked(False)
        elif t == 0 and self.parent.timerEnabled == False:
            self.parent.timer.start()
            self.parent.timerEnabled = True
            self.daTimer.setText(_("Refresh OFF"))
            self.daTimer.setIcon(get_icon("refreshOFF.png"))
        else:
            self.parent.timer.setInterval(t)
            self.parent.timer.start()
            if t == 5000:
                self.tenTimer.setChecked(False)
                self.tenFiveTimer.setChecked(False)
                self.twTimer.setChecked(False)
                self.trTimer.setChecked(False)
                self.daTimer.setText(_("Refresh OFF"))
                self.daTimer.setIcon(get_icon("refreshOFF.png"))
                self.parent.timerEnabled == True
            elif t == 10000:
                self.fiveTimer.setChecked(False)
                self.tenFiveTimer.setChecked(False)
                self.twTimer.setChecked(False)
                self.trTimer.setChecked(False)
                self.daTimer.setText(_("Refresh OFF"))
                self.daTimer.setIcon(get_icon("refreshOFF.png"))
                self.parent.timerEnabled == True
            elif t == 15000:
                self.fiveTimer.setChecked(False)
                self.tenTimer.setChecked(False)
                self.twTimer.setChecked(False)
                self.trTimer.setChecked(False)
                self.daTimer.setText(_("Refresh OFF"))
                self.daTimer.setIcon(get_icon("refreshOFF.png"))
                self.parent.timerEnabled == True
            elif t == 20000:
                self.fiveTimer.setChecked(False)
                self.tenTimer.setChecked(False)
                self.tenFiveTimer.setChecked(False)
                self.trTimer.setChecked(False)
                self.daTimer.setText(_("Refresh OFF"))
                self.daTimer.setIcon(get_icon("refreshOFF.png"))
                self.parent.timerEnabled == True
            elif t == 30000:
                self.fiveTimer.setChecked(False)
                self.tenTimer.setChecked(False)
                self.tenFiveTimer.setChecked(False)
                self.twTimer.setChecked(False)
                self.daTimer.setText(_("Refresh OFF"))
                self.daTimer.setIcon(get_icon("refreshOFF.png"))
                self.parent.timerEnabled == True

    def on_context_menu(self, point):
        try:
            if not self.currentItem().is_iface() :
                self.push_item_ram()
                self.popMenu.exec_(self.mapToGlobal(point))
        except AttributeError:
            pass

    def multiple_pwd_msg(self):
        m=""
        if type(self.itemKeyList) == list:
            for s in self.itemKeyList:
                m = m + s + "\n"
            msg =   QMessageBox(self, windowTitle=_("Multiple passwords"),
                    text=_("Multiple passwords were find, select one"))
            msg.setDetailedText(m)
            msg.exec_()

            
    def printStatus(self, st):
        if st == "SCANNING":
            sz = _("WS scanning")
            if self.parent.stateLabel.getText().contains(_("scanning")):
                sz = self.parent.stateLabel.getText()+"."
            self.parent.stateLabel.setLabelText(sz)
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledye.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "DISCONNECTED" or "UNKNOWN_KEY":
            if st == "UNKNOWN_KEY":
                self.parent.stateLabel.setLabelText(_("UFO: Unknown Key"))
            else:
                self.parent.stateLabel.setLabelText(_("UFO: Disconnected"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledre.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "NO_WPA_CONNECTION":
            self.parent.stateLabel.setLabelText(_("WSupplicant error"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledpr.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "NEED_KEY":
            self.parent.stateLabel.setLabelText(_("UFO: Need key!"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledre.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "WPA_COMPLETED":
            self.parent.stateLabel.setLabelText(_("WSupplicant ready"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledor.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "ON_LINE":
            self.parent.stateLabel.setLabelText(_("UFO: Connected"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledgr.png"))
            self.parent.stateLabel.styleWidget.repaint()
            self.connected = True
        if st == "RUN_AUTH":
            self.parent.stateLabel.setLabelText(_("UFO: Authenticating"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledye.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "ENABLE_NM":
            self.parent.stateLabel.setLabelText(_("Enable N.Manager"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("warning.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "IP_ERROR":
            self.parent.stateLabel.setLabelText(_("Error IP or DNS"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("error.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "DISABLE_NM":
            self.parent.stateLabel.setLabelText(_("Disable N.Manager"))
            self.parent.stateLabel.setLabelPixmap(get_pixmap("warning.png"))
            self.parent.stateLabel.styleWidget.repaint()
        if st == "INACTIVE":
            sz = _("WSupplicant inactive")
            if self.parent.stateLabel.getText().contains(_("inactive")):
                sz = self.parent.stateLabel.getText()+"."
            self.parent.stateLabel.setLabelText(sz)
            self.parent.stateLabel.setLabelPixmap(get_pixmap("ledb.png"))
            self.parent.stateLabel.styleWidget.repaint()
            
    def push_item_ram(self):
            self.itemIface = self.currentItem().get_iface()
            self.itemSsid = self.currentItem().essidString
            self.itemKeyList = self.currentItem().keyList #la chiave deve essere una lista, perche si possono trovare chiavi multiple
            self.itemEncr = QString(self.currentItem().get_encription())
            self.itemMac = self.currentItem().get_mac()
            self.itemEncr2 = QString(self.currentItem().get_encription2())
            self.itemIsKey = self.currentItem().get_isKey()
