#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_easyboxgui.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys
import os.path
from core.ufo_picsfinder import get_icon

from core import ufo_easyboxdecode

class UFOEasyboxWidget(QWidget):          
    def __init__(self, parent = None):
        super(UFOEasyboxWidget, self).__init__(parent)

        hBoxeasybox = QHBoxLayout()
        hBoxeasybox.setSpacing(5)

        vBoxeasybox = QVBoxLayout()
        vBoxeasybox.setSpacing(5)

        labeleasybox = QLabel("MAC:",self)
        self.lineEditeasybox= QLineEdit(self)
        self.lineEditeasybox.setToolTip("BSSID "+_("Compatible")+" : \nVodafone-\nArcor-\nEasyBox-")
        self.lineEditeasybox.setInputMask("HH:HH:HH:HH:HH:HH;_")

        self.outputTextEdit = QTextEdit(self)
        self.outputTextEdit.setReadOnly(True)

        self.buttonCalc = QPushButton(_("Find"),self)
        self.buttonCalc.setIcon(get_icon("key.png"))
        self.buttonCalc.setEnabled(0)

        hBoxeasybox.addWidget(labeleasybox)
        hBoxeasybox.addWidget(self.lineEditeasybox)
        hBoxeasybox.addWidget(self.buttonCalc)
        vBoxeasybox.addLayout(hBoxeasybox)
        vBoxeasybox.addWidget(self.outputTextEdit)

        self.setLayout(vBoxeasybox)

        self.lineEditeasybox.textChanged.connect(self.enable_button)
        self.buttonCalc.clicked.connect(self.find_key)

    def enable_button(self):
        if self.lineEditeasybox.text().length()==17:
            self.buttonCalc.setEnabled(1)
        else:
            self.buttonCalc.setEnabled(0)

    def find_key(self):
        mac_easy = str(self.lineEditeasybox.text())
        mac_easy = mac_easy.replace(" ","")
        try:
            stdouterr_easy = "\n".join(ufo_easyboxdecode.calc(mac_easy))
        except TypeError:
            self.outputTextEdit.setText(_("No key found."))
            return
        self.outputTextEdit.setText(stdouterr_easy)
