/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.preparator;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Asn1FieldPreparator<Field extends Asn1Field> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Field field;

    public Asn1FieldPreparator(Field field) {
        this.field = field;
    }

    public final void prepare() {
        LOGGER.trace("Preparing: {}", (Object)((Asn1Field)this.field).getIdentifier());
        this.prepareContent((Asn1Field)this.field);
        Asn1PreparatorHelper.prepareAfterContent(this.field);
    }

    public void prepareContent(Asn1Field field) {
        field.setContent(this.encodeContent());
    }

    protected abstract byte[] encodeContent();

    protected byte[] encodeChildren(Asn1Encodable ... children) {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        Asn1Encodable[] asn1EncodableArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Asn1Encodable child = asn1EncodableArray[n2];
            LOGGER.debug("Encoding {}", (Object)child.getIdentifier());
            outputStream.write(this.encode(child));
            ++n2;
        }
        return outputStream.toByteArray();
    }

    protected byte[] encodeChildren(List<Asn1Encodable> children) {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        for (Asn1Encodable child : children) {
            LOGGER.debug("Encoding {}", (Object)child.getIdentifier());
            outputStream.write(this.encode(child));
        }
        return outputStream.toByteArray();
    }

    private byte[] encode(Asn1Encodable encodable) {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        outputStream.write((byte[])encodable.getTagOctets().getValue());
        outputStream.write((byte[])encodable.getLengthOctets().getValue());
        outputStream.write((byte[])encodable.getContent().getValue());
        return outputStream.toByteArray();
    }
}

